/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.ml.spark.anomalydetection;

import net.sansa_stack.ml.spark.anomalydetection.CONOD;
import net.sansa_stack.ml.spark.anomalydetection.DistADConfig;
import net.sansa_stack.ml.spark.anomalydetection.DistADLogger$;
import net.sansa_stack.ml.spark.anomalydetection.DistADUtil$;
import net.sansa_stack.ml.spark.anomalydetection.MultiFeatureAnomalyDetection;
import net.sansa_stack.ml.spark.anomalydetection.NumericLiteralAnomalyDetection;
import net.sansa_stack.ml.spark.anomalydetection.PredicateAnomalyDetection;
import org.apache.jena.graph.Triple;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;

public final class AnomalyDetectionDispatcher$ {
    public static AnomalyDetectionDispatcher$ MODULE$;

    static {
        new AnomalyDetectionDispatcher$();
    }

    public void main(String[] args) {
        block10: {
            Dataset<Row> dataset;
            DistADConfig config = new DistADConfig(args[0]);
            SparkSession spark = DistADUtil$.MODULE$.createSpark();
            DistADLogger$.MODULE$.LOG().info((Object)config);
            String input = config.inputData();
            if (config.verbose()) {
                DistADLogger$.MODULE$.LOG().info((Object)new StringBuilder(15).append("Input file is: ").append(input).toString());
            }
            RDD<Triple> originalDataRDD = DistADUtil$.MODULE$.readData(spark, input);
            if (config.verbose()) {
                DistADLogger$.MODULE$.LOG().info((Object)"Original Data RDD:");
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originalDataRDD.take(10))).foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
                    AnomalyDetectionDispatcher$.$anonfun$main$1(x$1);
                    return BoxedUnit.UNIT;
                });
            }
            Dataset<Row> anomalyList = null;
            String string = config.anomalyDetectionType();
            String string2 = config.NUMERICLITERAL();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                dataset = new NumericLiteralAnomalyDetection(spark, originalDataRDD, config).run();
            } else {
                String string4 = config.PREDICATE();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    dataset = new PredicateAnomalyDetection(spark, originalDataRDD, config).run();
                } else {
                    String string6 = config.MULTIFEATURE();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        dataset = new MultiFeatureAnomalyDetection(spark, originalDataRDD, config).run();
                    } else {
                        String string8 = config.CONOD();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            dataset = new CONOD(spark, originalDataRDD, config).run();
                        } else {
                            throw new MatchError((Object)string);
                        }
                    }
                }
            }
            anomalyList = dataset;
            if (!config.writeResultToFile()) break block10;
            long now = System.currentTimeMillis();
            DistADUtil$.MODULE$.writeToFile(config.resultFilePath(), anomalyList);
            DistADLogger$.MODULE$.LOG().info((Object)new StringBuilder(29).append("writing result to file took: ").append(System.currentTimeMillis() - now).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$main$1(Object x$1) {
        DistADLogger$.MODULE$.LOG().info(x$1);
    }

    private AnomalyDetectionDispatcher$() {
        MODULE$ = this;
    }
}

