/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.ml.spark.outliers.vandalismdetection;

import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.classification.DecisionTreeClassifier;
import org.apache.spark.ml.classification.GBTClassifier;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifier;
import org.apache.spark.ml.classification.RandomForestClassifier;
import org.apache.spark.ml.evaluation.BinaryClassificationEvaluator;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

public final class Classifier$
implements Serializable {
    public static final Classifier$ MODULE$;

    static {
        new Classifier$();
    }

    public String randomForestClassifer(Dataset<Row> train, Dataset<Row> test2, SparkSession spark) {
        train.createOrReplaceTempView("DB1");
        test2.createOrReplaceTempView("DB2");
        Dataset TrainingData = spark.sql("select Rid, features,FinalROLLBACK_REVERTED  from DB1");
        Dataset TestingData = spark.sql("select Rid, features, FinalROLLBACK_REVERTED  from DB2");
        StringIndexerModel labelIndexer = new StringIndexer().setInputCol("FinalROLLBACK_REVERTED").setOutputCol("indexedLabel").fit(TrainingData);
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(TrainingData);
        RandomForestClassifier rf = (RandomForestClassifier)new RandomForestClassifier().setImpurity("gini").setMaxDepth(3).setNumTrees(20).setFeatureSubsetStrategy("auto").setSeed(5043L).setLabelCol("indexedLabel").setFeaturesCol("indexedFeatures");
        IndexToString labelConverter = new IndexToString().setInputCol("prediction").setOutputCol("predictedLabel").setLabels(labelIndexer.labels());
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{labelIndexer, featureIndexer, rf, labelConverter}));
        PipelineModel model_New = pipeline.fit(TrainingData);
        Dataset predictions = model_New.transform(TestingData);
        Dataset finlaPrediction = predictions.select("Rid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features", "FinalROLLBACK_REVERTED", "predictedLabel"}));
        predictions.show();
        BinaryClassificationEvaluator binaryClassificationEvaluator = new BinaryClassificationEvaluator().setLabelCol("indexedLabel").setRawPredictionCol("rawPrediction");
        DoubleRef results1 = DoubleRef.create((double)0.0);
        double ROC = this.printlnMetricCAse1$1("areaUnderROC", predictions, binaryClassificationEvaluator, results1);
        double PR = this.printlnMetricCAse1$1("areaUnderPR", predictions, binaryClassificationEvaluator, results1);
        MulticlassClassificationEvaluator MulticlassClassificationEvaluator2 = new MulticlassClassificationEvaluator().setLabelCol("indexedLabel").setPredictionCol("prediction");
        DoubleRef results2 = DoubleRef.create((double)0.0);
        double accuracy = this.printlnMetricCase2$1("accuracy", predictions, MulticlassClassificationEvaluator2, results2);
        double Precision = this.printlnMetricCase2$1("weightedPrecision", predictions, MulticlassClassificationEvaluator2, results2);
        double Recall = this.printlnMetricCase2$1("weightedRecall", predictions, MulticlassClassificationEvaluator2, results2);
        String finalResult = new StringBuilder().append((Object)"ROC=").append((Object)((Object)BoxesRunTime.boxToDouble((double)ROC)).toString()).append((Object)"|").append((Object)"PR=").append((Object)((Object)BoxesRunTime.boxToDouble((double)PR)).toString()).append((Object)"|").append((Object)"accuracy=").append((Object)((Object)BoxesRunTime.boxToDouble((double)accuracy)).toString()).append((Object)"|").append((Object)"Precision=").append((Object)((Object)BoxesRunTime.boxToDouble((double)Precision)).toString()).append((Object)"|").append((Object)"Recall=").append((Object)((Object)BoxesRunTime.boxToDouble((double)Recall)).toString()).toString();
        return finalResult;
    }

    public String decisionTreeClassifier(Dataset<Row> train, Dataset<Row> test2, SparkSession spark) {
        train.createOrReplaceTempView("DB1");
        test2.createOrReplaceTempView("DB2");
        Dataset TrainingData = spark.sql("select Rid, features, FinalROLLBACK_REVERTED  from DB1");
        Dataset TestingData = spark.sql("select Rid, features, FinalROLLBACK_REVERTED  from DB2");
        StringIndexerModel labelIndexer = new StringIndexer().setInputCol("FinalROLLBACK_REVERTED").setOutputCol("indexedLabel").fit(TrainingData);
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(TrainingData);
        DecisionTreeClassifier dt = (DecisionTreeClassifier)new DecisionTreeClassifier().setLabelCol("indexedLabel").setFeaturesCol("indexedFeatures");
        IndexToString labelConverter = new IndexToString().setInputCol("prediction").setOutputCol("predictedLabel").setLabels(labelIndexer.labels());
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{labelIndexer, featureIndexer, dt, labelConverter}));
        PipelineModel modelxx = pipeline.fit(TrainingData);
        Dataset predictions = modelxx.transform(TestingData);
        BinaryClassificationEvaluator binaryClassificationEvaluator = new BinaryClassificationEvaluator().setLabelCol("indexedLabel").setRawPredictionCol("rawPrediction");
        DoubleRef result1 = DoubleRef.create((double)0.0);
        double ROC = this.printlnMetricCAse1$2("areaUnderROC", predictions, binaryClassificationEvaluator, result1);
        double PR = this.printlnMetricCAse1$2("areaUnderPR", predictions, binaryClassificationEvaluator, result1);
        MulticlassClassificationEvaluator MulticlassClassificationEvaluator2 = new MulticlassClassificationEvaluator().setLabelCol("indexedLabel").setPredictionCol("prediction");
        DoubleRef result2 = DoubleRef.create((double)0.0);
        double accuracy = this.printlnMetricCase2$2("accuracy", predictions, MulticlassClassificationEvaluator2, result2);
        double Precision = this.printlnMetricCase2$2("weightedPrecision", predictions, MulticlassClassificationEvaluator2, result2);
        double Recall = this.printlnMetricCase2$2("weightedRecall", predictions, MulticlassClassificationEvaluator2, result2);
        String finalResult = new StringBuilder().append((Object)"ROC=").append((Object)((Object)BoxesRunTime.boxToDouble((double)ROC)).toString()).append((Object)"|").append((Object)"PR=").append((Object)((Object)BoxesRunTime.boxToDouble((double)PR)).toString()).append((Object)"|").append((Object)"accuracy=").append((Object)((Object)BoxesRunTime.boxToDouble((double)accuracy)).toString()).append((Object)"|").append((Object)"Precision=").append((Object)((Object)BoxesRunTime.boxToDouble((double)Precision)).toString()).append((Object)"|").append((Object)"Recall=").append((Object)((Object)BoxesRunTime.boxToDouble((double)Recall)).toString()).toString();
        return finalResult;
    }

    public String logisticRegrision(Dataset<Row> train, Dataset<Row> test2, SparkSession spark) {
        train.createOrReplaceTempView("DB1");
        test2.createOrReplaceTempView("DB2");
        Dataset TrainingData = spark.sql("select Rid, features, FinalROLLBACK_REVERTED as label from DB1");
        Dataset TestingData = spark.sql("select Rid, features, FinalROLLBACK_REVERTED as label from DB2");
        StringIndexerModel labelIndexer = new StringIndexer().setInputCol("label").setOutputCol("indexedLabel").fit(TrainingData);
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(TrainingData);
        LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8).setFamily("multinomial");
        IndexToString labelConverter = new IndexToString().setInputCol("prediction").setOutputCol("predictedLabel").setLabels(labelIndexer.labels());
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{labelIndexer, featureIndexer, lr, labelConverter}));
        PipelineModel modelxx = pipeline.fit(TrainingData);
        Dataset predictions = modelxx.transform(TestingData);
        Dataset finlaPrediction = predictions.select("Rid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features", "label", "predictedLabel"}));
        predictions.show();
        BinaryClassificationEvaluator binaryClassificationEvaluator = new BinaryClassificationEvaluator().setLabelCol("indexedLabel").setRawPredictionCol("rawPrediction");
        DoubleRef results1 = DoubleRef.create((double)0.0);
        double ROC = this.printlnMetricCase1$1("areaUnderROC", predictions, binaryClassificationEvaluator, results1);
        double PR = this.printlnMetricCase1$1("areaUnderPR", predictions, binaryClassificationEvaluator, results1);
        MulticlassClassificationEvaluator MulticlassClassificationEvaluator2 = new MulticlassClassificationEvaluator().setLabelCol("indexedLabel").setPredictionCol("prediction");
        DoubleRef result2 = DoubleRef.create((double)0.0);
        double accuracy = this.printlnMetricCase2$3("accuracy", predictions, MulticlassClassificationEvaluator2, result2);
        double Precision = this.printlnMetricCase2$3("weightedPrecision", predictions, MulticlassClassificationEvaluator2, result2);
        double Recall = this.printlnMetricCase2$3("weightedRecall", predictions, MulticlassClassificationEvaluator2, result2);
        String finalResult = new StringBuilder().append((Object)"ROC=").append((Object)((Object)BoxesRunTime.boxToDouble((double)ROC)).toString()).append((Object)"|").append((Object)"PR=").append((Object)((Object)BoxesRunTime.boxToDouble((double)PR)).toString()).append((Object)"|").append((Object)"accuracy=").append((Object)((Object)BoxesRunTime.boxToDouble((double)accuracy)).toString()).append((Object)"|").append((Object)"Precision=").append((Object)((Object)BoxesRunTime.boxToDouble((double)Precision)).toString()).append((Object)"|").append((Object)"Recall=").append((Object)((Object)BoxesRunTime.boxToDouble((double)Recall)).toString()).toString();
        return finalResult;
    }

    public String gradientBoostedTree(Dataset<Row> train, Dataset<Row> test2, SparkSession spark) {
        train.createOrReplaceTempView("DB1");
        train.createOrReplaceTempView("DB2");
        Dataset TrainingData = spark.sql("select Rid, features, FinalROLLBACK_REVERTED  from DB1").cache();
        Dataset TestingData = spark.sql("select Rid, features, FinalROLLBACK_REVERTED  from DB2").cache();
        StringIndexerModel labelIndexer = new StringIndexer().setInputCol("FinalROLLBACK_REVERTED").setOutputCol("indexedLabel").fit(TrainingData);
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(TrainingData);
        GBTClassifier gbt = (GBTClassifier)new GBTClassifier().setLabelCol("indexedLabel").setFeaturesCol("indexedFeatures");
        IndexToString labelConverter = new IndexToString().setInputCol("prediction").setOutputCol("predictedLabel").setLabels(labelIndexer.labels());
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{labelIndexer, featureIndexer, gbt, labelConverter}));
        PipelineModel modelxx = pipeline.fit(TrainingData);
        Dataset predictions = modelxx.transform(TestingData);
        RDD predictionsRDD = predictions.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FinalROLLBACK_REVERTED"})).rdd();
        RDD predictionAndLabels = predictionsRDD.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row row) {
                return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)row.get(0)), BoxesRunTime.unboxToDouble((Object)row.get(1)));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(predictionAndLabels);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Area under ROC = ").append((Object)BoxesRunTime.boxToDouble((double)metrics.areaUnderROC())).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Area under PR = ").append((Object)BoxesRunTime.boxToDouble((double)metrics.areaUnderPR())).toString());
        double ROC = metrics.areaUnderROC();
        double PR = metrics.areaUnderPR();
        MulticlassClassificationEvaluator MulticlassClassificationEvaluator2 = new MulticlassClassificationEvaluator().setLabelCol("indexedLabel").setPredictionCol("prediction");
        DoubleRef result2 = DoubleRef.create((double)0.0);
        double accuracy = this.printlnMetric$1("accuracy", predictions, MulticlassClassificationEvaluator2, result2);
        double Precision = this.printlnMetric$1("weightedPrecision", predictions, MulticlassClassificationEvaluator2, result2);
        double Recall = this.printlnMetric$1("weightedRecall", predictions, MulticlassClassificationEvaluator2, result2);
        String finalResult = new StringBuilder().append((Object)"ROC=").append((Object)((Object)BoxesRunTime.boxToDouble((double)ROC)).toString()).append((Object)"|").append((Object)"PR=").append((Object)((Object)BoxesRunTime.boxToDouble((double)PR)).toString()).append((Object)"|").append((Object)"accuracy=").append((Object)((Object)BoxesRunTime.boxToDouble((double)accuracy)).toString()).append((Object)"|").append((Object)"Precision=").append((Object)((Object)BoxesRunTime.boxToDouble((double)Precision)).toString()).append((Object)"|").append((Object)"Recall=").append((Object)((Object)BoxesRunTime.boxToDouble((double)Recall)).toString()).toString();
        return finalResult;
    }

    public String multilayerPerceptronClassifier(Dataset<Row> train, Dataset<Row> test2, SparkSession spark) {
        train.createOrReplaceTempView("DB1");
        train.createOrReplaceTempView("DB2");
        Dataset TrainingData = spark.sql("select Rid, features, FinalROLLBACK_REVERTED as label from DB1");
        Dataset TestingData = spark.sql("select Rid, features, FinalROLLBACK_REVERTED as label from DB2");
        StringIndexerModel labelIndexer = new StringIndexer().setInputCol("label").setOutputCol("indexedLabel").fit(TrainingData);
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(TrainingData);
        int[] layers = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 5, 4, 2}), ClassTag$.MODULE$.Int());
        MultilayerPerceptronClassifier trainer = new MultilayerPerceptronClassifier().setLayers(layers).setBlockSize(128).setSeed(1234L).setMaxIter(100);
        IndexToString labelConverter = new IndexToString().setInputCol("prediction").setOutputCol("predictedLabel").setLabels(labelIndexer.labels());
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{labelIndexer, featureIndexer, trainer, labelConverter}));
        PipelineModel modelxx = pipeline.fit(TrainingData);
        Dataset predictions = modelxx.transform(TestingData);
        Dataset predictionsDF = predictions.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}));
        RDD predictionsRDD = predictions.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"})).rdd();
        RDD predictionAndLabels = predictionsRDD.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row row) {
                return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)row.get(0)), BoxesRunTime.unboxToDouble((Object)row.get(1)));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(predictionAndLabels);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Area under ROC = ").append((Object)BoxesRunTime.boxToDouble((double)metrics.areaUnderROC())).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Area under PR = ").append((Object)BoxesRunTime.boxToDouble((double)metrics.areaUnderPR())).toString());
        double ROC = metrics.areaUnderROC();
        double PR = metrics.areaUnderPR();
        MulticlassClassificationEvaluator accuracyevaluator = new MulticlassClassificationEvaluator().setMetricName("accuracy");
        MulticlassClassificationEvaluator weightedPrecisionevaluator = new MulticlassClassificationEvaluator().setMetricName("weightedPrecision");
        MulticlassClassificationEvaluator weightedRecallevaluator = new MulticlassClassificationEvaluator().setMetricName("weightedRecall");
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Accuracy = ").append((Object)BoxesRunTime.boxToDouble((double)accuracyevaluator.evaluate(predictionsDF))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"weightedPrecision = ").append((Object)BoxesRunTime.boxToDouble((double)weightedPrecisionevaluator.evaluate(predictionsDF))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"weightedRecall = ").append((Object)BoxesRunTime.boxToDouble((double)weightedRecallevaluator.evaluate(predictionsDF))).toString());
        double accuracy = accuracyevaluator.evaluate(predictionsDF);
        double Precision = weightedPrecisionevaluator.evaluate(predictionsDF);
        double Recall = weightedRecallevaluator.evaluate(predictionsDF);
        String finalResult = new StringBuilder().append((Object)"ROC=").append((Object)((Object)BoxesRunTime.boxToDouble((double)ROC)).toString()).append((Object)"|").append((Object)"PR=").append((Object)((Object)BoxesRunTime.boxToDouble((double)PR)).toString()).append((Object)"|").append((Object)"accuracy=").append((Object)((Object)BoxesRunTime.boxToDouble((double)accuracy)).toString()).append((Object)"|").append((Object)"Precision=").append((Object)((Object)BoxesRunTime.boxToDouble((double)Precision)).toString()).append((Object)"|").append((Object)"Recall=").append((Object)((Object)BoxesRunTime.boxToDouble((double)Recall)).toString()).toString();
        return finalResult;
    }

    public String randomForestClassiferWithSplit(Dataset<Row> data) {
        StringIndexerModel labelIndexer = new StringIndexer().setInputCol("label").setOutputCol("indexedLabel").fit(data);
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(data);
        Dataset[] datasetArray = data.randomSplit(new double[]{0.8, 0.2});
        Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            Dataset trainingData = (Dataset)((SeqLike)option.get()).apply(0);
            Dataset testData = (Dataset)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)trainingData, (Object)testData);
            Dataset trainingData2 = (Dataset)tuple22._1();
            Dataset testData2 = (Dataset)tuple22._2();
            RandomForestClassifier rf = ((RandomForestClassifier)new RandomForestClassifier().setLabelCol("indexedLabel").setFeaturesCol("indexedFeatures")).setNumTrees(10);
            IndexToString labelConverter = new IndexToString().setInputCol("prediction").setOutputCol("predictedLabel").setLabels(labelIndexer.labels());
            Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{labelIndexer, featureIndexer, rf, labelConverter}));
            PipelineModel model = pipeline.fit(trainingData2);
            Dataset predictions = model.transform(testData2);
            BinaryClassificationEvaluator binaryClassificationEvaluator = new BinaryClassificationEvaluator().setLabelCol("label").setRawPredictionCol("rawPrediction");
            DoubleRef results1 = DoubleRef.create((double)0.0);
            double ROC = this.printlnMetricCAse1$3("areaUnderROC", predictions, binaryClassificationEvaluator, results1);
            double PR = this.printlnMetricCAse1$3("areaUnderPR", predictions, binaryClassificationEvaluator, results1);
            MulticlassClassificationEvaluator MulticlassClassificationEvaluator2 = new MulticlassClassificationEvaluator().setLabelCol("indexedLabel").setPredictionCol("prediction");
            DoubleRef results2 = DoubleRef.create((double)0.0);
            double accuracy = this.printlnMetricCase2$4("accuracy", predictions, MulticlassClassificationEvaluator2, results2);
            double Precision = this.printlnMetricCase2$4("weightedPrecision", predictions, MulticlassClassificationEvaluator2, results2);
            double Recall = this.printlnMetricCase2$4("weightedRecall", predictions, MulticlassClassificationEvaluator2, results2);
            String result = new StringBuilder().append((Object)"For RandomForest values are : ").append((Object)BoxesRunTime.boxToDouble((double)ROC)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)PR)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)accuracy)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)Precision)).append((Object)" &&&&& ").append((Object)((Object)BoxesRunTime.boxToDouble((double)Recall)).toString()).toString();
            return result;
        }
        throw new MatchError((Object)datasetArray);
    }

    public String decisionTreeClassifierWithSplit(Dataset<Row> data) {
        StringIndexerModel labelIndexer = new StringIndexer().setInputCol("label").setOutputCol("indexedLabel").fit(data);
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(data);
        Dataset[] datasetArray = data.randomSplit(new double[]{0.8, 0.2});
        Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            Dataset trainingData = (Dataset)((SeqLike)option.get()).apply(0);
            Dataset testData = (Dataset)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)trainingData, (Object)testData);
            Dataset trainingData2 = (Dataset)tuple22._1();
            Dataset testData2 = (Dataset)tuple22._2();
            DecisionTreeClassifier dt = (DecisionTreeClassifier)new DecisionTreeClassifier().setLabelCol("indexedLabel").setFeaturesCol("indexedFeatures");
            IndexToString labelConverter = new IndexToString().setInputCol("prediction").setOutputCol("predictedLabel").setLabels(labelIndexer.labels());
            Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{labelIndexer, featureIndexer, dt, labelConverter}));
            PipelineModel modelxx = pipeline.fit(trainingData2);
            Dataset predictions = modelxx.transform(testData2);
            BinaryClassificationEvaluator binaryClassificationEvaluator = new BinaryClassificationEvaluator().setLabelCol("indexedLabel").setRawPredictionCol("rawPrediction");
            DoubleRef result1 = DoubleRef.create((double)0.0);
            double ROC = this.printlnMetricCAse1$4("areaUnderROC", predictions, binaryClassificationEvaluator, result1);
            double PR = this.printlnMetricCAse1$4("areaUnderPR", predictions, binaryClassificationEvaluator, result1);
            MulticlassClassificationEvaluator MulticlassClassificationEvaluator2 = new MulticlassClassificationEvaluator().setLabelCol("indexedLabel").setPredictionCol("prediction");
            DoubleRef result2 = DoubleRef.create((double)0.0);
            double accuracy = this.printlnMetricCase2$5("accuracy", predictions, MulticlassClassificationEvaluator2, result2);
            double Precision = this.printlnMetricCase2$5("weightedPrecision", predictions, MulticlassClassificationEvaluator2, result2);
            double Recall = this.printlnMetricCase2$5("weightedRecall", predictions, MulticlassClassificationEvaluator2, result2);
            String result = new StringBuilder().append((Object)"For DecisionTreeClassifier values are : ").append((Object)BoxesRunTime.boxToDouble((double)ROC)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)PR)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)accuracy)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)Precision)).append((Object)" &&&&& ").append((Object)((Object)BoxesRunTime.boxToDouble((double)Recall)).toString()).toString();
            return result;
        }
        throw new MatchError((Object)datasetArray);
    }

    public String logisticRegrisionWithSplit(Dataset<Row> data) {
        StringIndexerModel labelIndexer = new StringIndexer().setInputCol("label").setOutputCol("indexedLabel").fit(data);
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(data);
        Dataset[] datasetArray = data.randomSplit(new double[]{0.8, 0.2});
        Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            Dataset trainingData = (Dataset)((SeqLike)option.get()).apply(0);
            Dataset testData = (Dataset)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)trainingData, (Object)testData);
            Dataset trainingData2 = (Dataset)tuple22._1();
            Dataset testData2 = (Dataset)tuple22._2();
            LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8).setFamily("multinomial");
            IndexToString labelConverter = new IndexToString().setInputCol("prediction").setOutputCol("predictedLabel").setLabels(labelIndexer.labels());
            Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{labelIndexer, featureIndexer, lr, labelConverter}));
            PipelineModel model = pipeline.fit(trainingData2);
            Dataset predictions = model.transform(testData2);
            BinaryClassificationEvaluator binaryClassificationEvaluator = new BinaryClassificationEvaluator().setLabelCol("label").setRawPredictionCol("rawPrediction");
            DoubleRef results1 = DoubleRef.create((double)0.0);
            double ROC = this.printlnMetricCAse1$5("areaUnderROC", predictions, binaryClassificationEvaluator, results1);
            double PR = this.printlnMetricCAse1$5("areaUnderPR", predictions, binaryClassificationEvaluator, results1);
            MulticlassClassificationEvaluator MulticlassClassificationEvaluator2 = new MulticlassClassificationEvaluator().setLabelCol("indexedLabel").setPredictionCol("prediction");
            DoubleRef result2 = DoubleRef.create((double)0.0);
            double accuracy = this.printlnMetricCase2$6("accuracy", predictions, MulticlassClassificationEvaluator2, result2);
            double Precision = this.printlnMetricCase2$6("weightedPrecision", predictions, MulticlassClassificationEvaluator2, result2);
            double Recall = this.printlnMetricCase2$6("weightedRecall", predictions, MulticlassClassificationEvaluator2, result2);
            String result = new StringBuilder().append((Object)"For LogisticRegrision values are : ").append((Object)BoxesRunTime.boxToDouble((double)ROC)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)PR)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)accuracy)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)Precision)).append((Object)" &&&&& ").append((Object)((Object)BoxesRunTime.boxToDouble((double)Recall)).toString()).toString();
            return result;
        }
        throw new MatchError((Object)datasetArray);
    }

    public String gradientBoostedTreeWithSplit(Dataset<Row> data) {
        StringIndexerModel labelIndexer = new StringIndexer().setInputCol("label").setOutputCol("indexedLabel").fit(data);
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(data);
        Dataset[] datasetArray = data.randomSplit(new double[]{0.8, 0.2});
        Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            Dataset trainingData = (Dataset)((SeqLike)option.get()).apply(0);
            Dataset testData = (Dataset)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)trainingData, (Object)testData);
            Dataset trainingData2 = (Dataset)tuple22._1();
            Dataset testData2 = (Dataset)tuple22._2();
            GBTClassifier gbt = (GBTClassifier)new GBTClassifier().setLabelCol("indexedLabel").setFeaturesCol("indexedFeatures");
            IndexToString labelConverter = new IndexToString().setInputCol("prediction").setOutputCol("predictedLabel").setLabels(labelIndexer.labels());
            Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{labelIndexer, featureIndexer, gbt, labelConverter}));
            PipelineModel modelxx = pipeline.fit(trainingData2);
            Dataset predictions = modelxx.transform(testData2);
            RDD predictionsRDD = predictions.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"})).rdd();
            RDD predictionAndLabels = predictionsRDD.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(Row row) {
                    return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)row.get(0)), BoxesRunTime.unboxToDouble((Object)row.get(1)));
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(predictionAndLabels);
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Area under ROC = ").append((Object)BoxesRunTime.boxToDouble((double)metrics.areaUnderROC())).toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Area under PR = ").append((Object)BoxesRunTime.boxToDouble((double)metrics.areaUnderPR())).toString());
            double ROC = metrics.areaUnderROC();
            double PR = metrics.areaUnderPR();
            MulticlassClassificationEvaluator MulticlassClassificationEvaluator2 = new MulticlassClassificationEvaluator().setLabelCol("indexedLabel").setPredictionCol("prediction");
            DoubleRef result2 = DoubleRef.create((double)0.0);
            double accuracy = this.printlnMetric$2("accuracy", predictions, MulticlassClassificationEvaluator2, result2);
            double Precision = this.printlnMetric$2("weightedPrecision", predictions, MulticlassClassificationEvaluator2, result2);
            double Recall = this.printlnMetric$2("weightedRecall", predictions, MulticlassClassificationEvaluator2, result2);
            String result = new StringBuilder().append((Object)"For GradientBoostedTree values are : ").append((Object)BoxesRunTime.boxToDouble((double)ROC)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)PR)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)accuracy)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)Precision)).append((Object)" &&&&& ").append((Object)((Object)BoxesRunTime.boxToDouble((double)Recall)).toString()).toString();
            return result;
        }
        throw new MatchError((Object)datasetArray);
    }

    public String multilayerPerceptronClassifierWithSplit(Dataset<Row> data) {
        StringIndexerModel labelIndexer = new StringIndexer().setInputCol("label").setOutputCol("indexedLabel").fit(data);
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(data);
        Dataset[] datasetArray = data.randomSplit(new double[]{0.8, 0.2});
        Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            Dataset trainingData = (Dataset)((SeqLike)option.get()).apply(0);
            Dataset testData = (Dataset)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)trainingData, (Object)testData);
            Dataset trainingData2 = (Dataset)tuple22._1();
            Dataset testData2 = (Dataset)tuple22._2();
            int[] layers = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 5, 4, 2}), ClassTag$.MODULE$.Int());
            MultilayerPerceptronClassifier trainer = new MultilayerPerceptronClassifier().setLayers(layers).setBlockSize(128).setSeed(1234L).setMaxIter(101);
            IndexToString labelConverter = new IndexToString().setInputCol("prediction").setOutputCol("predictedLabel").setLabels(labelIndexer.labels());
            Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{labelIndexer, featureIndexer, trainer, labelConverter}));
            PipelineModel modelxx = pipeline.fit(trainingData2);
            Dataset predictions = modelxx.transform(testData2);
            Dataset predictionsDF = predictions.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}));
            RDD predictionsRDD = predictions.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"})).rdd();
            RDD predictionAndLabels = predictionsRDD.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(Row row) {
                    return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)row.get(0)), BoxesRunTime.unboxToDouble((Object)row.get(1)));
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(predictionAndLabels);
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Area under ROC = ").append((Object)BoxesRunTime.boxToDouble((double)metrics.areaUnderROC())).toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Area under PR = ").append((Object)BoxesRunTime.boxToDouble((double)metrics.areaUnderPR())).toString());
            double ROC = metrics.areaUnderROC();
            double PR = metrics.areaUnderPR();
            MulticlassClassificationEvaluator accuracyevaluator = new MulticlassClassificationEvaluator().setMetricName("accuracy");
            MulticlassClassificationEvaluator weightedPrecisionevaluator = new MulticlassClassificationEvaluator().setMetricName("weightedPrecision");
            MulticlassClassificationEvaluator weightedRecallevaluator = new MulticlassClassificationEvaluator().setMetricName("weightedRecall");
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Accuracy = ").append((Object)BoxesRunTime.boxToDouble((double)accuracyevaluator.evaluate(predictionsDF))).toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"weightedPrecision = ").append((Object)BoxesRunTime.boxToDouble((double)weightedPrecisionevaluator.evaluate(predictionsDF))).toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"weightedRecall = ").append((Object)BoxesRunTime.boxToDouble((double)weightedRecallevaluator.evaluate(predictionsDF))).toString());
            double accuracy = accuracyevaluator.evaluate(predictionsDF);
            double Precision = weightedPrecisionevaluator.evaluate(predictionsDF);
            double Recall = weightedRecallevaluator.evaluate(predictionsDF);
            String result = new StringBuilder().append((Object)"For MultilayerPerceptronClassifier values are : ").append((Object)BoxesRunTime.boxToDouble((double)ROC)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)PR)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)accuracy)).append((Object)" &&&&& ").append((Object)BoxesRunTime.boxToDouble((double)Precision)).append((Object)" &&&&& ").append((Object)((Object)BoxesRunTime.boxToDouble((double)Recall)).toString()).toString();
            return result;
        }
        throw new MatchError((Object)datasetArray);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final double printlnMetricCAse1$1(String metricName, Dataset predictions$1, BinaryClassificationEvaluator binaryClassificationEvaluator$1, DoubleRef results1$1) {
        results1$1.elem = binaryClassificationEvaluator$1.setMetricName(metricName).evaluate(predictions$1);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)metricName).append((Object)" = ").append((Object)BoxesRunTime.boxToDouble((double)results1$1.elem)).toString());
        return results1$1.elem;
    }

    private final double printlnMetricCase2$1(String metricName, Dataset predictions$1, MulticlassClassificationEvaluator MulticlassClassificationEvaluator$1, DoubleRef results2$1) {
        results2$1.elem = MulticlassClassificationEvaluator$1.setMetricName(metricName).evaluate(predictions$1);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)metricName).append((Object)" = ").append((Object)BoxesRunTime.boxToDouble((double)results2$1.elem)).toString());
        return results2$1.elem;
    }

    private final double printlnMetricCAse1$2(String metricName, Dataset predictions$2, BinaryClassificationEvaluator binaryClassificationEvaluator$2, DoubleRef result1$1) {
        result1$1.elem = binaryClassificationEvaluator$2.setMetricName(metricName).evaluate(predictions$2);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)metricName).append((Object)" = ").append((Object)BoxesRunTime.boxToDouble((double)result1$1.elem)).toString());
        return result1$1.elem;
    }

    private final double printlnMetricCase2$2(String metricName, Dataset predictions$2, MulticlassClassificationEvaluator MulticlassClassificationEvaluator$2, DoubleRef result2$1) {
        result2$1.elem = MulticlassClassificationEvaluator$2.setMetricName(metricName).evaluate(predictions$2);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)metricName).append((Object)" = ").append((Object)BoxesRunTime.boxToDouble((double)result2$1.elem)).toString());
        return result2$1.elem;
    }

    private final double printlnMetricCase1$1(String metricName, Dataset predictions$3, BinaryClassificationEvaluator binaryClassificationEvaluator$3, DoubleRef results1$2) {
        results1$2.elem = binaryClassificationEvaluator$3.setMetricName(metricName).evaluate(predictions$3);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)metricName).append((Object)" = ").append((Object)BoxesRunTime.boxToDouble((double)results1$2.elem)).toString());
        return results1$2.elem;
    }

    private final double printlnMetricCase2$3(String metricName, Dataset predictions$3, MulticlassClassificationEvaluator MulticlassClassificationEvaluator$3, DoubleRef result2$2) {
        result2$2.elem = MulticlassClassificationEvaluator$3.setMetricName(metricName).evaluate(predictions$3);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)metricName).append((Object)" = ").append((Object)BoxesRunTime.boxToDouble((double)result2$2.elem)).toString());
        return result2$2.elem;
    }

    private final double printlnMetric$1(String metricName, Dataset predictions$4, MulticlassClassificationEvaluator MulticlassClassificationEvaluator$4, DoubleRef result2$3) {
        result2$3.elem = MulticlassClassificationEvaluator$4.setMetricName(metricName).evaluate(predictions$4);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)metricName).append((Object)" = ").append((Object)BoxesRunTime.boxToDouble((double)result2$3.elem)).toString());
        return result2$3.elem;
    }

    private final double printlnMetricCAse1$3(String metricName, Dataset predictions$5, BinaryClassificationEvaluator binaryClassificationEvaluator$4, DoubleRef results1$3) {
        results1$3.elem = binaryClassificationEvaluator$4.setMetricName(metricName).evaluate(predictions$5);
        return results1$3.elem;
    }

    private final double printlnMetricCase2$4(String metricName, Dataset predictions$5, MulticlassClassificationEvaluator MulticlassClassificationEvaluator$5, DoubleRef results2$2) {
        results2$2.elem = MulticlassClassificationEvaluator$5.setMetricName(metricName).evaluate(predictions$5);
        return results2$2.elem;
    }

    private final double printlnMetricCAse1$4(String metricName, Dataset predictions$6, BinaryClassificationEvaluator binaryClassificationEvaluator$5, DoubleRef result1$2) {
        result1$2.elem = binaryClassificationEvaluator$5.setMetricName(metricName).evaluate(predictions$6);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)metricName).append((Object)" = ").append((Object)BoxesRunTime.boxToDouble((double)result1$2.elem)).toString());
        return result1$2.elem;
    }

    private final double printlnMetricCase2$5(String metricName, Dataset predictions$6, MulticlassClassificationEvaluator MulticlassClassificationEvaluator$6, DoubleRef result2$4) {
        result2$4.elem = MulticlassClassificationEvaluator$6.setMetricName(metricName).evaluate(predictions$6);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)metricName).append((Object)" = ").append((Object)BoxesRunTime.boxToDouble((double)result2$4.elem)).toString());
        return result2$4.elem;
    }

    private final double printlnMetricCAse1$5(String metricName, Dataset predictions$7, BinaryClassificationEvaluator binaryClassificationEvaluator$6, DoubleRef results1$4) {
        results1$4.elem = binaryClassificationEvaluator$6.setMetricName(metricName).evaluate(predictions$7);
        return results1$4.elem;
    }

    private final double printlnMetricCase2$6(String metricName, Dataset predictions$7, MulticlassClassificationEvaluator MulticlassClassificationEvaluator$7, DoubleRef result2$5) {
        result2$5.elem = MulticlassClassificationEvaluator$7.setMetricName(metricName).evaluate(predictions$7);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)metricName).append((Object)" = ").append((Object)BoxesRunTime.boxToDouble((double)result2$5.elem)).toString());
        return result2$5.elem;
    }

    private final double printlnMetric$2(String metricName, Dataset predictions$8, MulticlassClassificationEvaluator MulticlassClassificationEvaluator$8, DoubleRef result2$6) {
        result2$6.elem = MulticlassClassificationEvaluator$8.setMetricName(metricName).evaluate(predictions$8);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)metricName).append((Object)" = ").append((Object)BoxesRunTime.boxToDouble((double)result2$6.elem)).toString());
        return result2$6.elem;
    }

    private Classifier$() {
        MODULE$ = this;
    }
}

