/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.ml.spark.mining.amieSpark;

import net.sansa_stack.ml.spark.mining.amieSpark.RDFGraph;
import net.sansa_stack.ml.spark.mining.amieSpark.RDFGraphDataFrame;
import net.sansa_stack.ml.spark.mining.amieSpark.RDFGraphNative;
import net.sansa_stack.ml.spark.mining.amieSpark.RDFTriple;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class RDFGraphLoader$ {
    public static final RDFGraphLoader$ MODULE$;
    private final Logger logger;

    static {
        new RDFGraphLoader$();
    }

    private Logger logger() {
        return this.logger;
    }

    public RDFGraph loadFromFile(String path, SparkContext sc, int minPartitions) {
        this.logger().info("loading triples from disk...");
        long startTime = System.currentTimeMillis();
        RDD triples = sc.textFile(path, minPartitions).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String line) {
                return line.replace("<", "").replace(">", "").split("\\s+");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(String[] tokens) {
                return new RDFTriple(tokens[0], tokens[1], new StringOps(Predef$.MODULE$.augmentString(tokens[2])).stripSuffix("."));
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class));
        this.logger().info(new StringBuilder().append((Object)"finished loading ").append((Object)BoxesRunTime.boxToLong((long)triples.count())).append((Object)" triples in ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))).append((Object)"ms.").toString());
        return new RDFGraph((RDD<RDFTriple>)triples);
    }

    public int loadFromFile$default$3() {
        return 2;
    }

    public RDFGraphNative loadGraphFromFile(String path, SparkSession session, int minPartitions) {
        this.logger().info("loading triples from disk...");
        long startTime = System.currentTimeMillis();
        RDD triples = session.sparkContext().textFile(path, minPartitions).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String line) {
                return line.replace(">", "").replace("<", "").split("\\s+");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(String[] tokens) {
                return new RDFTriple(tokens[0], tokens[1], tokens[2]);
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class));
        this.logger().info(new StringBuilder().append((Object)"finished loading ").append((Object)BoxesRunTime.boxToLong((long)triples.count())).append((Object)" triples in ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))).append((Object)"ms.").toString());
        return new RDFGraphNative((RDD<RDFTriple>)triples);
    }

    public int loadGraphFromFile$default$3() {
        return 2;
    }

    public RDFGraphDataFrame loadGraphDataFrameFromFile(String path, SparkSession session, int minPartitions) {
        return new RDFGraphDataFrame(this.loadGraphFromFile(path, session, minPartitions).toDataFrame(session));
    }

    public int loadGraphDataFrameFromFile$default$3() {
        return 2;
    }

    private RDFGraphLoader$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

