/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.ml.spark.kernel;

import net.sansa_stack.ml.spark.kernel.RDFFastTreeGraphKernel;
import net.sansa_stack.ml.spark.kernel.RDFFastTreeGraphKernel$;
import net.sansa_stack.ml.spark.kernel.RDFFastTreeGraphKernelUtil$;
import net.sansa_stack.ml.spark.kernel.Uri2Index$;
import net.sansa_stack.rdf.spark.io.NTripleReader$;
import org.apache.jena.graph.Triple;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.StdIn$;
import scala.runtime.BoxesRunTime;

public final class RDFFastTreeGraphKernelApp$ {
    public static final RDFFastTreeGraphKernelApp$ MODULE$;

    static {
        new RDFFastTreeGraphKernelApp$();
    }

    public void main(String[] args) {
        int taskNum = new StringOps(Predef$.MODULE$.augmentString(StdIn$.MODULE$.readLine("Task Number?(1=Affiliation, 3=Multi-contract, 4=Theme) ", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0])))).toInt();
        int depth = new StringOps(Predef$.MODULE$.augmentString(StdIn$.MODULE$.readLine("Depth? ", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0])))).toInt();
        int iteration = new StringOps(Predef$.MODULE$.augmentString(StdIn$.MODULE$.readLine("How many iterations or folding on validation? ", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0])))).toInt();
        SparkSession sparkSession = SparkSession$.MODULE$.builder().master("local[*]").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").appName("fast graph kernel").config("spark.driver.maxResultSize", "3g").getOrCreate();
        Logger.getRootLogger().setLevel(Level.WARN);
        long t0 = System.nanoTime();
        if (taskNum == 1) {
            this.experimentAffiliationPrediction(sparkSession, depth, iteration);
        }
        if (taskNum == 3) {
            this.experimentMultiContractPrediction(sparkSession, depth, iteration);
        }
        if (taskNum == 4) {
            this.experimentThemePrediction(sparkSession, depth, iteration, this.experimentThemePrediction$default$4());
        }
        RDFFastTreeGraphKernelUtil$.MODULE$.printTime("Total: ", t0, System.nanoTime());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"taskNum: ").append((Object)BoxesRunTime.boxToInteger((int)taskNum)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"depth: ").append((Object)BoxesRunTime.boxToInteger((int)depth)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"iteration: ").append((Object)BoxesRunTime.boxToInteger((int)iteration)).toString());
        sparkSession.stop();
    }

    public void experimentAffiliationPrediction(SparkSession sparkSession, int depth, int iteration) {
        String input = "src/main/resources/kernel/aifb-fixed_no_schema4.nt";
        long t0 = System.nanoTime();
        RDD tripleRDD = NTripleReader$.MODULE$.load(sparkSession, input, NTripleReader$.MODULE$.load$default$3(), NTripleReader$.MODULE$.load$default$4(), NTripleReader$.MODULE$.load$default$5(), NTripleReader$.MODULE$.load$default$6());
        tripleRDD.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple x$1) {
                String string = x$1.getPredicate().getURI();
                String string2 = "http://swrc.ontoware.org/ontology#affiliation";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Triple f) {
                Uri2Index$.MODULE$.setInstanceAndLabel(f.getSubject().toString(), f.getObject().toString());
            }
        });
        tripleRDD.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple x$2) {
                String string = x$2.getPredicate().getURI();
                String string2 = "http://swrc.ontoware.org/ontology#employs";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Triple f) {
                Uri2Index$.MODULE$.setInstanceAndLabel(f.getObject().toString(), f.getSubject().toString());
            }
        });
        RDD filteredTripleRDD = tripleRDD.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple x$3) {
                String string = x$3.getPredicate().getURI();
                String string2 = "http://swrc.ontoware.org/ontology#affiliation";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple x$4) {
                String string = x$4.getPredicate().getURI();
                String string2 = "http://swrc.ontoware.org/ontology#employs";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        });
        Dataset<Row> instanceDF = Uri2Index$.MODULE$.getInstanceLabelsDF(sparkSession);
        instanceDF.groupBy("label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().show();
        RDFFastTreeGraphKernel rdfFastTreeGraphKernel = RDFFastTreeGraphKernel$.MODULE$.apply(sparkSession, (RDD<Triple>)filteredTripleRDD, instanceDF, depth);
        RDD<LabeledPoint> data = rdfFastTreeGraphKernel.getMLLibLabeledPoints();
        long t1 = System.nanoTime();
        RDFFastTreeGraphKernelUtil$.MODULE$.printTime("Initialization", t0, t1);
        RDFFastTreeGraphKernelUtil$.MODULE$.predictLogisticRegressionMLLIB(data, 4, iteration);
        long t2 = System.nanoTime();
        RDFFastTreeGraphKernelUtil$.MODULE$.printTime("Run Prediction", t1, t2);
    }

    public void experimentMultiContractPrediction(SparkSession sparkSession, int depth, int iteration) {
        String input = "src/main/resources/kernel/LDMC_Task2_train.nt";
        long t0 = System.nanoTime();
        RDD tripleRDD = NTripleReader$.MODULE$.load(sparkSession, input, NTripleReader$.MODULE$.load$default$3(), NTripleReader$.MODULE$.load$default$4(), NTripleReader$.MODULE$.load$default$5(), NTripleReader$.MODULE$.load$default$6());
        tripleRDD.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple x$5) {
                String string = x$5.getPredicate().getURI();
                String string2 = "http://example.com/multicontract";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Triple f) {
                Uri2Index$.MODULE$.setInstanceAndLabel(f.getSubject().toString(), f.getObject().toString());
            }
        });
        RDD filteredTripleRDD = tripleRDD.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple x$6) {
                String string = x$6.getPredicate().getURI();
                String string2 = "http://example.com/multicontract";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        });
        Dataset<Row> instanceDF = Uri2Index$.MODULE$.getInstanceLabelsDF(sparkSession);
        instanceDF.groupBy("label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().show();
        RDFFastTreeGraphKernel rdfFastTreeGraphKernel = RDFFastTreeGraphKernel$.MODULE$.apply(sparkSession, (RDD<Triple>)filteredTripleRDD, instanceDF, depth);
        RDD<LabeledPoint> data = rdfFastTreeGraphKernel.getMLLibLabeledPoints();
        long t1 = System.nanoTime();
        RDFFastTreeGraphKernelUtil$.MODULE$.printTime("Initialization", t0, t1);
        RDFFastTreeGraphKernelUtil$.MODULE$.predictLogisticRegressionMLLIB(data, 2, iteration);
        long t2 = System.nanoTime();
        RDFFastTreeGraphKernelUtil$.MODULE$.printTime("Run Prediction", t1, t2);
    }

    public void experimentThemePrediction(SparkSession sparkSession, int depth, int iteration, String fraction) {
        String input = new StringBuilder().append((Object)"src/main/resources/kernel/Lexicon_NamedRockUnit_t").append((Object)fraction).append((Object)".nt").toString();
        long t0 = System.nanoTime();
        RDD tripleRDD = NTripleReader$.MODULE$.load(sparkSession, input, NTripleReader$.MODULE$.load$default$3(), NTripleReader$.MODULE$.load$default$4(), NTripleReader$.MODULE$.load$default$5(), NTripleReader$.MODULE$.load$default$6());
        tripleRDD.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple x$7) {
                String string = x$7.getPredicate().getURI();
                String string2 = "http://data.bgs.ac.uk/ref/Lexicon/hasTheme";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Triple f) {
                Uri2Index$.MODULE$.setInstanceAndLabel(f.getSubject().toString(), f.getObject().toString());
            }
        });
        RDD filteredTripleRDD = tripleRDD.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple x$8) {
                String string = x$8.getPredicate().getURI();
                String string2 = "http://data.bgs.ac.uk/ref/Lexicon/hasTheme";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        });
        Dataset<Row> instanceDF = Uri2Index$.MODULE$.getInstanceLabelsDF(sparkSession);
        RDFFastTreeGraphKernel rdfFastTreeGraphKernel = RDFFastTreeGraphKernel$.MODULE$.apply(sparkSession, (RDD<Triple>)filteredTripleRDD, instanceDF, depth);
        RDD<LabeledPoint> data = rdfFastTreeGraphKernel.getMLLibLabeledPoints();
        long t1 = System.nanoTime();
        RDFFastTreeGraphKernelUtil$.MODULE$.printTime("Initialization", t0, t1);
        RDFFastTreeGraphKernelUtil$.MODULE$.predictLogisticRegressionMLLIB(data, 2, iteration);
        long t2 = System.nanoTime();
        RDFFastTreeGraphKernelUtil$.MODULE$.printTime("Run Prediction", t1, t2);
    }

    public String experimentThemePrediction$default$4() {
        return "";
    }

    private RDFFastTreeGraphKernelApp$() {
        MODULE$ = this;
    }
}

