/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.ml.spark.clustering.utils;

import com.typesafe.config.Config;
import java.io.File;
import java.io.FilenameFilter;
import net.sansa_stack.ml.spark.clustering.datatypes.Categories;
import net.sansa_stack.ml.spark.clustering.datatypes.CoordinatePOI;
import net.sansa_stack.ml.spark.clustering.datatypes.POI;
import net.sansa_stack.rdf.spark.io.NTripleReader$;
import org.apache.jena.graph.Triple;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.Function2;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u0001\u0003\u0001=\u0011a\u0002R1uCB\u0013xnY3tg&twM\u0003\u0002\u0004\t\u0005)Q\u000f^5mg*\u0011QAB\u0001\u000bG2,8\u000f^3sS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0002nY*\u00111\u0002D\u0001\fg\u0006t7/Y0ti\u0006\u001c7NC\u0001\u000e\u0003\rqW\r^\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E9\u0012B\u0001\r\u0013\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!9\u0001A!b\u0001\n\u0003QR#A\u000e\u0011\u0005q!S\"A\u000f\u000b\u0005yy\u0012aA:rY*\u0011q\u0001\t\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014x-\u0003\u0002&;\ta1\u000b]1sWN+7o]5p]\"Aq\u0005\u0001B\u0001B\u0003%1$\u0001\u0004ta\u0006\u00148\u000e\t\u0005\tS\u0001\u0011)\u0019!C\u0001U\u0005!1m\u001c8g+\u0005Y\u0003C\u0001\u00174\u001b\u0005i#B\u0001\u00180\u0003\u0019\u0019wN\u001c4jO*\u0011\u0001'M\u0001\tif\u0004Xm]1gK*\t!'A\u0002d_6L!\u0001N\u0017\u0003\r\r{gNZ5h\u0011!1\u0004A!A!\u0002\u0013Y\u0013!B2p]\u001a\u0004\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u000f\u0011\fG/\u0019*E\tB\u0019!(P \u000e\u0003mR!\u0001P\u0010\u0002\u0007I$G-\u0003\u0002?w\t\u0019!\u000b\u0012#\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015!B4sCBD'B\u0001#!\u0003\u0011QWM\\1\n\u0005\u0019\u000b%A\u0002+sSBdW\rC\u0003I\u0001\u0011\u0005\u0011*\u0001\u0004=S:LGO\u0010\u000b\u0005\u00152ke\n\u0005\u0002L\u00015\t!\u0001C\u0003\b\u000f\u0002\u00071\u0004C\u0003*\u000f\u0002\u00071\u0006C\u00039\u000f\u0002\u0007\u0011\bC\u0004Q\u0001\u0001\u0007I\u0011A)\u0002\u001dA|\u0017nQ8pe\u0012Lg.\u0019;fgV\t!\u000bE\u0002;{M\u0003B!\u0005+W3&\u0011QK\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005E9\u0016B\u0001-\u0013\u0005\u0011auN\\4\u0011\u0005ikV\"A.\u000b\u0005q#\u0011!\u00033bi\u0006$\u0018\u0010]3t\u0013\tq6LA\u0007D_>\u0014H-\u001b8bi\u0016\u0004v*\u0013\u0005\bA\u0002\u0001\r\u0011\"\u0001b\u0003I\u0001x.[\"p_J$\u0017N\\1uKN|F%Z9\u0015\u0005\t,\u0007CA\td\u0013\t!'C\u0001\u0003V]&$\bb\u00024`\u0003\u0003\u0005\rAU\u0001\u0004q\u0012\n\u0004B\u00025\u0001A\u0003&!+A\bq_&\u001cun\u001c:eS:\fG/Z:!\u0011\u001dQ\u0007\u00011A\u0005\u0002-\f\u0011\u0003]8j\r2\fGoQ1uK\u001e|'/_%e+\u0005a\u0007c\u0001\u001e>[B!\u0011\u0003\u0016,W\u0011\u001dy\u0007\u00011A\u0005\u0002A\fQ\u0003]8j\r2\fGoQ1uK\u001e|'/_%e?\u0012*\u0017\u000f\u0006\u0002cc\"9aM\\A\u0001\u0002\u0004a\u0007BB:\u0001A\u0003&A.\u0001\nq_&4E.\u0019;DCR,wm\u001c:z\u0013\u0012\u0004\u0003bB;\u0001\u0001\u0004%\tA^\u0001\u000ea>L7)\u0019;fO>\u0014\u00180\u00133\u0016\u0003]\u00042AO\u001fy!\u0011\tBKV=\u0011\u0007ilhK\u0004\u0002\u0012w&\u0011APE\u0001\u0007!J,G-\u001a4\n\u0005y|(aA*fi*\u0011AP\u0005\u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0001\u0003\u000b\t\u0011\u0003]8j\u0007\u0006$XmZ8ss&#w\fJ3r)\r\u0011\u0017q\u0001\u0005\tM\u0006\u0005\u0011\u0011!a\u0001o\"9\u00111\u0002\u0001!B\u00139\u0018A\u00049pS\u000e\u000bG/Z4pefLE\r\t\u0005\n\u0003\u001f\u0001\u0001\u0019!C\u0001\u0003#\t1\u0003]8j\u0007\u0006$XmZ8ssZ\u000bG.^3TKR,\"!a\u0005\u0011\tij\u0014Q\u0003\t\u0006#Q3\u0016q\u0003\t\u00045\u0006e\u0011bAA\u000e7\nQ1)\u0019;fO>\u0014\u0018.Z:\t\u0013\u0005}\u0001\u00011A\u0005\u0002\u0005\u0005\u0012a\u00069pS\u000e\u000bG/Z4pef4\u0016\r\\;f'\u0016$x\fJ3r)\r\u0011\u00171\u0005\u0005\nM\u0006u\u0011\u0011!a\u0001\u0003'A\u0001\"a\n\u0001A\u0003&\u00111C\u0001\u0015a>L7)\u0019;fO>\u0014\u0018PV1mk\u0016\u001cV\r\u001e\u0011\t\u0013\u0005-\u0002\u00011A\u0005\u0002\u0005E\u0011!\u00049pS\u000e\u000bG/Z4pe&,7\u000fC\u0005\u00020\u0001\u0001\r\u0011\"\u0001\u00022\u0005\t\u0002o\\5DCR,wm\u001c:jKN|F%Z9\u0015\u0007\t\f\u0019\u0004C\u0005g\u0003[\t\t\u00111\u0001\u0002\u0014!A\u0011q\u0007\u0001!B\u0013\t\u0019\"\u0001\bq_&\u001c\u0015\r^3h_JLWm\u001d\u0011\t\u0013\u0005m\u0002A1A\u0005\u0002\u0005u\u0012!\u00059pSf+G\u000e]\"bi\u0016<wN]5fgV\u0011\u0011q\b\t\u0005uu\n\t\u0005E\u0003\u0012)Z\u000b\u0019\u0005\u0005\u0004\u0012)\u0006]\u0011Q\t\t\u0004#\u0005\u001d\u0013bAA%%\t1Ai\\;cY\u0016D\u0001\"!\u0014\u0001A\u0003%\u0011qH\u0001\u0013a>L\u0017,\u001a7q\u0007\u0006$XmZ8sS\u0016\u001c\b\u0005C\u0005\u0002R\u0001\u0001\r\u0011\"\u0001\u0002T\u0005!\u0001o\\5t+\t\t)\u0006\u0005\u0003;{\u0005]\u0003c\u0001.\u0002Z%\u0019\u00111L.\u0003\u0007A{\u0015\nC\u0005\u0002`\u0001\u0001\r\u0011\"\u0001\u0002b\u0005A\u0001o\\5t?\u0012*\u0017\u000fF\u0002c\u0003GB\u0011BZA/\u0003\u0003\u0005\r!!\u0016\t\u0011\u0005\u001d\u0004\u0001)Q\u0005\u0003+\nQ\u0001]8jg\u0002Bq!a\u001b\u0001\t\u0003\ti'A\u0006m_\u0006$g\n\u0016:ja2,GcA\u001d\u0002p!A\u0011\u0011OA5\u0001\u0004\t\u0019(\u0001\bue&\u0004H.\u001a$jY\u0016\u0004\u0016\r\u001e5\u0011\u0007i\f)(C\u0002\u0002x}\u0014aa\u0015;sS:<\u0007bBA>\u0001\u0011\u0005\u0011QP\u0001\u0012M&dG/\u001a:D_>\u0014H-\u001b8bi\u0016\u001cHc\u0003*\u0002\u0000\u0005\u0005\u0015QQAE\u0003\u001bCa\u0001UA=\u0001\u0004\u0011\u0006\u0002CAB\u0003s\u0002\r!!\u0012\u0002\r1|w,\\5o\u0011!\t9)!\u001fA\u0002\u0005\u0015\u0013A\u00027p?6\f\u0007\u0010\u0003\u0005\u0002\f\u0006e\u0004\u0019AA#\u0003\u0019a\u0017mX7j]\"A\u0011qRA=\u0001\u0004\t)%\u0001\u0004mC~k\u0017\r\u001f\u0005\u0007\u0003'\u0003A\u0011A)\u0002#\u001d,G\u000fU(J\u0007>|'\u000fZ5oCR,7\u000fC\u0004\u0002\u0014\u0002!\t!a&\u0015\u0013I\u000bI*a'\u0002\u001e\u0006}\u0005\u0002CAB\u0003+\u0003\r!!\u0012\t\u0011\u0005\u001d\u0015Q\u0013a\u0001\u0003\u000bB\u0001\"a#\u0002\u0016\u0002\u0007\u0011Q\t\u0005\t\u0003\u001f\u000b)\n1\u0001\u0002F!1\u00111\u0015\u0001\u0005\u0002-\fAcZ3u!>Ke\t\\1u\u0007\u0006$XmZ8ss&#\u0007bBAT\u0001\u0011\u0005\u0011\u0011V\u0001\u0011O\u0016$\bkT%DCR,wm\u001c:jKN$\u0002\"a\u0005\u0002,\u00065\u0016q\u0016\u0005\u0007!\u0006\u0015\u0006\u0019\u0001*\t\r)\f)\u000b1\u0001m\u0011!\ty!!*A\u0002\u0005M\u0001bBAZ\u0001\u0011\u0005\u0011\u0011C\u0001\u0012O\u0016$8)\u0019;fO>\u0014\u0018PV1mk\u0016\u001c\bbBA\\\u0001\u0011\u0005\u0011\u0011X\u0001\u000eO\u0016$8)\u0019;fO>\u0014\u00180\u00133\u0015\u000b]\fY,!0\t\rA\u000b)\f1\u0001S\u0011\u0019Q\u0017Q\u0017a\u0001Y\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0017!E4fif+G\u000e]\"bi\u0016<wN]5fgR!\u0011qHAc\u0011\u001d\t9-a0A\u0002e\n\u0011\"\\3sO\u0016$'\u000b\u0012#\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\u0006Yq-\u001a;`iJL\u0007\u000f\\3t))\ty-a5\u0002X\u0006\u0005\u00181\u001d\t\u0005uu\n\t\u000eE\u0003\u0012)\u0006Mt\b\u0003\u0005\u0002V\u0006%\u0007\u0019AA:\u0003\u0005\t\u0007\u0002CAm\u0003\u0013\u0004\r!a7\u0002\u0011A|\u0017.\u0011:sCf\u0004B!EAo-&\u0019\u0011q\u001c\n\u0003\u000b\u0005\u0013(/Y=\t\ra\nI\r1\u0001:\u0011\u00199\u0011\u0011\u001aa\u00017!9\u0011q\u001d\u0001\u0005\u0002\u0005%\u0018AD2sK\u0006$XmU;cU\u0016\u001cGo\u001d\u000b\u0005\u0003W\fY\u0010\u0005\u0004\u0002n\u0006]\u00181O\u0007\u0003\u0003_TA!!=\u0002t\u00069Q.\u001e;bE2,'bAA{%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u0018q\u001e\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fC\u0004\u0002~\u0006\u0015\b\u0019\u0001,\u0002\u000bA|\u0017.\u0013#")
public class DataProcessing
implements Serializable {
    private final SparkSession spark;
    private final Config conf;
    private final RDD<Triple> dataRDD;
    private RDD<Tuple2<Object, CoordinatePOI>> poiCoordinates;
    private RDD<Tuple2<Object, Object>> poiFlatCategoryId;
    private RDD<Tuple2<Object, scala.collection.immutable.Set<Object>>> poiCategoryId;
    private RDD<Tuple2<Object, Categories>> poiCategoryValueSet;
    private RDD<Tuple2<Object, Categories>> poiCategories;
    private final RDD<Tuple2<Object, Tuple2<Categories, Object>>> poiYelpCategories;
    private RDD<POI> pois;

    public SparkSession spark() {
        return this.spark;
    }

    public Config conf() {
        return this.conf;
    }

    public RDD<Tuple2<Object, CoordinatePOI>> poiCoordinates() {
        return this.poiCoordinates;
    }

    public void poiCoordinates_$eq(RDD<Tuple2<Object, CoordinatePOI>> x$1) {
        this.poiCoordinates = x$1;
    }

    public RDD<Tuple2<Object, Object>> poiFlatCategoryId() {
        return this.poiFlatCategoryId;
    }

    public void poiFlatCategoryId_$eq(RDD<Tuple2<Object, Object>> x$1) {
        this.poiFlatCategoryId = x$1;
    }

    public RDD<Tuple2<Object, scala.collection.immutable.Set<Object>>> poiCategoryId() {
        return this.poiCategoryId;
    }

    public void poiCategoryId_$eq(RDD<Tuple2<Object, scala.collection.immutable.Set<Object>>> x$1) {
        this.poiCategoryId = x$1;
    }

    public RDD<Tuple2<Object, Categories>> poiCategoryValueSet() {
        return this.poiCategoryValueSet;
    }

    public void poiCategoryValueSet_$eq(RDD<Tuple2<Object, Categories>> x$1) {
        this.poiCategoryValueSet = x$1;
    }

    public RDD<Tuple2<Object, Categories>> poiCategories() {
        return this.poiCategories;
    }

    public void poiCategories_$eq(RDD<Tuple2<Object, Categories>> x$1) {
        this.poiCategories = x$1;
    }

    public RDD<Tuple2<Object, Tuple2<Categories, Object>>> poiYelpCategories() {
        return this.poiYelpCategories;
    }

    public RDD<POI> pois() {
        return this.pois;
    }

    public void pois_$eq(RDD<POI> x$1) {
        this.pois = x$1;
    }

    public RDD<Triple> loadNTriple(String tripleFilePath) {
        RDD rDD;
        File tripleFile = new File(tripleFilePath);
        if (tripleFile.isDirectory()) {
            File[] files = tripleFile.listFiles(new FilenameFilter(this){

                public boolean accept(File tripleFile, String name) {
                    return !name.toString().contains("SUCCESS") && !name.toLowerCase().endsWith(".crc");
                }
            });
            IntRef i = IntRef.create((int)0);
            ObjectRef triple_0 = ObjectRef.create((Object)NTripleReader$.MODULE$.load(this.spark(), files[0].getAbsolutePath(), NTripleReader$.MODULE$.load$default$3(), NTripleReader$.MODULE$.load$default$4(), NTripleReader$.MODULE$.load$default$5(), NTripleReader$.MODULE$.load$default$6()));
            Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new Serializable(this, i, triple_0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DataProcessing $outer;
                private final IntRef i$1;
                private final ObjectRef triple_0$1;

                public final void apply(File file) {
                    if (this.i$1.elem != 0) {
                        this.triple_0$1.elem = ((RDD)this.triple_0$1.elem).union(NTripleReader$.MODULE$.load(this.$outer.spark(), file.getAbsolutePath(), NTripleReader$.MODULE$.load$default$3(), NTripleReader$.MODULE$.load$default$4(), NTripleReader$.MODULE$.load$default$5(), NTripleReader$.MODULE$.load$default$6()));
                    }
                    ++this.i$1.elem;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.i$1 = i$1;
                    this.triple_0$1 = triple_0$1;
                }
            });
            rDD = (RDD)triple_0.elem;
        } else {
            rDD = NTripleReader$.MODULE$.load(this.spark(), tripleFile.getAbsolutePath(), NTripleReader$.MODULE$.load$default$3(), NTripleReader$.MODULE$.load$default$4(), NTripleReader$.MODULE$.load$default$5(), NTripleReader$.MODULE$.load$default$6());
        }
        return rDD;
    }

    public RDD<Tuple2<Object, CoordinatePOI>> filterCoordinates(RDD<Tuple2<Object, CoordinatePOI>> poiCoordinates, double lo_min, double lo_max, double la_min, double la_max) {
        return poiCoordinates.filter((Function1)new Serializable(this, lo_min, lo_max, la_min, la_max){
            public static final long serialVersionUID = 0L;
            private final double lo_min$1;
            private final double lo_max$1;
            private final double la_min$1;
            private final double la_max$1;

            public final boolean apply(Tuple2<Object, CoordinatePOI> x) {
                return ((CoordinatePOI)x._2()).longitude() >= this.lo_min$1 && ((CoordinatePOI)x._2()).longitude() <= this.lo_max$1 && ((CoordinatePOI)x._2()).latitude() >= this.la_min$1 && ((CoordinatePOI)x._2()).latitude() <= this.la_max$1;
            }
            {
                this.lo_min$1 = lo_min$1;
                this.lo_max$1 = lo_max$1;
                this.la_min$1 = la_min$1;
                this.la_max$1 = la_max$1;
            }
        });
    }

    public RDD<Tuple2<Object, CoordinatePOI>> getPOICoordinates() {
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString("POINT(.+ .+)")).r();
        RDD poiCoordinatesString = this.dataRDD.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataProcessing $outer;

            public final boolean apply(Triple x) {
                return x.getPredicate().toString().equalsIgnoreCase(this.$outer.conf().getString("sansa.data.coordinatesPredicate"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable(this, pattern){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataProcessing $outer;
            private final Regex pattern$1;

            public final Tuple2<Object, String> apply(Triple x) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(x.getSubject().toString().replace(this.$outer.conf().getString("sansa.data.poiPrefix"), "").replace("/geometry", ""))).toLong()), (Object)((String)Option$.MODULE$.option2Iterable(this.pattern$1.findFirstIn((CharSequence)x.getObject().toString())).head()).replace("POINT", "").replace("^^http://www.opengis.net/ont/geosparql#wktLiteral", "").replaceAll("^\"|\"$", ""));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pattern$1 = pattern$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(poiCoordinatesString, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering.Long$.MODULE$).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final CoordinatePOI apply(String x) {
                String[] coordinates = x.replace("(", "").replace(")", "").split(" ");
                return new CoordinatePOI(new StringOps(Predef$.MODULE$.augmentString(coordinates[0])).toDouble(), new StringOps(Predef$.MODULE$.augmentString(coordinates[1])).toDouble());
            }
        });
    }

    public RDD<Tuple2<Object, CoordinatePOI>> getPOICoordinates(double lo_min, double lo_max, double la_min, double la_max) {
        return this.filterCoordinates(this.getPOICoordinates(), lo_min, lo_max, la_min, la_max);
    }

    public RDD<Tuple2<Object, Object>> getPOIFlatCategoryId() {
        RDD poiFlatCategories = this.dataRDD.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataProcessing $outer;

            public final boolean apply(Triple x) {
                return x.getPredicate().toString().equalsIgnoreCase(this.$outer.conf().getString("sansa.data.categoryPOI"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return poiFlatCategories.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataProcessing $outer;

            public final Tuple2<Object, Object> apply(Triple x) {
                return new Tuple2.mcJJ.sp(new StringOps(Predef$.MODULE$.augmentString(x.getSubject().toString().replace(this.$outer.conf().getString("sansa.data.poiPrefix"), ""))).toLong(), new StringOps(Predef$.MODULE$.augmentString(x.getObject().toString().replace(this.$outer.conf().getString("sansa.data.termPrefix"), ""))).toLong());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, Categories>> getPOICategories(RDD<Tuple2<Object, CoordinatePOI>> poiCoordinates, RDD<Tuple2<Object, Object>> poiFlatCategoryId, RDD<Tuple2<Object, Categories>> poiCategoryValueSet) {
        RDD poiCategorySets = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(poiFlatCategoryId.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> f) {
                return new Tuple2.mcJJ.sp(f._2$mcJ$sp(), f._1$mcJ$sp());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Long(), (Ordering)Ordering.Long$.MODULE$).join(poiCategoryValueSet).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Categories> apply(Tuple2<Object, Tuple2<Object, Categories>> f) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)((Tuple2)f._2())._1$mcJ$sp()), ((Tuple2)f._2())._2());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Categories.class), (Ordering)Ordering.Long$.MODULE$).groupByKey();
        return RDD$.MODULE$.rddToPairRDDFunctions(poiCoordinates, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(CoordinatePOI.class), (Ordering)Ordering.Long$.MODULE$).join(poiCategorySets).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Categories> apply(Tuple2<Object, Tuple2<CoordinatePOI, Iterable<Categories>>> x) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (Object)new Categories((Set<String>)((Set)Set$.MODULE$.apply((Seq)((TraversableOnce)((TraversableLike)((Tuple2)x._2())._2()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<String> apply(Categories x$1) {
                        return x$1.categories();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toList()))));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, Categories>> getCategoryValues() {
        RDD categoryTriples = this.dataRDD.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataProcessing $outer;

            public final boolean apply(Triple x) {
                return x.getPredicate().toString().equalsIgnoreCase(this.$outer.conf().getString("sansa.data.termValueUri"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        RDD categoriesIdValues = categoryTriples.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataProcessing $outer;

            public final Tuple2<Object, String> apply(Triple x) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(x.getSubject().toString().replace(this.$outer.conf().getString("sansa.data.termPrefix"), ""))).toLong()), (Object)x.getObject().toString().replaceAll("\"", ""));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(categoriesIdValues, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering.Long$.MODULE$).groupByKey().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Categories> apply(Tuple2<Object, Iterable<String>> x) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (Object)new Categories((Set<String>)((Set)Set$.MODULE$.apply((Seq)((TraversableOnce)x._2()).toList()))));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, scala.collection.immutable.Set<Object>>> getCategoryId(RDD<Tuple2<Object, CoordinatePOI>> poiCoordinates, RDD<Tuple2<Object, Object>> poiFlatCategoryId) {
        return RDD$.MODULE$.rddToPairRDDFunctions(poiCoordinates, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(CoordinatePOI.class), (Ordering)Ordering.Long$.MODULE$).join(RDD$.MODULE$.rddToPairRDDFunctions(poiFlatCategoryId, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Long(), (Ordering)Ordering.Long$.MODULE$).groupByKey()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, scala.collection.immutable.Set<Object>> apply(Tuple2<Object, Tuple2<CoordinatePOI, Iterable<Object>>> x) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (Object)((TraversableOnce)((Tuple2)x._2())._2()).toSet());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, Tuple2<Categories, Object>>> getYelpCategories(RDD<Triple> mergedRDD) {
        RDD yelpPOICategory = mergedRDD.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataProcessing $outer;

            public final boolean apply(Triple triple) {
                return triple.getPredicate().toString().equalsIgnoreCase(this.$outer.conf().getString("yelp.data.categoryPOI"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.println((Object)this.conf().getString("yelp.data.rating"));
        RDD yelpPOIRating = mergedRDD.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataProcessing $outer;

            public final boolean apply(Triple triple) {
                return triple.getPredicate().toString().contains(this.$outer.conf().getString("yelp.data.rating"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.println((Object)"category");
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToLong((long)yelpPOICategory.count()));
        Predef$.MODULE$.println((Object)"rating");
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToLong((long)yelpPOIRating.count()));
        RDD yelpPOICategoryMapped = yelpPOICategory.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataProcessing $outer;

            public final Tuple2<Object, String> apply(Triple triple) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(triple.getSubject().toString().replace(this.$outer.conf().getString("sansa.data.poiPrefix"), ""))).toLong()), (Object)triple.getObject().toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD yelpPOIRatingMapped = yelpPOIRating.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataProcessing $outer;

            public final Tuple2<Object, Object> apply(Triple triple) {
                return new Tuple2.mcJD.sp(new StringOps(Predef$.MODULE$.augmentString(triple.getSubject().toString().replace(this.$outer.conf().getString("sansa.data.poiPrefix"), ""))).toLong(), new StringOps(Predef$.MODULE$.augmentString(triple.getObject().getLiteralValue().toString())).toDouble());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(yelpPOICategoryMapped, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering.Long$.MODULE$).groupByKey(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.Long$.MODULE$).join(yelpPOIRatingMapped).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<Categories, Object>> apply(Tuple2<Object, Tuple2<Iterable<String>, Object>> x) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (Object)new Tuple2((Object)new Categories((Set<String>)((Set)Set$.MODULE$.apply((Seq)((TraversableOnce)((Tuple2)x._2())._1()).toList()))), (Object)BoxesRunTime.boxToDouble((double)((Tuple2)x._2())._2$mcD$sp())));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<String, Triple>> get_triples(String a, long[] poiArray, RDD<Triple> dataRDD, SparkSession spark) {
        ArrayBuffer subjects = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), poiArray.length - 1).foreach((Function1)new Serializable(this, poiArray, subjects){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataProcessing $outer;
            private final long[] poiArray$1;
            private final ArrayBuffer subjects$1;

            public final ArrayBuffer<String> apply(int i) {
                return this.subjects$1.$plus$plus$eq(this.$outer.createSubjects(this.poiArray$1[i]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.poiArray$1 = poiArray$1;
                this.subjects$1 = subjects$1;
            }
        });
        RDD dataRDDPair = dataRDD.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Triple> apply(Triple f) {
                return new Tuple2((Object)f.getSubject().getURI(), (Object)f);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).persist();
        RDD subjectsRDD = spark.sparkContext().parallelize((Seq)subjects.toSet().toList(), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String f) {
                return new Tuple2((Object)f, (Object)f);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).persist();
        RDD viennaTriples = RDD$.MODULE$.rddToPairRDDFunctions(subjectsRDD, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering.String$.MODULE$).join(dataRDDPair).map((Function1)new Serializable(this, a){
            public static final long serialVersionUID = 0L;
            private final String a$1;

            public final Tuple2<String, Triple> apply(Tuple2<String, Tuple2<String, Triple>> f) {
                return new Tuple2((Object)this.a$1, ((Tuple2)f._2())._2());
            }
            {
                this.a$1 = a$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).persist();
        RDD viennaCatgoriesObjects = viennaTriples.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Triple> f) {
                return ((Triple)f._2()).getPredicate().getURI().equals("http://slipo.eu/def#category");
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Triple> f) {
                return ((Triple)f._2()).getObject().getURI();
            }
        }, ClassTag$.MODULE$.apply(String.class)).distinct().persist();
        RDD viennaPoiCategoriesRDD = viennaCatgoriesObjects.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String f) {
                return new Tuple2((Object)f, (Object)f);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).persist();
        RDD viennaCategoryTriples = RDD$.MODULE$.rddToPairRDDFunctions(viennaPoiCategoriesRDD, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering.String$.MODULE$).join(dataRDDPair).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Triple apply(Tuple2<String, Tuple2<String, Triple>> f) {
                return (Triple)((Tuple2)f._2())._2();
            }
        }, ClassTag$.MODULE$.apply(Triple.class));
        RDD temp = viennaCategoryTriples.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Triple> apply(Triple f) {
                return new Tuple2((Object)new StringBuilder().append((Object)f.getSubject().getURI()).append((Object)f.getPredicate().getURI()).append((Object)f.getObject().toString()).toString(), (Object)f);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).persist();
        RDD categoryTriples = RDD$.MODULE$.rddToPairRDDFunctions(temp, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Triple.class), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Triple apply(Triple v1, Triple v2) {
                return v1;
            }
        }).map((Function1)new Serializable(this, a){
            public static final long serialVersionUID = 0L;
            private final String a$1;

            public final Tuple2<String, Triple> apply(Tuple2<String, Triple> f) {
                return new Tuple2((Object)this.a$1, f._2());
            }
            {
                this.a$1 = a$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).persist();
        RDD union = viennaTriples.union(categoryTriples);
        return union;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayBuffer<String> createSubjects(long poiID) {
        void var3_2;
        ArrayBuffer subjects = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String id = "http://example.org/id/poi/".concat(((Object)BoxesRunTime.boxToLong((long)poiID)).toString());
        subjects.$plus$eq((Object)id);
        subjects.$plus$eq((Object)id.concat("/address"));
        subjects.$plus$eq((Object)id.concat("/phone"));
        subjects.$plus$eq((Object)id.concat("/geometry"));
        subjects.$plus$eq((Object)id.concat("/name"));
        subjects.$plus$eq((Object)id.concat("/accuracy_info"));
        subjects.$plus$eq((Object)id.concat("/brandname"));
        return var3_2;
    }

    public DataProcessing(SparkSession spark, Config conf, RDD<Triple> dataRDD) {
        RDD rDD;
        this.spark = spark;
        this.conf = conf;
        this.dataRDD = dataRDD;
        this.poiCoordinates = this.getPOICoordinates();
        this.poiFlatCategoryId = this.getPOIFlatCategoryId();
        this.poiCategoryId = this.getCategoryId(this.poiCoordinates(), this.poiFlatCategoryId()).persist();
        this.poiCategoryValueSet = this.getCategoryValues();
        this.poiCategories = this.getPOICategories(this.poiCoordinates(), this.poiFlatCategoryId(), this.poiCategoryValueSet());
        this.poiYelpCategories = this.getYelpCategories(dataRDD).sample(false, 0.1, 0L);
        if (this.poiYelpCategories().isEmpty()) {
            rDD = RDD$.MODULE$.rddToPairRDDFunctions(this.poiCoordinates(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(CoordinatePOI.class), (Ordering)Ordering.Long$.MODULE$).join(this.poiCategories()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final POI apply(Tuple2<Object, Tuple2<CoordinatePOI, Categories>> x) {
                    return new POI(x._1$mcJ$sp(), (CoordinatePOI)((Tuple2)x._2())._1(), (Categories)((Tuple2)x._2())._2(), 0.0);
                }
            }, ClassTag$.MODULE$.apply(POI.class)).persist();
        } else {
            RDD poiAllCategories = RDD$.MODULE$.rddToPairRDDFunctions(this.poiYelpCategories(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).join(this.poiCategories()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Tuple2<Categories, Object>> apply(Tuple2<Object, Tuple2<Tuple2<Categories, Object>, Categories>> x) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (Object)new Tuple2((Object)new Categories((Set<String>)((Categories)((Tuple2)((Tuple2)x._2())._1())._1()).categories().$plus$plus(((Categories)((Tuple2)x._2())._2()).categories())), (Object)BoxesRunTime.boxToDouble((double)((Tuple2)((Tuple2)x._2())._1())._2$mcD$sp())));
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            rDD = RDD$.MODULE$.rddToPairRDDFunctions(this.poiCoordinates(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(CoordinatePOI.class), (Ordering)Ordering.Long$.MODULE$).join(poiAllCategories).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final POI apply(Tuple2<Object, Tuple2<CoordinatePOI, Tuple2<Categories, Object>>> x) {
                    return new POI(x._1$mcJ$sp(), (CoordinatePOI)((Tuple2)x._2())._1(), (Categories)((Tuple2)((Tuple2)x._2())._2())._1(), ((Tuple2)((Tuple2)x._2())._2())._2$mcD$sp());
                }
            }, ClassTag$.MODULE$.apply(POI.class)).persist();
        }
        this.pois = rDD;
    }
}

