/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.ml.common.outliers.vandalismdetection.feature.extraction;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sansa_stack.ml.common.outliers.vandalismdetection.feature.extraction.Statement$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class Comment$
implements Serializable {
    public static final Comment$ MODULE$;
    private final Logger logger;
    private final Pattern ROBUST_ROLLBACK_PATTERN;
    private final Pattern PRECISE_ROLLBACK_PATTERN;
    private final Pattern ROBUST_UNDO_PATTERN;
    private final Pattern PRECISE_UNDO_PATTERN;
    private final Pattern ROBUST_RESTORE_PATTERN;
    private final Pattern PRECISE_RESTORE_PATTERN;
    private String text;
    private String action1;
    private String action2;
    private String[] parameters;
    private String suffixComment;
    private String property;
    private String dataValue;
    private String itemValue;

    static {
        new Comment$();
    }

    public Logger logger() {
        return this.logger;
    }

    public Pattern ROBUST_ROLLBACK_PATTERN() {
        return this.ROBUST_ROLLBACK_PATTERN;
    }

    public Pattern PRECISE_ROLLBACK_PATTERN() {
        return this.PRECISE_ROLLBACK_PATTERN;
    }

    public Pattern ROBUST_UNDO_PATTERN() {
        return this.ROBUST_UNDO_PATTERN;
    }

    public Pattern PRECISE_UNDO_PATTERN() {
        return this.PRECISE_UNDO_PATTERN;
    }

    public Pattern ROBUST_RESTORE_PATTERN() {
        return this.ROBUST_RESTORE_PATTERN;
    }

    public Pattern PRECISE_RESTORE_PATTERN() {
        return this.PRECISE_RESTORE_PATTERN;
    }

    public String text() {
        return this.text;
    }

    public void text_$eq(String x$1) {
        this.text = x$1;
    }

    public String action1() {
        return this.action1;
    }

    public void action1_$eq(String x$1) {
        this.action1 = x$1;
    }

    public String action2() {
        return this.action2;
    }

    public void action2_$eq(String x$1) {
        this.action2 = x$1;
    }

    public String[] parameters() {
        return this.parameters;
    }

    public void parameters_$eq(String[] x$1) {
        this.parameters = x$1;
    }

    public String suffixComment() {
        return this.suffixComment;
    }

    public void suffixComment_$eq(String x$1) {
        this.suffixComment = x$1;
    }

    public String property() {
        return this.property;
    }

    public void property_$eq(String x$1) {
        this.property = x$1;
    }

    public String dataValue() {
        return this.dataValue;
    }

    public void dataValue_$eq(String x$1) {
        this.dataValue = x$1;
    }

    public String itemValue() {
        return this.itemValue;
    }

    public void itemValue_$eq(String x$1) {
        this.itemValue = x$1;
    }

    public String parseComment(String comment) {
        this.text_$eq(comment);
        if (comment != null) {
            if (this.isRollback(comment)) {
                this.action1_$eq("rollback");
            } else if (this.isUndo(comment)) {
                this.action1_$eq("undo");
            } else if (this.isRestore(comment)) {
                this.action1_$eq("restore");
            } else if (this.isPageCreation(comment)) {
                this.action1_$eq("pageCreation");
            } else if ("".equals(comment)) {
                this.action1_$eq("emptyComment");
            } else if (this.isSetPageProtection(comment)) {
                this.action1_$eq("setPageProtection");
            } else if (this.isChangePageProtection(comment)) {
                this.action1_$eq("changePageProtection");
            } else if (this.isRemovePageProtection(comment)) {
                this.action1_$eq("removePageProtection");
            } else {
                boolean result = this.parseNormalComment(comment);
                if (!result) {
                    this.action1_$eq("unknownCommentType");
                    this.logger().debug(new StringBuilder().append((Object)"unknown comment type: ").append((Object)comment).toString());
                }
            }
        }
        return this.action1();
    }

    /*
     * WARNING - void declaration
     */
    public String extractActionsFromComments(String comment) {
        void var2_2;
        String actions = "";
        if (comment != null) {
            actions = this.isRollback(comment) ? "rollback_NA" : (this.isUndo(comment) ? "undo_NA" : (this.isRestore(comment) ? "restore_NA" : (this.isPageCreation(comment) ? "pageCreation_NA" : ("".equals(comment) ? "emptyComment_NA" : (this.isSetPageProtection(comment) ? "setPageProtection_NA" : (this.isChangePageProtection(comment) ? "changePageProtection_NA" : (this.isRemovePageProtection(comment) ? "removePageProtection_NA" : this.extractActionsOfNormalComment(comment))))))));
        }
        return var2_2;
    }

    public String extractActionsOfNormalComment(String comment) {
        boolean check_asterisk_Start;
        boolean result = false;
        String result_Str = "";
        String suffixComment = "";
        String Action1 = "";
        String Action2 = "";
        String Param = "";
        String[] parameters = (String[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.apply(String.class));
        int asterisk_Start = 0;
        int asterisk_End = 0;
        int colon = 0;
        if (comment != null && (check_asterisk_Start = comment.contains("/*"))) {
            asterisk_Start = comment.indexOf("/*");
            boolean check_asterisk_End = comment.contains("*/");
            if (check_asterisk_End) {
                String ActionsParams_string;
                asterisk_End = comment.indexOf("*/");
                result_Str = ActionsParams_string = comment.substring(asterisk_Start + 2, asterisk_End);
            } else {
                String ActionsParams_string;
                asterisk_End = comment.length();
                result_Str = ActionsParams_string = comment.substring(asterisk_Start + 2, asterisk_End);
            }
            boolean str_colon = comment.contains(":");
            if (str_colon) {
                colon = comment.indexOf(":");
                int actionsEnd = 0;
                actionsEnd = colon != -1 && colon < asterisk_End ? colon : asterisk_End;
                boolean str_hyphenPos = comment.contains("-");
                int hyphenPos = comment.indexOf("-");
                if (str_hyphenPos) {
                    if (hyphenPos > -1 && hyphenPos < actionsEnd) {
                        Action1 = comment.substring(asterisk_Start + 3, hyphenPos).trim();
                        Action2 = comment.substring(hyphenPos + 1, actionsEnd).trim();
                    }
                } else {
                    Action1 = comment.substring(asterisk_Start + 3, colon).trim();
                    Action2 = "NA";
                }
            }
        }
        return new StringBuilder().append((Object)Action1).append((Object)"_").append((Object)Action2).toString();
    }

    /*
     * WARNING - void declaration
     */
    public String extractCommentTail(String comment) {
        void var2_2;
        String suffixComment = "NA";
        int asterisk_Start = 0;
        int asterisk_End = 0;
        int colon = 0;
        if (comment == null) {
            suffixComment = "NA";
        } else {
            boolean check_asterisk_Start = comment.contains("/*");
            if (check_asterisk_Start) {
                asterisk_Start = comment.indexOf("/*");
                boolean check_asterisk_End = comment.contains("*/");
                if (check_asterisk_End) {
                    String Checkempty_suffixComment;
                    asterisk_End = comment.indexOf("*/");
                    String string = Checkempty_suffixComment = comment.substring(asterisk_End + 2);
                    String string2 = "";
                    suffixComment = !(string != null ? !string.equals(string2) : string2 != null) ? "NA".trim() : Checkempty_suffixComment;
                    String ActionsParams_string = comment.substring(asterisk_Start + 2, asterisk_End);
                } else {
                    asterisk_End = comment.length();
                    String ActionsParams_string = comment.substring(asterisk_Start + 2, asterisk_End);
                    suffixComment = comment.trim();
                }
                boolean str_colon = comment.contains(":");
                if (str_colon) {
                    colon = comment.indexOf(":");
                    int actionsEnd = 0;
                    actionsEnd = colon != -1 && colon < asterisk_End ? colon : asterisk_End;
                }
            }
        }
        return var2_2;
    }

    public String extractAction2(String comment) {
        boolean check_asterisk_Start;
        boolean result = false;
        String result_Str = "";
        String suffixComment = "";
        String Action1 = "";
        String Action2 = "";
        String Param = "";
        String[] parameters = (String[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.apply(String.class));
        int asterisk_Start = 0;
        int asterisk_End = 0;
        int colon = 0;
        if (comment != null && (check_asterisk_Start = comment.contains("/*"))) {
            asterisk_Start = comment.indexOf("/*");
            boolean check_asterisk_End = comment.contains("*/");
            if (check_asterisk_End) {
                String ActionsParams_string;
                asterisk_End = comment.indexOf("*/");
                result_Str = ActionsParams_string = comment.substring(asterisk_Start + 2, asterisk_End);
            } else {
                String ActionsParams_string;
                asterisk_End = comment.length();
                result_Str = ActionsParams_string = comment.substring(asterisk_Start + 2, asterisk_End);
            }
            boolean str_colon = comment.contains(":");
            if (str_colon) {
                colon = comment.indexOf(":");
                int actionsEnd = 0;
                actionsEnd = colon != -1 && colon < asterisk_End ? colon : asterisk_End;
                boolean str_hyphenPos = comment.contains("-");
                int hyphenPos = comment.indexOf("-");
                if (str_hyphenPos) {
                    if (hyphenPos > -1 && hyphenPos < actionsEnd) {
                        Action1 = comment.substring(asterisk_Start + 3, hyphenPos).trim();
                        Action2 = comment.substring(hyphenPos + 1, actionsEnd).trim();
                    }
                } else {
                    Action1 = comment.substring(asterisk_Start + 3, colon).trim();
                    Action2 = "NA";
                }
            }
        }
        return Action2;
    }

    public String extractActionsRevisionFromNormalComment(String comment) {
        boolean check_asterisk_Start;
        boolean result = false;
        String result_Str = "";
        String suffixComment = "";
        String Action1 = "";
        String Action2 = "";
        String Param = "";
        String[] parameters = (String[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.apply(String.class));
        int asterisk_Start = 0;
        int asterisk_End = 0;
        int colon = 0;
        if (comment != null && (check_asterisk_Start = comment.contains("/*"))) {
            asterisk_Start = comment.indexOf("/*");
            boolean check_asterisk_End = comment.contains("*/");
            if (check_asterisk_End) {
                String ActionsParams_string;
                asterisk_End = comment.indexOf("*/");
                result_Str = ActionsParams_string = comment.substring(asterisk_Start + 2, asterisk_End);
            } else {
                String ActionsParams_string;
                asterisk_End = comment.length();
                result_Str = ActionsParams_string = comment.substring(asterisk_Start + 2, asterisk_End);
            }
            boolean str_colon = comment.contains(":");
            if (str_colon) {
                colon = comment.indexOf(":");
                int actionsEnd = 0;
                actionsEnd = colon != -1 && colon < asterisk_End ? colon : asterisk_End;
                boolean str_hyphenPos = comment.contains("-");
                int hyphenPos = comment.indexOf("-");
                if (str_hyphenPos) {
                    if (hyphenPos > -1 && hyphenPos < actionsEnd) {
                        Action1 = comment.substring(asterisk_Start + 3, hyphenPos).trim();
                        Action2 = comment.substring(hyphenPos + 1, actionsEnd).trim();
                    }
                } else {
                    Action1 = comment.substring(asterisk_Start + 3, colon).trim();
                    Action2 = "NA";
                }
            }
        }
        return new StringBuilder().append((Object)Action1).append((Object)"-").append((Object)Action2).toString();
    }

    public String actionParamSuffixNormalCommentMap(String comment) {
        boolean check_asterisk_Start;
        boolean result = false;
        String result_Str = "";
        String suffixComment = "";
        String Action1 = "";
        String Action2 = "";
        String Param = "";
        String[] parameters = (String[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.apply(String.class));
        int asterisk_Start = 0;
        int asterisk_End = 0;
        int colon = 0;
        if (comment != null && (check_asterisk_Start = comment.contains("/*"))) {
            asterisk_Start = comment.indexOf("/*");
            boolean check_asterisk_End = comment.contains("*/");
            if (check_asterisk_End) {
                String ActionsParams_string;
                asterisk_End = comment.indexOf("*/");
                result_Str = ActionsParams_string = comment.substring(asterisk_Start + 2, asterisk_End);
            } else {
                String ActionsParams_string;
                asterisk_End = comment.length();
                result_Str = ActionsParams_string = comment.substring(asterisk_Start + 2, asterisk_End);
            }
            boolean str_colon = comment.contains(":");
            if (str_colon) {
                colon = comment.indexOf(":");
                int actionsEnd = 0;
                actionsEnd = colon != -1 && colon < asterisk_End ? colon : asterisk_End;
                boolean str_hyphenPos = comment.contains("-");
                int hyphenPos = comment.indexOf("-");
                if (str_hyphenPos) {
                    if (hyphenPos > -1 && hyphenPos < actionsEnd) {
                        Action1 = comment.substring(asterisk_Start + 3, hyphenPos).trim();
                        Action2 = comment.substring(hyphenPos + 1, actionsEnd).trim();
                    }
                } else {
                    Action1 = comment.substring(asterisk_Start + 3, colon).trim();
                }
            }
        }
        return suffixComment;
    }

    public String extractParams(String comment) {
        boolean result = false;
        ObjectRef result_Str = ObjectRef.create((Object)"");
        String suffixComment = "";
        String Action1 = "";
        String Action2 = "";
        String Param = "";
        ObjectRef parameters = ObjectRef.create((Object)((String[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.apply(String.class))));
        int asterisk_Start = 0;
        int asterisk_End = 0;
        int colon = 0;
        if (comment != null) {
            boolean check_asterisk_Start = comment.contains("/*");
            if (check_asterisk_Start) {
                asterisk_Start = comment.indexOf("/*");
                boolean check_asterisk_End = comment.contains("*/");
                if (check_asterisk_End) {
                    asterisk_End = comment.indexOf("*/");
                    String ActionsParams_string = comment.substring(asterisk_Start + 2, asterisk_End);
                    result_Str.elem = ActionsParams_string;
                } else {
                    asterisk_End = comment.length();
                    String ActionsParams_string = comment.substring(asterisk_Start + 2, asterisk_End);
                    result_Str.elem = ActionsParams_string;
                }
                boolean str_colon = comment.contains(":");
                if (str_colon) {
                    colon = comment.indexOf(":");
                    int actionsEnd = 0;
                    actionsEnd = colon != -1 && colon < asterisk_End ? colon : asterisk_End;
                    boolean str_hyphenPos = comment.contains("-");
                    int hyphenPos = comment.indexOf("-");
                    if (str_hyphenPos) {
                        if (hyphenPos > -1 && hyphenPos < actionsEnd) {
                            Action1 = comment.substring(asterisk_Start + 3, hyphenPos).trim();
                            Action2 = comment.substring(hyphenPos + 1, actionsEnd).trim();
                        }
                    } else {
                        Action1 = comment.substring(asterisk_Start + 3, colon).trim();
                    }
                }
                String string = suffixComment;
                String string2 = "";
                if (string == null ? string2 != null : string.equals(string2)) {
                    // empty if block
                }
                if (colon != -1 && colon < asterisk_End) {
                    String tmp = comment.substring(colon + 1, asterisk_End);
                    tmp = tmp.trim();
                    parameters.elem = tmp.split("\\|");
                    IntRef counter = IntRef.create((int)0);
                    Predef$.MODULE$.refArrayOps((Object[])((String[])parameters.elem)).foreach((Function1)new Serializable(result_Str, counter){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef result_Str$1;
                        private final IntRef counter$1;

                        public final void apply(String x) {
                            this.result_Str$1.elem = new StringBuilder().append((Object)((String)this.result_Str$1.elem)).append((Object)"Param").append((Object)BoxesRunTime.boxToInteger((int)this.counter$1.elem)).append((Object)"::").append((Object)x).toString();
                            ++this.counter$1.elem;
                        }
                        {
                            this.result_Str$1 = result_Str$1;
                            this.counter$1 = counter$1;
                        }
                    });
                }
            }
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ((String[])parameters.elem).length).foreach$mVc$sp((Function1)new Serializable(parameters){
                public static final long serialVersionUID = 0L;
                private final ObjectRef parameters$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    ((String[])this.parameters$1.elem)[i] = Comment$.MODULE$.net$sansa_stack$ml$common$outliers$vandalismdetection$feature$extraction$Comment$$trim(((String[])this.parameters$1.elem)[i]);
                }
                {
                    this.parameters$1 = parameters$1;
                }
            });
        }
        return ((String[])parameters.elem)[0];
    }

    /*
     * WARNING - void declaration
     */
    public boolean isRollback(String comment) {
        void var2_2;
        boolean result = false;
        if (comment != null) {
            String tmp = comment.trim();
            result = this.ROBUST_ROLLBACK_PATTERN().matcher(tmp).matches();
            if (result != this.PRECISE_ROLLBACK_PATTERN().matcher(tmp).matches()) {
                this.logger().debug(new StringBuilder().append((Object)"Robust but not precise rollback match (result = ").append((Object)BoxesRunTime.boxToBoolean((boolean)result)).append((Object)") : ").append((Object)tmp).toString());
            }
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isUndo(String comment) {
        void var2_2;
        boolean result = false;
        if (comment != null) {
            String tmp = comment.trim();
            result = this.ROBUST_UNDO_PATTERN().matcher(comment).matches();
            if (this.logger().isDebugEnabled() && result != this.PRECISE_UNDO_PATTERN().matcher(tmp).matches()) {
                this.logger().debug(new StringBuilder().append((Object)"Robust but not precise undo match (result = ").append((Object)BoxesRunTime.boxToBoolean((boolean)result)).append((Object)") : ").append((Object)tmp).toString());
            }
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isRestore(String comment) {
        void var2_2;
        boolean result = false;
        if (comment != null) {
            String tmp = comment.trim();
            result = this.ROBUST_RESTORE_PATTERN().matcher(tmp).matches();
            if (this.logger().isDebugEnabled() && result != this.PRECISE_RESTORE_PATTERN().matcher(tmp).matches()) {
                this.logger().debug(new StringBuilder().append((Object)"Robust but not precise restore match (result = ").append((Object)BoxesRunTime.boxToBoolean((boolean)result)).append((Object)") : ").append((Object)tmp).toString());
            }
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isPageCreation(String comment) {
        void var2_2;
        boolean result = false;
        if (comment != null) {
            String tmp = comment.trim();
            result = tmp.startsWith("Created page");
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSetPageProtection(String comment) {
        void var2_2;
        boolean result = false;
        if (comment != null) {
            String tmp = comment.trim();
            result = tmp.startsWith("Protected");
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isChangePageProtection(String comment) {
        void var2_2;
        boolean result = false;
        if (comment != null) {
            String tmp = comment.trim();
            result = tmp.startsWith("Changed protection");
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isRemovePageProtection(String comment) {
        void var2_2;
        boolean result = false;
        if (comment != null) {
            String tmp = comment.trim();
            result = tmp.startsWith("Removed protection");
        }
        return (boolean)var2_2;
    }

    public String getRevertedContributor(String comment) {
        String origResult = null;
        String pattern = "[[Special:Contributions/";
        int startIndex = comment.indexOf(pattern);
        int endIndex = comment.indexOf("|");
        if (endIndex > startIndex) {
            origResult = comment.substring(startIndex + pattern.length(), endIndex);
        }
        String result = "null";
        Matcher matcher = this.ROBUST_ROLLBACK_PATTERN().matcher(comment);
        if (matcher.matches()) {
            result = matcher.group(1);
        }
        String string = result;
        String string2 = origResult;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.logger().warn(new StringBuilder().append((Object)"Difference to original contributor: ").append((Object)comment).toString());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public long getUndoneRevisionId(String comment) {
        void var2_2;
        long result = 0L;
        Matcher matcher = this.ROBUST_UNDO_PATTERN().matcher(comment);
        if (matcher.matches()) {
            String str = matcher.group(2);
            result = Long.parseLong(str);
        } else {
            result = -1L;
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public long getRestoredRevisionId(String comment) {
        void var2_2;
        long result = 0L;
        Matcher matcher = this.ROBUST_RESTORE_PATTERN().matcher(comment);
        if (matcher.matches()) {
            String str = matcher.group(1);
            result = Long.parseLong(str);
        } else {
            result = -1L;
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkCommentNormalOrNot(String comment) {
        void var2_2;
        boolean result = false;
        int asterisk_Start = comment.indexOf("/*");
        if (asterisk_Start != -1) {
            result = true;
            int asterisk_End = comment.indexOf("*/", asterisk_Start);
            if (asterisk_End == -1) {
                asterisk_End = comment.length();
            }
        } else {
            this.suffixComment_$eq(comment);
            result = false;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseNormalComment(String comment) {
        void var2_2;
        boolean result = false;
        int asterisk_Start = comment.indexOf("/*");
        if (asterisk_Start != -1) {
            result = true;
            int asterisk_End = comment.indexOf("*/", asterisk_Start);
            if (asterisk_End == -1) {
                asterisk_End = comment.length();
                this.suffixComment_$eq("");
            } else {
                this.suffixComment_$eq(comment.substring(asterisk_End + 2).trim());
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"lolo2 ").append((Object)this.suffixComment()).toString());
            }
            int colon = comment.indexOf(":");
            int actionsEnd = 0;
            actionsEnd = colon != -1 && colon < asterisk_End ? colon : asterisk_End;
            int hyphenPos = comment.indexOf("-");
            if (hyphenPos > -1 && hyphenPos < actionsEnd) {
                this.action1_$eq(comment.substring(asterisk_Start + 3, hyphenPos));
                this.action2_$eq(comment.substring(hyphenPos + 1, actionsEnd));
            } else {
                this.action1_$eq(comment.substring(asterisk_Start + 3, actionsEnd));
            }
            if (colon != -1 && colon < asterisk_End) {
                String tmp = comment.substring(colon + 1, asterisk_End);
                tmp = tmp.trim();
                this.parameters_$eq(tmp.split("\\|"));
            }
        } else {
            this.suffixComment_$eq(comment);
        }
        this.property_$eq(Statement$.MODULE$.getProperty(this.suffixComment()));
        this.dataValue_$eq(Statement$.MODULE$.getDataValue(this.suffixComment()));
        this.itemValue_$eq(Statement$.MODULE$.getItemValue(this.suffixComment()));
        this.action1_$eq(this.net$sansa_stack$ml$common$outliers$vandalismdetection$feature$extraction$Comment$$trim(this.action1()));
        this.action2_$eq(this.net$sansa_stack$ml$common$outliers$vandalismdetection$feature$extraction$Comment$$trim(this.action2()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.parameters().length).foreach$mVc$sp((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Comment$.MODULE$.parameters()[i] = Comment$.MODULE$.net$sansa_stack$ml$common$outliers$vandalismdetection$feature$extraction$Comment$$trim(Comment$.MODULE$.parameters()[i]);
            }
        });
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String net$sansa_stack$ml$common$outliers$vandalismdetection$feature$extraction$Comment$$trim(String str) {
        void var2_2;
        String result = str;
        if (str != null) {
            result = str.trim();
        }
        return var2_2;
    }

    public String getText() {
        return this.text();
    }

    public String getAction1() {
        return this.action1();
    }

    public String getAction2() {
        return this.action2();
    }

    public String[] getParameters() {
        return this.parameters();
    }

    public String getSuffixComment(String str) {
        return this.suffixComment();
    }

    public String getProperty() {
        return this.property();
    }

    public String getDataValue() {
        return this.dataValue();
    }

    public String getItemValue() {
        return this.itemValue();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Comment$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.ROBUST_ROLLBACK_PATTERN = Pattern.compile(".*\\bReverted\\s*edits\\s*by\\s*\\[\\[Special:Contributions\\/([^\\|\\]]*)\\|.*", 34);
        this.PRECISE_ROLLBACK_PATTERN = Pattern.compile("^Reverted edits by \\[\\[Special:Contributions\\/([^\\|\\]]*)\\|\\1\\]\\] \\(\\[\\[User talk:\\1\\|talk\\]\\]\\) to last revision by \\[\\[User:([^\\|\\]]*)\\|\\2\\]\\]$");
        this.ROBUST_UNDO_PATTERN = Pattern.compile(".*\\b(Undo|Undid)\\b.*revision\\s*(\\d+).*", 34);
        this.PRECISE_UNDO_PATTERN = Pattern.compile(".*\\b(Undo|Undid) revision (\\d+) by \\[\\[Special:Contributions\\/([^|]*)\\|\\3\\]\\] \\(\\[\\[User talk:\\3\\|talk\\]\\]\\).*");
        this.ROBUST_RESTORE_PATTERN = Pattern.compile(".*\\bRestored?\\b.*revision\\s*(\\d+).*", 34);
        this.PRECISE_RESTORE_PATTERN = Pattern.compile(".*\\bRestored? revision (\\d+) by \\[\\[Special:Contributions\\/([^|]*)\\|\\2\\]\\].*");
        this.text = "";
        this.action1 = "";
        this.action2 = "";
        this.parameters = (String[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.apply(String.class));
        this.suffixComment = "";
        this.property = "";
        this.dataValue = "";
        this.itemValue = "";
    }
}

