/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark.forwardchaining.triples;

import java.io.Serializable;
import net.sansa_stack.inference.spark.data.model.RDFGraph;
import net.sansa_stack.inference.spark.data.model.TripleUtils$;
import net.sansa_stack.inference.spark.forwardchaining.triples.ForwardRuleReasoner;
import net.sansa_stack.inference.utils.Logging;
import net.sansa_stack.inference.utils.Profiler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001\u0002\u000b\u0016\u0001\tB\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\to\u0001\u0011)\u0019!C\u0001q!AQ\n\u0001B\u0001B\u0003%\u0011\b\u0003\u0005O\u0001\t\u0015\r\u0011\"\u0001P\u0011!\u0019\u0006A!A!\u0002\u0013\u0001\u0006\"\u0002+\u0001\t\u0003)\u0006\"\u0002+\u0001\t\u0003Q\u0006\"\u0002+\u0001\t\u0003y\u0006\"\u0002+\u0001\t\u0003\u0011\u0007\"\u00027\u0001\t\u0003j\u0007\"B<\u0001\t\u0003A\bbBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001fBq!a\u0010\u0001\t\u0003\t\u0019\u0006C\u0004\u0002@\u0001!\t!a\u0019\t\u000f\u0005}\u0002\u0001\"\u0001\u0002l!9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0005bBA \u0001\u0011\u0005\u0011Q\u0015\u0002\u0013)J\fgn]5uSZ,'+Z1t_:,'O\u0003\u0002\u0017/\u00059AO]5qY\u0016\u001c(B\u0001\r\u001a\u0003=1wN]<be\u0012\u001c\u0007.Y5oS:<'B\u0001\u000e\u001c\u0003\u0015\u0019\b/\u0019:l\u0015\taR$A\u0005j]\u001a,'/\u001a8dK*\u0011adH\u0001\fg\u0006t7/Y0ti\u0006\u001c7NC\u0001!\u0003\rqW\r^\u0002\u0001'\r\u00011%\u000b\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)ZS\"A\u000b\n\u00051*\"a\u0005$pe^\f'\u000f\u001a*vY\u0016\u0014V-Y:p]\u0016\u0014\u0018AA:d!\tyS'D\u00011\u0015\tQ\u0012G\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<\u0017B\u0001\u001c1\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003)\u0001(o\u001c9feRLWm]\u000b\u0002sA\u0019!HQ#\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \"\u0003\u0019a$o\\8u}%\ta%\u0003\u0002BK\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005\r\u0019V-\u001d\u0006\u0003\u0003\u0016\u0002\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u000b\u001d\u0014\u0018\r\u001d5\u000b\u0005)\u000b\u0014\u0001\u00026f]\u0006L!\u0001T$\u0003\t9{G-Z\u0001\faJ|\u0007/\u001a:uS\u0016\u001c\b%A\u0006qCJ\fG\u000e\\3mSNlW#\u0001)\u0011\u0005\u0011\n\u0016B\u0001*&\u0005\rIe\u000e^\u0001\ra\u0006\u0014\u0018\r\u001c7fY&\u001cX\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tY;\u0006,\u0017\t\u0003U\u0001AQ!\f\u0004A\u00029BQa\u000e\u0004A\u0002eBQA\u0014\u0004A\u0002A#BAV.]=\")Qf\u0002a\u0001]!)Ql\u0002a\u0001\u000b\u0006A\u0001O]8qKJ$\u0018\u0010C\u0003O\u000f\u0001\u0007\u0001\u000bF\u0002WA\u0006DQ!\f\u0005A\u00029BQA\u0014\u0005A\u0002A#BAV2kW\")!$\u0003a\u0001IB\u0011Q\r[\u0007\u0002M*\u0011q\rM\u0001\u0004gFd\u0017BA5g\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u00159\u0014\u00021\u0001:\u0011\u0015q\u0015\u00021\u0001Q\u0003\u0015\t\u0007\u000f\u001d7z)\tqg\u000f\u0005\u0002pi6\t\u0001O\u0003\u0002re\u0006)Qn\u001c3fY*\u00111/G\u0001\u0005I\u0006$\u0018-\u0003\u0002va\nA!\u000b\u0012$He\u0006\u0004\b\u000eC\u0003I\u0015\u0001\u0007a.A\u000fd_6\u0004X\u000f^3Ue\u0006t7/\u001b;jm\u0016\u001cEn\\:ve\u0016\u0004\u0016-\u001b:t+\u0015I\u0018qBA\u0012)\rQ\u0018q\u0005\t\u0005w~\f)A\u0004\u0002}{B\u0011A(J\u0005\u0003}\u0016\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u00111aU3u\u0015\tqX\u0005E\u0004%\u0003\u000f\tY!!\t\n\u0007\u0005%QE\u0001\u0004UkBdWM\r\t\u0005\u0003\u001b\ty\u0001\u0004\u0001\u0005\u000f\u0005E1B1\u0001\u0002\u0014\t\t\u0011)\u0005\u0003\u0002\u0016\u0005m\u0001c\u0001\u0013\u0002\u0018%\u0019\u0011\u0011D\u0013\u0003\u000f9{G\u000f[5oOB\u0019A%!\b\n\u0007\u0005}QEA\u0002B]f\u0004B!!\u0004\u0002$\u00119\u0011QE\u0006C\u0002\u0005M!!\u0001\"\t\r\u0005%2\u00021\u0001{\u0003\u0005\u0019\u0018AE1eIR\u0013\u0018M\\:ji&4X\rU1jeN,b!a\f\u00028\u0005mB\u0003BA\u0019\u0003{\u0001Ba_@\u00024A9A%a\u0002\u00026\u0005e\u0002\u0003BA\u0007\u0003o!q!!\u0005\r\u0005\u0004\t\u0019\u0002\u0005\u0003\u0002\u000e\u0005mBaBA\u0013\u0019\t\u0007\u00111\u0003\u0005\b\u0003Sa\u0001\u0019AA\u0019\u0003a\u0019w.\u001c9vi\u0016$&/\u00198tSRLg/Z\"m_N,(/\u001a\u000b\u0005\u0003\u0007\nY\u0005\u0005\u0003|\u007f\u0006\u0015\u0003c\u0001$\u0002H%\u0019\u0011\u0011J$\u0003\rQ\u0013\u0018\u000e\u001d7f\u0011\u00191R\u00021\u0001\u0002D\u0005i\u0011\r\u001a3Ue\u0006t7/\u001b;jm\u0016$B!a\u0011\u0002R!1aC\u0004a\u0001\u0003\u0007\"B!!\u0016\u0002bA1\u0011qKA/\u0003\u000bj!!!\u0017\u000b\u0007\u0005m\u0003'A\u0002sI\u0012LA!a\u0018\u0002Z\t\u0019!\u000b\u0012#\t\rYy\u0001\u0019AA+)\u0019\t)&!\u001a\u0002h!1a\u0003\u0005a\u0001\u0003+Ba!!\u001b\u0011\u0001\u0004)\u0015!\u00039sK\u0012L7-\u0019;f+\u0011\ti'a\u001e\u0015\t\u0005=\u0014\u0011\u0012\u000b\u0005\u0003c\nI\b\u0005\u0004\u0002X\u0005u\u00131\u000f\t\bI\u0005\u001d\u0011QOA;!\u0011\ti!a\u001e\u0005\u000f\u0005E\u0011C1\u0001\u0002\u0014!I\u00111P\t\u0002\u0002\u0003\u000f\u0011QP\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004CBA@\u0003\u000b\u000b)(\u0004\u0002\u0002\u0002*\u0019\u00111Q\u0013\u0002\u000fI,g\r\\3di&!\u0011qQAA\u0005!\u0019E.Y:t)\u0006<\u0007bBAF#\u0001\u0007\u0011\u0011O\u0001\u0006K\u0012<Wm]\u0001\"G>l\u0007/\u001e;f)J\fgn]5uSZ,7\t\\8tkJ,7+Z7j\u001d\u0006Lg/Z\u000b\u0005\u0003#\u000bY\n\u0006\u0003\u0002\u0014\u0006\rF\u0003BAK\u0003;\u0003b!a\u0016\u0002^\u0005]\u0005c\u0002\u0013\u0002\b\u0005e\u0015\u0011\u0014\t\u0005\u0003\u001b\tY\nB\u0004\u0002\u0012I\u0011\r!a\u0005\t\u0013\u0005}%#!AA\u0004\u0005\u0005\u0016AC3wS\u0012,gnY3%eA1\u0011qPAC\u00033Cq!a#\u0013\u0001\u0004\t)\n\u0006\u0003\u0002(\u00065\u0006#B3\u0002*\u0006\u0015\u0013bAAVM\n9A)\u0019;bg\u0016$\bbBAF'\u0001\u0007\u0011q\u0015")
public class TransitiveReasoner
implements ForwardRuleReasoner {
    private final SparkContext sc;
    private final Seq<Node> properties;
    private final int parallelism;
    private transient Logger net$sansa_stack$inference$utils$Logging$$log_;

    @Override
    public RDD<Triple> apply(RDD<Triple> triples) {
        return ForwardRuleReasoner.apply$(this, triples);
    }

    @Override
    public Set<Triple> extractTriples(Set<Triple> triples, Node predicate) {
        return ForwardRuleReasoner.extractTriples$((ForwardRuleReasoner)this, triples, predicate);
    }

    @Override
    public RDD<Triple> extractTriples(RDD<Triple> triples, Node predicate) {
        return ForwardRuleReasoner.extractTriples$((ForwardRuleReasoner)this, triples, predicate);
    }

    @Override
    public RDD<Triple> extractTriples(RDD<Triple> triples, Option<Node> subject, Option<Node> predicate, Option<Node> obj) {
        return ForwardRuleReasoner.extractTriples$(this, triples, subject, predicate, obj);
    }

    public <R> R profile(Function0<R> block) {
        return (R)Profiler.profile$((Profiler)this, block);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Throwable e) {
        Logging.trace$((Logging)this, msg, (Throwable)e);
    }

    public void trace(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.trace$((Logging)this, msg, (Object)o, os);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Throwable e) {
        Logging.debug$((Logging)this, msg, (Throwable)e);
    }

    public void debug(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.debug$((Logging)this, msg, (Object)o, os);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Throwable e) {
        Logging.info$((Logging)this, msg, (Throwable)e);
    }

    public void info(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.info$((Logging)this, msg, (Object)o, os);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Throwable e) {
        Logging.warn$((Logging)this, msg, (Throwable)e);
    }

    public void warn(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.warn$((Logging)this, msg, (Object)o, os);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Throwable e) {
        Logging.error$((Logging)this, msg, (Throwable)e);
    }

    public void error(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.error$((Logging)this, msg, (Object)o, os);
    }

    public Logger net$sansa_stack$inference$utils$Logging$$log_() {
        return this.net$sansa_stack$inference$utils$Logging$$log_;
    }

    public void net$sansa_stack$inference$utils$Logging$$log__$eq(Logger x$1) {
        this.net$sansa_stack$inference$utils$Logging$$log_ = x$1;
    }

    public Seq<Node> properties() {
        return this.properties;
    }

    public int parallelism() {
        return this.parallelism;
    }

    @Override
    public RDFGraph apply(RDFGraph graph) {
        if (this.properties().isEmpty()) {
            throw new RuntimeException("A list of properties has to be given for the transitive reasoner!");
        }
        graph.triples().cache();
        Seq tcRDDs = (Seq)this.properties().map((Function1 & Serializable & scala.Serializable)p -> this.computeTransitiveClosure((RDD<Triple>)graph.triples().filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TransitiveReasoner.$anonfun$apply$2(p, t))), (Node)p), Seq$.MODULE$.canBuildFrom());
        RDD triples = this.sc.union((Seq)tcRDDs.$colon$plus(graph.triples(), Seq$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(Triple.class));
        return new RDFGraph((RDD<Triple>)triples);
    }

    public <A, B> scala.collection.immutable.Set<Tuple2<A, B>> computeTransitiveClosurePairs(scala.collection.immutable.Set<Tuple2<A, B>> s) {
        scala.collection.immutable.Set<Tuple2<A, B>> t = this.addTransitivePairs(s);
        if (t.size() == s.size()) {
            return s;
        }
        return this.computeTransitiveClosurePairs(t);
    }

    public <A, B> scala.collection.immutable.Set<Tuple2<A, B>> addTransitivePairs(scala.collection.immutable.Set<Tuple2<A, B>> s) {
        return (scala.collection.immutable.Set)s.$plus$plus((GenTraversableOnce)s.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransitiveReasoner.$anonfun$addTransitivePairs$1(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                Object x1 = tuple2._1();
                Object y1 = tuple2._2();
                return (scala.collection.immutable.Set)s.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransitiveReasoner.$anonfun$addTransitivePairs$3(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransitiveReasoner.$anonfun$addTransitivePairs$4(y1, x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> {
                    Tuple2 tuple2 = x$2;
                    if (tuple2 != null) {
                        Object y2 = tuple2._2();
                        return new Tuple2(x1, y2);
                    }
                    throw new MatchError((Object)tuple2);
                }, Set$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }, Set$.MODULE$.canBuildFrom()));
    }

    public scala.collection.immutable.Set<Triple> computeTransitiveClosure(scala.collection.immutable.Set<Triple> triples) {
        scala.collection.immutable.Set<Triple> tc = this.addTransitive(triples);
        if (tc.size() == triples.size()) {
            return triples;
        }
        return this.computeTransitiveClosure(tc);
    }

    private scala.collection.immutable.Set<Triple> addTransitive(scala.collection.immutable.Set<Triple> triples) {
        return (scala.collection.immutable.Set)triples.$plus$plus((GenTraversableOnce)triples.flatMap((Function1 & Serializable & scala.Serializable)t1 -> (scala.collection.immutable.Set)triples.withFilter((Function1 & Serializable & scala.Serializable)t2 -> BoxesRunTime.boxToBoolean((boolean)TransitiveReasoner.$anonfun$addTransitive$2(t1, t2))).map((Function1 & Serializable & scala.Serializable)t2 -> Triple.create((Node)TripleUtils$.MODULE$.RichTriple((Triple)t1).s(), (Node)TripleUtils$.MODULE$.RichTriple((Triple)t1).p(), (Node)TripleUtils$.MODULE$.RichTriple((Triple)t2).o()), Set$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom()));
    }

    public RDD<Triple> computeTransitiveClosure(RDD<Triple> triples) {
        if (triples.isEmpty()) {
            return triples;
        }
        Node predicate = TripleUtils$.MODULE$.RichTriple(((Triple[])triples.take(1))[0]).p();
        return this.computeTransitiveClosure(triples, predicate);
    }

    public RDD<Triple> computeTransitiveClosure(RDD<Triple> triples, Node predicate) {
        if (triples.isEmpty()) {
            return triples;
        }
        this.log().info(new StringBuilder(29).append("computing TC for property ").append(predicate).append("...").toString());
        return (RDD)this.profile((Function0 & Serializable & scala.Serializable)() -> {
            RDD subjectObjectPairs = triples.map((Function1 & Serializable & scala.Serializable)t -> new Tuple2((Object)TripleUtils$.MODULE$.RichTriple((Triple)t).s(), (Object)TripleUtils$.MODULE$.RichTriple((Triple)t).o()), ClassTag$.MODULE$.apply(Tuple2.class)).cache();
            RDD tc = this.computeTransitiveClosure(subjectObjectPairs, ClassTag$.MODULE$.apply(Node.class));
            return tc.map((Function1 & Serializable & scala.Serializable)p -> Triple.create((Node)((Node)p._1()), (Node)predicate, (Node)((Node)p._2())), ClassTag$.MODULE$.apply(Triple.class));
        });
    }

    public <A> RDD<Tuple2<A, A>> computeTransitiveClosure(RDD<Tuple2<A, A>> edges, ClassTag<A> evidence$1) {
        this.log().info("computing TC...");
        RDD tc = edges;
        tc.cache();
        RDD edgesReversed = tc.map((Function1 & Serializable & scala.Serializable)t -> new Tuple2(t._2(), t._1()), ClassTag$.MODULE$.apply(Tuple2.class));
        edgesReversed.cache();
        int i = 1;
        long oldCount = 0L;
        long nextCount = tc.count();
        do {
            this.log().info(new StringBuilder(13).append("iteration ").append(i).append("...").toString());
            oldCount = nextCount;
            RDD x$1 = tc;
            ClassTag<A> x$2 = evidence$1;
            ClassTag<A> x$3 = evidence$1;
            Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
            RDD qual$1 = tc.union(RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).join(edgesReversed).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(((Tuple2)x._2())._2(), ((Tuple2)x._2())._1()), ClassTag$.MODULE$.apply(Tuple2.class)));
            int x$5 = this.parallelism();
            Ordering x$6 = qual$1.distinct$default$2(x$5);
            tc = qual$1.distinct(x$5, x$6).cache();
            nextCount = tc.count();
            ++i;
        } while (nextCount != oldCount);
        this.log().info(new StringBuilder(14).append("TC has ").append(nextCount).append(" edges.").toString());
        return tc;
    }

    public <A> RDD<Tuple2<A, A>> computeTransitiveClosureSemiNaive(RDD<Tuple2<A, A>> edges, ClassTag<A> evidence$2) {
        this.log().info("computing TC...");
        RDD tc = edges;
        tc.cache();
        RDD edgesReversed = tc.map((Function1 & Serializable & scala.Serializable)t -> new Tuple2(t._2(), t._1()), ClassTag$.MODULE$.apply(Tuple2.class)).cache();
        RDD qual$1 = tc;
        int x$1 = 4;
        Ordering x$2 = qual$1.repartition$default$2(x$1);
        RDD deltaTC = qual$1.repartition(x$1, x$2);
        int i = 1;
        while (!deltaTC.isEmpty()) {
            this.log().info(new StringBuilder(13).append("iteration ").append(i).append("...").toString());
            RDD x$3 = deltaTC;
            ClassTag<A> x$4 = evidence$2;
            ClassTag<A> x$5 = evidence$2;
            Null$ x$6 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$3);
            deltaTC = RDD$.MODULE$.rddToPairRDDFunctions(x$3, x$4, x$5, null).join(edgesReversed).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(((Tuple2)x._2())._2(), ((Tuple2)x._2())._1()), ClassTag$.MODULE$.apply(Tuple2.class)).subtract(tc).distinct().cache();
            tc = tc.union(deltaTC).cache();
            ++i;
        }
        this.log().info(new StringBuilder(14).append("TC has ").append(tc.count()).append(" edges.").toString());
        return tc;
    }

    public Dataset<Triple> computeTransitiveClosure(Dataset<Triple> edges) {
        this.log().info("computing TC...");
        SQLContext spark = edges.sparkSession().sqlContext();
        Encoder myObjEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Triple.class));
        return (Dataset)this.profile((Function0 & Serializable & scala.Serializable)() -> {
            Dataset tc = edges;
            tc.cache();
            int i = 1;
            long oldCount = 0L;
            long nextCount = tc.count();
            do {
                this.log().info(new StringBuilder(13).append("iteration ").append(i).append("...").toString());
                oldCount = nextCount;
                tc.createOrReplaceTempView("SC");
                Dataset joined = tc.as("A").join(tc.as("B"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A.o"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B.s"}))).$((Seq)Nil$.MODULE$))).select("A.s", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A.p", "B.o"})).as(myObjEncoder);
                tc = tc.union(joined).distinct().cache();
                nextCount = tc.count();
                ++i;
            } while (nextCount != oldCount);
            tc.sqlContext().uncacheTable("SC");
            this.log().info(new StringBuilder(14).append("TC has ").append(nextCount).append(" edges.").toString());
            return tc;
        });
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(Node p$1, Triple t) {
        Node node = TripleUtils$.MODULE$.RichTriple(t).p();
        Node node2 = p$1;
        return !(node != null ? !node.equals(node2) : node2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$addTransitivePairs$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$addTransitivePairs$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$addTransitivePairs$4(Object y1$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Object x2 = tuple2._1();
            return BoxesRunTime.equals((Object)y1$1, (Object)x2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$addTransitive$2(Triple t1$1, Triple t2) {
        Node node = TripleUtils$.MODULE$.RichTriple(t1$1).o();
        Node node2 = TripleUtils$.MODULE$.RichTriple(t2).s();
        return !(node != null ? !node.equals(node2) : node2 != null);
    }

    private static final RDD f$1(RDD rdd, ClassTag evidence$1$1, RDD edgesReversed$1) {
        RDD x$1 = rdd;
        ClassTag x$2 = evidence$1$1;
        ClassTag x$3 = evidence$1$1;
        Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
        return RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).join(edgesReversed$1).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(((Tuple2)x._2())._2(), ((Tuple2)x._2())._1()), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public TransitiveReasoner(SparkContext sc, Seq<Node> properties, int parallelism) {
        this.sc = sc;
        this.properties = properties;
        this.parallelism = parallelism;
        Logging.$init$((Logging)this);
        Profiler.$init$((Profiler)this);
        ForwardRuleReasoner.$init$(this);
    }

    public TransitiveReasoner(SparkContext sc, Node property, int parallelism) {
        this(sc, (Seq<Node>)((Seq)new .colon.colon((Object)property, (List)Nil$.MODULE$)), parallelism);
    }

    public TransitiveReasoner(SparkContext sc, int parallelism) {
        this(sc, (Seq<Node>)((Seq)Nil$.MODULE$), parallelism);
    }

    public TransitiveReasoner(SparkSession spark, Seq<Node> properties, int parallelism) {
        this(spark.sparkContext(), properties, parallelism);
    }
}

