/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark.forwardchaining.triples;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import net.sansa_stack.inference.data.Jena;
import net.sansa_stack.inference.spark.data.model.RDFGraphNative;
import net.sansa_stack.inference.spark.forwardchaining.triples.AbstractForwardRuleReasoner;
import net.sansa_stack.inference.spark.rules.RuleExecutorNative;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Serializable;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001y4Aa\u0003\u0007\u00013!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u001dq\u0006A1A\u0005\n}CaA\u001b\u0001!\u0002\u0013\u0001\u0007bB6\u0001\u0005\u0004%\t\u0001\u001c\u0005\u0007e\u0002\u0001\u000b\u0011B7\t\u000bM\u0004A\u0011\u0001;\t\u000bY\u0004A\u0011A<\t\u000be\u0004A\u0011\u0001>\u00031\u0019{'o^1sIJ+H.\u001a*fCN|g.\u001a:OC&4XM\u0003\u0002\u000e\u001d\u00059AO]5qY\u0016\u001c(BA\b\u0011\u0003=1wN]<be\u0012\u001c\u0007.Y5oS:<'BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#A\u0005j]\u001a,'/\u001a8dK*\u0011QCF\u0001\fg\u0006t7/Y0ti\u0006\u001c7NC\u0001\u0018\u0003\rqW\r^\u0002\u0001'\t\u0001!\u0004E\u0003\u001c9y!s'D\u0001\r\u0013\tiBBA\u000eBEN$(/Y2u\r>\u0014x/\u0019:e%VdWMU3bg>tWM\u001d\t\u0003?\tj\u0011\u0001\t\u0006\u0003CI\tA\u0001Z1uC&\u00111\u0005\t\u0002\u0005\u0015\u0016t\u0017\rE\u0002&[=j\u0011A\n\u0006\u0003O!\n1A\u001d3e\u0015\t\t\u0012F\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018'\u0005\r\u0011F\t\u0012\t\u0003aUj\u0011!\r\u0006\u0003eM\nQa\u001a:ba\"T!\u0001N\u0015\u0002\t),g.Y\u0005\u0003mE\u0012a\u0001\u0016:ja2,\u0007C\u0001\u001d=\u001b\u0005I$B\u0001\u001e<\u0003\u0015iw\u000eZ3m\u0015\t\t\u0003#\u0003\u0002>s\tq!\u000b\u0012$He\u0006\u0004\bNT1uSZ,\u0017AA:d!\t\u0001\u0015)D\u0001)\u0013\t\u0011\u0005F\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\u0003sk2,7\u000fE\u0002F\u001dFs!A\u0012'\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%C\u0012A\u0002\u001fs_>$hHC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%*\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u00131aU3u\u0015\ti%\n\u0005\u0002S/6\t1K\u0003\u0002U+\u00069!/\u001e7fgf\u001c(B\u0001,4\u0003!\u0011X-Y:p]\u0016\u0014\u0018B\u0001-T\u0005\u0011\u0011V\u000f\\3\u0002\rqJg.\u001b;?)\rYF,\u0018\t\u00037\u0001AQAP\u0002A\u0002}BQaQ\u0002A\u0002\u0011\u000ba\u0001\\8hO\u0016\u0014X#\u00011\u0011\u0005\u0005DW\"\u00012\u000b\u0005\r$\u0017\u0001D:dC2\fGn\\4hS:<'BA3g\u0003!!\u0018\u0010]3tC\u001a,'\"A4\u0002\u0007\r|W.\u0003\u0002jE\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\u0007sk2,W\t_3dkR|'/F\u0001n!\tq\u0007/D\u0001p\u0015\t\u0019\u0005#\u0003\u0002r_\n\u0011\"+\u001e7f\u000bb,7-\u001e;pe:\u000bG/\u001b<f\u00035\u0011X\u000f\\3Fq\u0016\u001cW\u000f^8sA\u0005)\u0011\r\u001d9msR\u0011q'\u001e\u0005\u0006e!\u0001\raN\u0001\u000bCB\u0004H.\u001f*vY\u0016\u001cHCA\u001cy\u0011\u0015\u0011\u0014\u00021\u00018\u0003%\t\u0007\u000f\u001d7z%VdW\rF\u00028wvDQ\u0001 \u0006A\u0002E\u000bAA];mK\")!G\u0003a\u0001o\u0001")
public class ForwardRuleReasonerNaive
extends AbstractForwardRuleReasoner<Jena, RDD<Triple>, RDFGraphNative> {
    private final Set<Rule> rules;
    private final Logger logger;
    private final RuleExecutorNative ruleExecutor;

    private Logger logger() {
        return this.logger;
    }

    public RuleExecutorNative ruleExecutor() {
        return this.ruleExecutor;
    }

    @Override
    public RDFGraphNative apply(RDFGraphNative graph) {
        RDFGraphNative currentGraph = graph;
        int iteration = 0;
        long oldCount = 0L;
        long nextCount = currentGraph.size();
        do {
            BoxedUnit boxedUnit;
            ++iteration;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(10).append("Iteration ").append(iteration).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            oldCount = nextCount;
            currentGraph = currentGraph.union(this.applyRules(graph)).distinct();
            currentGraph.cache();
            nextCount = currentGraph.size();
        } while (nextCount != oldCount);
        return graph;
    }

    public RDFGraphNative applyRules(RDFGraphNative graph) {
        ObjectRef newGraph = ObjectRef.create((Object)graph);
        this.rules.foreach((Function1 & java.io.Serializable & Serializable)rule -> {
            newGraph.elem = ((RDFGraphNative)newGraph.elem).union(this.applyRule(rule, graph));
            return BoxedUnit.UNIT;
        });
        return (RDFGraphNative)newGraph.elem;
    }

    public RDFGraphNative applyRule(Rule rule, RDFGraphNative graph) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(5).append("Rule:").append(rule).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.ruleExecutor().execute(rule, graph);
    }

    public ForwardRuleReasonerNaive(SparkContext sc, Set<Rule> rules) {
        this.rules = rules;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
        this.ruleExecutor = new RuleExecutorNative(sc);
    }
}

