/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark.data.writer;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import net.sansa_stack.inference.spark.data.model.RDFGraph;
import net.sansa_stack.inference.utils.JenaTripleToNTripleString;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.util.TripleComparator;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class RDFGraphWriter$ {
    public static RDFGraphWriter$ MODULE$;
    private final Logger logger;

    static {
        new RDFGraphWriter$();
    }

    private Logger logger() {
        return this.logger;
    }

    public void writeToDisk(RDFGraph graph, String path, boolean singleFile, boolean sorted) {
        this.writeTriplesToDisk(graph.triples(), path, singleFile, sorted);
    }

    public boolean writeToDisk$default$3() {
        return false;
    }

    public boolean writeToDisk$default$4() {
        return false;
    }

    public void writeTriplesToDisk(RDD<Triple> triples, String path, boolean singleFile, boolean sorted) {
        BoxedUnit boxedUnit;
        RDD rDD;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("writing triples to disk...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long startTime = System.currentTimeMillis();
        Ordering<Triple> tripleOrdering = new Ordering<Triple>(){
            private final TripleComparator comparator;

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Triple> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Triple> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public TripleComparator comparator() {
                return this.comparator;
            }

            public int compare(Triple t1, Triple t2) {
                return this.comparator().compare(t1, t2);
            }
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
                this.comparator = new TripleComparator();
            }
        };
        if (sorted) {
            OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(triples.map((Function1 & Serializable & scala.Serializable)t -> new Tuple2(t, t), ClassTag$.MODULE$.apply(Tuple2.class)), (Ordering)tripleOrdering, ClassTag$.MODULE$.apply(Triple.class), ClassTag$.MODULE$.apply(Triple.class));
            boolean x$12 = qual$1.sortByKey$default$1();
            int x$2 = qual$1.sortByKey$default$2();
            rDD = qual$1.sortByKey(x$12, x$2).map((Function1 & Serializable & scala.Serializable)x$1 -> (Triple)x$1._1(), ClassTag$.MODULE$.apply(Triple.class));
        } else {
            rDD = triples;
        }
        RDD tmp = rDD;
        RDD triplesNTFormat = tmp.map((Function1)new JenaTripleToNTripleString(), ClassTag$.MODULE$.apply(String.class));
        if (singleFile) {
            RDD qual$2 = triplesNTFormat;
            int x$3 = 1;
            boolean x$4 = true;
            Option x$5 = qual$2.coalesce$default$3();
            triplesNTFormat = qual$2.coalesce(x$3, x$4, x$5, (Ordering)Ordering.String$.MODULE$);
        }
        triplesNTFormat.saveAsTextFile(path);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(39).append("finished writing triples to disk in ").append(System.currentTimeMillis() - startTime).append("ms.").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public boolean writeTriplesToDisk$default$3() {
        return false;
    }

    public boolean writeTriplesToDisk$default$4() {
        return false;
    }

    public void writeDataframeToDisk(Dataset<Row> triples, String path, boolean singleFile, boolean sorted) {
        Function1 & Serializable & scala.Serializable rowToJenaTriple = (Function1 & Serializable & scala.Serializable)row -> Triple.create((Node)NodeFactory.createURI((String)row.getString(0)), (Node)NodeFactory.createURI((String)row.getString(1)), (Node)(row.getString(2).startsWith("http:") ? NodeFactory.createURI((String)row.getString(2)) : NodeFactory.createLiteral((String)row.getString(2))));
        this.writeTriplesToDisk((RDD<Triple>)triples.rdd().map((Function1)rowToJenaTriple, ClassTag$.MODULE$.apply(Triple.class)), path, singleFile, sorted);
    }

    public boolean writeDataframeToDisk$default$3() {
        return false;
    }

    public boolean writeDataframeToDisk$default$4() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Model convertToModel(RDFGraph graph) {
        void var3_3;
        Triple[] triples = (Triple[])graph.triples().collect();
        Model model = ModelFactory.createDefaultModel();
        GraphUtil.add((Graph)model.getGraph(), (Triple[])triples);
        return var3_3;
    }

    private RDFGraphWriter$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
    }
}

