/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import net.sansa_stack.inference.rules.RDFSLevel$;
import net.sansa_stack.inference.rules.ReasoningProfile$;
import net.sansa_stack.inference.spark.RDFGraphMaterializer;
import net.sansa_stack.inference.spark.RDFGraphMaterializer$;
import net.sansa_stack.inference.spark.RDFGraphMaterializer$Config$;
import net.sansa_stack.inference.spark.data.loader.RDFGraphLoader$;
import net.sansa_stack.inference.spark.data.model.RDFGraph;
import net.sansa_stack.inference.spark.data.writer.RDFGraphWriter$;
import net.sansa_stack.inference.spark.forwardchaining.triples.ForwardRuleReasonerOWLHorst;
import net.sansa_stack.inference.spark.forwardchaining.triples.ForwardRuleReasonerRDFS;
import net.sansa_stack.inference.spark.forwardchaining.triples.TransitiveReasoner;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scopt.OptionParser;
import scopt.Read;
import scopt.Read$;

public final class RDFGraphMaterializer$ {
    public static RDFGraphMaterializer$ MODULE$;
    private final Read<Enumeration.Value> profilesRead;
    private final Read<Node> nodeRead;
    private final OptionParser<RDFGraphMaterializer.Config> parser;

    static {
        new RDFGraphMaterializer$();
    }

    public void main(String[] args) {
        Option option = this.parser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new RDFGraphMaterializer.Config(RDFGraphMaterializer$Config$.MODULE$.apply$default$1(), RDFGraphMaterializer$Config$.MODULE$.apply$default$2(), RDFGraphMaterializer$Config$.MODULE$.apply$default$3(), RDFGraphMaterializer$Config$.MODULE$.apply$default$4(), RDFGraphMaterializer$Config$.MODULE$.apply$default$5(), RDFGraphMaterializer$Config$.MODULE$.apply$default$6(), RDFGraphMaterializer$Config$.MODULE$.apply$default$7()));
        if (option instanceof Some) {
            Some some = (Some)option;
            RDFGraphMaterializer.Config config = (RDFGraphMaterializer.Config)some.value();
            this.run(config.in(), config.out(), config.profile(), config.properties(), config.writeToSingleFile(), config.sortedOutput(), config.parallelism());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.println((Object)this.parser().usage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void run(Seq<URI> input, URI output, Enumeration.Value profile, Seq<Node> properties, boolean writeToSingleFile, boolean sortedOutput, int parallelism) {
        TransitiveReasoner transitiveReasoner;
        SparkConf conf = new SparkConf();
        conf.registerKryoClasses((Class[])((Object[])new Class[]{Triple.class}));
        conf.set("spark.extraListeners", "net.sansa_stack.inference.spark.utils.CustomSparkListener");
        SparkSession session = SparkSession$.MODULE$.builder().appName(new StringBuilder(16).append("SPARK ").append(profile).append(" Reasoning").toString()).master("local[4]").config("spark.hadoop.validateOutputSpecs", "false").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.default.parallelism", (long)parallelism).config("spark.ui.showConsoleProgress", "false").config("spark.sql.shuffle.partitions", (long)parallelism).config(conf).getOrCreate();
        RDFGraph graph = RDFGraphLoader$.MODULE$.loadFromDisk(session, input, parallelism);
        Enumeration.Value value = profile;
        Enumeration.Value value2 = ReasoningProfile$.MODULE$.TRANSITIVE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            transitiveReasoner = new TransitiveReasoner(session.sparkContext(), properties, parallelism);
        } else {
            Enumeration.Value value4 = ReasoningProfile$.MODULE$.RDFS();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                transitiveReasoner = new ForwardRuleReasonerRDFS(session.sparkContext(), parallelism);
            } else {
                Enumeration.Value value6 = ReasoningProfile$.MODULE$.RDFS_SIMPLE();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    ForwardRuleReasonerRDFS r = new ForwardRuleReasonerRDFS(session.sparkContext(), parallelism);
                    r.level_$eq(RDFSLevel$.MODULE$.SIMPLE());
                    transitiveReasoner = r;
                } else {
                    Enumeration.Value value8 = ReasoningProfile$.MODULE$.OWL_HORST();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        transitiveReasoner = new ForwardRuleReasonerOWLHorst(session.sparkContext());
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        TransitiveReasoner reasoner = transitiveReasoner;
        RDFGraph inferredGraph = reasoner.apply(graph);
        RDFGraphWriter$.MODULE$.writeToDisk(inferredGraph, output.toString(), writeToSingleFile, sortedOutput);
        session.stop();
    }

    public Seq<Node> run$default$4() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Read<Enumeration.Value> profilesRead() {
        return this.profilesRead;
    }

    public Read<Node> nodeRead() {
        return this.nodeRead;
    }

    public OptionParser<RDFGraphMaterializer.Config> parser() {
        return this.parser;
    }

    private RDFGraphMaterializer$() {
        MODULE$ = this;
        this.profilesRead = Read$.MODULE$.reads((Function1 & Serializable & scala.Serializable)x$1 -> ReasoningProfile$.MODULE$.forName(x$1.toLowerCase()));
        this.nodeRead = Read$.MODULE$.reads((Function1 & Serializable & scala.Serializable)x$2 -> NodeFactory.createURI((String)x$2));
        this.parser = new OptionParser<RDFGraphMaterializer.Config>(){

            public static final /* synthetic */ RDFGraphMaterializer.Config $anonfun$new$7(int x, RDFGraphMaterializer.Config c) {
                int x$36 = x;
                Seq<URI> x$37 = c.copy$default$1();
                URI x$38 = c.copy$default$2();
                Seq<Node> x$39 = c.copy$default$3();
                Enumeration.Value x$40 = c.copy$default$4();
                boolean x$41 = c.copy$default$5();
                boolean x$42 = c.copy$default$6();
                return c.copy(x$37, x$38, x$39, x$40, x$41, x$42, x$36);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RDFGraphMaterializer", "0.1.0"}));
                this.opt('i', "input", Read$.MODULE$.seqRead(Read$.MODULE$.uriRead())).required().valueName("<path1>,<path2>,...").action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((Seq<URI>)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7())).text("path to file or directory that contains the input files (in N-Triples format)");
                this.opt('o', "out", Read$.MODULE$.uriRead()).required().valueName("<directory>").action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    URI x$1 = x;
                    Seq<URI> x$2 = c.copy$default$1();
                    Seq<Node> x$3 = c.copy$default$3();
                    Enumeration.Value x$4 = c.copy$default$4();
                    boolean x$5 = c.copy$default$5();
                    boolean x$6 = c.copy$default$6();
                    int x$7 = c.copy$default$7();
                    return c.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7);
                }).text("the output directory");
                this.opt("properties", Read$.MODULE$.seqRead(RDFGraphMaterializer$.MODULE$.nodeRead())).optional().valueName("<property1>,<property2>,...").action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    Seq x$8 = x;
                    Seq<URI> x$9 = c.copy$default$1();
                    URI x$10 = c.copy$default$2();
                    Enumeration.Value x$11 = c.copy$default$4();
                    boolean x$12 = c.copy$default$5();
                    boolean x$13 = c.copy$default$6();
                    int x$14 = c.copy$default$7();
                    return c.copy(x$9, x$10, (Seq<Node>)x$8, x$11, x$12, x$13, x$14);
                }).text("list of properties for which the transitive closure will be computed (used only for profile 'transitive')");
                this.opt('p', "profile", RDFGraphMaterializer$.MODULE$.profilesRead()).required().valueName("{rdfs | rdfs-simple | owl-horst | transitive}").action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    Enumeration.Value x$15 = x;
                    Seq<URI> x$16 = c.copy$default$1();
                    URI x$17 = c.copy$default$2();
                    Seq<Node> x$18 = c.copy$default$3();
                    boolean x$19 = c.copy$default$5();
                    boolean x$20 = c.copy$default$6();
                    int x$21 = c.copy$default$7();
                    return c.copy(x$16, x$17, x$18, x$15, x$19, x$20, x$21);
                }).text("the reasoning profile");
                this.opt("single-file", Read$.MODULE$.unitRead()).optional().action((Function2 & Serializable & scala.Serializable)(x$3, c) -> {
                    boolean x$22 = true;
                    Seq<URI> x$23 = c.copy$default$1();
                    URI x$24 = c.copy$default$2();
                    Seq<Node> x$25 = c.copy$default$3();
                    Enumeration.Value x$26 = c.copy$default$4();
                    boolean x$27 = c.copy$default$6();
                    int x$28 = c.copy$default$7();
                    return c.copy(x$23, x$24, x$25, x$26, x$22, x$27, x$28);
                }).text("write the output to a single file in the output directory");
                this.opt("sorted", Read$.MODULE$.unitRead()).optional().action((Function2 & Serializable & scala.Serializable)(x$4, c) -> {
                    boolean x$29 = true;
                    Seq<URI> x$30 = c.copy$default$1();
                    URI x$31 = c.copy$default$2();
                    Seq<Node> x$32 = c.copy$default$3();
                    Enumeration.Value x$33 = c.copy$default$4();
                    boolean x$34 = c.copy$default$5();
                    int x$35 = c.copy$default$7();
                    return c.copy(x$30, x$31, x$32, x$33, x$34, x$29, x$35);
                }).text("sorted output of the triples (per file)");
                this.opt("parallelism", Read$.MODULE$.intRead()).optional().action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$7(BoxesRunTime.unboxToInt((Object)x), c)).text("the degree of parallelism, i.e. the number of Spark partitions used in the Spark operations");
                this.help("help").text("prints this usage text");
                this.checkConfig((Function1 & Serializable & scala.Serializable)c -> {
                    Enumeration.Value value = c.profile();
                    Enumeration.Value value2 = ReasoningProfile$.MODULE$.TRANSITIVE();
                    return !(value != null ? !value.equals(value2) : value2 != null) && c.properties().isEmpty() ? this.failure("Option --properties must not be empty if profile 'transitive' is set") : this.success();
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(scala.collection.Seq net.sansa_stack.inference.spark.RDFGraphMaterializer$Config ), $anonfun$new$2(java.net.URI net.sansa_stack.inference.spark.RDFGraphMaterializer$Config ), $anonfun$new$3(scala.collection.Seq net.sansa_stack.inference.spark.RDFGraphMaterializer$Config ), $anonfun$new$4(scala.Enumeration$Value net.sansa_stack.inference.spark.RDFGraphMaterializer$Config ), $anonfun$new$5(scala.runtime.BoxedUnit net.sansa_stack.inference.spark.RDFGraphMaterializer$Config ), $anonfun$new$6(scala.runtime.BoxedUnit net.sansa_stack.inference.spark.RDFGraphMaterializer$Config ), $anonfun$new$7$adapted(java.lang.Object net.sansa_stack.inference.spark.RDFGraphMaterializer$Config ), $anonfun$new$8(net.sansa_stack.inference.spark.RDFGraphMaterializer$$anon$1 net.sansa_stack.inference.spark.RDFGraphMaterializer$Config )}, serializedLambda);
            }
        };
    }
}

