/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark.backwardchaining;

import net.sansa_stack.inference.rules.RuleSets$;
import net.sansa_stack.inference.spark.backwardchaining.BackwardChainingReasonerDataset;
import net.sansa_stack.inference.spark.backwardchaining.BackwardChainingReasonerDataset$;
import net.sansa_stack.inference.spark.backwardchaining.RDFTriple;
import net.sansa_stack.inference.spark.data.loader.RDFGraphLoader$;
import net.sansa_stack.inference.spark.utils.PrettyDuration$;
import net.sansa_stack.inference.spark.utils.PrettyDuration$PrettyPrintableDuration$;
import net.sansa_stack.inference.utils.Logging;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class BackwardChainingReasonerDataset$
implements Logging {
    public static final BackwardChainingReasonerDataset$ MODULE$;
    private final int DEFAULT_PARALLELISM;
    private final int DEFAULT_NUM_THREADS;
    private transient Logger net$sansa_stack$inference$utils$Logging$$log_;

    static {
        new BackwardChainingReasonerDataset$();
    }

    public Logger net$sansa_stack$inference$utils$Logging$$log_() {
        return this.net$sansa_stack$inference$utils$Logging$$log_;
    }

    public void net$sansa_stack$inference$utils$Logging$$log__$eq(Logger x$1) {
        this.net$sansa_stack$inference$utils$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Throwable e) {
        Logging.class.trace((Logging)this, msg, (Throwable)e);
    }

    public void trace(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.trace((Logging)this, msg, (Object)o, os);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Throwable e) {
        Logging.class.debug((Logging)this, msg, (Throwable)e);
    }

    public void debug(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.debug((Logging)this, msg, (Object)o, os);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Throwable e) {
        Logging.class.info((Logging)this, msg, (Throwable)e);
    }

    public void info(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.info((Logging)this, msg, (Object)o, os);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Throwable e) {
        Logging.class.warn((Logging)this, msg, (Throwable)e);
    }

    public void warn(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.warn((Logging)this, msg, (Object)o, os);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Throwable e) {
        Logging.class.error((Logging)this, msg, (Throwable)e);
    }

    public void error(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.error((Logging)this, msg, (Object)o, os);
    }

    public int DEFAULT_PARALLELISM() {
        return this.DEFAULT_PARALLELISM;
    }

    public int DEFAULT_NUM_THREADS() {
        return this.DEFAULT_NUM_THREADS;
    }

    public RDD<RDFTriple> loadRDD(SparkSession session, String path) {
        return RDFGraphLoader$.MODULE$.loadFromDisk(session, path, RDFGraphLoader$.MODULE$.loadFromDisk$default$3()).triples().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(Triple t) {
                return new RDFTriple(t.getSubject().toString(), t.getPredicate().toString(), t.getObject().toString());
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class));
    }

    public Dataset<RDFTriple> loadDataset(SparkSession session, String path) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Net_sansa_stack_inference_spark_backwardchaining_BackwardChainingReasonerDataset$$typecreator36$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("net.sansa_stack.inference.spark.backwardchaining.RDFTriple").asType().toTypeConstructor();
            }

            public Net_sansa_stack_inference_spark_backwardchaining_BackwardChainingReasonerDataset$$typecreator36$1() {
            }
        }
        return session.createDataset(this.loadRDD(session, path), session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Net_sansa_stack_inference_spark_backwardchaining_BackwardChainingReasonerDataset$$typecreator36$1())));
    }

    public Dataset<RDFTriple> loadDatasetFromParquet(SparkSession session, String path) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Net_sansa_stack_inference_spark_backwardchaining_BackwardChainingReasonerDataset$$typecreator40$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("net.sansa_stack.inference.spark.backwardchaining.RDFTriple").asType().toTypeConstructor();
            }

            public Net_sansa_stack_inference_spark_backwardchaining_BackwardChainingReasonerDataset$$typecreator40$1() {
            }
        }
        return session.read().parquet(path).as(session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Net_sansa_stack_inference_spark_backwardchaining_BackwardChainingReasonerDataset$$typecreator40$1())));
    }

    public Dataset<Row> loadDataFrame(SparkSession session, String path) {
        return this.loadDataset(session, path).toDF();
    }

    public Dataset<Row> loadDataFrameFromParquet(SparkSession session, String path) {
        return this.loadDatasetFromParquet(session, path).toDF();
    }

    public void main(String[] args) {
        if (args.length == 0) {
            throw scala.sys.package$.MODULE$.error("USAGE: BackwardChainingReasonerDataset <INPUT_PATH>+ <NUM_THREADS>? <PARALLELISM>?");
        }
        String inputPath = args[0];
        boolean parquet = args.length > 1 ? new StringOps(Predef$.MODULE$.augmentString(args[1])).toBoolean() : false;
        int numThreads = args.length > 2 ? new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt() : this.DEFAULT_NUM_THREADS();
        int parallelism = args.length > 3 ? new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt() : this.DEFAULT_PARALLELISM();
        SparkSession session = SparkSession$.MODULE$.builder().appName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark Backward Chaining"})).s((Seq)Nil$.MODULE$)).master(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"local[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numThreads)}))).config("spark.eventLog.enabled", "true").config("spark.hadoop.validateOutputSpecs", "false").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.default.parallelism", (long)parallelism).config("spark.ui.showConsoleProgress", "false").config("spark.sql.shuffle.partitions", (long)parallelism).config("spark.sql.autoBroadcastJoinThreshold", "10485760").config("parquet.enable.summary-metadata", "false").getOrCreate();
        ObjectRef graph = ObjectRef.create(parquet ? this.loadDatasetFromParquet(session, inputPath) : this.loadDataset(session, inputPath));
        graph.elem = ((Dataset)graph.elem).cache();
        ((Dataset)graph.elem).createOrReplaceTempView("TRIPLES");
        this.time((Function0)new Serializable(graph){
            public static final long serialVersionUID = 0L;
            private final ObjectRef graph$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BackwardChainingReasonerDataset$.MODULE$.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|G|=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((Dataset)this.graph$1.elem).count())})));
            }
            {
                this.graph$1 = graph$1;
            }
        });
        Set rules = (Set)RuleSets$.MODULE$.RDFS_SIMPLE().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Rule r) {
                return ((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rdfs2", "rdfs3", "rdfs9", "rdfs7"}))).contains((Object)r.getName());
            }
        });
        BackwardChainingReasonerDataset reasoner = new BackwardChainingReasonerDataset(session, (Set<Rule>)rules, (Dataset<RDFTriple>)((Dataset)graph.elem));
        Triple tp = Triple.create((Node)NodeFactory.createVariable((String)"s"), (Node)RDF.type.asNode(), (Node)NodeFactory.createURI((String)"http://swat.cse.lehigh.edu/onto/univ-bench.owl#Person"));
        this.compare(tp, reasoner, this.compare$default$3());
        tp = Triple.create((Node)NodeFactory.createURI((String)"http://www.Department0.University0.edu/FullProfessor0"), (Node)RDF.type.asNode(), (Node)NodeFactory.createVariable((String)"o"));
        this.compare(tp, reasoner, this.compare$default$3());
        tp = Triple.create((Node)NodeFactory.createURI((String)"http://swat.cse.lehigh.edu/onto/univ-bench.owl#ClericalStaff"), (Node)RDFS.subClassOf.asNode(), (Node)NodeFactory.createVariable((String)"o"));
        this.compare(tp, reasoner, true);
        tp = Triple.create((Node)NodeFactory.createURI((String)"http://swat.cse.lehigh.edu/onto/univ-bench.owl#headOf"), (Node)RDFS.subPropertyOf.asNode(), (Node)NodeFactory.createVariable((String)"o"));
        this.compare(tp, reasoner, this.compare$default$3());
        tp = Triple.create((Node)NodeFactory.createVariable((String)"s"), (Node)NodeFactory.createURI((String)"http://swat.cse.lehigh.edu/onto/univ-bench.owl#degreeFrom"), (Node)NodeFactory.createVariable((String)"o"));
        this.compare(tp, reasoner, this.compare$default$3());
        tp = Triple.create((Node)NodeFactory.createURI((String)"http://www.Department4.University3.edu/GraduateStudent40"), (Node)NodeFactory.createURI((String)"http://swat.cse.lehigh.edu/onto/univ-bench.owl#degreeFrom"), (Node)NodeFactory.createVariable((String)"o"));
        this.compare(tp, reasoner, this.compare$default$3());
        tp = Triple.create((Node)NodeFactory.createVariable((String)"s"), (Node)NodeFactory.createURI((String)"http://swat.cse.lehigh.edu/onto/univ-bench.owl#degreeFrom"), (Node)NodeFactory.createURI((String)"http://www.University801.edu"));
        this.compare(tp, reasoner, this.compare$default$3());
        tp = Triple.create((Node)NodeFactory.createURI((String)"http://www.Department4.University3.edu/GraduateStudent40"), (Node)NodeFactory.createVariable((String)"p"), (Node)NodeFactory.createURI((String)"http://www.University801.edu"));
        this.compare(tp, reasoner, this.compare$default$3());
        tp = Triple.create((Node)NodeFactory.createURI((String)"http://www.Department4.University3.edu/GraduateStudent40"), (Node)NodeFactory.createVariable((String)"p"), (Node)NodeFactory.createVariable((String)"o"));
        this.compare(tp, reasoner, this.compare$default$3());
        tp = Triple.create((Node)NodeFactory.createURI((String)"http://swat.cse.lehigh.edu/onto/univ-bench.owl#Book"), (Node)NodeFactory.createVariable((String)"p"), (Node)NodeFactory.createVariable((String)"o"));
        this.compare(tp, reasoner, this.compare$default$3());
        tp = Triple.create((Node)NodeFactory.createURI((String)"http://swat.cse.lehigh.edu/onto/univ-bench.owl#undergraduateDegreeFrom"), (Node)NodeFactory.createVariable((String)"p"), (Node)NodeFactory.createVariable((String)"o"));
        this.compare(tp, reasoner, this.compare$default$3());
        session.stop();
    }

    public void compare(Triple tp, BackwardChainingReasonerDataset reasoner, boolean show) {
        this.time((Function0)new Serializable(tp, reasoner, show){
            public static final long serialVersionUID = 0L;
            private final Triple tp$6;
            private final BackwardChainingReasonerDataset reasoner$1;
            private final boolean show$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Dataset<RDFTriple> triples = this.reasoner$1.query(this.tp$6);
                BackwardChainingReasonerDataset$.MODULE$.log().info(((Object)BoxesRunTime.boxToLong((long)triples.count())).toString());
                if (this.show$1) {
                    triples.show(false);
                }
            }
            {
                this.tp$6 = tp$6;
                this.reasoner$1 = reasoner$1;
                this.show$1 = show$1;
            }
        });
    }

    public boolean compare$default$3() {
        return false;
    }

    public <R> R time(Function0<R> block) {
        long t0 = System.nanoTime();
        Object result = block.apply();
        long t1 = System.nanoTime();
        this.log().info(new StringBuilder().append((Object)"Elapsed time: ").append((Object)PrettyDuration$PrettyPrintableDuration$.MODULE$.pretty$extension0(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)FiniteDuration$.MODULE$.apply(t1 - t0, "ns")))).toString());
        return (R)result;
    }

    private BackwardChainingReasonerDataset$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.DEFAULT_PARALLELISM = 200;
        this.DEFAULT_NUM_THREADS = 4;
    }
}

