/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark;

import java.net.URI;
import net.sansa_stack.inference.rules.RDFSLevel$;
import net.sansa_stack.inference.rules.ReasoningProfile$;
import net.sansa_stack.inference.spark.RDFGraphMaterializer;
import net.sansa_stack.inference.spark.RDFGraphMaterializer$;
import net.sansa_stack.inference.spark.RDFGraphMaterializer$Config$;
import net.sansa_stack.inference.spark.data.loader.RDFGraphLoader$;
import net.sansa_stack.inference.spark.data.model.RDFGraph;
import net.sansa_stack.inference.spark.data.writer.RDFGraphWriter$;
import net.sansa_stack.inference.spark.forwardchaining.triples.ForwardRuleReasonerOWLHorst;
import net.sansa_stack.inference.spark.forwardchaining.triples.ForwardRuleReasonerRDFS;
import net.sansa_stack.inference.spark.forwardchaining.triples.TransitiveReasoner;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scopt.OptionParser;
import scopt.Read;
import scopt.Read$;

public final class RDFGraphMaterializer$ {
    public static final RDFGraphMaterializer$ MODULE$;
    private final Read<Enumeration.Value> profilesRead;
    private final Read<Node> nodeRead;
    private final OptionParser<RDFGraphMaterializer.Config> parser;

    static {
        new RDFGraphMaterializer$();
    }

    public void main(String[] args) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = this.parser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new RDFGraphMaterializer.Config(RDFGraphMaterializer$Config$.MODULE$.apply$default$1(), RDFGraphMaterializer$Config$.MODULE$.apply$default$2(), RDFGraphMaterializer$Config$.MODULE$.apply$default$3(), RDFGraphMaterializer$Config$.MODULE$.apply$default$4(), RDFGraphMaterializer$Config$.MODULE$.apply$default$5(), RDFGraphMaterializer$Config$.MODULE$.apply$default$6(), RDFGraphMaterializer$Config$.MODULE$.apply$default$7()));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    RDFGraphMaterializer.Config config = (RDFGraphMaterializer.Config)some.x();
                    this.run(config.in(), config.out(), config.profile(), config.properties(), config.writeToSingleFile(), config.sortedOutput(), config.parallelism());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                Predef$.MODULE$.println((Object)this.parser().usage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public void run(Seq<URI> input, URI output, Enumeration.Value profile, Seq<Node> properties, boolean writeToSingleFile, boolean sortedOutput, int parallelism) {
        Enumeration.Value value;
        block6: {
            TransitiveReasoner transitiveReasoner;
            RDFGraph graph;
            SparkSession session;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            SparkConf conf = new SparkConf();
                            conf.registerKryoClasses((Class[])((Object[])new Class[]{Triple.class}));
                            conf.set("spark.extraListeners", "net.sansa_stack.inference.spark.utils.CustomSparkListener");
                            session = SparkSession$.MODULE$.builder().appName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SPARK ", " Reasoning"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{profile}))).master("local[4]").config("spark.hadoop.validateOutputSpecs", "false").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.default.parallelism", (long)parallelism).config("spark.ui.showConsoleProgress", "false").config("spark.sql.shuffle.partitions", (long)parallelism).config(conf).getOrCreate();
                            graph = RDFGraphLoader$.MODULE$.loadFromDisk(session, input, parallelism);
                            value = profile;
                            Enumeration.Value value2 = ReasoningProfile$.MODULE$.TRANSITIVE();
                            Enumeration.Value value3 = value;
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                            transitiveReasoner = new TransitiveReasoner(session.sparkContext(), properties, parallelism);
                            break block3;
                        }
                        Enumeration.Value value4 = ReasoningProfile$.MODULE$.RDFS();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                        transitiveReasoner = new ForwardRuleReasonerRDFS(session.sparkContext(), parallelism);
                        break block3;
                    }
                    Enumeration.Value value6 = ReasoningProfile$.MODULE$.RDFS_SIMPLE();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                    ForwardRuleReasonerRDFS r = new ForwardRuleReasonerRDFS(session.sparkContext(), parallelism);
                    r.level_$eq(RDFSLevel$.MODULE$.SIMPLE());
                    transitiveReasoner = r;
                    break block3;
                }
                Enumeration.Value value8 = ReasoningProfile$.MODULE$.OWL_HORST();
                Enumeration.Value value9 = value;
                if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                transitiveReasoner = new ForwardRuleReasonerOWLHorst(session.sparkContext());
            }
            TransitiveReasoner reasoner = transitiveReasoner;
            RDFGraph inferredGraph = reasoner.apply(graph);
            RDFGraphWriter$.MODULE$.writeToDisk(inferredGraph, output.toString(), writeToSingleFile, sortedOutput);
            session.stop();
            return;
        }
        throw new MatchError((Object)value);
    }

    public Seq<Node> run$default$4() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Read<Enumeration.Value> profilesRead() {
        return this.profilesRead;
    }

    public Read<Node> nodeRead() {
        return this.nodeRead;
    }

    public OptionParser<RDFGraphMaterializer.Config> parser() {
        return this.parser;
    }

    private RDFGraphMaterializer$() {
        MODULE$ = this;
        this.profilesRead = Read$.MODULE$.reads((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Enumeration.Value apply(String x$1) {
                return ReasoningProfile$.MODULE$.forName(x$1.toLowerCase());
            }
        });
        this.nodeRead = Read$.MODULE$.reads((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Node apply(String x$2) {
                return NodeFactory.createURI((String)x$2);
            }
        });
        this.parser = new OptionParser<RDFGraphMaterializer.Config>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RDFGraphMaterializer", "0.1.0"}));
                this.opt('i', "input", Read$.MODULE$.seqRead(Read$.MODULE$.uriRead())).required().valueName("<path1>,<path2>,...").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFGraphMaterializer.Config apply(Seq<URI> x, RDFGraphMaterializer.Config c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7());
                    }
                }).text("path to file or directory that contains the input files (in N-Triples format)");
                this.opt('o', "out", Read$.MODULE$.uriRead()).required().valueName("<directory>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFGraphMaterializer.Config apply(URI x, RDFGraphMaterializer.Config c) {
                        URI x$5 = x;
                        Seq<URI> x$6 = c.copy$default$1();
                        Seq<Node> x$7 = c.copy$default$3();
                        Enumeration.Value x$8 = c.copy$default$4();
                        boolean x$9 = c.copy$default$5();
                        boolean x$10 = c.copy$default$6();
                        int x$11 = c.copy$default$7();
                        return c.copy(x$6, x$5, x$7, x$8, x$9, x$10, x$11);
                    }
                }).text("the output directory");
                this.opt("properties", Read$.MODULE$.seqRead(RDFGraphMaterializer$.MODULE$.nodeRead())).optional().valueName("<property1>,<property2>,...").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFGraphMaterializer.Config apply(Seq<Node> x, RDFGraphMaterializer.Config c) {
                        Seq<Node> x$12 = x;
                        Seq<URI> x$13 = c.copy$default$1();
                        URI x$14 = c.copy$default$2();
                        Enumeration.Value x$15 = c.copy$default$4();
                        boolean x$16 = c.copy$default$5();
                        boolean x$17 = c.copy$default$6();
                        int x$18 = c.copy$default$7();
                        return c.copy(x$13, x$14, x$12, x$15, x$16, x$17, x$18);
                    }
                }).text("list of properties for which the transitive closure will be computed (used only for profile 'transitive')");
                this.opt('p', "profile", RDFGraphMaterializer$.MODULE$.profilesRead()).required().valueName("{rdfs | rdfs-simple | owl-horst | transitive}").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFGraphMaterializer.Config apply(Enumeration.Value x, RDFGraphMaterializer.Config c) {
                        Enumeration.Value x$19 = x;
                        Seq<URI> x$20 = c.copy$default$1();
                        URI x$21 = c.copy$default$2();
                        Seq<Node> x$22 = c.copy$default$3();
                        boolean x$23 = c.copy$default$5();
                        boolean x$24 = c.copy$default$6();
                        int x$25 = c.copy$default$7();
                        return c.copy(x$20, x$21, x$22, x$19, x$23, x$24, x$25);
                    }
                }).text("the reasoning profile");
                this.opt("single-file", Read$.MODULE$.unitRead()).optional().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFGraphMaterializer.Config apply(BoxedUnit x$3, RDFGraphMaterializer.Config c) {
                        boolean x$26 = true;
                        Seq<URI> x$27 = c.copy$default$1();
                        URI x$28 = c.copy$default$2();
                        Seq<Node> x$29 = c.copy$default$3();
                        Enumeration.Value x$30 = c.copy$default$4();
                        boolean x$31 = c.copy$default$6();
                        int x$32 = c.copy$default$7();
                        return c.copy(x$27, x$28, x$29, x$30, x$26, x$31, x$32);
                    }
                }).text("write the output to a single file in the output directory");
                this.opt("sorted", Read$.MODULE$.unitRead()).optional().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFGraphMaterializer.Config apply(BoxedUnit x$4, RDFGraphMaterializer.Config c) {
                        boolean x$33 = true;
                        Seq<URI> x$34 = c.copy$default$1();
                        URI x$35 = c.copy$default$2();
                        Seq<Node> x$36 = c.copy$default$3();
                        Enumeration.Value x$37 = c.copy$default$4();
                        boolean x$38 = c.copy$default$5();
                        int x$39 = c.copy$default$7();
                        return c.copy(x$34, x$35, x$36, x$37, x$38, x$33, x$39);
                    }
                }).text("sorted output of the triples (per file)");
                this.opt("parallelism", Read$.MODULE$.intRead()).optional().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFGraphMaterializer.Config apply(int x, RDFGraphMaterializer.Config c) {
                        int x$40 = x;
                        Seq<URI> x$41 = c.copy$default$1();
                        URI x$42 = c.copy$default$2();
                        Seq<Node> x$43 = c.copy$default$3();
                        Enumeration.Value x$44 = c.copy$default$4();
                        boolean x$45 = c.copy$default$5();
                        boolean x$46 = c.copy$default$6();
                        return c.copy(x$41, x$42, x$43, x$44, x$45, x$46, x$40);
                    }
                }).text("the degree of parallelism, i.e. the number of Spark partitions used in the Spark operations");
                this.help("help").text("prints this usage text");
                this.checkConfig((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(RDFGraphMaterializer.Config c) {
                        Enumeration.Value value = c.profile();
                        Enumeration.Value value2 = ReasoningProfile$.MODULE$.TRANSITIVE();
                        return !(value != null ? !value.equals(value2) : value2 != null) && c.properties().isEmpty() ? this.$outer.failure("Option --properties must not be empty if profile 'transitive' is set") : this.$outer.success();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        };
    }
}

