/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark.data.writer;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.sansa_stack.inference.spark.data.model.RDFGraph;
import net.sansa_stack.inference.utils.JenaTripleToNTripleString;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.util.TripleComparator;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RDFGraphWriter$ {
    public static final RDFGraphWriter$ MODULE$;
    private final Logger logger;

    static {
        new RDFGraphWriter$();
    }

    private Logger logger() {
        return this.logger;
    }

    public void writeToDisk(RDFGraph graph, String path, boolean singleFile, boolean sorted) {
        this.writeTriplesToDisk(graph.triples(), path, singleFile, sorted);
    }

    public boolean writeToDisk$default$3() {
        return false;
    }

    public boolean writeToDisk$default$4() {
        return false;
    }

    public void writeTriplesToDisk(RDD<Triple> triples, String path, boolean singleFile, boolean sorted) {
        BoxedUnit boxedUnit;
        RDD rDD;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("writing triples to disk...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long startTime = System.currentTimeMillis();
        Ordering<Triple> tripleOrdering = new Ordering<Triple>(){
            private final TripleComparator comparator;

            public Some tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Triple> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Triple> f2) {
                return Ordering.class.on((Ordering)this, f2);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public TripleComparator comparator() {
                return this.comparator;
            }

            public int compare(Triple t1, Triple t2) {
                return this.comparator().compare(t1, t2);
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
                this.comparator = new TripleComparator();
            }
        };
        if (sorted) {
            OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(triples.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Triple, Triple> apply(Triple t) {
                    return new Tuple2((Object)t, (Object)t);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), (Ordering)tripleOrdering, ClassTag$.MODULE$.apply(Triple.class), ClassTag$.MODULE$.apply(Triple.class));
            boolean x$2 = qual$1.sortByKey$default$1();
            int x$3 = qual$1.sortByKey$default$2();
            rDD = qual$1.sortByKey(x$2, x$3).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Triple apply(Tuple2<Triple, Triple> x$1) {
                    return (Triple)x$1._1();
                }
            }, ClassTag$.MODULE$.apply(Triple.class));
        } else {
            rDD = triples;
        }
        RDD tmp = rDD;
        RDD triplesNTFormat = tmp.map((Function1)new JenaTripleToNTripleString(), ClassTag$.MODULE$.apply(String.class));
        if (singleFile) {
            RDD qual$2 = triplesNTFormat;
            int x$4 = 1;
            boolean x$5 = true;
            Option x$6 = qual$2.coalesce$default$3();
            triplesNTFormat = qual$2.coalesce(x$4, x$5, x$6, (Ordering)Ordering.String$.MODULE$);
        }
        triplesNTFormat.saveAsTextFile(path);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"finished writing triples to disk in ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))).append((Object)"ms.").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public boolean writeTriplesToDisk$default$3() {
        return false;
    }

    public boolean writeTriplesToDisk$default$4() {
        return false;
    }

    public void writeDataframeToDisk(Dataset<Row> triples, String path, boolean singleFile, boolean sorted) {
        Serializable rowToJenaTriple = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Triple apply(Row row) {
                return Triple.create((Node)NodeFactory.createURI((String)row.getString(0)), (Node)NodeFactory.createURI((String)row.getString(1)), (Node)(row.getString(2).startsWith("http:") ? NodeFactory.createURI((String)row.getString(2)) : NodeFactory.createLiteral((String)row.getString(2))));
            }
        };
        this.writeTriplesToDisk((RDD<Triple>)triples.rdd().map((Function1)rowToJenaTriple, ClassTag$.MODULE$.apply(Triple.class)), path, singleFile, sorted);
    }

    public boolean writeDataframeToDisk$default$3() {
        return false;
    }

    public boolean writeDataframeToDisk$default$4() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Model convertToModel(RDFGraph graph) {
        void var3_3;
        String modelString = Predef$.MODULE$.refArrayOps((Object[])graph.triples().map((Function1)new JenaTripleToNTripleString(), ClassTag$.MODULE$.apply(String.class)).collect()).mkString("\n");
        Model model = ModelFactory.createDefaultModel();
        Object object = modelString.trim().isEmpty() ? BoxedUnit.UNIT : model.read((InputStream)new ByteArrayInputStream(modelString.getBytes(StandardCharsets.UTF_8)), null, "N-TRIPLES");
        return var3_3;
    }

    private RDFGraphWriter$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
    }
}

