/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark.data.loader;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.net.URI;
import net.sansa_stack.inference.data.SQLSchema;
import net.sansa_stack.inference.data.SQLSchemaDefault$;
import net.sansa_stack.inference.spark.data.loader.RDFGraphLoader$;
import net.sansa_stack.inference.spark.data.model.RDFGraph;
import net.sansa_stack.inference.spark.data.model.RDFGraphDataFrame;
import net.sansa_stack.inference.spark.data.model.RDFGraphDataFrame$;
import net.sansa_stack.inference.spark.data.model.RDFGraphDataset;
import net.sansa_stack.inference.spark.data.model.RDFGraphNative;
import net.sansa_stack.rdf.spark.io.NTripleReader$;
import net.sansa_stack.rdf.spark.io.package;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.vocabulary.RDF;
import org.apache.spark.SparkConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RDFGraphLoader$ {
    public static final RDFGraphLoader$ MODULE$;
    private final Logger logger;

    static {
        new RDFGraphLoader$();
    }

    private Logger logger() {
        return this.logger;
    }

    private String pathURIsConverter(Seq<URI> uris) {
        return ((TraversableOnce)uris.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(URI p) {
                return p.toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public RDFGraph loadFromDisk(SparkSession session, String path, int minPartitions) {
        return new RDFGraph((RDD<Triple>)NTripleReader$.MODULE$.load(session, path, NTripleReader$.MODULE$.load$default$3(), NTripleReader$.MODULE$.load$default$4(), NTripleReader$.MODULE$.load$default$5(), NTripleReader$.MODULE$.load$default$6()));
    }

    public RDFGraph loadFromDisk(SparkSession session, Seq<URI> paths, int minPartitions) {
        return this.loadFromDisk(session, paths.mkString(","), minPartitions);
    }

    public RDFGraph loadFromDisk(SparkSession session, URI path, int minPartitions) {
        return this.loadFromDisk(session, (Seq<URI>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new URI[]{path}))), minPartitions);
    }

    public int loadFromDisk$default$3() {
        return 2;
    }

    public RDFGraphNative loadFromDiskAsRDD(SparkSession session, String path, int minPartitions) {
        return new RDFGraphNative((RDD<Triple>)NTripleReader$.MODULE$.load(session, path, NTripleReader$.MODULE$.load$default$3(), NTripleReader$.MODULE$.load$default$4(), NTripleReader$.MODULE$.load$default$5(), NTripleReader$.MODULE$.load$default$6()));
    }

    public RDFGraphDataset loadFromDiskAsDataset(SparkSession session, String path) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("loading triples from disk...");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long startTime = System.currentTimeMillis();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Net_sansa_stack_inference_spark_data_loader_RDFGraphLoader$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.String").asType().toTypeConstructor()})))})));
            }

            public Net_sansa_stack_inference_spark_data_loader_RDFGraphLoader$$typecreator1$1() {
            }
        }
        public final class Net_sansa_stack_inference_spark_data_loader_RDFGraphLoader$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Net_sansa_stack_inference_spark_data_loader_RDFGraphLoader$$typecreator2$1() {
            }
        }
        UserDefinedFunction splitter = functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String>[] apply(String str) {
                Function1 splitted = Predef$.MODULE$.wrapRefArray((Object[])str.split(" ")).lift();
                return (Option[])((Object[])new Option[]{(Option)splitted.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Option)splitted.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Option)splitted.apply((Object)BoxesRunTime.boxToInteger((int)2))});
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Net_sansa_stack_inference_spark_data_loader_RDFGraphLoader$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Net_sansa_stack_inference_spark_data_loader_RDFGraphLoader$$typecreator2$1()));
        Encoder rdfTripleEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Triple.class));
        SQLContext spark = session.sqlContext();
        Dataset triples = session.createDataset(NTripleReader$.MODULE$.load(session, path, NTripleReader$.MODULE$.load$default$3(), NTripleReader$.MODULE$.load$default$4(), NTripleReader$.MODULE$.load$default$5(), NTripleReader$.MODULE$.load$default$6()), rdfTripleEncoder).as("triples");
        return new RDFGraphDataset((Dataset<Triple>)triples);
    }

    public RDFGraphDataset loadFromDiskAsDataset(SparkSession session, Seq<URI> paths) {
        return this.loadFromDiskAsDataset(session, paths.mkString(","));
    }

    public RDFGraphDataFrame loadFromDiskAsDataFrame(SparkSession session, String path, int minPartitions, SQLSchema sqlSchema) {
        Dataset df = session.read().format("net.sansa_stack.inference.spark.data.loader.sql").load(path);
        df.createOrReplaceTempView(sqlSchema.triplesTable());
        return new RDFGraphDataFrame((Dataset<Row>)df, RDFGraphDataFrame$.MODULE$.$lessinit$greater$default$2());
    }

    public int loadFromDiskAsDataFrame$default$3() {
        return 4;
    }

    public SQLSchema loadFromDiskAsDataFrame$default$4() {
        return SQLSchemaDefault$.MODULE$;
    }

    public void main(String[] args) {
        String path = args[0];
        String string = args[1];
        Object object = "turtle".equals(string) ? Lang.TURTLE : ("ntriples".equals(string) ? Lang.NTRIPLES : null);
        Lang lang = object;
        int numThreads = args.length > 2 ? new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt() : 4;
        int parallelism = args.length > 3 ? new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt() : 4;
        SparkConf conf = new SparkConf();
        conf.registerKryoClasses((Class[])((Object[])new Class[]{Triple.class}));
        conf.set("spark.extraListeners", "net.sansa_stack.inference.spark.utils.CustomSparkListener");
        conf.set("textinputformat.record.delimiter", ".\n");
        SparkSession session = SparkSession$.MODULE$.builder().appName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SPARK ", " Loading"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lang.getLabel()}))).master(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"local[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numThreads)}))).config("spark.eventLog.enabled", "true").config("spark.hadoop.validateOutputSpecs", "false").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.default.parallelism", (long)parallelism).config("spark.ui.showConsoleProgress", "false").config("spark.sql.shuffle.partitions", (long)parallelism).config(conf).getOrCreate();
        Dataset triples = (Dataset)net.sansa_stack.rdf.spark.io.package$.MODULE$.RDFDataFrameReader(session.read()).rdf(lang).apply((Object)path);
        triples.show(10);
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToLong((long)triples.count()));
        net.sansa_stack.rdf.spark.io.package$.MODULE$.RDFDataFrameWriter(triples.filter("p == 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type'").write().mode(SaveMode.Append)).rdf().apply((Object)"/tmp/lubm/out");
        package.RDFReader qual$1 = net.sansa_stack.rdf.spark.io.package$.MODULE$.RDFReader(session);
        Lang x$2 = lang;
        boolean x$3 = qual$1.rdf$default$2();
        RDD triplesRDD = (RDD)qual$1.rdf(x$2, x$3).apply((Object)path);
        triples.show(10);
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToLong((long)triples.count()));
        package.RDFWriter qual$2 = net.sansa_stack.rdf.spark.io.package$.MODULE$.RDFWriter(triplesRDD.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Triple x$1) {
                return x$1.predicateMatches(RDF.type.asNode());
            }
        }));
        String x$4 = "/tmp/lubm/out";
        SaveMode x$5 = qual$2.saveAsNTriplesFile$default$2();
        boolean x$6 = qual$2.saveAsNTriplesFile$default$3();
        qual$2.saveAsNTriplesFile(x$4, x$5, x$6);
        session.stop();
    }

    private RDFGraphLoader$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
    }
}

