/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark.rules.plan;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import net.sansa_stack.inference.spark.data.RDFGraphDataFrame;
import net.sansa_stack.inference.spark.rules.plan.Plan;
import net.sansa_stack.inference.spark.rules.plan.PlanExecutor;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001\u001f\ty\u0001\u000b\\1o\u000bb,7-\u001e;peN\u000bFJ\u0003\u0002\u0004\t\u0005!\u0001\u000f\\1o\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\nS:4WM]3oG\u0016T!a\u0003\u0007\u0002\u0017M\fgn]1`gR\f7m\u001b\u0006\u0002\u001b\u0005\u0019a.\u001a;\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0005#I!R&D\u0001\u0003\u0013\t\u0019\"A\u0001\u0007QY\u0006tW\t_3dkR|'\u000f\u0005\u0002\u0016U9\u0011ac\n\b\u0003/\u0011r!\u0001\u0007\u0012\u000f\u0005eybB\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\u000f\u0003\u0019a$o\\8u}%\ta$A\u0002pe\u001eL!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012BA\u0004$\u0015\t\u0001\u0013%\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001d\u0019\u0013B\u0001\u0015*\u0003\u001d\u0001\u0018mY6bO\u0016T!!\n\u0014\n\u0005-b#!\u0003#bi\u00064%/Y7f\u0015\tA\u0013\u0006\u0005\u0002/c5\tqF\u0003\u00021\r\u0005!A-\u0019;b\u0013\t\u0011tFA\tS\t\u001a;%/\u00199i\t\u0006$\u0018M\u0012:b[\u0016D\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!N\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003m]j\u0011!K\u0005\u0003q%\u0012Ab\u00159be.\u001cVm]:j_:DQA\u000f\u0001\u0005\u0002m\na\u0001P5oSRtDC\u0001\u001f>!\t\t\u0002\u0001C\u00035s\u0001\u0007Q\u0007C\u0004@\u0001\t\u0007I\u0011\t!\u0002\r1|wmZ3s+\u0005\t\u0005C\u0001\"J\u001b\u0005\u0019%B\u0001#F\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t1u)\u0001\u0005usB,7/\u00194f\u0015\u0005A\u0015aA2p[&\u0011!j\u0011\u0002\u0007\u0019><w-\u001a:\t\r1\u0003\u0001\u0015!\u0003B\u0003\u001dawnZ4fe\u0002BQA\u0014\u0001\u0005\u0002=\u000bq!\u001a=fGV$X\rF\u0002.!RCQaA'A\u0002E\u0003\"!\u0005*\n\u0005M\u0013!\u0001\u0002)mC:DQ!V'A\u00025\nQa\u001a:ba\"\u0004")
public class PlanExecutorSQL
extends PlanExecutor<Dataset<Row>, RDFGraphDataFrame> {
    private final SparkSession sparkSession;
    private final Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public RDFGraphDataFrame execute(Plan plan, RDFGraphDataFrame graph) {
        BoxedUnit boxedUnit;
        String sql = plan.toSQL();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SQL Query:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String tmpName = "TEMP_TRIPLES";
        graph.toDataFrame(this.sparkSession).createTempView(tmpName);
        Dataset results = this.sparkSession.sql(sql.replace("TRIPLES", tmpName));
        this.sparkSession.sqlContext().dropTempTable(tmpName);
        return new RDFGraphDataFrame((Dataset<Row>)results);
    }

    public PlanExecutorSQL(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
    }
}

