/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark.forwardchaining;

import com.typesafe.scalalogging.Logger$;
import net.sansa_stack.inference.data.RDFTriple;
import net.sansa_stack.inference.spark.data.RDFGraph;
import net.sansa_stack.inference.spark.data.RDFGraphDataFrame;
import net.sansa_stack.inference.spark.forwardchaining.ForwardRuleReasoner;
import net.sansa_stack.inference.spark.forwardchaining.ForwardRuleReasoner$class;
import net.sansa_stack.inference.spark.forwardchaining.TransitiveReasoner;
import net.sansa_stack.inference.spark.forwardchaining.TransitiveReasoner$class;
import net.sansa_stack.inference.spark.utils.RDFSSchemaExtractor;
import net.sansa_stack.inference.utils.Logging;
import net.sansa_stack.inference.utils.Profiler;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001\u001b\t\u0001ci\u001c:xCJ$'+\u001e7f%\u0016\f7o\u001c8feJ#ei\u0015#bi\u00064'/Y7f\u0015\t\u0019A!A\bg_J<\u0018M\u001d3dQ\u0006Lg.\u001b8h\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u0005I\u0011N\u001c4fe\u0016t7-\u001a\u0006\u0003\u0013)\t1b]1og\u0006|6\u000f^1dW*\t1\"A\u0002oKR\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005M1uN]<be\u0012\u0014V\u000f\\3SK\u0006\u001cxN\\3s\u0011!I\u0002A!A!\u0002\u0013Q\u0012aB:fgNLwN\u001c\t\u00037\rj\u0011\u0001\b\u0006\u0003;y\t1a]9m\u0015\t)qD\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<\u0017B\u0001\u0013\u001d\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u00151\u0003\u0001\"\u0001(\u0003\u0019a\u0014N\\5u}Q\u0011\u0001&\u000b\t\u0003+\u0001AQ!G\u0013A\u0002iAqa\u000b\u0001C\u0002\u0013\u0005A&\u0001\u0006tc2\u001cuN\u001c;fqR,\u0012!\f\t\u000379J!a\f\u000f\u0003\u0015M\u000bFjQ8oi\u0016DH\u000f\u0003\u00042\u0001\u0001\u0006I!L\u0001\fgFd7i\u001c8uKb$\b\u0005C\u00044\u0001\t\u0007I\u0011\u0002\u001b\u0002\r1|wmZ3s+\u0005)\u0004C\u0001\u001c>\u001b\u00059$B\u0001\u001d:\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tQ4(\u0001\u0005usB,7/\u00194f\u0015\u0005a\u0014aA2p[&\u0011ah\u000e\u0002\u0007\u0019><w-\u001a:\t\r\u0001\u0003\u0001\u0015!\u00036\u0003\u001dawnZ4fe\u0002BQA\u0011\u0001\u0005\u0002\r\u000bQ!\u00199qYf$\"\u0001\u0012&\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d#\u0011\u0001\u00023bi\u0006L!!\u0013$\u0003#I#ei\u0012:ba\"$\u0015\r^1Ge\u0006lW\rC\u0003L\u0003\u0002\u0007A)A\u0003he\u0006\u0004\b\u000eC\u0003C\u0001\u0011\u0005S\n\u0006\u0002O#B\u0011QiT\u0005\u0003!\u001a\u0013\u0001B\u0015#G\u000fJ\f\u0007\u000f\u001b\u0005\u0006\u00172\u0003\rA\u0014")
public class ForwardRuleReasonerRDFSDataframe
implements ForwardRuleReasoner {
    private final SparkSession session;
    private final SQLContext sqlContext;
    private final com.typesafe.scalalogging.Logger logger;
    private final Logger log;
    private volatile boolean bitmap$0;

    @Override
    public Set<RDFTriple> extractTriples(Set<RDFTriple> triples, String predicate) {
        return ForwardRuleReasoner$class.extractTriples((ForwardRuleReasoner)this, triples, predicate);
    }

    @Override
    public RDD<RDFTriple> extractTriples(RDD<RDFTriple> triples, String predicate) {
        return ForwardRuleReasoner$class.extractTriples((ForwardRuleReasoner)this, triples, predicate);
    }

    @Override
    public RDD<RDFTriple> extractTriples(RDD<RDFTriple> triples, Option<String> subject, Option<String> predicate, Option<String> obj) {
        return ForwardRuleReasoner$class.extractTriples(this, triples, subject, predicate, obj);
    }

    @Override
    public scala.collection.immutable.Set<RDFTriple> computeTransitiveClosure(scala.collection.immutable.Set<RDFTriple> triples) {
        return TransitiveReasoner$class.computeTransitiveClosure((TransitiveReasoner)this, triples);
    }

    @Override
    public RDD<RDFTriple> computeTransitiveClosure(RDD<RDFTriple> triples) {
        return TransitiveReasoner$class.computeTransitiveClosure((TransitiveReasoner)this, triples);
    }

    @Override
    public RDD<RDFTriple> computeTransitiveClosure(RDD<RDFTriple> triples, String predicate) {
        return TransitiveReasoner$class.computeTransitiveClosure((TransitiveReasoner)this, triples, predicate);
    }

    @Override
    public <A> RDD<Tuple2<A, A>> computeTransitiveClosure(RDD<Tuple2<A, A>> edges, ClassTag<A> evidence$1) {
        return TransitiveReasoner$class.computeTransitiveClosure((TransitiveReasoner)this, edges, evidence$1);
    }

    @Override
    public <A> Dataset<Row> computeTransitiveClosure(Dataset<Row> edges, ClassTag<A> evidence$2) {
        return TransitiveReasoner$class.computeTransitiveClosure((TransitiveReasoner)this, edges, evidence$2);
    }

    public <R> R profile(Function0<R> block) {
        return (R)Profiler.class.profile((Profiler)this, block);
    }

    private Logger log$lzycompute() {
        ForwardRuleReasonerRDFSDataframe forwardRuleReasonerRDFSDataframe = this;
        synchronized (forwardRuleReasonerRDFSDataframe) {
            if (!this.bitmap$0) {
                this.log = Logging.class.log((Logging)this);
                this.bitmap$0 = true;
            }
            return this.log;
        }
    }

    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Throwable e) {
        Logging.class.trace((Logging)this, msg, (Throwable)e);
    }

    public void trace(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.trace((Logging)this, msg, (Object)o, os);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Throwable e) {
        Logging.class.debug((Logging)this, msg, (Throwable)e);
    }

    public void debug(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.debug((Logging)this, msg, (Object)o, os);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Throwable e) {
        Logging.class.info((Logging)this, msg, (Throwable)e);
    }

    public void info(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.info((Logging)this, msg, (Object)o, os);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Throwable e) {
        Logging.class.warn((Logging)this, msg, (Throwable)e);
    }

    public void warn(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.warn((Logging)this, msg, (Object)o, os);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Throwable e) {
        Logging.class.error((Logging)this, msg, (Throwable)e);
    }

    public void error(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.error((Logging)this, msg, (Object)o, os);
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    private com.typesafe.scalalogging.Logger logger() {
        return this.logger;
    }

    public RDFGraphDataFrame apply(RDFGraphDataFrame graph) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("materializing graph...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long startTime = System.currentTimeMillis();
        RDFSSchemaExtractor extractor = new RDFSSchemaExtractor(this.session);
        Map index = extractor.extract(graph);
        Dataset triples = graph.toDataFrame(this.session).alias("DATA");
        index = (Map)index.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Dataset<Row>> apply(Tuple2<String, Dataset<Row>> e) {
                String property = (String)e._1();
                Dataset dataframe = (Dataset)e._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)property), (Object)functions$.MODULE$.broadcast(dataframe).as(property));
            }
        }, Map$.MODULE$.canBuildFrom());
        Dataset subClassOfTriples = (Dataset)index.apply((Object)RDFS.subClassOf.getURI());
        Dataset subClassOfTriplesTrans = functions$.MODULE$.broadcast(this.computeTransitiveClosure((Dataset<Row>)subClassOfTriples, ClassTag$.MODULE$.Nothing()).alias("SC"));
        Dataset subPropertyOfTriples = (Dataset)index.apply((Object)RDFS.subPropertyOf.getURI());
        Dataset subPropertyOfTriplesTrans = functions$.MODULE$.broadcast(this.computeTransitiveClosure((Dataset<Row>)subPropertyOfTriples, ClassTag$.MODULE$.Nothing()).alias("SP"));
        Dataset triplesRDFS7 = triples.join(subPropertyOfTriplesTrans, this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATA.predicate"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SP.subject"}))).$((Seq)Nil$.MODULE$)), "inner").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATA.subject"}))).$((Seq)Nil$.MODULE$), this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SP.object"}))).$((Seq)Nil$.MODULE$), this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATA.object"}))).$((Seq)Nil$.MODULE$)}));
        triples = triples.union(triplesRDFS7).alias("DATA");
        Dataset domainTriples = functions$.MODULE$.broadcast(((Dataset)index.apply((Object)RDFS.domain.getURI())).alias("DOM"));
        Dataset triplesRDFS2 = triples.join(domainTriples, this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATA.predicate"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DOM.subject"}))).$((Seq)Nil$.MODULE$)), "inner").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATA.subject"}))).$((Seq)Nil$.MODULE$), this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DOM.object"}))).$((Seq)Nil$.MODULE$)}));
        Dataset rangeTriples = functions$.MODULE$.broadcast(((Dataset)index.apply((Object)RDFS.range.getURI())).alias("RAN"));
        Dataset triplesRDFS3 = triples.join(rangeTriples, this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATA.predicate"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RAN.subject"}))).$((Seq)Nil$.MODULE$)), "inner").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DATA.object"}))).$((Seq)Nil$.MODULE$), this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RAN.object"}))).$((Seq)Nil$.MODULE$)}));
        Dataset tuples23 = triplesRDFS2.union(triplesRDFS3);
        Dataset typeTuples = triples.where(new StringBuilder().append((Object)"predicate='").append((Object)RDF.type.getURI()).append((Object)"'").toString()).select("subject", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"object"})).union(tuples23).alias("TYPES");
        Dataset tripleRDFS9 = typeTuples.join(subClassOfTriplesTrans, this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TYPES.object"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SC.subject"}))).$((Seq)Nil$.MODULE$)), "inner").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TYPES.subject"}))).$((Seq)Nil$.MODULE$), this.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SC.object"}))).$((Seq)Nil$.MODULE$)}));
        Dataset allTriples = tuples23.union(tripleRDFS9).withColumn("const", functions$.MODULE$.lit((Object)RDF.type.getURI())).select("subject", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"const", "object"})).union(subClassOfTriplesTrans).union(subPropertyOfTriplesTrans).union(triplesRDFS7).distinct();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"...finished materialization in ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))).append((Object)"ms.").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new RDFGraphDataFrame((Dataset<Row>)allTriples);
    }

    @Override
    public RDFGraph apply(RDFGraph graph) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public ForwardRuleReasonerRDFSDataframe(SparkSession session) {
        this.session = session;
        Logging.class.$init$((Logging)this);
        Profiler.class.$init$((Profiler)this);
        TransitiveReasoner$class.$init$(this);
        ForwardRuleReasoner$class.$init$(this);
        this.sqlContext = new SQLContext(session.sparkContext());
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
    }
}

