/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark.forwardchaining;

import com.typesafe.scalalogging.Logger$;
import net.sansa_stack.inference.data.RDFTriple;
import net.sansa_stack.inference.spark.data.RDFGraph;
import net.sansa_stack.inference.spark.forwardchaining.ForwardRuleReasoner;
import net.sansa_stack.inference.spark.forwardchaining.ForwardRuleReasoner$class;
import net.sansa_stack.inference.spark.forwardchaining.ForwardRuleReasonerOWLHorst$;
import net.sansa_stack.inference.spark.forwardchaining.TransitiveReasoner;
import net.sansa_stack.inference.spark.forwardchaining.TransitiveReasoner$class;
import net.sansa_stack.inference.utils.CollectionUtils$;
import net.sansa_stack.inference.utils.Logging;
import net.sansa_stack.inference.utils.Profiler;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rdd.UnionRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u001b\tYbi\u001c:xCJ$'+\u001e7f%\u0016\f7o\u001c8fe>;F\nS8sgRT!a\u0001\u0003\u0002\u001f\u0019|'o^1sI\u000eD\u0017-\u001b8j]\u001eT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011!C5oM\u0016\u0014XM\\2f\u0015\tI!\"A\u0006tC:\u001c\u0018mX:uC\u000e\\'\"A\u0006\u0002\u00079,Go\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u00111CR8so\u0006\u0014HMU;mKJ+\u0017m]8oKJD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0003g\u000e\u0004\"aG\u0011\u000e\u0003qQ!!B\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Eq\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\fa\u0006\u0014\u0018\r\u001c7fY&\u001cX\u000e\u0005\u0002\u0010M%\u0011q\u0005\u0005\u0002\u0004\u0013:$\b\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\bF\u0002,Y5\u0002\"!\u0006\u0001\t\u000beA\u0003\u0019\u0001\u000e\t\u000b\u0011B\u0003\u0019A\u0013\t\u000b%\u0002A\u0011A\u0018\u0015\u0005-\u0002\u0004\"B\r/\u0001\u0004Q\u0002b\u0002\u001a\u0001\u0005\u0004%IaM\u0001\u0007Y><w-\u001a:\u0016\u0003Q\u0002\"!\u000e\u001f\u000e\u0003YR!a\u000e\u001d\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005eR\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003m\n1aY8n\u0013\tidG\u0001\u0004M_\u001e<WM\u001d\u0005\u0007\u007f\u0001\u0001\u000b\u0011\u0002\u001b\u0002\u000f1|wmZ3sA!)\u0011\t\u0001C\u0001\u0005\u0006)\u0011\r\u001d9msR\u00111)\u0013\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r\u0012\tA\u0001Z1uC&\u0011\u0001*\u0012\u0002\t%\u00123uI]1qQ\")!\n\u0011a\u0001\u0007\u0006)qM]1qQ\")A\n\u0001C\u0001\u001b\u0006YA-\u001a3va2L7-\u0019;f)\tq\u0015\fE\u0002P%Rk\u0011\u0001\u0015\u0006\u0003#r\t1A\u001d3e\u0013\t\u0019\u0006KA\u0002S\t\u0012\u0003\"!V,\u000e\u0003YS!A\u0012\u0004\n\u0005a3&!\u0003*E\rR\u0013\u0018\u000e\u001d7f\u0011\u0015Q6\n1\u0001O\u0003\u001d!(/\u001b9mKN\u0004")
public class ForwardRuleReasonerOWLHorst
implements ForwardRuleReasoner {
    private final SparkContext sc;
    private final int parallelism;
    private final com.typesafe.scalalogging.Logger logger;
    private final Logger log;
    private volatile boolean bitmap$0;

    @Override
    public Set<RDFTriple> extractTriples(Set<RDFTriple> triples, String predicate) {
        return ForwardRuleReasoner$class.extractTriples((ForwardRuleReasoner)this, triples, predicate);
    }

    @Override
    public RDD<RDFTriple> extractTriples(RDD<RDFTriple> triples, String predicate) {
        return ForwardRuleReasoner$class.extractTriples((ForwardRuleReasoner)this, triples, predicate);
    }

    @Override
    public RDD<RDFTriple> extractTriples(RDD<RDFTriple> triples, Option<String> subject, Option<String> predicate, Option<String> obj) {
        return ForwardRuleReasoner$class.extractTriples(this, triples, subject, predicate, obj);
    }

    @Override
    public scala.collection.immutable.Set<RDFTriple> computeTransitiveClosure(scala.collection.immutable.Set<RDFTriple> triples) {
        return TransitiveReasoner$class.computeTransitiveClosure((TransitiveReasoner)this, triples);
    }

    @Override
    public RDD<RDFTriple> computeTransitiveClosure(RDD<RDFTriple> triples) {
        return TransitiveReasoner$class.computeTransitiveClosure((TransitiveReasoner)this, triples);
    }

    @Override
    public RDD<RDFTriple> computeTransitiveClosure(RDD<RDFTriple> triples, String predicate) {
        return TransitiveReasoner$class.computeTransitiveClosure((TransitiveReasoner)this, triples, predicate);
    }

    @Override
    public <A> RDD<Tuple2<A, A>> computeTransitiveClosure(RDD<Tuple2<A, A>> edges, ClassTag<A> evidence$1) {
        return TransitiveReasoner$class.computeTransitiveClosure((TransitiveReasoner)this, edges, evidence$1);
    }

    @Override
    public <A> Dataset<Row> computeTransitiveClosure(Dataset<Row> edges, ClassTag<A> evidence$2) {
        return TransitiveReasoner$class.computeTransitiveClosure((TransitiveReasoner)this, edges, evidence$2);
    }

    public <R> R profile(Function0<R> block) {
        return (R)Profiler.class.profile((Profiler)this, block);
    }

    private Logger log$lzycompute() {
        ForwardRuleReasonerOWLHorst forwardRuleReasonerOWLHorst = this;
        synchronized (forwardRuleReasonerOWLHorst) {
            if (!this.bitmap$0) {
                this.log = Logging.class.log((Logging)this);
                this.bitmap$0 = true;
            }
            return this.log;
        }
    }

    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Throwable e) {
        Logging.class.trace((Logging)this, msg, (Throwable)e);
    }

    public void trace(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.trace((Logging)this, msg, (Object)o, os);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Throwable e) {
        Logging.class.debug((Logging)this, msg, (Throwable)e);
    }

    public void debug(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.debug((Logging)this, msg, (Object)o, os);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Throwable e) {
        Logging.class.info((Logging)this, msg, (Throwable)e);
    }

    public void info(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.info((Logging)this, msg, (Object)o, os);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Throwable e) {
        Logging.class.warn((Logging)this, msg, (Throwable)e);
    }

    public void warn(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.warn((Logging)this, msg, (Object)o, os);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Throwable e) {
        Logging.class.error((Logging)this, msg, (Throwable)e);
    }

    public void error(Function0<String> msg, Object o, Seq<Object> os) {
        Logging.class.error((Logging)this, msg, (Object)o, os);
    }

    private com.typesafe.scalalogging.Logger logger() {
        return this.logger;
    }

    @Override
    public RDFGraph apply(RDFGraph graph) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("materializing graph...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long startTime = System.currentTimeMillis();
        RDD triplesRDD = graph.triples().cache();
        RDD subClassOfTriples = this.extractTriples((RDD<RDFTriple>)triplesRDD, RDFS.subClassOf.getURI());
        RDD subPropertyOfTriples = this.extractTriples((RDD<RDFTriple>)triplesRDD, RDFS.subPropertyOf.getURI());
        RDD<RDFTriple> domainTriples = this.extractTriples((RDD<RDFTriple>)triplesRDD, RDFS.domain.getURI());
        RDD<RDFTriple> rangeTriples = this.extractTriples((RDD<RDFTriple>)triplesRDD, RDFS.range.getURI());
        RDD<RDFTriple> equivClassTriples = this.extractTriples((RDD<RDFTriple>)triplesRDD, OWL2.equivalentClass.getURI());
        RDD<RDFTriple> equivPropertyTriples = this.extractTriples((RDD<RDFTriple>)triplesRDD, OWL2.equivalentProperty.getURI());
        subClassOfTriples = this.sc.union(subClassOfTriples, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{equivClassTriples.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(RDFTriple t) {
                return new RDFTriple(t.subject(), RDFS.subClassOf.getURI(), t.object());
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class)), equivClassTriples.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(RDFTriple t) {
                return new RDFTriple(t.object(), RDFS.subClassOf.getURI(), t.subject());
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class))}), ClassTag$.MODULE$.apply(RDFTriple.class)).distinct();
        subPropertyOfTriples = this.sc.union(subPropertyOfTriples, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{equivPropertyTriples.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(RDFTriple t) {
                return new RDFTriple(t.subject(), RDFS.subPropertyOf.getURI(), t.object());
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class)), equivPropertyTriples.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(RDFTriple t) {
                return new RDFTriple(t.object(), RDFS.subPropertyOf.getURI(), t.subject());
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class))}), ClassTag$.MODULE$.apply(RDFTriple.class)).distinct();
        RDD<RDFTriple> subClassOfTriplesTrans = this.computeTransitiveClosure((RDD<RDFTriple>)subClassOfTriples);
        RDD<RDFTriple> subPropertyOfTriplesTrans = this.computeTransitiveClosure((RDD<RDFTriple>)subPropertyOfTriples);
        Map subClassOfMap = CollectionUtils$.MODULE$.toMultiMap((Iterable)Predef$.MODULE$.wrapRefArray((Object[])subClassOfTriplesTrans.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(RDFTriple t) {
                return new Tuple2((Object)t.subject(), (Object)t.object());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).collect()));
        Map subPropertyMap = CollectionUtils$.MODULE$.toMultiMap((Iterable)Predef$.MODULE$.wrapRefArray((Object[])subPropertyOfTriplesTrans.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(RDFTriple t) {
                return new Tuple2((Object)t.subject(), (Object)t.object());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).collect()));
        Map domainMap = Predef$.MODULE$.refArrayOps((Object[])domainTriples.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(RDFTriple t) {
                return new Tuple2((Object)t.subject(), (Object)t.object());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).collect()).toMap(Predef$.MODULE$.$conforms());
        Map rangeMap = Predef$.MODULE$.refArrayOps((Object[])rangeTriples.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(RDFTriple t) {
                return new Tuple2((Object)t.subject(), (Object)t.object());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).collect()).toMap(Predef$.MODULE$.$conforms());
        Broadcast subClassOfMapBC = this.sc.broadcast((Object)subClassOfMap, ClassTag$.MODULE$.apply(Map.class));
        Broadcast subPropertyMapBC = this.sc.broadcast((Object)subPropertyMap, ClassTag$.MODULE$.apply(Map.class));
        Broadcast domainMapBC = this.sc.broadcast((Object)domainMap, ClassTag$.MODULE$.apply(Map.class));
        Broadcast rangeMapBC = this.sc.broadcast((Object)rangeMap, ClassTag$.MODULE$.apply(Map.class));
        RDD equivClassTriplesInf = equivClassTriples.union(subClassOfTriplesTrans.filter((Function1)new Serializable(this, subClassOfMapBC){
            public static final long serialVersionUID = 0L;
            private final Broadcast subClassOfMapBC$1;

            public final boolean apply(RDFTriple t) {
                return ((SetLike)((MapLike)this.subClassOfMapBC$1.value()).getOrElse((Object)t.object(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.immutable.Set<String> apply() {
                        return Predef$.MODULE$.Set().empty();
                    }
                })).contains((Object)t.subject());
            }
            {
                this.subClassOfMapBC$1 = subClassOfMapBC$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(RDFTriple t) {
                return new RDFTriple(t.subject(), OWL2.equivalentClass.getURI(), t.object());
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class)));
        RDD equivPropTriplesInf = equivPropertyTriples.union(subPropertyOfTriplesTrans.filter((Function1)new Serializable(this, subPropertyMapBC){
            public static final long serialVersionUID = 0L;
            private final Broadcast subPropertyMapBC$1;

            public final boolean apply(RDFTriple t) {
                return ((SetLike)((MapLike)this.subPropertyMapBC$1.value()).getOrElse((Object)t.object(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.immutable.Set<String> apply() {
                        return Predef$.MODULE$.Set().empty();
                    }
                })).contains((Object)t.subject());
            }
            {
                this.subPropertyMapBC$1 = subPropertyMapBC$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(RDFTriple t) {
                return new RDFTriple(t.subject(), OWL2.equivalentProperty.getURI(), t.object());
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class)));
        Broadcast transitivePropertiesBC = this.sc.broadcast(this.extractTriples((RDD<RDFTriple>)triplesRDD, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)OWL2.TransitiveProperty.getURI())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(RDFTriple triple) {
                return triple.subject();
            }
        }, ClassTag$.MODULE$.apply(String.class)).collect(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        Broadcast functionalPropertiesBC = this.sc.broadcast(this.extractTriples((RDD<RDFTriple>)triplesRDD, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)OWL2.FunctionalProperty.getURI())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(RDFTriple triple) {
                return triple.subject();
            }
        }, ClassTag$.MODULE$.apply(String.class)).collect(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        Broadcast inverseFunctionalPropertiesBC = this.sc.broadcast(this.extractTriples((RDD<RDFTriple>)triplesRDD, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)OWL2.InverseFunctionalProperty.getURI())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(RDFTriple triple) {
                return triple.subject();
            }
        }, ClassTag$.MODULE$.apply(String.class)).collect(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        Broadcast symmetricPropertiesBC = this.sc.broadcast(this.extractTriples((RDD<RDFTriple>)triplesRDD, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)OWL2.SymmetricProperty.getURI())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(RDFTriple triple) {
                return triple.subject();
            }
        }, ClassTag$.MODULE$.apply(String.class)).collect(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        Broadcast inverseOfMapBC = this.sc.broadcast((Object)Predef$.MODULE$.refArrayOps((Object[])this.extractTriples((RDD<RDFTriple>)triplesRDD, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)OWL2.inverseOf.getURI()), (Option<String>)None$.MODULE$).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(RDFTriple triple) {
                return new Tuple2((Object)triple.subject(), (Object)triple.object());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).collect()).toMap(Predef$.MODULE$.$conforms()), ClassTag$.MODULE$.apply(Map.class));
        Broadcast inverseOfMapRevertedBC = this.sc.broadcast(((TraversableLike)inverseOfMapBC.value()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, String> x$1) {
                return x$1.swap();
            }
        }, Map$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(Map.class));
        Broadcast someValuesFromMapBC = this.sc.broadcast((Object)Predef$.MODULE$.refArrayOps((Object[])this.extractTriples((RDD<RDFTriple>)triplesRDD, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)OWL2.someValuesFrom.getURI()), (Option<String>)None$.MODULE$).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(RDFTriple triple) {
                return new Tuple2((Object)triple.subject(), (Object)triple.object());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).collect()).toMap(Predef$.MODULE$.$conforms()), ClassTag$.MODULE$.apply(Map.class));
        Broadcast someValuesFromMapReversedBC = this.sc.broadcast(((TraversableLike)someValuesFromMapBC.value()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, String> x$2) {
                return x$2.swap();
            }
        }, Map$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(Map.class));
        Broadcast allValuesFromMapBC = this.sc.broadcast((Object)Predef$.MODULE$.refArrayOps((Object[])this.extractTriples((RDD<RDFTriple>)triplesRDD, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)OWL2.allValuesFrom.getURI()), (Option<String>)None$.MODULE$).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(RDFTriple triple) {
                return new Tuple2((Object)triple.subject(), (Object)triple.object());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).collect()).toMap(Predef$.MODULE$.$conforms()), ClassTag$.MODULE$.apply(Map.class));
        Broadcast allValuesFromMapReversedBC = this.sc.broadcast(((TraversableLike)allValuesFromMapBC.value()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, String> x$3) {
                return x$3.swap();
            }
        }, Map$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(Map.class));
        Broadcast hasValueMapBC = this.sc.broadcast((Object)Predef$.MODULE$.refArrayOps((Object[])this.extractTriples((RDD<RDFTriple>)triplesRDD, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)OWL2.hasValue.getURI()), (Option<String>)None$.MODULE$).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(RDFTriple triple) {
                return new Tuple2((Object)triple.subject(), (Object)triple.object());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).collect()).toMap(Predef$.MODULE$.$conforms()), ClassTag$.MODULE$.apply(Map.class));
        Broadcast onPropertyMapBC = this.sc.broadcast((Object)Predef$.MODULE$.refArrayOps((Object[])this.extractTriples((RDD<RDFTriple>)triplesRDD, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)OWL2.onProperty.getURI()), (Option<String>)None$.MODULE$).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(RDFTriple triple) {
                return new Tuple2((Object)triple.subject(), (Object)triple.object());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).collect()).toMap(Predef$.MODULE$.$conforms()), ClassTag$.MODULE$.apply(Map.class));
        Broadcast onPropertyMapReversedBC = this.sc.broadcast(((TraversableLike)onPropertyMapBC.value()).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x$4) {
                return (String)x$4._2();
            }
        }).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(Map<String, String> x$5) {
                return x$5.keys();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Iterable<String>> apply(Tuple2<String, Iterable<String>> x) {
                return (Tuple2)Predef$.MODULE$.identity(x);
            }
        }, Map$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(Map.class));
        Broadcast hasValueMapReversedBC = this.sc.broadcast(((TraversableLike)hasValueMapBC.value()).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x$6) {
                return (String)x$6._2();
            }
        }).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(Map<String, String> x$7) {
                return x$7.keys();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Iterable<String>> apply(Tuple2<String, Iterable<String>> x) {
                return (Tuple2)Predef$.MODULE$.identity(x);
            }
        }, Map$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(Map.class));
        RDD triplesFiltered = triplesRDD.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(RDFTriple triple) {
                String string = triple.predicate();
                String string2 = OWL2.sameAs.getURI();
                if (string == null) {
                    if (string2 == null) return false;
                } else if (string.equals(string2)) return false;
                String string3 = triple.predicate();
                String string4 = RDF.type.getURI();
                if (string3 != null) {
                    if (!string3.equals(string4)) return true;
                    return false;
                }
                if (string4 == null) return false;
                return true;
            }
        });
        RDD sameAsTriples = triplesRDD.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RDFTriple triple) {
                String string = triple.predicate();
                String string2 = OWL2.sameAs.getURI();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        });
        RDD typeTriples = triplesRDD.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RDFTriple triple) {
                String string = triple.predicate();
                String string2 = RDF.type.getURI();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        });
        boolean newDataInferred = true;
        int iteration = 0;
        while (newDataInferred) {
            Ordering x$11;
            int x$10;
            UnionRDD qual$2;
            RDD typeTriplesNew;
            long typeTriplesNewCnt;
            BoxedUnit boxedUnit3;
            ++iteration;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder().append(iteration).append((Object)". iteration...").toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            RDD triplesRDFS7 = triplesFiltered.filter((Function1)new Serializable(this, subPropertyMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast subPropertyMapBC$1;

                public final boolean apply(RDFTriple t) {
                    return ((MapLike)this.subPropertyMapBC$1.value()).contains((Object)t.predicate());
                }
                {
                    this.subPropertyMapBC$1 = subPropertyMapBC$1;
                }
            }).flatMap((Function1)new Serializable(this, subPropertyMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast subPropertyMapBC$1;

                public final scala.collection.immutable.Set<RDFTriple> apply(RDFTriple t) {
                    return (scala.collection.immutable.Set)((SetLike)((MapLike)this.subPropertyMapBC$1.value()).apply((Object)t.predicate())).map((Function1)new Serializable(this, t){
                        public static final long serialVersionUID = 0L;
                        private final RDFTriple t$1;

                        public final RDFTriple apply(String supProp) {
                            return new RDFTriple(this.t$1.subject(), supProp, this.t$1.object());
                        }
                        {
                            this.t$1 = t$1;
                        }
                    }, Set$.MODULE$.canBuildFrom());
                }
                {
                    this.subPropertyMapBC$1 = subPropertyMapBC$1;
                }
            }, ClassTag$.MODULE$.apply(RDFTriple.class));
            RDD rdfs7Res = triplesRDFS7.union(triplesFiltered);
            RDD triplesRDFS2 = rdfs7Res.filter((Function1)new Serializable(this, domainMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast domainMapBC$1;

                public final boolean apply(RDFTriple t) {
                    return ((MapLike)this.domainMapBC$1.value()).contains((Object)t.predicate());
                }
                {
                    this.domainMapBC$1 = domainMapBC$1;
                }
            }).map((Function1)new Serializable(this, domainMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast domainMapBC$1;

                public final RDFTriple apply(RDFTriple t) {
                    return new RDFTriple(t.subject(), RDF.type.getURI(), (String)((MapLike)this.domainMapBC$1.value()).apply((Object)t.predicate()));
                }
                {
                    this.domainMapBC$1 = domainMapBC$1;
                }
            }, ClassTag$.MODULE$.apply(RDFTriple.class));
            RDD triplesRDFS3 = rdfs7Res.filter((Function1)new Serializable(this, rangeMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast rangeMapBC$1;

                public final boolean apply(RDFTriple t) {
                    return ((MapLike)this.rangeMapBC$1.value()).contains((Object)t.predicate());
                }
                {
                    this.rangeMapBC$1 = rangeMapBC$1;
                }
            }).map((Function1)new Serializable(this, rangeMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast rangeMapBC$1;

                public final RDFTriple apply(RDFTriple t) {
                    return new RDFTriple(t.object(), RDF.type.getURI(), (String)((MapLike)this.rangeMapBC$1.value()).apply((Object)t.predicate()));
                }
                {
                    this.rangeMapBC$1 = rangeMapBC$1;
                }
            }, ClassTag$.MODULE$.apply(RDFTriple.class));
            RDD triplesRDFS9 = triplesRDFS2.union(triplesRDFS3).union(typeTriples).filter((Function1)new Serializable(this, subClassOfMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast subClassOfMapBC$1;

                public final boolean apply(RDFTriple t) {
                    return ((MapLike)this.subClassOfMapBC$1.value()).contains((Object)t.object());
                }
                {
                    this.subClassOfMapBC$1 = subClassOfMapBC$1;
                }
            }).flatMap((Function1)new Serializable(this, subClassOfMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast subClassOfMapBC$1;

                public final scala.collection.immutable.Set<RDFTriple> apply(RDFTriple t) {
                    return (scala.collection.immutable.Set)((SetLike)((MapLike)this.subClassOfMapBC$1.value()).apply((Object)t.object())).map((Function1)new Serializable(this, t){
                        public static final long serialVersionUID = 0L;
                        private final RDFTriple t$2;

                        public final RDFTriple apply(String supCls) {
                            return new RDFTriple(this.t$2.subject(), RDF.type.getURI(), supCls);
                        }
                        {
                            this.t$2 = t$2;
                        }
                    }, Set$.MODULE$.canBuildFrom());
                }
                {
                    this.subClassOfMapBC$1 = subClassOfMapBC$1;
                }
            }, ClassTag$.MODULE$.apply(RDFTriple.class));
            RDD rdfp14b = typeTriples.filter((Function1)new Serializable(this, hasValueMapBC, onPropertyMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast hasValueMapBC$1;
                private final Broadcast onPropertyMapBC$1;

                public final boolean apply(RDFTriple triple) {
                    return ((MapLike)this.hasValueMapBC$1.value()).contains((Object)triple.object()) && ((MapLike)this.onPropertyMapBC$1.value()).contains((Object)triple.object());
                }
                {
                    this.hasValueMapBC$1 = hasValueMapBC$1;
                    this.onPropertyMapBC$1 = onPropertyMapBC$1;
                }
            }).map((Function1)new Serializable(this, hasValueMapBC, onPropertyMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast hasValueMapBC$1;
                private final Broadcast onPropertyMapBC$1;

                public final RDFTriple apply(RDFTriple triple) {
                    return new RDFTriple(triple.subject(), (String)((MapLike)this.onPropertyMapBC$1.value()).apply((Object)triple.object()), (String)((MapLike)this.hasValueMapBC$1.value()).apply((Object)triple.object()));
                }
                {
                    this.hasValueMapBC$1 = hasValueMapBC$1;
                    this.onPropertyMapBC$1 = onPropertyMapBC$1;
                }
            }, ClassTag$.MODULE$.apply(RDFTriple.class));
            RDD rdfp14a = rdfs7Res.filter((Function1)new Serializable(this, hasValueMapBC, onPropertyMapReversedBC){
                public static final long serialVersionUID = 0L;
                public final Broadcast hasValueMapBC$1;
                private final Broadcast onPropertyMapReversedBC$1;

                public final boolean apply(RDFTriple triple) {
                    BooleanRef valueRestrictionExists = BooleanRef.create((boolean)false);
                    if (((MapLike)this.onPropertyMapReversedBC$1.value()).contains((Object)triple.predicate())) {
                        ((IterableLike)((MapLike)this.onPropertyMapReversedBC$1.value()).apply((Object)triple.predicate())).foreach((Function1)new Serializable(this, valueRestrictionExists, triple){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$40 $outer;
                            private final BooleanRef valueRestrictionExists$1;
                            private final RDFTriple triple$1;

                            public final void apply(String restriction) {
                                if (((MapLike)this.$outer.hasValueMapBC$1.value()).contains((Object)restriction)) {
                                    Object object = ((MapLike)this.$outer.hasValueMapBC$1.value()).apply((Object)restriction);
                                    String string = this.triple$1.object();
                                    if (!(object != null ? !object.equals(string) : string != null)) {
                                        this.valueRestrictionExists$1.elem = true;
                                    }
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.valueRestrictionExists$1 = valueRestrictionExists$1;
                                this.triple$1 = triple$1;
                            }
                        });
                    }
                    return valueRestrictionExists.elem;
                }
                {
                    this.hasValueMapBC$1 = hasValueMapBC$1;
                    this.onPropertyMapReversedBC$1 = onPropertyMapReversedBC$1;
                }
            }).map((Function1)new Serializable(this, hasValueMapBC, onPropertyMapReversedBC){
                public static final long serialVersionUID = 0L;
                public final Broadcast hasValueMapBC$1;
                private final Broadcast onPropertyMapReversedBC$1;

                public final RDFTriple apply(RDFTriple triple) {
                    String s = triple.subject();
                    String p = RDF.type.getURI();
                    ObjectRef o = ObjectRef.create((Object)"");
                    ((IterableLike)((MapLike)this.onPropertyMapReversedBC$1.value()).apply((Object)triple.predicate())).foreach((Function1)new Serializable(this, o, triple){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$41 $outer;
                        private final ObjectRef o$1;
                        private final RDFTriple triple$2;

                        public final void apply(String restriction) {
                            if (((MapLike)this.$outer.hasValueMapBC$1.value()).contains((Object)restriction)) {
                                Object object = ((MapLike)this.$outer.hasValueMapBC$1.value()).apply((Object)restriction);
                                String string = this.triple$2.object();
                                if (!(object != null ? !object.equals(string) : string != null)) {
                                    this.o$1.elem = restriction;
                                }
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.o$1 = o$1;
                            this.triple$2 = triple$2;
                        }
                    });
                    return new RDFTriple(s, p, (String)o.elem);
                }
                {
                    this.hasValueMapBC$1 = hasValueMapBC$1;
                    this.onPropertyMapReversedBC$1 = onPropertyMapReversedBC$1;
                }
            }, ClassTag$.MODULE$.apply(RDFTriple.class));
            RDD rdfp8a = triplesFiltered.filter((Function1)new Serializable(this, inverseOfMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast inverseOfMapBC$1;

                public final boolean apply(RDFTriple triple) {
                    return ((MapLike)this.inverseOfMapBC$1.value()).contains((Object)triple.predicate());
                }
                {
                    this.inverseOfMapBC$1 = inverseOfMapBC$1;
                }
            }).map((Function1)new Serializable(this, inverseOfMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast inverseOfMapBC$1;

                public final RDFTriple apply(RDFTriple triple) {
                    return new RDFTriple(triple.object(), (String)((MapLike)this.inverseOfMapBC$1.value()).apply((Object)triple.predicate()), triple.subject());
                }
                {
                    this.inverseOfMapBC$1 = inverseOfMapBC$1;
                }
            }, ClassTag$.MODULE$.apply(RDFTriple.class));
            RDD rdfp8b = triplesFiltered.filter((Function1)new Serializable(this, inverseOfMapRevertedBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast inverseOfMapRevertedBC$1;

                public final boolean apply(RDFTriple triple) {
                    return ((MapLike)this.inverseOfMapRevertedBC$1.value()).contains((Object)triple.predicate());
                }
                {
                    this.inverseOfMapRevertedBC$1 = inverseOfMapRevertedBC$1;
                }
            }).map((Function1)new Serializable(this, inverseOfMapRevertedBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast inverseOfMapRevertedBC$1;

                public final RDFTriple apply(RDFTriple triple) {
                    return new RDFTriple(triple.object(), (String)((MapLike)this.inverseOfMapRevertedBC$1.value()).apply((Object)triple.predicate()), triple.subject());
                }
                {
                    this.inverseOfMapRevertedBC$1 = inverseOfMapRevertedBC$1;
                }
            }, ClassTag$.MODULE$.apply(RDFTriple.class));
            RDD rdfp3 = triplesFiltered.filter((Function1)new Serializable(this, symmetricPropertiesBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast symmetricPropertiesBC$1;

                public final boolean apply(RDFTriple triple) {
                    return Predef$.MODULE$.refArrayOps((Object[])this.symmetricPropertiesBC$1.value()).contains((Object)triple.predicate());
                }
                {
                    this.symmetricPropertiesBC$1 = symmetricPropertiesBC$1;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RDFTriple apply(RDFTriple triple) {
                    return new RDFTriple(triple.object(), triple.predicate(), triple.subject());
                }
            }, ClassTag$.MODULE$.apply(RDFTriple.class));
            RDD rdfp15_1 = triplesFiltered.filter((Function1)new Serializable(this, onPropertyMapReversedBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast onPropertyMapReversedBC$1;

                public final boolean apply(RDFTriple triple) {
                    return ((MapLike)this.onPropertyMapReversedBC$1.value()).contains((Object)triple.predicate());
                }
                {
                    this.onPropertyMapReversedBC$1 = onPropertyMapReversedBC$1;
                }
            }).map((Function1)new Serializable(this, onPropertyMapReversedBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast onPropertyMapReversedBC$1;

                public final Iterable<Tuple2<Tuple2<String, String>, String>> apply(RDFTriple triple) {
                    Iterable restrictions = (Iterable)((MapLike)this.onPropertyMapReversedBC$1.value()).apply((Object)triple.predicate());
                    return (Iterable)restrictions.map((Function1)new Serializable(this, triple){
                        public static final long serialVersionUID = 0L;
                        private final RDFTriple triple$3;

                        public final Tuple2<Tuple2<String, String>, String> apply(String _r) {
                            return new Tuple2((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)_r), (Object)this.triple$3.object()), (Object)this.triple$3.subject());
                        }
                        {
                            this.triple$3 = triple$3;
                        }
                    }, Iterable$.MODULE$.canBuildFrom());
                }
                {
                    this.onPropertyMapReversedBC$1 = onPropertyMapReversedBC$1;
                }
            }, ClassTag$.MODULE$.apply(Iterable.class)).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<Tuple2<Tuple2<String, String>, String>> apply(Iterable<Tuple2<Tuple2<String, String>, String>> x) {
                    return (Iterable)Predef$.MODULE$.identity(x);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            RDD rdfp15_2 = typeTriples.filter((Function1)new Serializable(this, someValuesFromMapReversedBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast someValuesFromMapReversedBC$1;

                public final boolean apply(RDFTriple triple) {
                    return ((MapLike)this.someValuesFromMapReversedBC$1.value()).contains((Object)triple.object());
                }
                {
                    this.someValuesFromMapReversedBC$1 = someValuesFromMapReversedBC$1;
                }
            }).map((Function1)new Serializable(this, someValuesFromMapReversedBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast someValuesFromMapReversedBC$1;

                public final Tuple2<Tuple2<String, String>, Nil$> apply(RDFTriple triple) {
                    return new Tuple2((Object)new Tuple2(((MapLike)this.someValuesFromMapReversedBC$1.value()).apply((Object)triple.object()), (Object)triple.subject()), (Object)Nil$.MODULE$);
                }
                {
                    this.someValuesFromMapReversedBC$1 = someValuesFromMapReversedBC$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            RDD rdfp15 = RDD$.MODULE$.rddToPairRDDFunctions(rdfp15_1, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(String.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$)).join(rdfp15_2).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RDFTriple apply(Tuple2<Tuple2<String, String>, Tuple2<String, Nil$>> e) {
                    return new RDFTriple((String)((Tuple2)e._2())._1(), RDF.type.getURI(), (String)((Tuple2)e._1())._1());
                }
            }, ClassTag$.MODULE$.apply(RDFTriple.class));
            RDD rdfp16_1 = triplesFiltered.filter((Function1)new Serializable(this, allValuesFromMapBC, onPropertyMapReversedBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast allValuesFromMapBC$1;
                private final Broadcast onPropertyMapReversedBC$1;

                public final boolean apply(RDFTriple triple) {
                    return ((MapLike)this.onPropertyMapReversedBC$1.value()).contains((Object)triple.predicate()) && ((TraversableOnce)((scala.collection.immutable.MapLike)this.allValuesFromMapBC$1.value()).keySet().intersect((GenSet)((TraversableOnce)((MapLike)this.onPropertyMapReversedBC$1.value()).apply((Object)triple.predicate())).toSet())).nonEmpty();
                }
                {
                    this.allValuesFromMapBC$1 = allValuesFromMapBC$1;
                    this.onPropertyMapReversedBC$1 = onPropertyMapReversedBC$1;
                }
            }).map((Function1)new Serializable(this, onPropertyMapReversedBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast onPropertyMapReversedBC$1;

                public final Iterable<Tuple2<Tuple2<String, String>, String>> apply(RDFTriple triple) {
                    Iterable restrictions = (Iterable)((MapLike)this.onPropertyMapReversedBC$1.value()).apply((Object)triple.predicate());
                    return (Iterable)restrictions.map((Function1)new Serializable(this, triple){
                        public static final long serialVersionUID = 0L;
                        private final RDFTriple triple$4;

                        public final Tuple2<Tuple2<String, String>, String> apply(String _r) {
                            return new Tuple2((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.triple$4.subject()), (Object)_r), (Object)this.triple$4.object());
                        }
                        {
                            this.triple$4 = triple$4;
                        }
                    }, Iterable$.MODULE$.canBuildFrom());
                }
                {
                    this.onPropertyMapReversedBC$1 = onPropertyMapReversedBC$1;
                }
            }, ClassTag$.MODULE$.apply(Iterable.class)).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<Tuple2<Tuple2<String, String>, String>> apply(Iterable<Tuple2<Tuple2<String, String>, String>> x) {
                    return (Iterable)Predef$.MODULE$.identity(x);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            RDD rdfp16_2 = typeTriples.filter((Function1)new Serializable(this, allValuesFromMapBC, onPropertyMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast allValuesFromMapBC$1;
                private final Broadcast onPropertyMapBC$1;

                public final boolean apply(RDFTriple triple) {
                    return ((MapLike)this.allValuesFromMapBC$1.value()).contains((Object)triple.object()) && ((MapLike)this.onPropertyMapBC$1.value()).contains((Object)triple.object());
                }
                {
                    this.allValuesFromMapBC$1 = allValuesFromMapBC$1;
                    this.onPropertyMapBC$1 = onPropertyMapBC$1;
                }
            }).map((Function1)new Serializable(this, allValuesFromMapBC){
                public static final long serialVersionUID = 0L;
                private final Broadcast allValuesFromMapBC$1;

                public final Tuple2<Tuple2<String, String>, String> apply(RDFTriple triple) {
                    return new Tuple2((Object)new Tuple2((Object)triple.subject(), (Object)triple.object()), ((MapLike)this.allValuesFromMapBC$1.value()).apply((Object)triple.object()));
                }
                {
                    this.allValuesFromMapBC$1 = allValuesFromMapBC$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            RDD rdfp16 = RDD$.MODULE$.rddToPairRDDFunctions(rdfp16_1, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(String.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$)).join(rdfp16_2).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RDFTriple apply(Tuple2<Tuple2<String, String>, Tuple2<String, String>> e) {
                    return new RDFTriple((String)((Tuple2)e._2())._1(), RDF.type.getURI(), (String)((Tuple2)e._2())._2());
                }
            }, ClassTag$.MODULE$.apply(RDFTriple.class));
            UnionRDD qual$1 = new UnionRDD(this.sc, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{triplesRDFS7, rdfp3, rdfp8a, rdfp8b, rdfp14b})), ClassTag$.MODULE$.apply(RDFTriple.class));
            int x$8 = this.parallelism;
            Ordering x$9 = qual$1.distinct$default$2(x$8);
            RDD triplesNew = qual$1.distinct(x$8, x$9).subtract(triplesFiltered, this.parallelism);
            long tripleNewCnt = triplesNew.count();
            if (iteration == 1 || tripleNewCnt > 0L) {
                triplesFiltered = triplesFiltered.union(triplesNew);
                RDD<RDFTriple> rdfp4 = this.computeTransitiveClosure((RDD<RDFTriple>)triplesFiltered.filter((Function1)new Serializable(this, transitivePropertiesBC){
                    public static final long serialVersionUID = 0L;
                    private final Broadcast transitivePropertiesBC$1;

                    public final boolean apply(RDFTriple triple) {
                        return Predef$.MODULE$.refArrayOps((Object[])this.transitivePropertiesBC$1.value()).contains((Object)triple.predicate());
                    }
                    {
                        this.transitivePropertiesBC$1 = transitivePropertiesBC$1;
                    }
                }));
                triplesFiltered = triplesFiltered.union(rdfp4);
            }
            if ((typeTriplesNewCnt = (typeTriplesNew = (qual$2 = new UnionRDD(this.sc, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{triplesRDFS2, triplesRDFS3, triplesRDFS9, rdfp14a, rdfp15, rdfp16})), ClassTag$.MODULE$.apply(RDFTriple.class))).distinct(x$10 = this.parallelism, x$11 = qual$2.distinct$default$2(x$10)).subtract(typeTriples, this.parallelism)).count()) > 0L) {
                typeTriples = typeTriples.union(typeTriplesNew);
            }
            newDataInferred = typeTriplesNewCnt > 0L || typeTriplesNewCnt > 0L;
        }
        RDD rdfp1_1 = triplesFiltered.filter((Function1)new Serializable(this, functionalPropertiesBC){
            public static final long serialVersionUID = 0L;
            private final Broadcast functionalPropertiesBC$1;

            public final boolean apply(RDFTriple triple) {
                return Predef$.MODULE$.refArrayOps((Object[])this.functionalPropertiesBC$1.value()).contains((Object)triple.predicate());
            }
            {
                this.functionalPropertiesBC$1 = functionalPropertiesBC$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<String, String>, String> apply(RDFTriple triple) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)triple.subject(), (Object)triple.predicate())), (Object)triple.object());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD rdfp1 = RDD$.MODULE$.rddToPairRDDFunctions(rdfp1_1, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(String.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$)).join(rdfp1_1).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<String, String>, Tuple2<String, String>> e) {
                return !BoxesRunTime.equals((Object)((Tuple2)e._2())._1(), (Object)((Tuple2)e._2())._2());
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(Tuple2<Tuple2<String, String>, Tuple2<String, String>> e) {
                return new RDFTriple((String)((Tuple2)e._2())._1(), OWL2.sameAs.getURI(), (String)((Tuple2)e._2())._2());
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class));
        RDD rdfp2_1 = triplesFiltered.filter((Function1)new Serializable(this, inverseFunctionalPropertiesBC){
            public static final long serialVersionUID = 0L;
            private final Broadcast inverseFunctionalPropertiesBC$1;

            public final boolean apply(RDFTriple triple) {
                return Predef$.MODULE$.refArrayOps((Object[])this.inverseFunctionalPropertiesBC$1.value()).contains((Object)triple.predicate());
            }
            {
                this.inverseFunctionalPropertiesBC$1 = inverseFunctionalPropertiesBC$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<String, String>, String> apply(RDFTriple triple) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)triple.object(), (Object)triple.predicate())), (Object)triple.subject());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD rdfp2 = RDD$.MODULE$.rddToPairRDDFunctions(rdfp2_1, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(String.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$)).join(rdfp2_1).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<String, String>, Tuple2<String, String>> e) {
                return !BoxesRunTime.equals((Object)((Tuple2)e._2())._1(), (Object)((Tuple2)e._2())._2());
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(Tuple2<Tuple2<String, String>, Tuple2<String, String>> e) {
                return new RDFTriple((String)((Tuple2)e._2())._1(), OWL2.sameAs.getURI(), (String)((Tuple2)e._2())._2());
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class));
        triplesFiltered = triplesFiltered.union(rdfp1).union(rdfp2);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"...finished materialization in ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))).append((Object)"ms.").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        triplesFiltered = this.deduplicate((RDD<RDFTriple>)triplesFiltered);
        typeTriples = this.deduplicate((RDD<RDFTriple>)typeTriples);
        RDD inferredTriples = this.sc.union(triplesFiltered, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{typeTriples, subClassOfTriplesTrans, subPropertyOfTriplesTrans, equivClassTriplesInf, equivPropTriplesInf}), ClassTag$.MODULE$.apply(RDFTriple.class));
        return new RDFGraph((RDD<RDFTriple>)inferredTriples);
    }

    public RDD<RDFTriple> deduplicate(RDD<RDFTriple> triples) {
        int x$12 = this.parallelism;
        Ordering x$13 = triples.distinct$default$2(x$12);
        return triples.distinct(x$12, x$13);
    }

    public ForwardRuleReasonerOWLHorst(SparkContext sc, int parallelism) {
        this.sc = sc;
        this.parallelism = parallelism;
        Logging.class.$init$((Logging)this);
        Profiler.class.$init$((Profiler)this);
        TransitiveReasoner$class.$init$(this);
        ForwardRuleReasoner$class.$init$(this);
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
    }

    public ForwardRuleReasonerOWLHorst(SparkContext sc) {
        this(sc, sc.defaultParallelism());
    }
}

