/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark.data;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.sansa_stack.inference.data.RDFTriple;
import net.sansa_stack.inference.spark.data.RDFGraph;
import net.sansa_stack.inference.utils.RDFTripleOrdering$;
import net.sansa_stack.inference.utils.RDFTripleToNTripleString;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RDFGraphWriter$ {
    public static final RDFGraphWriter$ MODULE$;
    private final Logger logger;

    static {
        new RDFGraphWriter$();
    }

    private Logger logger() {
        return this.logger;
    }

    public void writeGraphToFile(RDFGraph graph, String path, boolean singleFile, boolean sorted) {
        this.writeTriplesToFile(graph.triples(), path, singleFile, sorted);
    }

    public boolean writeGraphToFile$default$3() {
        return false;
    }

    public boolean writeGraphToFile$default$4() {
        return false;
    }

    public void writeTriplesToFile(RDD<RDFTriple> triples, String path, boolean singleFile, boolean sorted) {
        BoxedUnit boxedUnit;
        RDD rDD;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("writing triples to disk...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long startTime = System.currentTimeMillis();
        RDFTripleOrdering$ ordering = RDFTripleOrdering$.MODULE$;
        if (sorted) {
            OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(triples.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<RDFTriple, RDFTriple> apply(RDFTriple t) {
                    return new Tuple2((Object)t, (Object)t);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), (Ordering)ordering, ClassTag$.MODULE$.apply(RDFTriple.class), ClassTag$.MODULE$.apply(RDFTriple.class));
            boolean x$2 = qual$1.sortByKey$default$1();
            int x$3 = qual$1.sortByKey$default$2();
            rDD = qual$1.sortByKey(x$2, x$3).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final RDFTriple apply(Tuple2<RDFTriple, RDFTriple> x$1) {
                    return (RDFTriple)x$1._1();
                }
            }, ClassTag$.MODULE$.apply(RDFTriple.class));
        } else {
            rDD = triples;
        }
        RDD tmp = rDD;
        RDD triplesNTFormat = tmp.map((Function1)new RDFTripleToNTripleString(), ClassTag$.MODULE$.apply(String.class));
        if (singleFile) {
            RDD qual$2 = triplesNTFormat;
            int x$4 = 1;
            boolean x$5 = true;
            Option x$6 = qual$2.coalesce$default$3();
            triplesNTFormat = qual$2.coalesce(x$4, x$5, x$6, (Ordering)Ordering.String$.MODULE$);
        }
        triplesNTFormat.saveAsTextFile(path);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"finished writing triples to disk in ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))).append((Object)"ms.").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public boolean writeTriplesToFile$default$3() {
        return false;
    }

    public boolean writeTriplesToFile$default$4() {
        return false;
    }

    public void writeDataframeToFile(Dataset<Row> dataFrame, String path, boolean singleFile, boolean sorted) {
        this.writeTriplesToFile((RDD<RDFTriple>)dataFrame.rdd().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(Row row) {
                return new RDFTriple(row.getString(0), row.getString(1), row.getString(2));
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class)), path, singleFile, sorted);
    }

    public boolean writeDataframeToFile$default$3() {
        return false;
    }

    public boolean writeDataframeToFile$default$4() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Model convertToModel(RDFGraph graph) {
        void var3_3;
        String modelString = Predef$.MODULE$.refArrayOps((Object[])graph.triples().map((Function1)new RDFTripleToNTripleString(), ClassTag$.MODULE$.apply(String.class)).collect()).mkString("\n");
        Model model = ModelFactory.createDefaultModel();
        Object object = modelString.trim().isEmpty() ? BoxedUnit.UNIT : model.read((InputStream)new ByteArrayInputStream(modelString.getBytes(StandardCharsets.UTF_8)), null, "N-TRIPLES");
        return var3_3;
    }

    private RDFGraphWriter$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
    }
}

