/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark.data;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.File;
import net.sansa_stack.inference.data.RDFTriple;
import net.sansa_stack.inference.spark.data.RDFGraph;
import net.sansa_stack.inference.spark.data.RDFGraphDataFrame;
import net.sansa_stack.inference.spark.data.RDFGraphNative;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class RDFGraphLoader$ {
    public static final RDFGraphLoader$ MODULE$;
    private final Logger logger;

    static {
        new RDFGraphLoader$();
    }

    private Logger logger() {
        return this.logger;
    }

    public RDFGraph loadFromFile(String path, SparkContext sc, int minPartitions) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("loading triples from disk...");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long startTime = System.currentTimeMillis();
        RDD triples = sc.textFile(path, minPartitions).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String line) {
                return line.replace(">", "").replace("<", "").split("\\s+");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(String[] tokens) {
                return new RDFTriple(tokens[0], tokens[1], tokens[2]);
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class));
        return new RDFGraph((RDD<RDFTriple>)triples);
    }

    public int loadFromFile$default$3() {
        return 2;
    }

    public RDFGraph loadFromDisk(Seq<File> paths, SparkContext sc, int minPartitions) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("loading triples from disk...");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long startTime = System.currentTimeMillis();
        RDD triples = sc.textFile(((TraversableOnce)paths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(File p) {
                return p.getAbsolutePath();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(","), sc.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String line) {
                return line.replace(">", "").replace("<", "").split("\\s+");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(String[] tokens) {
                return new RDFTriple(tokens[0], tokens[1], tokens[2]);
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class)).cache();
        return new RDFGraph((RDD<RDFTriple>)triples);
    }

    public int loadFromDisk$default$3() {
        return 2;
    }

    public RDFGraphNative loadGraphFromFile(String path, SparkSession session, int minPartitions) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("loading triples from disk...");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long startTime = System.currentTimeMillis();
        RDD triples = session.sparkContext().textFile(path, minPartitions).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String line) {
                return line.replace(">", "").replace("<", "").split("\\s+");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(String[] tokens) {
                return new RDFTriple(tokens[0], tokens[1], tokens[2]);
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class));
        return new RDFGraphNative((RDD<RDFTriple>)triples);
    }

    public int loadGraphFromFile$default$3() {
        return 2;
    }

    public RDFGraphDataFrame loadGraphDataFrameFromFile(String path, SparkSession session, int minPartitions) {
        return new RDFGraphDataFrame(this.loadGraphFromFile(path, session, minPartitions).toDataFrame(session));
    }

    public int loadGraphDataFrameFromFile$default$3() {
        return 2;
    }

    private RDFGraphLoader$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
    }
}

