/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.spark;

import java.io.File;
import net.sansa_stack.inference.data.RDFTriple;
import net.sansa_stack.inference.rules.RDFSLevel$;
import net.sansa_stack.inference.rules.ReasoningProfile$;
import net.sansa_stack.inference.spark.RDFGraphMaterializer;
import net.sansa_stack.inference.spark.RDFGraphMaterializer$Config$;
import net.sansa_stack.inference.spark.data.RDFGraph;
import net.sansa_stack.inference.spark.data.RDFGraphLoader$;
import net.sansa_stack.inference.spark.data.RDFGraphWriter$;
import net.sansa_stack.inference.spark.forwardchaining.ForwardRuleReasoner;
import net.sansa_stack.inference.spark.forwardchaining.ForwardRuleReasonerOWLHorst;
import net.sansa_stack.inference.spark.forwardchaining.ForwardRuleReasonerRDFS;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scopt.OptionParser;
import scopt.Read;
import scopt.Read$;

public final class RDFGraphMaterializer$ {
    public static final RDFGraphMaterializer$ MODULE$;
    private final Read<Enumeration.Value> profilesRead;
    private final OptionParser<RDFGraphMaterializer.Config> parser;

    static {
        new RDFGraphMaterializer$();
    }

    public void main(String[] args) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = this.parser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new RDFGraphMaterializer.Config(RDFGraphMaterializer$Config$.MODULE$.apply$default$1(), RDFGraphMaterializer$Config$.MODULE$.apply$default$2(), RDFGraphMaterializer$Config$.MODULE$.apply$default$3(), RDFGraphMaterializer$Config$.MODULE$.apply$default$4(), RDFGraphMaterializer$Config$.MODULE$.apply$default$5()));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    RDFGraphMaterializer.Config config = (RDFGraphMaterializer.Config)some.x();
                    this.run(config.in(), config.out(), config.profile(), config.writeToSingleFile(), config.sortedOutput());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                Predef$.MODULE$.println((Object)this.parser().usage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public void run(Seq<File> input, File output, Enumeration.Value profile, boolean writeToSingleFile, boolean sortedOutput) {
        Enumeration.Value value;
        block5: {
            ForwardRuleReasoner forwardRuleReasoner;
            RDFGraph graph;
            SparkSession session;
            block3: {
                block4: {
                    block2: {
                        SparkConf conf = new SparkConf();
                        conf.registerKryoClasses((Class[])((Object[])new Class[]{RDFTriple.class}));
                        session = SparkSession$.MODULE$.builder().appName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SPARK ", " Reasoning"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{profile}))).master("local[4]").config("spark.eventLog.enabled", "true").config("spark.hadoop.validateOutputSpecs", "false").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.default.parallelism", "4").config(conf).getOrCreate();
                        graph = RDFGraphLoader$.MODULE$.loadFromDisk(input, session.sparkContext(), 4);
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|G| = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)graph.size())})));
                        value = profile;
                        Enumeration.Value value2 = ReasoningProfile$.MODULE$.RDFS();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                        forwardRuleReasoner = new ForwardRuleReasonerRDFS(session.sparkContext());
                        break block3;
                    }
                    Enumeration.Value value4 = ReasoningProfile$.MODULE$.RDFS_SIMPLE();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                    ForwardRuleReasonerRDFS r = new ForwardRuleReasonerRDFS(session.sparkContext());
                    r.level_$eq(RDFSLevel$.MODULE$.SIMPLE());
                    forwardRuleReasoner = r;
                    break block3;
                }
                Enumeration.Value value6 = ReasoningProfile$.MODULE$.OWL_HORST();
                Enumeration.Value value7 = value;
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                forwardRuleReasoner = new ForwardRuleReasonerOWLHorst(session.sparkContext());
            }
            ForwardRuleReasonerRDFS reasoner = forwardRuleReasoner;
            RDFGraph inferredGraph = reasoner.apply(graph);
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|G_inf| = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)inferredGraph.size())})));
            RDFGraphWriter$.MODULE$.writeGraphToFile(inferredGraph, output.getAbsolutePath(), writeToSingleFile, sortedOutput);
            session.stop();
            return;
        }
        throw new MatchError((Object)value);
    }

    public Read<Enumeration.Value> profilesRead() {
        return this.profilesRead;
    }

    public OptionParser<RDFGraphMaterializer.Config> parser() {
        return this.parser;
    }

    private RDFGraphMaterializer$() {
        MODULE$ = this;
        this.profilesRead = Read$.MODULE$.reads((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Enumeration.Value apply(String x$1) {
                return ReasoningProfile$.MODULE$.forName(x$1.toLowerCase());
            }
        });
        this.parser = new OptionParser<RDFGraphMaterializer.Config>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RDFGraphMaterializer", "0.1.0"}));
                this.opt('i', "input", Read$.MODULE$.seqRead(Read$.MODULE$.fileRead())).required().valueName("<path1>,<path2>,...").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFGraphMaterializer.Config apply(Seq<File> x, RDFGraphMaterializer.Config c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5());
                    }
                }).text("path to file or directory that contains the input files (in N-Triple format)");
                this.opt('o', "out", Read$.MODULE$.fileRead()).required().valueName("<directory>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFGraphMaterializer.Config apply(File x, RDFGraphMaterializer.Config c) {
                        File x$4 = x;
                        Seq<File> x$5 = c.copy$default$1();
                        Enumeration.Value x$6 = c.copy$default$3();
                        boolean x$7 = c.copy$default$4();
                        boolean x$8 = c.copy$default$5();
                        return c.copy(x$5, x$4, x$6, x$7, x$8);
                    }
                }).text("the output directory");
                this.opt("single-file", Read$.MODULE$.unitRead()).optional().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFGraphMaterializer.Config apply(BoxedUnit x$2, RDFGraphMaterializer.Config c) {
                        boolean x$9 = true;
                        Seq<File> x$10 = c.copy$default$1();
                        File x$11 = c.copy$default$2();
                        Enumeration.Value x$12 = c.copy$default$3();
                        boolean x$13 = c.copy$default$5();
                        return c.copy(x$10, x$11, x$12, x$9, x$13);
                    }
                }).text("write the output to a single file in the output directory");
                this.opt("sorted", Read$.MODULE$.unitRead()).optional().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFGraphMaterializer.Config apply(BoxedUnit x$3, RDFGraphMaterializer.Config c) {
                        boolean x$14 = true;
                        Seq<File> x$15 = c.copy$default$1();
                        File x$16 = c.copy$default$2();
                        Enumeration.Value x$17 = c.copy$default$3();
                        boolean x$18 = c.copy$default$4();
                        return c.copy(x$15, x$16, x$17, x$18, x$14);
                    }
                }).text("sorted output of the triples (per file)");
                this.opt('p', "profile", RDFGraphMaterializer$.MODULE$.profilesRead()).required().valueName("{rdfs | rdfs-simple | owl-horst}").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFGraphMaterializer.Config apply(Enumeration.Value x, RDFGraphMaterializer.Config c) {
                        Enumeration.Value x$19 = x;
                        Seq<File> x$20 = c.copy$default$1();
                        File x$21 = c.copy$default$2();
                        boolean x$22 = c.copy$default$4();
                        boolean x$23 = c.copy$default$5();
                        return c.copy(x$20, x$21, x$19, x$22, x$23);
                    }
                }).text("the reasoning profile");
                this.help("help").text("prints this usage text");
            }
        };
    }
}

