/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.inference.flink.data;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import net.sansa_stack.inference.data.RDFTriple;
import net.sansa_stack.inference.flink.data.RDFGraph;
import net.sansa_stack.inference.flink.data.RDFGraphWriter$;
import net.sansa_stack.inference.utils.RDFTripleOrdering$;
import net.sansa_stack.inference.utils.RDFTripleToNTripleString;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.core.fs.FileSystem;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class RDFGraphWriter$ {
    public static final RDFGraphWriter$ MODULE$;
    private final Logger logger;

    static {
        new RDFGraphWriter$();
    }

    private Logger logger() {
        return this.logger;
    }

    public void writeToFile(RDFGraph graph, String path) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("writing triples to disk...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long startTime = System.currentTimeMillis();
        RDFTripleOrdering$ ordering = RDFTripleOrdering$.MODULE$;
        graph.triples().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<RDFTriple, RDFTriple> apply(RDFTriple t) {
                return new Tuple2((Object)t, (Object)t);
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<RDFTriple, RDFTriple>>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<RDFTriple, RDFTriple>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.7 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                return new CaseClassSerializer<Tuple2<RDFTriple, RDFTriple>>(this, fieldSerializers){

                    public Tuple2<RDFTriple, RDFTriple> createInstance(Object[] fields) {
                        return new Tuple2((Object)((RDFTriple)fields[0]), (Object)((RDFTriple)fields[1]));
                    }

                    public CaseClassSerializer<Tuple2<RDFTriple, RDFTriple>> createSerializerInstance(Class<Tuple2<RDFTriple, RDFTriple>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)((Object)((Object)this)).getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).sortPartition(1, Order.DESCENDING).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RDFTriple apply(Tuple2<RDFTriple, RDFTriple> x$1) {
                return (RDFTriple)x$1._1();
            }
        }, (TypeInformation)new CaseClassTypeInfo<RDFTriple>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<RDFTriple> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.12 $outer;
                    private final ExecutionConfig executionConfig$6;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$6 = executionConfig$6;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                return new CaseClassSerializer<RDFTriple>(this, fieldSerializers){

                    public RDFTriple createInstance(Object[] fields) {
                        return new RDFTriple((String)fields[0], (String)fields[1], (String)fields[2]);
                    }

                    public CaseClassSerializer<RDFTriple> createSerializerInstance(Class<RDFTriple> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)((Object)((Object)this)).getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(RDFTriple.class)).map((Function1)new RDFTripleToNTripleString(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class), ClassTag$.MODULE$.apply(String.class)).writeAsText(path, FileSystem.WriteMode.OVERWRITE);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"finished writing triples to disk in ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))).append((Object)"ms.").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void writeToDisk(RDFGraph graph, URI path, boolean singleFile, boolean sorted) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("writing triples to disk...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long startTime = System.currentTimeMillis();
        RDFTripleOrdering$ ordering = RDFTripleOrdering$.MODULE$;
        DataSet<RDFTriple> tmp = sorted ? graph.triples() : graph.triples();
        Object object = singleFile ? tmp.setParallelism(1) : BoxedUnit.UNIT;
        tmp.map((Function1)new RDFTripleToNTripleString(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class), ClassTag$.MODULE$.apply(String.class)).writeAsText(path.toString(), FileSystem.WriteMode.OVERWRITE);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"finished writing triples to disk in ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))).append((Object)"ms.").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public boolean writeToDisk$default$3() {
        return false;
    }

    public boolean writeToDisk$default$4() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Model convertToModel(RDFGraph graph) {
        void var3_3;
        String modelString = graph.triples().map((Function1)new RDFTripleToNTripleString(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class), ClassTag$.MODULE$.apply(String.class)).collect().mkString("\n");
        Model model = ModelFactory.createDefaultModel();
        Object object = modelString.trim().isEmpty() ? BoxedUnit.UNIT : model.read((InputStream)new ByteArrayInputStream(modelString.getBytes(StandardCharsets.UTF_8)), null, "N-TRIPLES");
        return var3_3;
    }

    private RDFGraphWriter$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
    }
}

