/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.examples.spark.rdf;

import java.io.File;
import net.sansa_stack.examples.spark.rdf.RDFQualityAssessment;
import net.sansa_stack.examples.spark.rdf.RDFQualityAssessment$Config$;
import net.sansa_stack.rdf.spark.io.package;
import net.sansa_stack.rdf.spark.qualityassessment.package$;
import org.apache.jena.riot.Lang;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scopt.OptionParser;
import scopt.Read$;

public final class RDFQualityAssessment$ {
    public static final RDFQualityAssessment$ MODULE$;
    private final OptionParser<RDFQualityAssessment.Config> parser;

    static {
        new RDFQualityAssessment$();
    }

    public void main(String[] args) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = this.parser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new RDFQualityAssessment.Config(RDFQualityAssessment$Config$.MODULE$.apply$default$1(), RDFQualityAssessment$Config$.MODULE$.apply$default$2()));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    RDFQualityAssessment.Config config = (RDFQualityAssessment.Config)some.x();
                    this.run(config.in(), config.out());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                Predef$.MODULE$.println((Object)this.parser().usage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public void run(String input, String output) {
        String rdf_quality_file = new File(input).getName();
        SparkSession spark = SparkSession$.MODULE$.builder().appName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RDF Quality Assessment Example ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rdf_quality_file}))).master("local[*]").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").getOrCreate();
        Predef$.MODULE$.println((Object)"======================================");
        Predef$.MODULE$.println((Object)"| RDF Quality Assessment Example     |");
        Predef$.MODULE$.println((Object)"======================================");
        Lang lang = Lang.NTRIPLES;
        package.RDFReader qual$1 = net.sansa_stack.rdf.spark.io.package$.MODULE$.RDFReader(spark);
        Lang x$3 = lang;
        boolean x$4 = qual$1.rdf$default$2();
        RDD triples = (RDD)qual$1.rdf(x$3, x$4).apply((Object)input);
        double completeness_schema = package$.MODULE$.QualityAssessmentOperations(triples).assessSchemaCompleteness();
        long completeness_interlinking = package$.MODULE$.QualityAssessmentOperations(triples).assessInterlinkingCompleteness();
        long completeness_property = package$.MODULE$.QualityAssessmentOperations(triples).assessPropertyCompleteness();
        long syntacticvalidity_literalnumeric = package$.MODULE$.QualityAssessmentOperations(triples).assessLiteralNumericRangeChecker();
        long syntacticvalidity_XSDDatatypeCompatibleLiterals = package$.MODULE$.QualityAssessmentOperations(triples).assessXSDDatatypeCompatibleLiterals();
        double availability_DereferenceableUris = package$.MODULE$.QualityAssessmentOperations(triples).assessDereferenceableUris();
        double relevancy_CoverageDetail = package$.MODULE$.QualityAssessmentOperations(triples).assessCoverageDetail();
        double relevancy_CoverageScope = package$.MODULE$.QualityAssessmentOperations(triples).assessCoverageScope();
        double relevancy_AmountOfTriples = package$.MODULE$.QualityAssessmentOperations(triples).assessAmountOfTriples();
        double performance_NoHashURIs = package$.MODULE$.QualityAssessmentOperations(triples).assessNoHashUris();
        double understandability_LabeledResources = package$.MODULE$.QualityAssessmentOperations(triples).assessLabeledResources();
        String AssessQualityStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      completeness_schema:", "\n      completeness_interlinking:", "\n      completeness_property:", "\n      syntacticvalidity_literalnumeric:", "\n      syntacticvalidity_XSDDatatypeCompatibleLiterals:", "\n      availability_DereferenceableUris:", "\n      relevancy_CoverageDetail:", "\n      relevancy_CoverageScope:", "\n      relevancy_AmountOfTriples:", "\n      performance_NoHashURIs:", "\n      understandability_LabeledResources:", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)completeness_schema), BoxesRunTime.boxToLong((long)completeness_interlinking), BoxesRunTime.boxToLong((long)completeness_property), BoxesRunTime.boxToLong((long)syntacticvalidity_literalnumeric), BoxesRunTime.boxToLong((long)syntacticvalidity_XSDDatatypeCompatibleLiterals), BoxesRunTime.boxToDouble((double)availability_DereferenceableUris), BoxesRunTime.boxToDouble((double)relevancy_CoverageDetail), BoxesRunTime.boxToDouble((double)relevancy_CoverageScope), BoxesRunTime.boxToDouble((double)relevancy_AmountOfTriples), BoxesRunTime.boxToDouble((double)performance_NoHashURIs), BoxesRunTime.boxToDouble((double)understandability_LabeledResources)}));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n AssessQuality for ", " :\\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rdf_quality_file, AssessQualityStr})));
    }

    public OptionParser<RDFQualityAssessment.Config> parser() {
        return this.parser;
    }

    private RDFQualityAssessment$() {
        MODULE$ = this;
        this.parser = new OptionParser<RDFQualityAssessment.Config>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RDF Quality Assessment Example"}));
                this.opt('i', "input", Read$.MODULE$.stringRead()).required().valueName("<path>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFQualityAssessment.Config apply(String x, RDFQualityAssessment.Config c) {
                        return c.copy(x, c.copy$default$2());
                    }
                }).text("path to file that contains the data (in N-Triples format)");
                this.opt('o', "out", Read$.MODULE$.stringRead()).required().valueName("<directory>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDFQualityAssessment.Config apply(String x, RDFQualityAssessment.Config c) {
                        String x$1 = x;
                        String x$2 = c.copy$default$1();
                        return c.copy(x$2, x$1);
                    }
                }).text("the output directory");
                this.help("help").text("prints this usage text");
            }
        };
    }
}

