/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.examples.spark.query;

import net.sansa_stack.examples.spark.query.GraphQuery;
import net.sansa_stack.examples.spark.query.GraphQuery$;
import net.sansa_stack.examples.spark.query.GraphQuery$Config$;
import net.sansa_stack.query.spark.graph.jena.Ops;
import net.sansa_stack.query.spark.graph.jena.SparqlParser;
import net.sansa_stack.query.spark.graph.jena.model.Config$;
import net.sansa_stack.query.spark.graph.jena.model.IntermediateResult$;
import net.sansa_stack.query.spark.graph.jena.model.SparkExecutionModel$;
import net.sansa_stack.query.spark.graph.jena.util.Result;
import net.sansa_stack.rdf.spark.partition.graph.algo.ObjectHashPartition;
import net.sansa_stack.rdf.spark.partition.graph.algo.PathPartition;
import net.sansa_stack.rdf.spark.partition.graph.algo.SOHashPartition;
import net.sansa_stack.rdf.spark.partition.graph.algo.SubjectHashPartition;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.Lang;
import org.apache.log4j.Logger;
import org.apache.spark.graphx.Graph;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scopt.OptionParser;
import scopt.Read$;

public final class GraphQuery$ {
    public static final GraphQuery$ MODULE$;
    private final OptionParser<GraphQuery.Config> parser;

    static {
        new GraphQuery$();
    }

    public void main(String[] args) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = this.parser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new GraphQuery.Config(GraphQuery$Config$.MODULE$.apply$default$1(), GraphQuery$Config$.MODULE$.apply$default$2(), GraphQuery$Config$.MODULE$.apply$default$3(), GraphQuery$Config$.MODULE$.apply$default$4(), GraphQuery$Config$.MODULE$.apply$default$5(), GraphQuery$Config$.MODULE$.apply$default$6()));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    GraphQuery.Config config = (GraphQuery.Config)some.x();
                    this.run(config);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                Predef$.MODULE$.println((Object)this.parser().usage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public void run(GraphQuery.Config config) {
        Predef$.MODULE$.println((Object)"===========================================");
        Predef$.MODULE$.println((Object)"| SANSA - Graph query example     |");
        Predef$.MODULE$.println((Object)"===========================================");
        Logger log = Logger.getLogger(this.getClass());
        Config$.MODULE$.setAppName("SANSA Graph Query").setInputGraphFile(config.input()).setInputQueryFile((String)config.query().head()).setLang(Lang.NTRIPLES).setMaster("local[*]");
        log.info((Object)"Start to load graph");
        SparkExecutionModel$.MODULE$.createSparkSession();
        SparkSession session = SparkExecutionModel$.MODULE$.getSession();
        Graph prevG = SparkExecutionModel$.MODULE$.getGraph();
        Graph g = null;
        String msg = null;
        int numParts = 0;
        int numIters = 0;
        int n = config.numParts();
        switch (n) {
            default: {
                numParts = n;
                break;
            }
            case 0: {
                numParts = prevG.edges().partitions().length;
            }
        }
        int n2 = config.numIters();
        switch (n2) {
            default: {
                numIters = n2;
            }
            case 0: 
        }
        SubjectHashPartition partAlgo = null;
        String string = config.algo();
        if ("SSHP".equals(string)) {
            partAlgo = numIters == 0 ? new SubjectHashPartition(prevG, session, numParts, ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class)) : new SubjectHashPartition(prevG, session, numParts, ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class)).setNumIterations(numIters);
            msg = "Start to execute subject semantic hash partitioning";
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("OSHP".equals(string)) {
            partAlgo = numIters == 0 ? new ObjectHashPartition(prevG, session, numParts, ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class)) : new ObjectHashPartition(prevG, session, numParts, ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class)).setNumIterations(numIters);
            msg = "Start to execute object semantic hash partitioning";
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("SOSHP".equals(string)) {
            partAlgo = numIters == 0 ? new SOHashPartition(prevG, session, numParts, ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class)) : new SOHashPartition(prevG, session, numParts, ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class)).setNumIterations(numIters);
            msg = "Start to execute subject-object semantic hash partitioning";
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("PP".equals(string)) {
            partAlgo = numIters == 0 ? new PathPartition(prevG, session, numParts, ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class)) : new PathPartition(prevG, session, numParts, ClassTag$.MODULE$.apply(Node.class), ClassTag$.MODULE$.apply(Node.class)).setNumIterations(numIters);
            msg = "Start to execute path partitioning";
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the input ", " doesn't match any options, no algorithm will be applied."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        LongRef start = LongRef.create((long)0L);
        LongRef end = LongRef.create((long)0L);
        if (partAlgo != null) {
            log.info((Object)msg);
            start.elem = System.currentTimeMillis();
            g = partAlgo.partitionBy().cache();
            SparkExecutionModel$.MODULE$.loadGraph(g);
            end.elem = System.currentTimeMillis();
            log.info((Object)new StringBuilder().append((Object)"Graph partitioning execution time: ").append((Object)BoxesRunTime.boxToLong((long)Duration$.MODULE$.apply(end.elem - start.elem, "millis").toMillis())).append((Object)" ms").toString());
        }
        log.info((Object)"Start to execute queries");
        config.query().foreach((Function1)new Serializable(log, start, end){
            public static final long serialVersionUID = 0L;
            public final Logger log$1;
            public final LongRef start$1;
            public final LongRef end$1;

            public final void apply(String path) {
                this.log$1.info((Object)new StringBuilder().append((Object)"Query file: ").append((Object)path).toString());
                Config$.MODULE$.setInputQueryFile(path);
                SparqlParser sp2 = new SparqlParser(Config$.MODULE$.getInputQueryFile());
                sp2.getOps().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.run.1 $outer;

                    public final void apply(Ops ops) {
                        String tag = ops.getTag();
                        this.$outer.log$1.info((Object)new StringBuilder().append((Object)"Operation ").append((Object)tag).append((Object)" start").toString());
                        this.$outer.start$1.elem = System.currentTimeMillis();
                        ops.execute();
                        this.$outer.end$1.elem = System.currentTimeMillis();
                        this.$outer.log$1.info((Object)new StringBuilder().append((Object)tag).append((Object)" execution time: ").append((Object)BoxesRunTime.boxToLong((long)Duration$.MODULE$.apply(this.$outer.end$1.elem - this.$outer.start$1.elem, "millis").toMillis())).append((Object)" ms").toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.log$1 = log$1;
                this.start$1 = start$1;
                this.end$1 = end$1;
            }
        });
        if (config.print()) {
            log.info((Object)"print final result");
            RDD results = IntermediateResult$.MODULE$.getFinalResult().cache();
            if (results.count() >= 10L) {
                log.info((Object)"Too long results(more than 10)");
            } else {
                Predef$.MODULE$.refArrayOps((Object[])results.collect()).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Result<Node> x$1) {
                        Predef$.MODULE$.println(x$1);
                    }
                });
            }
            results.unpersist(results.unpersist$default$1());
        }
    }

    public OptionParser<GraphQuery.Config> parser() {
        return this.parser;
    }

    private GraphQuery$() {
        MODULE$ = this;
        this.parser = new OptionParser<GraphQuery.Config>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SANSA-Query-Graph-Example"}));
                this.opt('i', "input", Read$.MODULE$.stringRead()).required().valueName("<path>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GraphQuery.Config apply(String x, GraphQuery.Config c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6());
                    }
                }).text("path to file that contains the data (in N-Triples format).");
                this.opt('q', "query", Read$.MODULE$.seqRead(Read$.MODULE$.stringRead())).required().valueName("<query1>, <query2>...").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GraphQuery.Config apply(Seq<String> x, GraphQuery.Config c) {
                        Seq<String> x$3 = x;
                        String x$4 = c.copy$default$1();
                        boolean x$5 = c.copy$default$3();
                        String x$6 = c.copy$default$4();
                        int x$7 = c.copy$default$5();
                        int x$8 = c.copy$default$6();
                        return c.copy(x$4, x$3, x$5, x$6, x$7, x$8);
                    }
                }).text("files that contain SPARQL queries.");
                this.opt('p', "print", Read$.MODULE$.booleanRead()).optional().valueName("Boolean").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GraphQuery.Config apply(boolean x$2, GraphQuery.Config c) {
                        boolean x$9 = true;
                        String x$10 = c.copy$default$1();
                        Seq<String> x$11 = c.copy$default$2();
                        String x$12 = c.copy$default$4();
                        int x$13 = c.copy$default$5();
                        int x$14 = c.copy$default$6();
                        return c.copy(x$10, x$11, x$9, x$12, x$13, x$14);
                    }
                }).text("print the result to the console(maximum 10 rows), default: false.");
                this.opt('a', "algorithm", Read$.MODULE$.stringRead()).optional().valueName("<SSHP | OSHP | SOSHP | PP>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GraphQuery.Config apply(String x, GraphQuery.Config c) {
                        String x$15 = x;
                        String x$16 = c.copy$default$1();
                        Seq<String> x$17 = c.copy$default$2();
                        boolean x$18 = c.copy$default$3();
                        int x$19 = c.copy$default$5();
                        int x$20 = c.copy$default$6();
                        return c.copy(x$16, x$17, x$18, x$15, x$19, x$20);
                    }
                }).text("choose one graph partitioning algorithm, default: no algorithm applied.");
                this.opt('n', "number of partitions", Read$.MODULE$.intRead()).optional().valueName("<Int>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GraphQuery.Config apply(int x, GraphQuery.Config c) {
                        int x$21 = x;
                        String x$22 = c.copy$default$1();
                        Seq<String> x$23 = c.copy$default$2();
                        boolean x$24 = c.copy$default$3();
                        String x$25 = c.copy$default$4();
                        int x$26 = c.copy$default$6();
                        return c.copy(x$22, x$23, x$24, x$25, x$21, x$26);
                    }
                }).text("set the number of partitions.");
                this.opt('t', "number of iterations", Read$.MODULE$.intRead()).optional().valueName("<Int>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GraphQuery.Config apply(int x, GraphQuery.Config c) {
                        int x$27 = x;
                        String x$28 = c.copy$default$1();
                        Seq<String> x$29 = c.copy$default$2();
                        boolean x$30 = c.copy$default$3();
                        String x$31 = c.copy$default$4();
                        int x$32 = c.copy$default$5();
                        return c.copy(x$28, x$29, x$30, x$31, x$32, x$27);
                    }
                }).text("set the number of iterations.");
                this.help("help").text("prints this usage text");
            }
        };
    }
}

