/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.examples.spark.ml.outliers.anomalydetection;

import net.sansa_stack.examples.spark.ml.outliers.anomalydetection.AnomalyDetection;
import net.sansa_stack.examples.spark.ml.outliers.anomalydetection.AnomalyDetection$Config$;
import net.sansa_stack.ml.spark.outliers.anomalydetection.AnomalyWithHashingTF;
import net.sansa_stack.rdf.spark.io.package;
import net.sansa_stack.rdf.spark.io.package$;
import org.apache.jena.riot.Lang;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.storage.StorageLevel$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scopt.OptionParser;
import scopt.Read$;

public final class AnomalyDetection$ {
    public static final AnomalyDetection$ MODULE$;
    private final OptionParser<AnomalyDetection.Config> parser;

    static {
        new AnomalyDetection$();
    }

    public void main(String[] args) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = this.parser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new AnomalyDetection.Config(AnomalyDetection$Config$.MODULE$.apply$default$1(), AnomalyDetection$Config$.MODULE$.apply$default$2(), AnomalyDetection$Config$.MODULE$.apply$default$3(), AnomalyDetection$Config$.MODULE$.apply$default$4(), AnomalyDetection$Config$.MODULE$.apply$default$5()));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    AnomalyDetection.Config config = (AnomalyDetection.Config)some.x();
                    this.run(config.in(), config.threshold(), config.anomalyListLimit(), config.numofpartition(), config.out());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                Predef$.MODULE$.println((Object)this.parser().usage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public void run(String input, double JSimThreshold, int anomalyListLimit, int numofpartition, String output) {
        Predef$.MODULE$.println((Object)"==================================================");
        Predef$.MODULE$.println((Object)"|        Distributed Anomaly Detection           |");
        Predef$.MODULE$.println((Object)"==================================================");
        SparkSession spark = SparkSession$.MODULE$.builder().appName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Anomaly Detection example ( ", " )"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input}))).master("local[*]").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").getOrCreate();
        Lang lang = Lang.NTRIPLES;
        package.RDFReader qual$1 = package$.MODULE$.RDFReader(spark);
        Lang x$21 = lang;
        boolean x$22 = qual$1.rdf$default$2();
        RDD qual$2 = (RDD)qual$1.rdf(x$21, x$22).apply((Object)input);
        int x$23 = numofpartition;
        Ordering x$24 = qual$2.repartition$default$2(x$23);
        RDD triplesRDD = qual$2.repartition(x$23, x$24).persist();
        List wikiList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wikiPageRevisionID,wikiPageID"}));
        List objList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://www.w3.org/2001/XMLSchema#double", "http://www.w3.org/2001/XMLSchema#integer", "http://www.w3.org/2001/XMLSchema#nonNegativeInteger", "http://dbpedia.org/datatype/squareKilometre"}));
        List triplesType = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://dbpedia.org/ontology"}));
        List listSuperType = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://dbpedia.org/ontology/Activity", "http://dbpedia.org/ontology/Organisation", "http://dbpedia.org/ontology/Agent", "http://dbpedia.org/ontology/SportsLeague", "http://dbpedia.org/ontology/Person", "http://dbpedia.org/ontology/Athlete", "http://dbpedia.org/ontology/Event", "http://dbpedia.org/ontology/Place", "http://dbpedia.org/ontology/PopulatedPlace", "http://dbpedia.org/ontology/Region", "http://dbpedia.org/ontology/Species", "http://dbpedia.org/ontology/Eukaryote", "http://dbpedia.org/ontology/Location"}));
        String hypernym = "http://purl.org/linguistics/gold/hypernym";
        RDD clusterOfSubject = null;
        Predef$.MODULE$.println((Object)"AnomalyDetection-using ApproxSimilarityJoin function with the help of HashingTF ");
        AnomalyWithHashingTF outDetection = new AnomalyWithHashingTF(triplesRDD, objList, triplesType, JSimThreshold, listSuperType, spark, hypernym, numofpartition);
        RDD qual$3 = clusterOfSubject = outDetection.run();
        int x$25 = 1000;
        Ordering x$26 = qual$3.repartition$default$2(x$25);
        RDD setData = qual$3.repartition(x$25, x$26).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        RDD setDataStore = setData.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple3<String, String, Object>> apply(Set<Tuple3<String, String, Object>> f) {
                return f.toSeq();
            }
        }, ClassTag$.MODULE$.apply(Seq.class));
        RDD setDataSize = setDataStore.filter((Function1)new Serializable(anomalyListLimit){
            public static final long serialVersionUID = 0L;
            private final int anomalyListLimit$1;

            public final boolean apply(Seq<Tuple3<String, String, Object>> f) {
                return f.size() > this.anomalyListLimit$1;
            }
            {
                this.anomalyListLimit$1 = anomalyListLimit$1;
            }
        });
        RDD test = setDataSize.map((Function1)new Serializable(anomalyListLimit, outDetection){
            public static final long serialVersionUID = 0L;
            private final int anomalyListLimit$1;
            private final AnomalyWithHashingTF outDetection$1;

            public final Seq<Tuple3<String, String, Object>> apply(Seq<Tuple3<String, String, Object>> f) {
                return this.outDetection$1.iqr2(f, this.anomalyListLimit$1);
            }
            {
                this.anomalyListLimit$1 = anomalyListLimit$1;
                this.outDetection$1 = outDetection$1;
            }
        }, ClassTag$.MODULE$.apply(Seq.class));
        RDD testfilter = test.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<Tuple3<String, String, Object>> f) {
                return f.size() > 0;
            }
        });
        RDD testfilterDistinct = testfilter.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple3<String, String, Object>> apply(Seq<Tuple3<String, String, Object>> f) {
                return f;
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        testfilterDistinct.saveAsTextFile(output);
        setData.unpersist(setData.unpersist$default$1());
        spark.stop();
    }

    public OptionParser<AnomalyDetection.Config> parser() {
        return this.parser;
    }

    private AnomalyDetection$() {
        MODULE$ = this;
        this.parser = new OptionParser<AnomalyDetection.Config>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detecting Numerical Outliers in dataset"}));
                this.opt('i', "input", Read$.MODULE$.stringRead()).required().valueName("<path>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AnomalyDetection.Config apply(String x, AnomalyDetection.Config c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5());
                    }
                }).text("path to file that contains RDF data (in N-Triples format)");
                this.opt('t', "threshold", Read$.MODULE$.doubleRead()).required().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AnomalyDetection.Config apply(double x, AnomalyDetection.Config c) {
                        double x$1 = x;
                        String x$2 = c.copy$default$1();
                        int x$3 = c.copy$default$3();
                        int x$4 = c.copy$default$4();
                        String x$5 = c.copy$default$5();
                        return c.copy(x$2, x$1, x$3, x$4, x$5);
                    }
                }).text("the Jaccard Similarity value");
                this.opt('a', "numofpartition", Read$.MODULE$.intRead()).required().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AnomalyDetection.Config apply(int x, AnomalyDetection.Config c) {
                        int x$6 = x;
                        String x$7 = c.copy$default$1();
                        double x$8 = c.copy$default$2();
                        int x$9 = c.copy$default$3();
                        String x$10 = c.copy$default$5();
                        return c.copy(x$7, x$8, x$9, x$6, x$10);
                    }
                }).text("Number of partition");
                this.opt('c', "anomalyListLimit", Read$.MODULE$.intRead()).required().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AnomalyDetection.Config apply(int x, AnomalyDetection.Config c) {
                        int x$11 = x;
                        String x$12 = c.copy$default$1();
                        double x$13 = c.copy$default$2();
                        int x$14 = c.copy$default$4();
                        String x$15 = c.copy$default$5();
                        return c.copy(x$12, x$13, x$11, x$14, x$15);
                    }
                }).text("the outlier List Limit");
                this.opt('o', "output", Read$.MODULE$.stringRead()).required().valueName("<directory>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AnomalyDetection.Config apply(String x, AnomalyDetection.Config c) {
                        String x$16 = x;
                        String x$17 = c.copy$default$1();
                        double x$18 = c.copy$default$2();
                        int x$19 = c.copy$default$3();
                        int x$20 = c.copy$default$4();
                        return c.copy(x$17, x$18, x$19, x$20, x$16);
                    }
                }).text("the output directory");
                this.help("help").text("prints this usage text");
            }
        };
    }
}

