/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.datalake.spark;

import com.google.common.collect.ArrayListMultimap;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import net.sansa_stack.datalake.spark.QueryAnalyser$;
import net.sansa_stack.datalake.spark.utils.Helpers$;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.ElementWalker;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.MultiMap;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\u0001-\u0011Q\"U;fef\fe.\u00197zg\u0016\u0014(BA\u0002\u0005\u0003\u0015\u0019\b/\u0019:l\u0015\t)a!\u0001\u0005eCR\fG.Y6f\u0015\t9\u0001\"A\u0006tC:\u001c\u0018mX:uC\u000e\\'\"A\u0005\u0002\u00079,Go\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0003\u0005\u0014\u0001\t\u0005\t\u0015!\u0003\u0015\u0003\u0015\tX/\u001a:z!\t)\u0002D\u0004\u0002\u000e-%\u0011qCD\u0001\u0007!J,G-\u001a4\n\u0005eQ\"AB*ue&twM\u0003\u0002\u0018\u001d!)A\u0004\u0001C\u0001;\u00051A(\u001b8jiz\"\"A\b\u0011\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000bMY\u0002\u0019\u0001\u000b\t\u000f\t\u0002!\u0019!C\u0001G\u00051An\\4hKJ,\u0012\u0001\n\t\u0003K1j\u0011A\n\u0006\u0003O!\nAb]2bY\u0006dwnZ4j]\u001eT!!\u000b\u0016\u0002\u0011QL\b/Z:bM\u0016T\u0011aK\u0001\u0004G>l\u0017BA\u0017'\u0005\u0019aunZ4fe\"1q\u0006\u0001Q\u0001\n\u0011\nq\u0001\\8hO\u0016\u0014\b\u0005C\u00032\u0001\u0011\u0005!'A\u0006hKR\u0004&/\u001a4jq\u0016\u001cX#A\u001a\u0011\tU!D\u0003F\u0005\u0003ki\u00111!T1q\u0011\u00159\u0004\u0001\"\u00019\u0003)9W\r\u001e)s_*,7\r^\u000b\u0002sA!QB\u000f\u001fE\u0013\tYdB\u0001\u0004UkBdWM\r\t\u0004{\t#R\"\u0001 \u000b\u0005}\u0002\u0015\u0001B;uS2T\u0011!Q\u0001\u0005U\u00064\u0018-\u0003\u0002D}\t!A*[:u!\tiQ)\u0003\u0002G\u001d\t9!i\\8mK\u0006t\u0007\"\u0002%\u0001\t\u0003I\u0015AC4fi\u001aKG\u000e^3sgV\t!\n\u0005\u0003L%R!V\"\u0001'\u000b\u00055s\u0015aB2pY2,7\r\u001e\u0006\u0003\u001fB\u000baaY8n[>t'BA)+\u0003\u00199wn\\4mK&\u00111\u000b\u0014\u0002\u0012\u0003J\u0014\u0018-\u001f'jgRlU\u000f\u001c;j[\u0006\u0004\b\u0003B\u0007;)QAQA\u0016\u0001\u0005\u0002]\u000b!bZ3u\u001fJ$WM\u001d\"z+\u0005A\u0006cA-_)6\t!L\u0003\u0002\\9\u00069Q.\u001e;bE2,'BA/\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003?j\u00131aU3u\u0011\u0015\t\u0007\u0001\"\u0001c\u0003)9W\r^$s_V\u0004()\u001f\u000b\u0004G\u001eT\u0007\u0003B\u0007;Ib\u00032!W3\u0015\u0013\t1'L\u0001\u0006MSN$()\u001e4gKJDQ\u0001\u001b1A\u0002%\fQC^1sS\u0006\u0014G.\u001a)sK\u0012L7-\u0019;f'R\f'\u000f\u0005\u0003\u0016iQ!\u0006\"B6a\u0001\u0004\u0019\u0014\u0001\u00039sK\u001aL\u00070Z:\t\u000b5\u0004A\u0011\u00018\u0002\u0011\u001d,Go\u0015;beN,\u0012a\u001c\t\u0005\u001bi\u0002\u0018PE\u0002rgZ4AA\u001d\u0001\u0001a\naAH]3gS:,W.\u001a8u}A!\u0011\f\u001e\u000bY\u0013\t)(LA\u0004ICNDW*\u00199\u0011\te;H\u0003V\u0005\u0003qj\u0013\u0001\"T;mi&l\u0015\r\u001d\t\u00053R$F\u0003C\u0003|\u0001\u0011\u0005A0\u0001\nhKR$&/\u00198tM>\u0014X.\u0019;j_:\u001cHcA?\u0002\nA)QB\u000f@\u0002\bA!Q\u0003\u000e\u000b\u0000!\u0015i!\bFA\u0001!\u0011i\u00111\u0001\u000b\n\u0007\u0005\u0015aBA\u0003BeJ\f\u0017\u0010E\u0003\u0016iQ\t\t\u0001\u0003\u0004\u0002\fi\u0004\r\u0001F\u0001\u0006iJ\fgn\u001d\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0003!A\u0017m\u001d'j[&$X#\u0001#\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018\u0005Aq-\u001a;MS6LG/\u0006\u0002\u0002\u001aA\u0019Q\"a\u0007\n\u0007\u0005uaBA\u0002J]R\u0004")
public class QueryAnalyser {
    private final String query;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> getPrefixes() {
        void var3_3;
        BoxedUnit boxedUnit;
        Query q = QueryFactory.create((String)this.query);
        java.util.Map prolog = q.getPrologue().getPrefixMapping().getNsPrefixMap();
        Map<String, String> prefix = Helpers$.MODULE$.invertMap(prolog);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"\n- Prefixes: ").append(prefix).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public Tuple2<java.util.List<String>, Object> getProject() {
        BoxedUnit boxedUnit;
        Query q = QueryFactory.create((String)this.query);
        java.util.List project = q.getResultVars();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("\n- Projected vars: {}", new Object[]{project});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Tuple2((Object)project, (Object)BoxesRunTime.boxToBoolean((boolean)q.isDistinct()));
    }

    /*
     * WARNING - void declaration
     */
    public ArrayListMultimap<String, Tuple2<String, String>> getFilters() {
        void var2_2;
        Query q = QueryFactory.create((String)this.query);
        ArrayListMultimap filters = ArrayListMultimap.create();
        ElementWalker.walk((Element)q.getQueryPattern(), (ElementVisitor)new ElementVisitorBase(this, filters){
            private final /* synthetic */ QueryAnalyser $outer;
            private final ArrayListMultimap filters$1;

            public void visit(ElementFilter ef) {
                BoxedUnit boxedUnit;
                String[] bits = ef.getExpr().toString().replace("(", "").replace(")", "").split(" ", 3);
                String operation = bits[1];
                String leftOperand = bits[0];
                String rightOperand = bits[2];
                if (this.$outer.logger().underlying().isInfoEnabled()) {
                    this.$outer.logger().underlying().info("Filter: {},({},{})", new Object[]{operation, leftOperand, rightOperand});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.filters$1.put((Object)operation, (Object)new Tuple2((Object)leftOperand, (Object)rightOperand));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.filters$1 = filters$1;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Tuple2<String, String>> getOrderBy() {
        void var2_2;
        Query q = QueryFactory.create((String)this.query);
        Set orderBys = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (q.hasOrderBy()) {
            for (SortCondition it : q.getOrderBy()) {
                orderBys.$plus$eq((Object)new Tuple2((Object)((Object)BoxesRunTime.boxToInteger((int)it.direction)).toString(), (Object)it.expression.toString()));
            }
        } else {
            orderBys = null;
        }
        return var2_2;
    }

    public Tuple2<ListBuffer<String>, Set<Tuple2<String, String>>> getGroupBy(Map<String, Tuple2<String, String>> variablePredicateStar, Map<String, String> prefixes) {
        Tuple2 tuple2;
        Query q = QueryFactory.create((String)this.query);
        ListBuffer groupByCols = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef aggregationFunctions = ObjectRef.create((Object)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
        if (q.hasGroupBy()) {
            BoxedUnit boxedUnit;
            List groupByVars = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(q.getGroupBy().getVars()).asScala()).toList();
            groupByVars.foreach((Function1)new Serializable(this, variablePredicateStar, prefixes, groupByCols){
                public static final long serialVersionUID = 0L;
                private final Map variablePredicateStar$1;
                private final Map prefixes$1;
                private final ListBuffer groupByCols$1;

                public final boolean apply(Var gbv) {
                    String str = (String)((Tuple2)this.variablePredicateStar$1.apply((Object)gbv.toString()))._1();
                    String vr = (String)((Tuple2)this.variablePredicateStar$1.apply((Object)gbv.toString()))._2();
                    Tuple2<String, String> ns_p = Helpers$.MODULE$.get_NS_predicate(vr);
                    String column = new StringBuilder().append((Object)Helpers$.MODULE$.omitQuestionMark(str)).append((Object)"_").append(ns_p._2()).append((Object)"_").append(this.prefixes$1.apply(ns_p._1())).toString();
                    return ((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)this.groupByCols$1).asJava()).add(column);
                }
                {
                    this.variablePredicateStar$1 = variablePredicateStar$1;
                    this.prefixes$1 = prefixes$1;
                    this.groupByCols$1 = groupByCols$1;
                }
            });
            Buffer agg = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(q.getAggregators()).asScala();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder().append((Object)"agg: ").append((Object)agg).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            agg.foreach((Function1)new Serializable(this, variablePredicateStar, prefixes, aggregationFunctions){
                public static final long serialVersionUID = 0L;
                private final Map variablePredicateStar$1;
                private final Map prefixes$1;
                private final ObjectRef aggregationFunctions$1;

                public final Set<Tuple2<String, String>> apply(ExprAggregator ag) {
                    String[] bits = ag.getAggregator().toPrefixString().split(" ");
                    String aggCol = new StringBuilder().append((Object)"?").append((Object)((String)new StringOps(Predef$.MODULE$.augmentString(bits[1])).dropRight(1)).substring(1)).toString();
                    String str = (String)((Tuple2)this.variablePredicateStar$1.apply((Object)aggCol))._1();
                    String vr = (String)((Tuple2)this.variablePredicateStar$1.apply((Object)aggCol))._2();
                    Tuple2<String, String> ns_p = Helpers$.MODULE$.get_NS_predicate(vr);
                    String column = new StringBuilder().append((Object)Helpers$.MODULE$.omitQuestionMark(str)).append((Object)"_").append(ns_p._2()).append((Object)"_").append(this.prefixes$1.apply(ns_p._1())).toString();
                    return (Set)((Set)this.aggregationFunctions$1.elem).$plus$eq((Object)new Tuple2((Object)column, (Object)bits[0].substring(1)));
                }
                {
                    this.variablePredicateStar$1 = variablePredicateStar$1;
                    this.prefixes$1 = prefixes$1;
                    this.aggregationFunctions$1 = aggregationFunctions$1;
                }
            });
            tuple2 = new Tuple2((Object)groupByCols, (Object)((Set)aggregationFunctions.elem));
        } else {
            tuple2 = null;
        }
        return tuple2;
    }

    public Tuple2<HashMap<String, Set<Tuple2<String, String>>>, HashMap<Tuple2<String, String>, String>> getStars() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Query q = QueryFactory.create((String)this.query);
        String originalBGP = q.getQueryPattern().toString();
        String bgp = originalBGP.replaceAll("\n", "").replaceAll("\\s+", " ").replace("{", " ").replace("}", " ");
        String[] triples = bgp.split("\\.(?![^\\<\\[]*[\\]\\>])");
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"\n- The BGP of the input query:  ").append((Object)originalBGP).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"\n- Number of triple-stars detected: ").append((Object)BoxesRunTime.boxToInteger((int)triples.length)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MultiMap<String, Tuple2<String, String>> stars = new MultiMap<String, Tuple2<String, String>>(this){

            public Set<Tuple2<String, String>> makeSet() {
                return MultiMap.class.makeSet((MultiMap)this);
            }

            public MultiMap addBinding(Object key, Object value) {
                return MultiMap.class.addBinding((MultiMap)this, (Object)key, (Object)value);
            }

            public MultiMap removeBinding(Object key, Object value) {
                return MultiMap.class.removeBinding((MultiMap)this, (Object)key, (Object)value);
            }

            public boolean entryExists(Object key, Function1 p) {
                return MultiMap.class.entryExists((MultiMap)this, (Object)key, (Function1)p);
            }
            {
                MultiMap.class.$init$((MultiMap)this);
            }
        };
        HashMap star_pred_var = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])triples).indices().foreach((Function1)new Serializable(this, triples, (HashMap)stars, star_pred_var){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryAnalyser $outer;
            private final String[] triples$1;
            public final HashMap stars$1;
            public final HashMap star_pred_var$1;

            public final Object apply(int i) {
                Option option;
                BoxedUnit boxedUnit;
                String triple = this.triples$1[i].trim();
                if (this.$outer.logger().underlying().isInfoEnabled()) {
                    this.$outer.logger().underlying().info("Triple: {}", new Object[]{triple});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (new StringOps(Predef$.MODULE$.augmentString(triple)).contains((Object)BoxesRunTime.boxToCharacter((char)';'))) {
                    String[] triples = triple.split(";");
                    String firsTriple = triples[0];
                    String[] firsTripleBits = firsTriple.split(" ");
                    String sbj = firsTripleBits[0];
                    ((MultiMap)this.stars$1).addBinding((Object)sbj, (Object)new Tuple2((Object)firsTripleBits[1], (Object)firsTripleBits[2]));
                    this.star_pred_var$1.put((Object)new Tuple2((Object)sbj, (Object)firsTripleBits[1]), (Object)firsTripleBits[2]);
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), triples.length).foreach((Function1)new Serializable(this, triples, sbj){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$getStars$1 $outer;
                        private final String[] triples$2;
                        private final String sbj$1;

                        public final Option<String> apply(int i) {
                            String[] t = this.triples$2[i].trim().split(" ");
                            ((MultiMap)this.$outer.stars$1).addBinding((Object)this.sbj$1, (Object)new Tuple2((Object)t[0], (Object)t[1]));
                            return this.$outer.star_pred_var$1.put((Object)new Tuple2((Object)this.sbj$1, (Object)t[0]), (Object)t[1]);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.triples$2 = triples$2;
                            this.sbj$1 = sbj$1;
                        }
                    });
                    option = BoxedUnit.UNIT;
                } else {
                    String[] tripleBits = triple.split(" ");
                    ((MultiMap)this.stars$1).addBinding((Object)tripleBits[0], (Object)new Tuple2((Object)tripleBits[1], (Object)tripleBits[2]));
                    option = this.star_pred_var$1.put((Object)new Tuple2((Object)tripleBits[0], (Object)tripleBits[1]), (Object)tripleBits[2]);
                }
                return option;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.triples$1 = triples$1;
                this.stars$1 = stars$1;
                this.star_pred_var$1 = star_pred_var$1;
            }
        });
        return new Tuple2((Object)stars, (Object)star_pred_var);
    }

    public Tuple2<Map<String, Tuple2<String, String[]>>, Map<String, String[]>> getTransformations(String trans) {
        String[] transformations = trans.trim().substring(1).split("&&");
        ObjectRef transmap_left = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        ObjectRef transmap_right = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        Predef$.MODULE$.refArrayOps((Object[])transformations).foreach((Function1)new Serializable(this, transmap_left, transmap_right){
            public static final long serialVersionUID = 0L;
            private final ObjectRef transmap_left$1;
            private final ObjectRef transmap_right$1;

            public final void apply(String t) {
                String[] tbits = t.trim().split("\\.", 2);
                String[] vars = tbits[0].substring(1).split("\\?");
                String operation = tbits[1];
                String[] temp = operation.split("\\.", 2);
                String lORr = temp[0];
                String[] functions = temp[1].split("\\.");
                String string = lORr;
                String string2 = "l";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.transmap_left$1.elem = ((Map)this.transmap_left$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)vars[0]), (Object)new Tuple2((Object)vars[1], (Object)functions)));
                } else {
                    this.transmap_right$1.elem = ((Map)this.transmap_right$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)vars[1]), (Object)functions));
                }
            }
            {
                this.transmap_left$1 = transmap_left$1;
                this.transmap_right$1 = transmap_right$1;
            }
        });
        return new Tuple2((Object)((Map)transmap_left.elem), (Object)((Map)transmap_right.elem));
    }

    public boolean hasLimit() {
        return QueryFactory.create((String)this.query).hasLimit();
    }

    public int getLimit() {
        return (int)QueryFactory.create((String)this.query).getLimit();
    }

    public QueryAnalyser(String query2) {
        this.query = query2;
        this.logger = Logger$.MODULE$.apply("SANSA-DataLake");
    }
}

