/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.datalake.spark;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sansa_stack.datalake.spark.model.Triple;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Tuple2;

public class NTtoDF
implements Serializable {
    private String className;

    public NTtoDF options(Map<String, String> options) {
        this.className = options.get("class");
        return this;
    }

    public Dataset<Row> read(String input_path, SparkSession spark) {
        try {
            JavaRDD lines = spark.read().textFile(input_path).toJavaRDD();
            JavaRDD triples = lines.map((Function & Serializable)line -> {
                Triple triple;
                ArrayList<String> parts = new ArrayList<String>();
                Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher((CharSequence)line);
                while (m.find()) {
                    parts.add(m.group(1));
                }
                if (((String)parts.get(1)).equals("<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>")) {
                    triple = new Triple(this.replaceInValue(this.removeTagSymbol((String)parts.get(0))), null, this.replaceInValue(this.removeTagSymbol((String)parts.get(2))));
                } else {
                    String subject = this.replaceInValue(this.removeTagSymbol((String)parts.get(0)));
                    String property = this.replaceInColumn(this.removeTagSymbol((String)parts.get(1)));
                    String object = this.replaceInValue(this.removeTagSymbol((String)parts.get(2)));
                    String type = this.replaceInValue(this.removeTagSymbol((String)parts.get(3)));
                    String objectAndType = parts.size() == 5 ? object + type : object;
                    objectAndType = this.reverse(objectAndType);
                    triple = new Triple(subject, property, objectAndType);
                }
                return triple;
            });
            JavaPairRDD subject_property = triples.mapToPair((PairFunction & Serializable)trpl -> new Tuple2((Object)trpl.getSubject(), (Object)new Tuple2((Object)trpl.getProperty(), trpl.getObject())));
            JavaPairRDD groupBySubject = subject_property.groupByKey();
            JavaPairRDD type_s_po = groupBySubject.mapToPair((PairFunction & Serializable)list -> {
                ArrayList<Tuple2> p_o = new ArrayList<Tuple2>();
                ArrayList<String> types = new ArrayList<String>();
                String subject = (String)list._1();
                Iterator iterator = ((Iterable)list._2()).iterator();
                while (iterator.hasNext()) {
                    Tuple2 stringStringTuple2;
                    Tuple2 tt = stringStringTuple2 = (Tuple2)iterator.next();
                    String property = (String)tt._1();
                    String object = (String)tt._2();
                    if (property == null) {
                        p_o.add(new Tuple2((Object)("type_" + object), (Object)"1"));
                        types.add(object);
                        continue;
                    }
                    Tuple2 t2 = new Tuple2((Object)property, (Object)object);
                    p_o.add(t2);
                }
                Collections.sort(types);
                String chosen_type = (String)types.get(types.size() - 1);
                p_o.remove(new Tuple2((Object)("type_" + chosen_type), (Object)"1"));
                Tuple2 s_po = new Tuple2((Object)subject, p_o);
                return new Tuple2((Object)chosen_type, (Object)s_po);
            });
            JavaPairRDD groupByType = type_s_po.groupByKey();
            List keys = groupByType.keys().distinct().collect();
            System.out.println("Types found: " + keys);
            JavaRDD rddByKey = this.getRddByKey((JavaPairRDD<String, Iterable<Tuple2<String, Iterable<Tuple2<String, String>>>>>)groupByType, this.className);
            JavaRDD cols = rddByKey.flatMap((FlatMapFunction & Serializable)i -> {
                LinkedHashMap<String, String> po = new LinkedHashMap<String, String>();
                for (Tuple2 temp : (Iterable)i._2) {
                    String property = (String)temp._1();
                    String object = this.reverse((String)temp._2());
                    if (object.contains("XMLSchema#double")) {
                        if (!po.containsKey(property + "--TD") && !po.containsKey(property + "--TAD")) {
                            property = property + "--TD";
                        } else if (!po.containsKey(property + "--TAD")) {
                            po.remove(property + "--TD");
                            property = property + "--TAD";
                        }
                    } else if (object.contains("XMLSchema#int")) {
                        if (po.containsKey(property = property + "--TI")) {
                            property = property.replace("--TI", "--TAI");
                        }
                    } else if (object.contains("XMLSchema#boolean")) {
                        property = property + "--TB";
                    } else if (object.contains("XMLSchema#dateTime")) {
                        property = property + "--TTS";
                    }
                    if (po.containsKey(property) && !po.containsKey(property + "**")) {
                        po.remove(property);
                        property = property + "**";
                    } else if (po.containsKey(property + "**")) {
                        property = property + "**";
                    }
                    po.put(property, "");
                }
                po.put("id", "");
                return po.keySet().iterator();
            });
            LinkedHashMap<String, String> type_columns = new LinkedHashMap<String, String>();
            List readColumns = cols.distinct().collect();
            for (String j : readColumns) {
                type_columns.put(j, "");
            }
            ArrayList<StructField> table_columns = new ArrayList<StructField>();
            HashMap toSaveToDB = new HashMap();
            for (String s : readColumns) {
                String col;
                if (s.contains("--TD")) {
                    if (readColumns.contains(s.split("--")[0] + "--TAD")) continue;
                    col = s.split("--")[0];
                    table_columns.add(DataTypes.createStructField((String)col, (DataType)DataTypes.DoubleType, (boolean)true));
                    continue;
                }
                if (s.contains("--TI")) {
                    col = s.split("--")[0];
                    table_columns.add(DataTypes.createStructField((String)col, (DataType)DataTypes.IntegerType, (boolean)true));
                    continue;
                }
                if (s.contains("--TB")) {
                    col = s.split("--")[0];
                    table_columns.add(DataTypes.createStructField((String)col, (DataType)DataTypes.BooleanType, (boolean)true));
                    continue;
                }
                if (s.contains("--TTS")) {
                    col = s.split("--")[0];
                    table_columns.add(DataTypes.createStructField((String)col, (DataType)DataTypes.TimestampType, (boolean)true));
                    continue;
                }
                if (s.contains("--TAD")) {
                    col = s.split("--")[0];
                    table_columns.add(DataTypes.createStructField((String)col, (DataType)DataTypes.createArrayType((DataType)DataTypes.DoubleType, (boolean)true), (boolean)true));
                    continue;
                }
                if (s.contains("--TAI")) {
                    col = s.split("--")[0];
                    table_columns.add(DataTypes.createStructField((String)col, (DataType)DataTypes.createArrayType((DataType)DataTypes.IntegerType, (boolean)true), (boolean)true));
                    continue;
                }
                if (s.contains("**")) {
                    col = s.replace("**", "");
                    table_columns.add(DataTypes.createStructField((String)col, (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType, (boolean)true), (boolean)true));
                    continue;
                }
                table_columns.add(DataTypes.createStructField((String)s, (DataType)DataTypes.StringType, (boolean)true));
            }
            StructType schema = DataTypes.createStructType(table_columns);
            JavaRDD returnValues = rddByKey.map((Function & Serializable)i -> {
                LinkedHashMap<Object, Object> po = new LinkedHashMap<Object, Object>();
                for (Object j : readColumns) {
                    if (((String)j).contains("--TI")) {
                        po.put(((String)j).replace("--TI", ""), null);
                        continue;
                    }
                    if (((String)j).contains("--TD") && !readColumns.contains((String)j + "--TAD")) {
                        po.put(((String)j).replace("--TD", ""), null);
                        continue;
                    }
                    if (((String)j).contains("--TB")) {
                        po.put(((String)j).replace("--TB", ""), null);
                        continue;
                    }
                    if (((String)j).contains("--TTS")) {
                        po.put(((String)j).replace("--TTS", ""), null);
                        continue;
                    }
                    if (((String)j).contains("--TAI")) {
                        po.put(((String)j).replace("--TAI", ""), null);
                        continue;
                    }
                    if (((String)j).contains("--TAD")) {
                        po.put(((String)j).replace("--TAD", ""), null);
                        continue;
                    }
                    if (((String)j).contains("**")) {
                        po.put(((String)j).replace("**", ""), null);
                        continue;
                    }
                    po.put(j, null);
                }
                String subject = (String)i._1;
                for (Tuple2 temp : (Iterable)i._2) {
                    ArrayList arr;
                    String property = (String)temp._1();
                    String object = this.reverse((String)temp._2());
                    Object newobject = null;
                    if (readColumns.contains(property + "--TD") && !readColumns.contains(property + "--TAD")) {
                        newobject = Double.parseDouble(object.replace("^^www.w3.org/2001/XMLSchema#double", "").replace("\"", ""));
                        po.put(property, newobject);
                        continue;
                    }
                    if (readColumns.contains(property + "--TI")) {
                        newobject = Integer.parseInt(object.replace("^^www.w3.org/2001/XMLSchema#integer", "").replace("^^www.w3.org/2001/XMLSchema#int", "").replace("\"", ""));
                        po.put(property, newobject);
                        continue;
                    }
                    if (readColumns.contains(property + "--TB")) {
                        newobject = Boolean.parseBoolean(object.replace("^^www.w3.org/2001/XMLSchema#boolean", "").replace("\"", ""));
                        po.put(property, newobject);
                        continue;
                    }
                    if (readColumns.contains(property + "--TTS")) {
                        newobject = Timestamp.valueOf(object.replace("^^www.w3.org/2001/XMLSchema#dateTime", "").replace("\"", "").replace("T", " "));
                        po.put(property, newobject);
                        continue;
                    }
                    if (readColumns.contains(property + "--TAD")) {
                        newobject = Double.parseDouble(object.replace("^^www.w3.org/2001/XMLSchema#double", "").replace("\"", ""));
                        if (po.get(property) != null) {
                            arr = (ArrayList)po.get(property);
                            arr.add(newobject);
                        } else {
                            arr = new ArrayList();
                            arr.add(newobject);
                        }
                        po.put(property, arr);
                        continue;
                    }
                    if (readColumns.contains(property + "--TAI")) {
                        arr = new ArrayList();
                        if (po.containsKey(property)) {
                            arr = (ArrayList)po.get(property);
                            arr.add((Integer)newobject);
                        } else {
                            arr.add((Integer)newobject);
                        }
                        po.put(property, arr);
                        continue;
                    }
                    if (readColumns.contains(property + "**")) {
                        String[] arr2;
                        newobject = object.replace("**", "").replace("\"", "");
                        if (po.get(property) != null) {
                            arr2 = (String[])po.get(property);
                            ArrayList<String> temparr = new ArrayList<String>(Arrays.asList(arr2));
                            temparr.add((String)newobject);
                            arr2 = temparr.toArray(new String[0]);
                        } else {
                            arr2 = new String[]{(String)newobject};
                        }
                        po.put(property, arr2);
                        continue;
                    }
                    po.put(property, object);
                }
                po.put("id", subject);
                ArrayList vals = new ArrayList(po.values());
                Row values_list = RowFactory.create((Object[])vals.toArray());
                return values_list;
            });
            Dataset typeDataFrame = spark.createDataFrame(returnValues, schema);
            return typeDataFrame;
        }
        catch (Exception ex) {
            System.out.println("SOMETHING WENT WRONG..." + ex.getMessage());
            spark.close();
            return null;
        }
    }

    private String reverse(String string) {
        return new StringBuffer(string).reverse().toString();
    }

    private JavaRDD getRddByKey(JavaPairRDD<String, Iterable<Tuple2<String, Iterable<Tuple2<String, String>>>>> pairRdd, String key) {
        JavaPairRDD a = pairRdd.filter((Function & Serializable)v -> ((String)v._1()).equals(key));
        return a.values().flatMap((FlatMapFunction & Serializable)tuples -> tuples.iterator());
    }

    private String removeTagSymbol(String string) {
        return string.replace("<", "").replace(">", "");
    }

    private String replaceInValue(String str) {
        return str.replace("http://", "");
    }

    private String replaceInType(String str) {
        return str.replace("/", "__").replace("-", "@");
    }

    private String replaceInColumn(String str) {
        return str.replace("http://", "");
    }
}

