/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.schematic4j.utils;

import java.util.Optional;
import net.querz.nbt.tag.ArrayTag;
import net.querz.nbt.tag.ByteArrayTag;
import net.querz.nbt.tag.ByteTag;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.DoubleTag;
import net.querz.nbt.tag.FloatTag;
import net.querz.nbt.tag.IntArrayTag;
import net.querz.nbt.tag.IntTag;
import net.querz.nbt.tag.ListTag;
import net.querz.nbt.tag.LongArrayTag;
import net.querz.nbt.tag.LongTag;
import net.querz.nbt.tag.NumberTag;
import net.querz.nbt.tag.ShortTag;
import net.querz.nbt.tag.StringTag;
import net.querz.nbt.tag.Tag;
import net.sandrohc.schematic4j.exception.MissingFieldException;

public class TagUtils {
    public static Optional<Integer> getInt(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getIntTag(key)).map(NumberTag::asInt);
    }

    public static Optional<Short> getShort(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getShortTag(key)).map(NumberTag::asShort);
    }

    public static Optional<Byte> getByte(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getByteTag(key)).map(NumberTag::asByte);
    }

    public static Optional<Long> getLong(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getLongTag(key)).map(NumberTag::asLong);
    }

    public static Optional<Float> getFloat(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getFloatTag(key)).map(NumberTag::asFloat);
    }

    public static Optional<Double> getDouble(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getDoubleTag(key)).map(NumberTag::asDouble);
    }

    public static Optional<int[]> getIntArray(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getIntArrayTag(key)).map(ArrayTag::getValue);
    }

    public static Optional<byte[]> getByteArray(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getByteArrayTag(key)).map(ArrayTag::getValue);
    }

    public static Optional<long[]> getLongArray(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getLongArrayTag(key)).map(ArrayTag::getValue);
    }

    public static Optional<ListTag<FloatTag>> getFloatList(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getListTag(key)).map(ListTag::asFloatTagList);
    }

    public static Optional<ListTag<DoubleTag>> getDoubleList(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getListTag(key)).map(ListTag::asDoubleTagList);
    }

    public static Optional<ListTag<CompoundTag>> getCompoundList(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getListTag(key)).map(ListTag::asCompoundTagList);
    }

    public static Optional<String> getString(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getStringTag(key)).map(StringTag::getValue);
    }

    public static Optional<CompoundTag> getCompound(CompoundTag tag, String key) {
        return Optional.ofNullable(tag.getCompoundTag(key));
    }

    public static int getIntOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getInt(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, IntTag.class));
    }

    public static short getShortOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getShort(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, ShortTag.class));
    }

    public static byte getByteOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getByte(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, ByteTag.class));
    }

    public static long getLongOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getLong(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, LongTag.class));
    }

    public static float getFloatOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getFloat(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, FloatTag.class)).floatValue();
    }

    public static double getDoubleOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getDouble(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, DoubleTag.class));
    }

    public static int[] getIntArrayOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getIntArray(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, IntArrayTag.class));
    }

    public static byte[] getByteArrayOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getByteArray(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, ByteArrayTag.class));
    }

    public static long[] getLongArrayOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getLongArray(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, LongArrayTag.class));
    }

    public static ListTag<FloatTag> getFloatListOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getFloatList(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, ListTag.class));
    }

    public static ListTag<DoubleTag> getDoubleListOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getDoubleList(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, ListTag.class));
    }

    public static ListTag<CompoundTag> getCompoundListOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getCompoundList(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, ListTag.class));
    }

    public static String getStringOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getString(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, StringTag.class));
    }

    public static CompoundTag getCompoundOrThrow(CompoundTag tag, String key) throws MissingFieldException {
        return TagUtils.getCompound(tag, key).orElseThrow(() -> new MissingFieldException((Tag<?>)tag, key, CompoundTag.class));
    }
}

