/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.schematic4j.schematic;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.sandrohc.schematic4j.SchematicFormat;
import net.sandrohc.schematic4j.exception.SchematicBuilderException;
import net.sandrohc.schematic4j.schematic.Schematic;
import net.sandrohc.schematic4j.schematic.types.SchematicBiome;
import net.sandrohc.schematic4j.schematic.types.SchematicBlock;
import net.sandrohc.schematic4j.schematic.types.SchematicBlockEntity;
import net.sandrohc.schematic4j.schematic.types.SchematicEntity;
import net.sandrohc.schematic4j.utils.BiomeIterator;
import net.sandrohc.schematic4j.utils.BiomeIteratorImpl;
import net.sandrohc.schematic4j.utils.BlockIterator;
import net.sandrohc.schematic4j.utils.BlockIteratorImpl;

public class SchematicSponge
implements Schematic {
    private static final int[] DEFAULT_OFFSET = new int[]{0, 0, 0};
    private final int version;
    private final int dataVersion;
    private final Metadata metadata;
    private final int width;
    private final int height;
    private final int length;
    private final int[] offset;
    private final SchematicBlock[][][] blocks;
    private final Collection<SchematicBlockEntity> blockEntities;
    private final Collection<SchematicEntity> entities;
    private final SchematicBiome[][] biomes;

    public SchematicSponge(int version, int dataVersion, Metadata metadata, int width, int height, int length, int[] offset, SchematicBlock[][][] blocks, Collection<SchematicBlockEntity> blockEntities, Collection<SchematicEntity> entities, SchematicBiome[][] biomes) {
        this.version = version;
        this.dataVersion = dataVersion;
        this.metadata = metadata != null ? metadata : new Metadata(null, null, null, new String[0], Collections.emptyMap());
        this.width = width;
        this.height = height;
        this.length = length;
        this.offset = offset != null ? offset : DEFAULT_OFFSET;
        this.blocks = blocks;
        this.blockEntities = Collections.unmodifiableCollection(blockEntities);
        this.entities = Collections.unmodifiableCollection(entities);
        this.biomes = biomes;
    }

    @Override
    public SchematicFormat getFormat() {
        return this.version == 1 ? SchematicFormat.SPONGE_V1 : SchematicFormat.SPONGE_V2;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int[] getOffset() {
        return this.offset;
    }

    @Override
    public SchematicBlock getBlock(int x, int y, int z) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height || z < 0 || z >= this.length) {
            throw new ArrayIndexOutOfBoundsException("invalid position");
        }
        return this.blocks[x][y][z];
    }

    @Override
    public BlockIterator getBlocks() {
        return new BlockIteratorImpl<SchematicBlock[][][]>(this.blocks, this.blocks.length, this.blocks[0].length, this.blocks[0][0].length){

            @Override
            public SchematicBlock next() {
                this.z = this.i % this.length;
                this.y = this.i / this.length % this.height;
                this.x = this.i / (this.height * this.length);
                ++this.i;
                return ((SchematicBlock[][][])this.blocks)[this.x][this.y][this.z];
            }
        };
    }

    @Override
    public Collection<SchematicBlockEntity> getBlockEntities() {
        return this.blockEntities;
    }

    @Override
    public Collection<SchematicEntity> getEntities() {
        return this.entities;
    }

    @Override
    public SchematicBiome getBiome(int x, int z) {
        if (x < 0 || x >= this.width || z < 0 || z >= this.length) {
            throw new ArrayIndexOutOfBoundsException("invalid position");
        }
        return this.biomes[x][z];
    }

    @Override
    public BiomeIterator getBiomes() {
        return new BiomeIteratorImpl<SchematicBiome[][]>(this.biomes, this.biomes.length, this.biomes.length != 0 ? this.biomes[0].length : 0){

            @Override
            public SchematicBiome next() {
                this.x = this.i / this.width;
                this.z = this.i % this.length;
                ++this.i;
                return ((SchematicBiome[][])this.arr)[this.x][this.z];
            }
        };
    }

    @Override
    public String getName() {
        return this.metadata.name;
    }

    @Override
    public String getAuthor() {
        return this.metadata.author;
    }

    @Override
    public LocalDateTime date() {
        return this.metadata.date;
    }

    public int getDataVersion() {
        return this.dataVersion;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "SchematicSponge(format=" + (Object)((Object)this.getFormat()) + ", name=" + this.getName() + ", author=" + this.getAuthor() + ", width=" + this.width + ", height=" + this.height + ", length=" + this.length + ')';
    }

    static /* synthetic */ int[] access$000() {
        return DEFAULT_OFFSET;
    }

    public static class Metadata {
        public final String name;
        public final String author;
        public final LocalDateTime date;
        public final String[] requiredMods;
        public final Map<String, Object> extra;

        public Metadata(String name, String author, LocalDateTime date, String[] requiredMods, Map<String, Object> extra) {
            this.name = name;
            this.author = author;
            this.date = date;
            this.requiredMods = requiredMods;
            this.extra = Collections.unmodifiableMap(extra);
        }

        public String toString() {
            return "Metadata(name='" + this.name + '\'' + ", author='" + this.author + '\'' + ')';
        }
    }

    public static class Builder {
        private Integer version;
        private Integer dataVersion;
        private Metadata metadata;
        private Integer width;
        private Integer height;
        private Integer length;
        private int[] offset = SchematicSponge.access$000();
        private SchematicBlock[][][] blocks;
        private Collection<SchematicBlockEntity> blockEntities;
        private Collection<SchematicEntity> entities;
        private SchematicBiome[][] biomes;

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder dataVersion(Integer dataVersion) {
            this.dataVersion = dataVersion;
            return this;
        }

        public Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder height(int height) {
            this.height = height;
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public Builder offset(int[] offset) {
            if (offset.length != 3) {
                throw new IllegalArgumentException("offset must have exactly three values");
            }
            this.offset = offset;
            return this;
        }

        public Builder blocks(SchematicBlock[][][] blocks) {
            this.blocks = blocks;
            return this;
        }

        public Builder blockEntities(Collection<SchematicBlockEntity> blockEntities) {
            this.blockEntities = blockEntities;
            return this;
        }

        public Builder entities(Collection<SchematicEntity> entities) {
            this.entities = entities;
            return this;
        }

        public Builder biomes(SchematicBiome[][] biomes) {
            this.biomes = biomes;
            return null;
        }

        public SchematicSponge build() {
            if (this.version == null) {
                throw new SchematicBuilderException("version must be set");
            }
            if (this.dataVersion == null) {
                throw new SchematicBuilderException("dataVersion must be set");
            }
            if (this.width == null) {
                throw new SchematicBuilderException("width must be set");
            }
            if (this.height == null) {
                throw new SchematicBuilderException("height must be set");
            }
            if (this.length == null) {
                throw new SchematicBuilderException("length must be set");
            }
            if (this.blocks == null) {
                throw new SchematicBuilderException("blocks must be set");
            }
            return new SchematicSponge(this.version, this.dataVersion, this.metadata, this.width, this.height, this.length, this.offset, this.blocks, this.blockEntities, this.entities, this.biomes);
        }
    }
}

