/*
 * Decompiled with CFR 0.152.
 */
package net.sandrohc.schematic4j;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import net.querz.nbt.io.NBTUtil;
import net.querz.nbt.io.NamedTag;
import net.querz.nbt.tag.ByteArrayTag;
import net.querz.nbt.tag.ByteTag;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.DoubleTag;
import net.querz.nbt.tag.FloatTag;
import net.querz.nbt.tag.IntArrayTag;
import net.querz.nbt.tag.IntTag;
import net.querz.nbt.tag.LongArrayTag;
import net.querz.nbt.tag.LongTag;
import net.querz.nbt.tag.ShortTag;
import net.querz.nbt.tag.StringTag;
import net.querz.nbt.tag.Tag;
import net.sandrohc.schematic4j.SchematicFormat;
import net.sandrohc.schematic4j.exception.ParsingException;
import net.sandrohc.schematic4j.parser.Parser;
import net.sandrohc.schematic4j.schematic.Schematic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchematicUtil {
    private static final Logger log = LoggerFactory.getLogger(SchematicUtil.class);

    public static Schematic load(String file) throws ParsingException, IOException {
        return SchematicUtil.load(Paths.get(file, new String[0]));
    }

    public static Schematic load(File file) throws ParsingException, IOException {
        return SchematicUtil.load(file.toPath());
    }

    public static Schematic load(Path path) throws ParsingException, IOException {
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            Schematic schematic = SchematicUtil.load(is);
            return schematic;
        }
    }

    public static Schematic load(InputStream is) throws ParsingException, IOException {
        NamedTag rootTag = NBTUtil.Reader.read().from(is);
        return SchematicUtil.parse(rootTag);
    }

    public static Schematic parse(NamedTag root) throws ParsingException {
        SchematicFormat format = SchematicUtil.detectFormat(root);
        log.info("Found format: {}", (Object)format);
        Parser parser = format.createParser();
        log.debug("Found parser: {}", (Object)parser);
        return parser.parse(root);
    }

    public static SchematicFormat detectFormat(NamedTag root) {
        if (!root.getName().equals("Schematic")) {
            log.warn("Root tag does not follow the standard. Expected a tag named '{}' but got '{}'", (Object)"Schematic", (Object)root.getName());
        }
        if (root.getTag() instanceof CompoundTag) {
            CompoundTag rootCompound = (CompoundTag)root.getTag();
            if (SchematicUtil.containsAllTags(rootCompound, "Version", "Width", "Height", "Length", "BlockData", "Palette")) {
                int version = rootCompound.getInt("Version");
                switch (version) {
                    case 1: {
                        return SchematicFormat.SPONGE_V1;
                    }
                    case 2: {
                        return SchematicFormat.SPONGE_V2;
                    }
                }
                log.warn("Found Sponge Schematic with version {}, which is not supported. Using parser for version 2", (Object)version);
                return SchematicFormat.SPONGE_V2;
            }
        }
        return SchematicFormat.UNKNOWN;
    }

    public static Object unwrap(Tag<?> value) {
        if (value instanceof StringTag) {
            return ((StringTag)value).getValue();
        }
        if (value instanceof LongTag) {
            return ((LongTag)value).asLong();
        }
        if (value instanceof IntTag) {
            return ((IntTag)value).asInt();
        }
        if (value instanceof ShortTag) {
            return ((ShortTag)value).asShort();
        }
        if (value instanceof ByteTag) {
            return ((ByteTag)value).asByte();
        }
        if (value instanceof FloatTag) {
            return Float.valueOf(((FloatTag)value).asFloat());
        }
        if (value instanceof DoubleTag) {
            return ((DoubleTag)value).asDouble();
        }
        if (value instanceof IntArrayTag) {
            return ((IntArrayTag)value).getValue();
        }
        if (value instanceof ByteArrayTag) {
            return ((ByteArrayTag)value).getValue();
        }
        if (value instanceof LongArrayTag) {
            return ((LongArrayTag)value).getValue();
        }
        return value;
    }

    public static boolean containsAllTags(CompoundTag tag, String ... requiredTags) {
        return Arrays.stream(requiredTags).allMatch(arg_0 -> ((CompoundTag)tag).containsKey(arg_0));
    }

    public static boolean containsTag(CompoundTag tag, String ... optionalTags) {
        return Arrays.stream(optionalTags).anyMatch(arg_0 -> ((CompoundTag)tag).containsKey(arg_0));
    }
}

