/*
 * Decompiled with CFR 0.152.
 */
package net.saliman.spring.request.correlation.support;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import net.saliman.spring.request.correlation.api.CorrelationIdGenerator;
import net.saliman.spring.request.correlation.api.RequestCorrelationInterceptor;
import net.saliman.spring.request.correlation.filter.RequestCorrelationFilter;
import net.saliman.spring.request.correlation.generator.UuidGenerator;
import net.saliman.spring.request.correlation.support.RequestCorrelationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RequestCorrelationProperties.class})
public class RequestCorrelationConfiguration {
    @Autowired(required=false)
    private List<RequestCorrelationInterceptor> interceptors = new ArrayList<RequestCorrelationInterceptor>();

    @Bean
    @ConditionalOnMissingBean(value={CorrelationIdGenerator.class})
    public CorrelationIdGenerator requestIdGenerator() {
        return new UuidGenerator();
    }

    @Bean
    public RequestCorrelationFilter requestCorrelationFilter(CorrelationIdGenerator generator, RequestCorrelationProperties properties) {
        return new RequestCorrelationFilter(generator, this.interceptors, properties);
    }

    @Bean
    public FilterRegistrationBean requestCorrelationFilterBean(RequestCorrelationFilter correlationFilter) {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setFilter((Filter)correlationFilter);
        filterRegistration.setMatchAfter(false);
        filterRegistration.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC));
        filterRegistration.setAsyncSupported(true);
        filterRegistration.setOrder(Integer.MIN_VALUE);
        return filterRegistration;
    }
}

