/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.recognition.tf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.tika.config.Field;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.recognition.ObjectRecogniser;
import org.apache.tika.parser.recognition.RecognisedObject;
import org.apache.tika.parser.recognition.tf.TensorflowImageRecParser;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TensorflowRESTRecogniser
implements ObjectRecogniser {
    private static final Logger LOG = LoggerFactory.getLogger(TensorflowRESTRecogniser.class);
    private static final String LABEL_LANG = "en";
    @Field
    private URI apiUri = URI.create("http://localhost:8764/inception/v3/classify?topk=10");
    @Field
    private URI healthUri = URI.create("http://localhost:8764/inception/v3/ping");
    private boolean available;

    @Override
    public Set<MediaType> getSupportedMimes() {
        return TensorflowImageRecParser.SUPPORTED_MIMES;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpResponse response = client.execute(new HttpGet(this.healthUri));
            this.available = response.getStatusLine().getStatusCode() == 200;
            LOG.info("Available = {}, API Status = {}", (Object)this.available, (Object)response.getStatusLine());
        }
        catch (Exception e) {
            this.available = false;
            throw new TikaConfigException(e.getMessage(), e);
        }
    }

    @Override
    public List<RecognisedObject> recognise(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ArrayList<RecognisedObject> recObjs = new ArrayList<RecognisedObject>();
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpPost request = new HttpPost(this.apiUri);
            try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
                IOUtils.copy(stream, (OutputStream)byteStream);
                request.setEntity(new ByteArrayEntity(byteStream.toByteArray()));
            }
            HttpResponse response = client.execute(request);
            try (InputStream reply = response.getEntity().getContent();){
                String replyMessage = IOUtils.toString(reply);
                if (response.getStatusLine().getStatusCode() == 200) {
                    JSONObject jReply = new JSONObject(replyMessage);
                    JSONArray jClasses = jReply.getJSONArray("classnames");
                    JSONArray jConfidence = jReply.getJSONArray("confidence");
                    if (jClasses.length() != jConfidence.length()) {
                        LOG.warn("Classes of size {} is not equal to confidence of size {}", (Object)jClasses.length(), (Object)jConfidence.length());
                    }
                    assert (jClasses.length() == jConfidence.length());
                    for (int i = 0; i < jClasses.length(); ++i) {
                        RecognisedObject recObj = new RecognisedObject(jClasses.getString(i), LABEL_LANG, jClasses.getString(i), jConfidence.getDouble(i));
                        recObjs.add(recObj);
                    }
                } else {
                    LOG.warn("Status = {}", (Object)response.getStatusLine());
                    LOG.warn("Response = {}", (Object)replyMessage);
                }
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
        LOG.debug("Num Objects found {}", (Object)recObjs.size());
        return recObjs;
    }
}

