/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.AbstractPDF2XHTML;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class PDF2XHTML
extends AbstractPDF2XHTML {
    private static final List<String> JPEG = Arrays.asList(COSName.DCT_DECODE.getName(), COSName.DCT_DECODE_ABBREVIATION.getName());
    private Map<COSStream, Integer> processedInlineImages = new HashMap<COSStream, Integer>();
    private int inlineImageCounter = 0;

    private PDF2XHTML(PDDocument document, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws IOException {
        super(document, handler, context, metadata, config);
    }

    public static void process(PDDocument document, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws SAXException, TikaException {
        PDF2XHTML pdf2XHTML = null;
        try {
            pdf2XHTML = new PDF2XHTML(document, handler, context, metadata, config);
            config.configure(pdf2XHTML);
            pdf2XHTML.writeText(document, new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) {
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            });
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new TikaException("Unable to extract PDF content", e);
        }
        if (pdf2XHTML.exceptions.size() > 0) {
            throw new TikaException("Unable to extract PDF content", (Throwable)pdf2XHTML.exceptions.get(0));
        }
    }

    @Override
    public void processPage(PDPage page) throws IOException {
        try {
            super.processPage(page);
        }
        catch (IOException e) {
            this.handleCatchableIOE(e);
        }
    }

    @Override
    protected void endPage(PDPage page) throws IOException {
        try {
            this.writeParagraphEnd();
            try {
                this.extractImages(page.getResources(), new HashSet<COSBase>());
            }
            catch (IOException e) {
                this.handleCatchableIOE(e);
            }
            super.endPage(page);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a page", e);
        }
        catch (IOException e) {
            this.exceptions.add(e);
        }
    }

    private void extractImages(PDResources resources, Set<COSBase> seenThisPage) throws SAXException, IOException {
        if (resources == null || !this.config.getExtractInlineImages()) {
            return;
        }
        for (COSName name : resources.getXObjectNames()) {
            COSStream cosStream;
            PDXObject object = resources.getXObject(name);
            if (object == null || seenThisPage.contains(cosStream = object.getCOSObject())) continue;
            seenThisPage.add(cosStream);
            if (object instanceof PDFormXObject) {
                this.extractImages(((PDFormXObject)object).getResources(), seenThisPage);
                continue;
            }
            if (!(object instanceof PDImageXObject)) continue;
            PDImageXObject image = (PDImageXObject)object;
            Metadata metadata = new Metadata();
            String extension = image.getSuffix();
            if (extension == null) {
                metadata.set("Content-Type", "image/png");
                extension = "png";
            } else if (extension.equals("jpg")) {
                metadata.set("Content-Type", "image/jpeg");
            } else if (extension.equals("tiff")) {
                metadata.set("Content-Type", "image/tiff");
                extension = "tif";
            }
            Integer imageNumber = this.processedInlineImages.get(cosStream);
            if (imageNumber == null) {
                imageNumber = this.inlineImageCounter++;
            }
            String fileName = "image" + imageNumber + "." + extension;
            metadata.set("resourceName", fileName);
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute("", "src", "src", "CDATA", "embedded:" + fileName);
            attr.addAttribute("", "alt", "alt", "CDATA", fileName);
            this.xhtml.startElement("img", attr);
            this.xhtml.endElement("img");
            if (this.config.getExtractUniqueInlineImagesOnly()) {
                if (this.processedInlineImages.containsKey(cosStream)) continue;
                this.processedInlineImages.put(cosStream, imageNumber);
            }
            metadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.INLINE.toString());
            EmbeddedDocumentExtractor extractor = this.getEmbeddedDocumentExtractor();
            if (!extractor.shouldParseEmbedded(metadata)) continue;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                this.writeToBuffer(image, extension, buffer);
                extractor.parseEmbedded(new ByteArrayInputStream(buffer.toByteArray()), new EmbeddedContentHandler(this.xhtml), metadata, false);
            }
            catch (IOException e) {
                this.handleCatchableIOE(e);
            }
        }
    }

    private void writeToBuffer(PDImageXObject pdImage, String suffix, OutputStream out) throws IOException {
        BufferedImage image = pdImage.getImage();
        if (image != null) {
            if ("jpg".equals(suffix)) {
                String colorSpaceName = pdImage.getColorSpace().getName();
                if (PDDeviceGray.INSTANCE.getName().equals(colorSpaceName) || PDDeviceRGB.INSTANCE.getName().equals(colorSpaceName)) {
                    InputStream data = pdImage.getStream().createInputStream(JPEG);
                    IOUtils.copy(data, out);
                    IOUtils.closeQuietly(data);
                } else {
                    ImageIOUtil.writeImage(image, suffix, out);
                }
            } else {
                ImageIOUtil.writeImage(image, suffix, out);
            }
        }
        out.flush();
    }

    @Override
    protected void writeParagraphStart() throws IOException {
        super.writeParagraphStart();
        try {
            this.xhtml.startElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a paragraph", e);
        }
    }

    @Override
    protected void writeParagraphEnd() throws IOException {
        super.writeParagraphEnd();
        try {
            this.xhtml.endElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a paragraph", e);
        }
    }

    @Override
    protected void writeString(String text) throws IOException {
        try {
            this.xhtml.characters(text);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a string: " + text, e);
        }
    }

    @Override
    protected void writeCharacters(TextPosition text) throws IOException {
        try {
            this.xhtml.characters(text.getUnicode());
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a character: " + text.getUnicode(), e);
        }
    }

    @Override
    protected void writeWordSeparator() throws IOException {
        try {
            this.xhtml.characters(this.getWordSeparator());
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a space character", e);
        }
    }

    @Override
    protected void writeLineSeparator() throws IOException {
        try {
            this.xhtml.newline();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a newline character", e);
        }
    }
}

