/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.pdmodel.interactive.form.PDXFAResource;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.ocr.TesseractOCRConfig;
import org.apache.tika.parser.ocr.TesseractOCRParser;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.parser.pdf.XFAExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class AbstractPDF2XHTML
extends PDFTextStripper {
    private static final int MAX_ACROFORM_RECURSIONS = 10;
    private static final TesseractOCRConfig DEFAULT_TESSERACT_CONFIG = new TesseractOCRConfig();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ROOT);
    final List<IOException> exceptions = new ArrayList<IOException>();
    final PDDocument pdDocument;
    final XHTMLContentHandler xhtml;
    private final ParseContext context;
    private final Metadata metadata;
    final PDFParserConfig config;
    private int pageIndex = 0;

    AbstractPDF2XHTML(PDDocument pdDocument, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws IOException {
        this.pdDocument = pdDocument;
        this.xhtml = new XHTMLContentHandler(handler, metadata);
        this.context = context;
        this.metadata = metadata;
        this.config = config;
    }

    @Override
    protected void startPage(PDPage page) throws IOException {
        try {
            this.xhtml.startElement("div", "class", "page");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a page", e);
        }
        this.writeParagraphStart();
    }

    EmbeddedDocumentExtractor getEmbeddedDocumentExtractor() {
        EmbeddedDocumentExtractor extractor = this.context.get(EmbeddedDocumentExtractor.class);
        if (extractor == null) {
            extractor = new ParsingEmbeddedDocumentExtractor(this.context);
        }
        return extractor;
    }

    private void extractEmbeddedDocuments(PDDocument document) throws IOException, SAXException, TikaException {
        PDDocumentNameDictionary namesDictionary = new PDDocumentNameDictionary(document.getDocumentCatalog());
        PDEmbeddedFilesNameTreeNode efTree = namesDictionary.getEmbeddedFiles();
        if (efTree == null) {
            return;
        }
        Map<String, PDComplexFileSpecification> embeddedFileNames = efTree.getNames();
        if (embeddedFileNames != null) {
            this.processEmbeddedDocNames(embeddedFileNames);
        } else {
            List kids = efTree.getKids();
            if (kids == null) {
                return;
            }
            for (PDNameTreeNode node : kids) {
                embeddedFileNames = node.getNames();
                if (embeddedFileNames == null) continue;
                this.processEmbeddedDocNames(embeddedFileNames);
            }
        }
    }

    private void processEmbeddedDocNames(Map<String, PDComplexFileSpecification> embeddedFileNames) throws IOException, SAXException, TikaException {
        if (embeddedFileNames == null || embeddedFileNames.isEmpty()) {
            return;
        }
        EmbeddedDocumentExtractor extractor = this.getEmbeddedDocumentExtractor();
        for (Map.Entry<String, PDComplexFileSpecification> ent : embeddedFileNames.entrySet()) {
            PDComplexFileSpecification spec = ent.getValue();
            this.extractMultiOSPDEmbeddedFiles(ent.getKey(), spec, extractor);
        }
    }

    private void extractMultiOSPDEmbeddedFiles(String displayName, PDComplexFileSpecification spec, EmbeddedDocumentExtractor extractor) throws IOException, SAXException, TikaException {
        if (spec == null) {
            return;
        }
        this.extractPDEmbeddedFile(displayName, spec.getFileUnicode(), spec.getFile(), spec.getEmbeddedFile(), extractor);
        this.extractPDEmbeddedFile(displayName, spec.getFileUnicode(), spec.getFileMac(), spec.getEmbeddedFileMac(), extractor);
        this.extractPDEmbeddedFile(displayName, spec.getFileUnicode(), spec.getFileDos(), spec.getEmbeddedFileDos(), extractor);
        this.extractPDEmbeddedFile(displayName, spec.getFileUnicode(), spec.getFileUnix(), spec.getEmbeddedFileUnix(), extractor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractPDEmbeddedFile(String displayName, String unicodeFileName, String fileName, PDEmbeddedFile file, EmbeddedDocumentExtractor extractor) throws SAXException, IOException, TikaException {
        if (file == null) {
            return;
        }
        fileName = fileName == null ? displayName : fileName;
        Metadata metadata = new Metadata();
        metadata.set("resourceName", fileName);
        metadata.set("Content-Type", file.getSubtype());
        metadata.set("Content-Length", Long.toString(file.getSize()));
        metadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString());
        metadata.set(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, fileName);
        if (extractor.shouldParseEmbedded(metadata)) {
            TikaInputStream stream = null;
            try {
                stream = TikaInputStream.get(file.createInputStream());
                extractor.parseEmbedded(stream, new EmbeddedContentHandler(this.xhtml), metadata, false);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "class", "class", "CDATA", "embedded");
                attributes.addAttribute("", "id", "id", "CDATA", fileName);
                this.xhtml.startElement("div", attributes);
                this.xhtml.endElement("div");
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
    }

    void handleCatchableIOE(IOException e) throws IOException {
        String msg;
        if (this.config.isCatchIntermediateIOExceptions()) {
            if (e.getCause() instanceof SAXException && e.getCause().getMessage() != null && e.getCause().getMessage().contains("Your document contained more than")) {
                throw e;
            }
            msg = e.getMessage();
            if (msg == null) {
                msg = "IOException, no message";
            }
        } else {
            throw e;
        }
        this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, msg);
        this.exceptions.add(e);
    }

    void doOCROnCurrentPage() throws IOException, TikaException, SAXException {
        if (this.config.getOcrStrategy().equals((Object)PDFParserConfig.OCR_STRATEGY.NO_OCR)) {
            return;
        }
        TesseractOCRParser tesseractOCRParser = new TesseractOCRParser();
        TesseractOCRConfig tesseractConfig = this.context.get(TesseractOCRConfig.class, DEFAULT_TESSERACT_CONFIG);
        if (!tesseractOCRParser.hasTesseract(tesseractConfig)) {
            throw new TikaException("Tesseract is not available. Please set the OCR_STRATEGY to NO_OCR or configure Tesseract correctly");
        }
        PDFRenderer renderer = new PDFRenderer(this.pdDocument);
        TemporaryResources tmp = new TemporaryResources();
        try {
            BufferedImage image = renderer.renderImage(this.pageIndex, 2.0f, this.config.getOcrImageType());
            Path tmpFile = tmp.createTempFile();
            try (OutputStream os = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                ImageIOUtil.writeImage(image, this.config.getOcrImageFormatName(), os, this.config.getOcrDPI());
            }
            var8_10 = null;
            try (TikaInputStream is = TikaInputStream.get(tmpFile);){
                tesseractOCRParser.parseInline(is, this.xhtml, tesseractConfig);
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            this.handleCatchableIOE(e);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("error writing OCR content from PDF", e);
        }
        finally {
            tmp.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void endPage(PDPage page) throws IOException {
        try {
            EmbeddedDocumentExtractor extractor = this.getEmbeddedDocumentExtractor();
            for (PDAnnotation annotation : page.getAnnotations()) {
                PDActionURI uri;
                String link;
                PDAction action;
                PDAnnotationLink annotationlink;
                if (annotation instanceof PDAnnotationFileAttachment) {
                    PDAnnotationFileAttachment fann = (PDAnnotationFileAttachment)annotation;
                    PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)fann.getFile();
                    try {
                        this.extractMultiOSPDEmbeddedFiles(fann.getAttachmentName(), fileSpec, extractor);
                    }
                    catch (SAXException e) {
                        throw new IOExceptionWithCause("file embedded in annotation sax exception", e);
                    }
                    catch (TikaException e) {
                        throw new IOExceptionWithCause("file embedded in annotation tika exception", e);
                    }
                    catch (IOException e) {
                        this.handleCatchableIOE(e);
                    }
                }
                if (!this.config.getExtractAnnotationText()) continue;
                if (annotation instanceof PDAnnotationLink && (annotationlink = (PDAnnotationLink)annotation).getAction() != null && (action = annotationlink.getAction()) instanceof PDActionURI && (link = (uri = (PDActionURI)action).getURI()) != null && link.trim().length() > 0) {
                    this.xhtml.startElement("div", "class", "annotation");
                    this.xhtml.startElement("a", "href", link);
                    this.xhtml.characters(link);
                    this.xhtml.endElement("a");
                    this.xhtml.endElement("div");
                }
                if (!(annotation instanceof PDAnnotationMarkup)) continue;
                PDAnnotationMarkup annotationMarkup = (PDAnnotationMarkup)annotation;
                String title = annotationMarkup.getTitlePopup();
                String subject = annotationMarkup.getSubject();
                String contents = annotationMarkup.getContents();
                if (title == null && subject == null && contents == null) continue;
                this.xhtml.startElement("div", "class", "annotation");
                if (title != null) {
                    this.xhtml.startElement("div", "class", "annotationTitle");
                    this.xhtml.characters(title);
                    this.xhtml.endElement("div");
                }
                if (subject != null) {
                    this.xhtml.startElement("div", "class", "annotationSubject");
                    this.xhtml.characters(subject);
                    this.xhtml.endElement("div");
                }
                if (contents != null) {
                    this.xhtml.startElement("div", "class", "annotationContents");
                    this.xhtml.characters(contents);
                    this.xhtml.endElement("div");
                }
                this.xhtml.endElement("div");
            }
            if (this.config.getOcrStrategy().equals((Object)PDFParserConfig.OCR_STRATEGY.OCR_AND_TEXT_EXTRACTION)) {
                this.doOCROnCurrentPage();
            }
            this.xhtml.endElement("div");
        }
        catch (TikaException | SAXException e) {
            throw new IOExceptionWithCause("Unable to end a page", e);
        }
        catch (IOException e) {
            this.exceptions.add(e);
        }
        finally {
            ++this.pageIndex;
        }
    }

    @Override
    protected void startDocument(PDDocument pdf) throws IOException {
        try {
            this.xhtml.startDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a document", e);
        }
    }

    @Override
    protected void endDocument(PDDocument pdf) throws IOException {
        try {
            this.extractBookmarkText();
            try {
                this.extractEmbeddedDocuments(pdf);
            }
            catch (IOException e) {
                this.handleCatchableIOE(e);
            }
            if (this.config.getExtractAcroFormContent()) {
                try {
                    this.extractAcroForm(pdf);
                }
                catch (IOException e) {
                    this.handleCatchableIOE(e);
                }
            }
            this.xhtml.endDocument();
        }
        catch (TikaException e) {
            throw new IOExceptionWithCause("Unable to end a document", e);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a document", e);
        }
    }

    void extractBookmarkText() throws SAXException {
        PDDocumentOutline outline = this.document.getDocumentCatalog().getDocumentOutline();
        if (outline != null) {
            this.extractBookmarkText(outline);
        }
    }

    void extractBookmarkText(PDOutlineNode bookmark) throws SAXException {
        PDOutlineItem current = bookmark.getFirstChild();
        if (current != null) {
            this.xhtml.startElement("ul");
            while (current != null) {
                this.xhtml.startElement("li");
                this.xhtml.characters(current.getTitle());
                this.xhtml.endElement("li");
                this.extractBookmarkText(current);
                current = current.getNextSibling();
            }
            this.xhtml.endElement("ul");
        }
    }

    void extractAcroForm(PDDocument pdf) throws IOException, SAXException {
        List<PDField> fields;
        PDDocumentCatalog catalog = pdf.getDocumentCatalog();
        if (catalog == null) {
            return;
        }
        PDAcroForm form = catalog.getAcroForm();
        if (form == null) {
            return;
        }
        PDXFAResource pdxfa = form.getXFA();
        if (pdxfa != null) {
            XFAExtractor xfaExtractor = new XFAExtractor();
            try (BufferedInputStream is2 = new BufferedInputStream(new ByteArrayInputStream(pdxfa.getBytes()));){
                xfaExtractor.extract(is2, this.xhtml, this.metadata, this.context);
                return;
            }
            catch (IOException | XMLStreamException is2) {
                // empty catch block
            }
        }
        if ((fields = form.getFields()) == null) {
            return;
        }
        ListIterator<PDField> itr = fields.listIterator();
        if (itr == null) {
            return;
        }
        this.xhtml.startElement("div", "class", "acroform");
        this.xhtml.startElement("ol");
        while (itr.hasNext()) {
            PDField obj = itr.next();
            if (obj == null || !(obj instanceof PDField)) continue;
            this.processAcroField(obj, 0);
        }
        this.xhtml.endElement("ol");
        this.xhtml.endElement("div");
    }

    private void processAcroField(PDField field, int currentRecursiveDepth) throws SAXException, IOException {
        if (currentRecursiveDepth >= 10) {
            return;
        }
        this.addFieldString(field);
        if (field instanceof PDNonTerminalField) {
            int r = currentRecursiveDepth + 1;
            this.xhtml.startElement("ol");
            for (PDField child : ((PDNonTerminalField)field).getChildren()) {
                this.processAcroField(child, r);
            }
            this.xhtml.endElement("ol");
        }
    }

    private void addFieldString(PDField field) throws SAXException {
        String partName = field.getPartialName();
        String altName = field.getAlternateFieldName();
        StringBuilder sb = new StringBuilder();
        AttributesImpl attrs = new AttributesImpl();
        if (partName != null) {
            sb.append(partName).append(": ");
        }
        if (altName != null) {
            attrs.addAttribute("", "altName", "altName", "CDATA", altName);
        }
        if (field instanceof PDSignatureField) {
            this.handleSignature(attrs, (PDSignatureField)field);
            return;
        }
        String value = field.getValueAsString();
        if (value != null && !value.equals("null")) {
            sb.append(value);
        }
        if (attrs.getLength() > 0 || sb.length() > 0) {
            this.xhtml.startElement("li", attrs);
            this.xhtml.characters(sb.toString());
            this.xhtml.endElement("li");
        }
    }

    private void handleSignature(AttributesImpl parentAttributes, PDSignatureField sigField) throws SAXException {
        PDSignature sig = sigField.getSignature();
        if (sig == null) {
            return;
        }
        TreeMap<String, String> vals = new TreeMap<String, String>();
        vals.put("name", sig.getName());
        vals.put("contactInfo", sig.getContactInfo());
        vals.put("location", sig.getLocation());
        vals.put("reason", sig.getReason());
        Calendar cal = sig.getSignDate();
        if (cal != null) {
            this.dateFormat.setTimeZone(cal.getTimeZone());
            vals.put("date", this.dateFormat.format(cal.getTime()));
        }
        int nonNull = 0;
        for (String val : vals.keySet()) {
            if (val == null || val.equals("")) continue;
            ++nonNull;
        }
        if (nonNull > 0) {
            this.xhtml.startElement("li", parentAttributes);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "type", "type", "CDATA", "signaturedata");
            this.xhtml.startElement("ol", attrs);
            for (Map.Entry e : vals.entrySet()) {
                if (e.getValue() == null || ((String)e.getValue()).equals("")) continue;
                attrs = new AttributesImpl();
                attrs.addAttribute("", "signdata", "signdata", "CDATA", (String)e.getKey());
                this.xhtml.startElement("li", attrs);
                this.xhtml.characters((String)e.getValue());
                this.xhtml.endElement("li");
            }
            this.xhtml.endElement("ol");
            this.xhtml.endElement("li");
        }
    }
}

