/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.MSOffice;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;

public class SummaryExtractor {
    private static final Log logger = LogFactory.getLog(AbstractPOIFSExtractor.class);
    private static final String SUMMARY_INFORMATION = "\u0005SummaryInformation";
    private static final String DOCUMENT_SUMMARY_INFORMATION = "\u0005DocumentSummaryInformation";
    private final Metadata metadata;

    public SummaryExtractor(Metadata metadata) {
        this.metadata = metadata;
    }

    public void parseSummaries(NPOIFSFileSystem filesystem) throws IOException, TikaException {
        this.parseSummaries(filesystem.getRoot());
    }

    public void parseSummaries(DirectoryNode root) throws IOException, TikaException {
        this.parseSummaryEntryIfExists(root, SUMMARY_INFORMATION);
        this.parseSummaryEntryIfExists(root, DOCUMENT_SUMMARY_INFORMATION);
    }

    private void parseSummaryEntryIfExists(DirectoryNode root, String entryName) throws IOException, TikaException {
        try {
            DocumentEntry entry = (DocumentEntry)root.getEntry(entryName);
            PropertySet properties = new PropertySet(new DocumentInputStream(entry));
            if (properties.isSummaryInformation()) {
                this.parse(new SummaryInformation(properties));
            }
            if (properties.isDocumentSummaryInformation()) {
                this.parse(new DocumentSummaryInformation(properties));
            }
        }
        catch (FileNotFoundException entry) {
        }
        catch (NoPropertySetStreamException entry) {
        }
        catch (UnexpectedPropertySetTypeException e) {
            throw new TikaException("Unexpected HPSF document", e);
        }
        catch (MarkUnsupportedException e) {
            throw new TikaException("Invalid DocumentInputStream", e);
        }
        catch (Exception e) {
            logger.warn("Ignoring unexpected exception while parsing summary entry " + entryName, e);
        }
    }

    private void parse(SummaryInformation summary) {
        this.set(TikaCoreProperties.TITLE, summary.getTitle());
        SummaryExtractor.addMulti(this.metadata, TikaCoreProperties.CREATOR, summary.getAuthor());
        this.set(TikaCoreProperties.KEYWORDS, summary.getKeywords());
        this.set(TikaCoreProperties.TRANSITION_SUBJECT_TO_OO_SUBJECT, summary.getSubject());
        this.set(TikaCoreProperties.MODIFIER, summary.getLastAuthor());
        this.set(TikaCoreProperties.COMMENTS, summary.getComments());
        this.set(OfficeOpenXMLExtended.TEMPLATE, summary.getTemplate());
        this.set(OfficeOpenXMLExtended.APPLICATION, summary.getApplicationName());
        this.set(OfficeOpenXMLCore.REVISION, summary.getRevNumber());
        this.set(TikaCoreProperties.CREATED, summary.getCreateDateTime());
        this.set(TikaCoreProperties.MODIFIED, summary.getLastSaveDateTime());
        this.set(TikaCoreProperties.PRINT_DATE, summary.getLastPrinted());
        this.set("Edit-Time", summary.getEditTime());
        this.set(OfficeOpenXMLExtended.DOC_SECURITY, summary.getSecurity());
        this.set(Office.WORD_COUNT, summary.getWordCount());
        this.set(Office.CHARACTER_COUNT, summary.getCharCount());
        this.set(Office.PAGE_COUNT, summary.getPageCount());
        if (summary.getPageCount() > 0) {
            this.metadata.set(PagedText.N_PAGES, summary.getPageCount());
        }
        this.set("Template", summary.getTemplate());
        this.set("Application-Name", summary.getApplicationName());
        this.set("Revision-Number", summary.getRevNumber());
        this.set("Security", (long)summary.getSecurity());
        this.set(MSOffice.WORD_COUNT, summary.getWordCount());
        this.set(MSOffice.CHARACTER_COUNT, summary.getCharCount());
        this.set(MSOffice.PAGE_COUNT, summary.getPageCount());
    }

    private void parse(DocumentSummaryInformation summary) {
        this.set(OfficeOpenXMLExtended.COMPANY, summary.getCompany());
        SummaryExtractor.addMulti(this.metadata, OfficeOpenXMLExtended.MANAGER, summary.getManager());
        this.set(TikaCoreProperties.LANGUAGE, this.getLanguage(summary));
        this.set(OfficeOpenXMLCore.CATEGORY, summary.getCategory());
        this.set(Office.SLIDE_COUNT, summary.getSlideCount());
        if (summary.getSlideCount() > 0) {
            this.metadata.set(PagedText.N_PAGES, summary.getSlideCount());
        }
        this.set("Company", summary.getCompany());
        this.set("Manager", summary.getManager());
        this.set(MSOffice.SLIDE_COUNT, summary.getSlideCount());
        this.set("Category", summary.getCategory());
        this.parse(summary.getCustomProperties());
    }

    private String getLanguage(DocumentSummaryInformation summary) {
        Object value;
        CustomProperties customProperties = summary.getCustomProperties();
        if (customProperties != null && (value = customProperties.get("Language")) instanceof String) {
            return (String)value;
        }
        return null;
    }

    private void parse(CustomProperties customProperties) {
        if (customProperties != null) {
            for (String name : customProperties.nameSet()) {
                Property prop;
                String key = "custom:" + name;
                Object value = customProperties.get(name);
                if (value instanceof String) {
                    this.set(key, (String)value);
                    continue;
                }
                if (value instanceof Date) {
                    prop = Property.externalDate(key);
                    this.metadata.set(prop, (Date)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    prop = Property.externalBoolean(key);
                    this.metadata.set(prop, value.toString());
                    continue;
                }
                if (value instanceof Long) {
                    prop = Property.externalInteger(key);
                    this.metadata.set(prop, ((Long)value).intValue());
                    continue;
                }
                if (value instanceof Double) {
                    prop = Property.externalReal(key);
                    this.metadata.set(prop, (Double)value);
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                prop = Property.externalInteger(key);
                this.metadata.set(prop, (Integer)value);
            }
        }
    }

    private void set(String name, String value) {
        if (value != null) {
            this.metadata.set(name, value);
        }
    }

    private void set(Property property, String value) {
        if (value != null) {
            this.metadata.set(property, value);
        }
    }

    private void set(Property property, Date value) {
        if (value != null) {
            this.metadata.set(property, value);
        }
    }

    private void set(Property property, int value) {
        if (value > 0) {
            this.metadata.set(property, value);
        }
    }

    private void set(String name, long value) {
        if (value > 0L) {
            this.metadata.set(name, Long.toString(value));
        }
    }

    public static void addMulti(Metadata metadata, Property property, String string) {
        if (string == null) {
            return;
        }
        String[] parts = string.split(";");
        String[] current = metadata.getValues(property);
        HashSet<String> seen = new HashSet<String>();
        if (current != null) {
            for (String val : current) {
                seen.add(val);
            }
        }
        for (String part : parts) {
            if (seen.contains(part)) continue;
            metadata.add(property, part);
            seen.add(part);
        }
    }
}

