/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class POIFSContainerDetector
implements Detector {
    public static final MediaType OLE = MediaType.application("x-tika-msoffice");
    public static final MediaType OOXML_PROTECTED = MediaType.application("x-tika-ooxml-protected");
    public static final MediaType GENERAL_EMBEDDED = MediaType.application("x-tika-msoffice-embedded");
    public static final MediaType OLE10_NATIVE = new MediaType(GENERAL_EMBEDDED, "format", "ole10_native");
    public static final MediaType COMP_OBJ = new MediaType(GENERAL_EMBEDDED, "format", "comp_obj");
    public static final MediaType MS_GRAPH_CHART = MediaType.application("vnd.ms-graph");
    public static final MediaType XLS = MediaType.application("vnd.ms-excel");
    public static final MediaType DOC = MediaType.application("msword");
    public static final MediaType PPT = MediaType.application("vnd.ms-powerpoint");
    public static final MediaType PUB = MediaType.application("x-mspublisher");
    public static final MediaType VSD = MediaType.application("vnd.visio");
    public static final MediaType WPS = MediaType.application("vnd.ms-works");
    public static final MediaType XLR = MediaType.application("x-tika-msworks-spreadsheet");
    public static final MediaType MSG = MediaType.application("vnd.ms-outlook");
    public static final MediaType MPP = MediaType.application("vnd.ms-project");
    public static final MediaType SDC = MediaType.application("vnd.stardivision.calc");
    public static final MediaType SDA = MediaType.application("vnd.stardivision.draw");
    public static final MediaType SDD = MediaType.application("vnd.stardivision.impress");
    public static final MediaType SDW = MediaType.application("vnd.stardivision.writer");
    public static final MediaType SLDWORKS = MediaType.application("sldworks");
    public static final MediaType HWP = MediaType.application("x-hwp-v5");
    private static final long serialVersionUID = -3028021741663605293L;
    private static final byte[] STAR_IMPRESS = new byte[]{83, 116, 97, 114, 73, 109, 112, 114, 101, 115, 115};
    private static final byte[] STAR_DRAW = new byte[]{83, 116, 97, 114, 68, 114, 97, 119};
    private static final byte[] WORKS_QUILL96 = new byte[]{81, 117, 105, 108, 108, 57, 54};
    private static final byte[] MS_GRAPH_CHART_BYTES = new byte[]{77, 83, 71, 114, 97, 112, 104, 46, 67, 104, 97, 114, 116};
    private static final Pattern mppDataMatch = Pattern.compile("\\s\\s\\s\\d+");

    protected static MediaType detect(Set<String> names) {
        return POIFSContainerDetector.detect(names, null);
    }

    protected static MediaType detect(Set<String> names, DirectoryEntry root) {
        block33: {
            if (names == null) break block33;
            if (names.contains("SwDocContentMgr") && names.contains("SwDocMgrTempStorage")) {
                return SLDWORKS;
            }
            if (names.contains("StarCalcDocument")) {
                return SDC;
            }
            if (names.contains("StarWriterDocument")) {
                return SDW;
            }
            if (names.contains("StarDrawDocument3")) {
                if (root == null) {
                    return OLE;
                }
                return POIFSContainerDetector.processCompObjFormatType(root);
            }
            if (names.contains("\u0005HwpSummaryInformation")) {
                return HWP;
            }
            if (names.contains("WksSSWorkBook")) {
                return XLR;
            }
            if (names.contains("Workbook") || names.contains("WORKBOOK")) {
                MediaType tmp = POIFSContainerDetector.processCompObjFormatType(root);
                if (tmp.equals(MS_GRAPH_CHART)) {
                    return MS_GRAPH_CHART;
                }
                return XLS;
            }
            if (names.contains("Book")) {
                return XLS;
            }
            if (names.contains("EncryptedPackage") && names.contains("EncryptionInfo") && names.contains("\u0006DataSpaces")) {
                return OOXML_PROTECTED;
            }
            if (names.contains("EncryptedPackage")) {
                return OLE;
            }
            if (names.contains("WordDocument")) {
                return DOC;
            }
            if (names.contains("Quill")) {
                return PUB;
            }
            if (names.contains("PowerPoint Document")) {
                return PPT;
            }
            if (names.contains("VisioDocument")) {
                return VSD;
            }
            if (names.contains("\u0001Ole10Native")) {
                return OLE10_NATIVE;
            }
            if (names.contains("MatOST")) {
                return WPS;
            }
            if (names.contains("CONTENTS") && names.contains("SPELLING")) {
                return WPS;
            }
            if (names.contains("Contents") && names.contains("\u0003ObjInfo")) {
                return COMP_OBJ;
            }
            if (names.contains("CONTENTS") && names.contains("\u0001CompObj")) {
                if (root != null) {
                    MediaType type = POIFSContainerDetector.processCompObjFormatType(root);
                    if (type == WPS) {
                        return WPS;
                    }
                    return COMP_OBJ;
                }
                return COMP_OBJ;
            }
            if (names.contains("CONTENTS")) {
                return OLE;
            }
            if (names.contains("\u0001CompObj") && (names.contains("Props") || names.contains("Props9") || names.contains("Props12"))) {
                for (String name : names) {
                    if (!mppDataMatch.matcher(name).matches()) continue;
                    return MPP;
                }
            } else if (names.contains("PerfectOffice_MAIN")) {
                if (names.contains("SlideShow")) {
                    return MediaType.application("x-corelpresentations");
                }
                if (names.contains("PerfectOffice_OBJECTS")) {
                    return MediaType.application("x-quattro-pro");
                }
            } else {
                if (names.contains("NativeContent_MAIN")) {
                    return MediaType.application("x-quattro-pro");
                }
                for (String name : names) {
                    if (!name.startsWith("__substg1.0_")) continue;
                    return MSG;
                }
            }
        }
        return OLE;
    }

    private static MediaType processCompObjFormatType(DirectoryEntry root) {
        try {
            Entry e = root.getEntry("\u0001CompObj");
            if (e != null && e.isDocumentEntry()) {
                DocumentNode dn = (DocumentNode)e;
                DocumentInputStream stream = new DocumentInputStream(dn);
                byte[] bytes = IOUtils.toByteArray(stream);
                if (POIFSContainerDetector.arrayContains(bytes, MS_GRAPH_CHART_BYTES)) {
                    return MS_GRAPH_CHART;
                }
                if (POIFSContainerDetector.arrayContains(bytes, STAR_DRAW)) {
                    return SDA;
                }
                if (POIFSContainerDetector.arrayContains(bytes, STAR_IMPRESS)) {
                    return SDD;
                }
                if (POIFSContainerDetector.arrayContains(bytes, WORKS_QUILL96)) {
                    return WPS;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OLE;
    }

    private static boolean arrayContains(byte[] larger, byte[] smaller) {
        int largerCounter = 0;
        int smallerCounter = 0;
        while (largerCounter < larger.length) {
            if (larger[largerCounter] == smaller[smallerCounter]) {
                ++largerCounter;
                if (++smallerCounter != smaller.length) continue;
                return true;
            }
            largerCounter = largerCounter - smallerCounter + 1;
            smallerCounter = 0;
        }
        return false;
    }

    private static Set<String> getTopLevelNames(TikaInputStream stream) throws IOException {
        File file = stream.getFile();
        try {
            NPOIFSFileSystem fs = new NPOIFSFileSystem(file, true);
            stream.setOpenContainer(fs);
            return POIFSContainerDetector.getTopLevelNames(fs.getRoot());
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
        catch (RuntimeException e) {
            return Collections.emptySet();
        }
    }

    private static Set<String> getTopLevelNames(DirectoryNode root) {
        HashSet<String> names = new HashSet<String>();
        for (Entry entry : root) {
            names.add(entry.getName());
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        TikaInputStream tis = TikaInputStream.cast(input);
        Set<String> names = null;
        if (tis != null) {
            Object container = tis.getOpenContainer();
            if (container instanceof NPOIFSFileSystem) {
                names = POIFSContainerDetector.getTopLevelNames(((NPOIFSFileSystem)container).getRoot());
            } else if (container instanceof DirectoryNode) {
                names = POIFSContainerDetector.getTopLevelNames((DirectoryNode)container);
            }
        }
        if (names == null) {
            input.mark(8);
            try {
                if (input.read() != 208 || input.read() != 207 || input.read() != 17 || input.read() != 224 || input.read() != 161 || input.read() != 177 || input.read() != 26 || input.read() != 225) {
                    MediaType mediaType = MediaType.OCTET_STREAM;
                    return mediaType;
                }
            }
            finally {
                input.reset();
            }
        }
        if (names == null && tis != null) {
            names = POIFSContainerDetector.getTopLevelNames(tis);
        }
        if (tis != null && tis.getOpenContainer() != null && tis.getOpenContainer() instanceof NPOIFSFileSystem) {
            return POIFSContainerDetector.detect(names, ((NPOIFSFileSystem)tis.getOpenContainer()).getRoot());
        }
        return POIFSContainerDetector.detect(names, null);
    }
}

