/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.PropertyValue;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.util.CodePageUtil;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.html.HtmlEncodingDetector;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.parser.mbox.MboxParser;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.parser.rtf.RTFParser;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public class OutlookExtractor
extends AbstractPOIFSExtractor {
    private static Pattern HEADER_KEY_PAT = Pattern.compile("\\A([\\x21-\\x39\\x3B-\\x7E]+):(.*?)\\Z");
    private static final Metadata EMPTY_METADATA = new Metadata();
    HtmlEncodingDetector detector = new HtmlEncodingDetector();
    private final MAPIMessage msg;

    public OutlookExtractor(NPOIFSFileSystem filesystem, ParseContext context) throws TikaException {
        this(filesystem.getRoot(), context);
    }

    public OutlookExtractor(DirectoryNode root, ParseContext context) throws TikaException {
        super(context);
        try {
            this.msg = new MAPIMessage(root);
        }
        catch (IOException e) {
            throw new TikaException("Failed to parse Outlook message", e);
        }
    }

    public void parse(XHTMLContentHandler xhtml, Metadata metadata) throws TikaException, SAXException, IOException {
        try {
            String from;
            String subject;
            block39: {
                String[] headers2;
                this.msg.setReturnNullOnMissingChunk(true);
                if (this.msg.has7BitEncodingStrings()) {
                    this.guess7BitEncoding(this.msg);
                }
                subject = this.msg.getSubject();
                from = this.msg.getDisplayFrom();
                metadata.set(TikaCoreProperties.CREATOR, from);
                metadata.set("Message-From", from);
                metadata.set("Message-To", this.msg.getDisplayTo());
                metadata.set("Message-Cc", this.msg.getDisplayCC());
                metadata.set("Message-Bcc", this.msg.getDisplayBCC());
                metadata.set(TikaCoreProperties.TITLE, subject);
                metadata.set(TikaCoreProperties.TRANSITION_SUBJECT_TO_DC_DESCRIPTION, this.msg.getConversationTopic());
                try {
                    for (String recipientAddress : this.msg.getRecipientEmailAddressList()) {
                        if (recipientAddress == null) continue;
                        metadata.add("Message-Recipient-Address", recipientAddress);
                    }
                }
                catch (ChunkNotFoundException arr$) {
                    // empty catch block
                }
                try {
                    headers2 = this.normalizeHeaders(this.msg.getHeaders());
                    for (Map.Entry<String, String[]> e : headers2.entrySet()) {
                        String headerKey = e.getKey();
                        for (String headerValue : e.getValue()) {
                            metadata.add("Message:Raw-Header:" + headerKey, headerValue);
                        }
                    }
                }
                catch (ChunkNotFoundException headers2) {
                    // empty catch block
                }
                if (this.msg.getMessageDate() != null) {
                    metadata.set(TikaCoreProperties.CREATED, this.msg.getMessageDate().getTime());
                    metadata.set(TikaCoreProperties.MODIFIED, this.msg.getMessageDate().getTime());
                } else {
                    try {
                        headers2 = this.msg.getHeaders();
                        if (headers2 == null || headers2.length <= 0) break block39;
                        for (String header : headers2) {
                            if (!header.toLowerCase(Locale.ROOT).startsWith("date:")) continue;
                            String date = header.substring(header.indexOf(58) + 1).trim();
                            try {
                                Date d = MboxParser.parseDate(date);
                                metadata.set(TikaCoreProperties.CREATED, d);
                                metadata.set(TikaCoreProperties.MODIFIED, d);
                            }
                            catch (ParseException e) {
                                metadata.set(TikaCoreProperties.CREATED, date);
                                metadata.set(TikaCoreProperties.MODIFIED, date);
                            }
                            break;
                        }
                    }
                    catch (ChunkNotFoundException headers3) {
                        // empty catch block
                    }
                }
            }
            xhtml.element("h1", subject);
            xhtml.startElement("dl");
            if (from != null) {
                this.header(xhtml, "From", from);
            }
            this.header(xhtml, "To", this.msg.getDisplayTo());
            this.header(xhtml, "Cc", this.msg.getDisplayCC());
            this.header(xhtml, "Bcc", this.msg.getDisplayBCC());
            try {
                this.header(xhtml, "Recipients", this.msg.getRecipientEmailAddress());
            }
            catch (ChunkNotFoundException headers3) {
                // empty catch block
            }
            xhtml.endElement("dl");
            Chunk htmlChunk = null;
            Chunk rtfChunk = null;
            Chunk textChunk = null;
            for (Chunk chunk : this.msg.getMainChunks().getChunks()) {
                if (chunk.getChunkId() == MAPIProperty.BODY_HTML.id) {
                    htmlChunk = chunk;
                }
                if (chunk.getChunkId() == MAPIProperty.RTF_COMPRESSED.id) {
                    rtfChunk = chunk;
                }
                if (chunk.getChunkId() != MAPIProperty.BODY.id) continue;
                textChunk = chunk;
            }
            boolean doneBody = false;
            xhtml.startElement("div", "class", "message-body");
            if (htmlChunk != null) {
                byte[] data = null;
                if (htmlChunk instanceof ByteChunk) {
                    data = ((ByteChunk)htmlChunk).getValue();
                } else if (htmlChunk instanceof StringChunk) {
                    data = ((StringChunk)htmlChunk).getRawValue();
                }
                if (data != null) {
                    HtmlParser htmlParser = new HtmlParser();
                    htmlParser.parse(new ByteArrayInputStream(data), new EmbeddedContentHandler(new BodyContentHandler(xhtml)), new Metadata(), new ParseContext());
                    doneBody = true;
                }
            }
            if (rtfChunk != null && !doneBody) {
                ByteChunk chunk = (ByteChunk)rtfChunk;
                MAPIRtfAttribute rtf = new MAPIRtfAttribute(MAPIProperty.RTF_COMPRESSED, Types.BINARY.getId(), chunk.getValue());
                RTFParser rtfParser = new RTFParser();
                rtfParser.parse(new ByteArrayInputStream(rtf.getData()), new EmbeddedContentHandler(new BodyContentHandler(xhtml)), new Metadata(), new ParseContext());
                doneBody = true;
            }
            if (textChunk != null && !doneBody) {
                xhtml.element("p", ((StringChunk)textChunk).getValue());
            }
            xhtml.endElement("div");
            for (AttachmentChunks attachment : this.msg.getAttachmentFiles()) {
                xhtml.startElement("div", "class", "attachment-entry");
                String filename = null;
                if (attachment.attachLongFileName != null) {
                    filename = attachment.attachLongFileName.getValue();
                } else if (attachment.attachFileName != null) {
                    filename = attachment.attachFileName.getValue();
                }
                if (filename != null && filename.length() > 0) {
                    xhtml.element("h1", filename);
                }
                if (attachment.attachData != null) {
                    this.handleEmbeddedResource(TikaInputStream.get(attachment.attachData.getValue()), filename, null, null, xhtml, true);
                }
                if (attachment.attachmentDirectory != null) {
                    this.handleEmbeddedOfficeDoc(attachment.attachmentDirectory.getDirectory(), xhtml);
                }
                xhtml.endElement("div");
            }
        }
        catch (ChunkNotFoundException e) {
            throw new TikaException("POI MAPIMessage broken - didn't return null on missing chunk", e);
        }
    }

    private Map<String, String[]> normalizeHeaders(String[] rows) {
        LinkedHashMap<String, String[]> ret = new LinkedHashMap<String, String[]>();
        if (rows == null) {
            return ret;
        }
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, List> headers = new LinkedHashMap<String, List>();
        Matcher headerKeyMatcher = HEADER_KEY_PAT.matcher("");
        String lastKey = null;
        int consec = 0;
        for (String row : rows) {
            headerKeyMatcher.reset(row);
            if (headerKeyMatcher.find()) {
                if (lastKey != null) {
                    List vals = (List)headers.get(lastKey);
                    vals = vals == null ? new ArrayList() : vals;
                    vals.add(this.decodeHeader(sb.toString()));
                    headers.put(lastKey, vals);
                }
                sb.setLength(0);
                lastKey = headerKeyMatcher.group(1).trim();
                sb.append(headerKeyMatcher.group(2).trim());
                consec = 0;
            } else {
                if (consec > 0) {
                    sb.append("\n");
                }
                sb.append(row);
            }
            ++consec;
        }
        if (sb.length() > 0 && lastKey != null) {
            List vals = (List)headers.get(lastKey);
            vals = vals == null ? new ArrayList() : vals;
            vals.add(this.decodeHeader(sb.toString()));
            headers.put(lastKey, vals);
        }
        for (Map.Entry e : headers.entrySet()) {
            ret.put((String)e.getKey(), ((List)e.getValue()).toArray(new String[((List)e.getValue()).size()]));
        }
        return ret;
    }

    private String decodeHeader(String header) {
        return DecoderUtil.decodeEncodedWords(header, DecodeMonitor.SILENT);
    }

    private void header(XHTMLContentHandler xhtml, String key, String value) throws SAXException {
        if (value != null && value.length() > 0) {
            xhtml.element("dt", key);
            xhtml.element("dd", value);
        }
    }

    private void guess7BitEncoding(MAPIMessage msg) {
        Chunks mainChunks;
        block16: {
            mainChunks = msg.getMainChunks();
            if (mainChunks == null) {
                return;
            }
            Map<MAPIProperty, List<PropertyValue>> props = mainChunks.getProperties();
            if (props != null) {
                for (MAPIProperty prop : new MAPIProperty[]{MAPIProperty.MESSAGE_CODEPAGE, MAPIProperty.INTERNET_CPID}) {
                    List<PropertyValue> val = props.get(prop);
                    if (val == null || val.size() <= 0) continue;
                    int codepage = ((PropertyValue.LongPropertyValue)val.get(0)).getValue();
                    String encoding = null;
                    try {
                        encoding = CodePageUtil.codepageToEncoding(codepage, true);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (!this.tryToSet7BitEncoding(msg, encoding)) continue;
                    return;
                }
            }
            try {
                String[] headers = msg.getHeaders();
                if (headers != null && headers.length > 0) {
                    Pattern p = Pattern.compile("Content-Type:.*?charset=[\"']?([^;'\"]+)[\"']?", 2);
                    for (String header : headers) {
                        String charset;
                        Matcher m;
                        if (!header.startsWith("Content-Type") || !(m = p.matcher(header)).matches() || !this.tryToSet7BitEncoding(msg, charset = m.group(1))) continue;
                        return;
                    }
                }
            }
            catch (ChunkNotFoundException headers) {
                // empty catch block
            }
            try {
                String html = msg.getHtmlBody();
                if (html == null || html.length() <= 0) break block16;
                Charset charset = null;
                try {
                    charset = this.detector.detect(new ByteArrayInputStream(html.getBytes(StandardCharsets.UTF_8)), EMPTY_METADATA);
                }
                catch (IOException arr$) {
                    // empty catch block
                }
                if (charset != null && this.tryToSet7BitEncoding(msg, charset.name())) {
                    return;
                }
            }
            catch (ChunkNotFoundException html) {
                // empty catch block
            }
        }
        StringChunk text = mainChunks.textBodyChunk;
        if (text != null) {
            CharsetDetector detector = new CharsetDetector();
            detector.setText(text.getRawValue());
            CharsetMatch match = detector.detect();
            if (match != null && match.getConfidence() > 35 && this.tryToSet7BitEncoding(msg, match.getName())) {
                return;
            }
        }
    }

    private boolean tryToSet7BitEncoding(MAPIMessage msg, String charsetName) {
        if (charsetName == null) {
            return false;
        }
        if (charsetName.equalsIgnoreCase("utf-8")) {
            return false;
        }
        try {
            if (Charset.isSupported(charsetName)) {
                msg.set7BitEncoding(charsetName);
                return true;
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }
}

