/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.jdbc.SQLite3DBParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SQLite3Parser
extends AbstractParser {
    private static final long serialVersionUID = -752276948656079347L;
    private static final MediaType MEDIA_TYPE = MediaType.application("x-sqlite3");
    private final Set<MediaType> SUPPORTED_TYPES;

    public SQLite3Parser() {
        Set<MediaType> tmp;
        try {
            Class.forName("org.sqlite.JDBC");
            tmp = Collections.singleton(MEDIA_TYPE);
        }
        catch (ClassNotFoundException e) {
            tmp = Collections.EMPTY_SET;
        }
        this.SUPPORTED_TYPES = tmp;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        SQLite3DBParser p = new SQLite3DBParser();
        p.parse(stream, handler, metadata, context);
    }
}

