/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Database;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.jdbc.AbstractDBParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class JDBCTableReader {
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private final Connection connection;
    private final String tableName;
    int maxClobLength = 1000000;
    ResultSet results = null;
    int rows = 0;
    private TikaConfig tikaConfig = null;
    private Detector detector = null;
    private MimeTypes mimeTypes = null;

    public JDBCTableReader(Connection connection, String tableName, ParseContext context) {
        this.connection = connection;
        this.tableName = tableName;
        this.tikaConfig = context.get(TikaConfig.class);
    }

    public boolean nextRow(ContentHandler handler, ParseContext context) throws IOException, SAXException {
        if (this.results == null) {
            this.reset();
        }
        try {
            if (!this.results.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            throw new IOExceptionWithCause(e);
        }
        try {
            ResultSetMetaData meta = this.results.getMetaData();
            handler.startElement("http://www.w3.org/1999/xhtml", "tr", "tr", EMPTY_ATTRIBUTES);
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                handler.startElement("http://www.w3.org/1999/xhtml", "td", "td", EMPTY_ATTRIBUTES);
                this.handleCell(meta, i, handler, context);
                handler.endElement("http://www.w3.org/1999/xhtml", "td", "td");
            }
            handler.endElement("http://www.w3.org/1999/xhtml", "tr", "tr");
        }
        catch (SQLException e) {
            throw new IOExceptionWithCause(e);
        }
        ++this.rows;
        return true;
    }

    private void handleCell(ResultSetMetaData rsmd, int i, ContentHandler handler, ParseContext context) throws SQLException, IOException, SAXException {
        switch (rsmd.getColumnType(i)) {
            case 2004: {
                this.handleBlob(this.tableName, rsmd.getColumnName(i), this.rows, this.results, i, handler, context);
                break;
            }
            case 2005: {
                this.handleClob(this.tableName, rsmd.getColumnName(i), this.rows, this.results, i, handler, context);
                break;
            }
            case 16: {
                this.handleBoolean(this.results, i, handler);
                break;
            }
            case 91: {
                this.handleDate(this.results, i, handler);
                break;
            }
            case 93: {
                this.handleTimeStamp(this.results, i, handler);
                break;
            }
            case 4: {
                this.handleInteger(this.results, i, handler);
                break;
            }
            case 6: {
                float f = this.results.getFloat(i);
                if (this.results.wasNull()) break;
                this.addAllCharacters(Float.toString(f), handler);
                break;
            }
            case 8: {
                double d = this.results.getDouble(i);
                if (this.results.wasNull()) break;
                this.addAllCharacters(Double.toString(d), handler);
                break;
            }
            default: {
                String s = this.results.getString(i);
                if (this.results.wasNull()) break;
                this.addAllCharacters(s, handler);
            }
        }
    }

    public List<String> getHeaders() throws IOException {
        LinkedList<String> headers = new LinkedList<String>();
        if (this.results == null) {
            this.reset();
        }
        try {
            ResultSetMetaData meta = this.results.getMetaData();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                headers.add(meta.getColumnName(i));
            }
        }
        catch (SQLException e) {
            throw new IOExceptionWithCause(e);
        }
        return headers;
    }

    protected void handleInteger(ResultSet rs, int columnIndex, ContentHandler handler) throws SQLException, SAXException {
        int i = rs.getInt(columnIndex);
        if (!rs.wasNull()) {
            this.addAllCharacters(Integer.toString(i), handler);
        }
    }

    private void handleBoolean(ResultSet rs, int columnIndex, ContentHandler handler) throws SAXException, SQLException {
        boolean b = rs.getBoolean(columnIndex);
        if (!rs.wasNull()) {
            this.addAllCharacters(Boolean.toString(b), handler);
        }
    }

    protected void handleClob(String tableName, String columnName, int rowNum, ResultSet resultSet, int columnIndex, ContentHandler handler, ParseContext context) throws SQLException, IOException, SAXException {
        Clob clob = resultSet.getClob(columnIndex);
        if (resultSet.wasNull()) {
            return;
        }
        boolean truncated = clob.length() > Integer.MAX_VALUE || clob.length() > (long)this.maxClobLength;
        int readSize = clob.length() < (long)this.maxClobLength ? (int)clob.length() : this.maxClobLength;
        Metadata m = new Metadata();
        m.set(Database.TABLE_NAME, tableName);
        m.set(Database.COLUMN_NAME, columnName);
        m.set("database:ROW_NUM", Integer.toString(rowNum));
        m.set("database:IS_CLOB", "true");
        m.set("database:CLOB_LENGTH", Long.toString(clob.length()));
        m.set("database:IS_CLOB_TRUNCATED", Boolean.toString(truncated));
        m.set("Content-Type", "text/plain; charset=UTF-8");
        m.set("Content-Length", Integer.toString(readSize));
        m.set("resourceName", FilenameUtils.normalize(FilenameUtils.getName(columnName + "_" + rowNum + ".txt")));
        String s = clob.getSubString(0L, readSize);
        EmbeddedDocumentExtractor ex = AbstractDBParser.getEmbeddedDocumentExtractor(context);
        ex.parseEmbedded(new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)), handler, m, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleBlob(String tableName, String columnName, int rowNum, ResultSet resultSet, int columnIndex, ContentHandler handler, ParseContext context) throws SQLException, IOException, SAXException {
        TikaInputStream is;
        block14: {
            EmbeddedDocumentExtractor ex;
            Blob blob;
            Metadata m;
            block12: {
                block13: {
                    m = new Metadata();
                    m.set(Database.TABLE_NAME, tableName);
                    m.set(Database.COLUMN_NAME, columnName);
                    m.set("database:ROW_NUM", Integer.toString(rowNum));
                    m.set("database:IS_BLOB", "true");
                    blob = null;
                    is = null;
                    ex = AbstractDBParser.getEmbeddedDocumentExtractor(context);
                    try {
                        blob = this.getBlob(resultSet, columnIndex, m);
                        if (blob != null) break block12;
                        if (blob == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (blob != null) {
                            try {
                                blob.free();
                            }
                            catch (UnsupportedOperationException | SQLException exception) {
                                // empty catch block
                            }
                        }
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    try {
                        blob.free();
                    }
                    catch (UnsupportedOperationException | SQLException exception) {
                        // empty catch block
                    }
                }
                IOUtils.closeQuietly(is);
                return;
            }
            is = TikaInputStream.get(blob, m);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "type", "type", "CDATA", "blob");
            attrs.addAttribute("", "column_name", "column_name", "CDATA", columnName);
            attrs.addAttribute("", "row_number", "row_number", "CDATA", Integer.toString(rowNum));
            handler.startElement("", "span", "span", attrs);
            MediaType mediaType = this.getDetector().detect(is, new Metadata());
            String extension = "";
            try {
                MimeType mimeType = this.getMimeTypes().forName(mediaType.toString());
                m.set("Content-Type", mimeType.toString());
                extension = mimeType.getExtension();
            }
            catch (MimeTypeException mimeTypeException) {
                // empty catch block
            }
            m.set("resourceName", FilenameUtils.normalize(FilenameUtils.getName(columnName + "_" + rowNum + extension)));
            ex.parseEmbedded(is, handler, m, true);
            if (blob == null) break block14;
            try {
                blob.free();
            }
            catch (UnsupportedOperationException | SQLException exception) {
                // empty catch block
            }
        }
        IOUtils.closeQuietly(is);
        handler.endElement("", "span", "span");
    }

    protected Blob getBlob(ResultSet resultSet, int columnIndex, Metadata metadata) throws SQLException {
        Blob blob = resultSet.getBlob(columnIndex);
        if (!resultSet.wasNull()) {
            return blob;
        }
        return null;
    }

    protected void handleDate(ResultSet resultSet, int columnIndex, ContentHandler handler) throws SAXException, SQLException {
        this.addAllCharacters(resultSet.getString(columnIndex), handler);
    }

    protected void handleTimeStamp(ResultSet resultSet, int columnIndex, ContentHandler handler) throws SAXException, SQLException {
        this.addAllCharacters(resultSet.getString(columnIndex), handler);
    }

    protected void addAllCharacters(String s, ContentHandler handler) throws SAXException {
        if (s == null) {
            return;
        }
        char[] chars = s.toCharArray();
        handler.characters(chars, 0, chars.length);
    }

    void reset() throws IOException {
        if (this.results != null) {
            try {
                this.results.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        String sql = "SELECT * from " + this.tableName;
        try {
            Statement st = this.connection.createStatement();
            this.results = st.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new IOExceptionWithCause(e);
        }
        this.rows = 0;
    }

    public String getTableName() {
        return this.tableName;
    }

    protected TikaConfig getTikaConfig() {
        if (this.tikaConfig == null) {
            this.tikaConfig = TikaConfig.getDefaultConfig();
        }
        return this.tikaConfig;
    }

    protected Detector getDetector() {
        if (this.detector != null) {
            return this.detector;
        }
        this.detector = this.getTikaConfig().getDetector();
        return this.detector;
    }

    protected MimeTypes getMimeTypes() {
        if (this.mimeTypes != null) {
            return this.mimeTypes;
        }
        this.mimeTypes = this.getTikaConfig().getMimeRepository();
        return this.mimeTypes;
    }
}

