/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iwork.iwana;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class IWork13PackageParser
extends AbstractParser {
    public static final String IWORK13_COMMON_ENTRY = "Metadata/BuildVersionHistory.plist";
    private static final Set<MediaType> supportedTypes = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(IWork13DocumentType.KEYNOTE13.getType(), IWork13DocumentType.NUMBERS13.getType(), IWork13DocumentType.PAGES13.getType())));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return supportedTypes;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
    }

    public static enum IWork13DocumentType {
        KEYNOTE13(MediaType.application("vnd.apple.keynote.13")),
        NUMBERS13(MediaType.application("vnd.apple.numbers.13")),
        PAGES13(MediaType.application("vnd.apple.pages.13")),
        UNKNOWN13(MediaType.application("vnd.apple.unknown.13"));

        private final MediaType mediaType;

        private IWork13DocumentType(MediaType mediaType) {
            this.mediaType = mediaType;
        }

        public MediaType getType() {
            return this.mediaType;
        }

        public static MediaType detect(ZipFile zipFile) {
            ZipArchiveEntry entry = zipFile.getEntry("Index/MasterSlide.iwa");
            if (zipFile.getEntry("Index/MasterSlide.iwa") != null || zipFile.getEntry("Index/Slide.iwa") != null) {
                return KEYNOTE13.getType();
            }
            return UNKNOWN13.getType();
        }
    }
}

