/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.Deque;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.sis.internal.jaxb.AdapterReplacement;
import org.apache.sis.internal.jaxb.TypeRegistration;
import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.xml.Pooled;
import org.apache.sis.xml.PooledMarshaller;
import org.apache.sis.xml.PooledTemplate;
import org.apache.sis.xml.PooledUnmarshaller;

public class MarshallerPool {
    private static final String INDENTATION = "  ";
    private static final long TIMEOUT = 15000000000L;
    private static final byte INTERNAL = 0;
    private static final byte ENDORSED = 1;
    private static final byte OTHER = 2;
    private final JAXBContext context;
    private final byte implementation;
    private final Object mapper;
    private final ServiceLoader<AdapterReplacement> replacements;
    private final PooledTemplate template;
    private final Deque<Marshaller> marshallers;
    private final Deque<Unmarshaller> unmarshallers;
    private final AtomicBoolean isRemovalScheduled;

    public MarshallerPool(Map<String, ?> map) throws JAXBException {
        this(TypeRegistration.getSharedContext(), map);
    }

    public MarshallerPool(JAXBContext jAXBContext, Map<String, ?> map) throws JAXBException {
        ArgumentChecks.ensureNonNull("context", jAXBContext);
        this.context = jAXBContext;
        this.replacements = ServiceLoader.load(AdapterReplacement.class);
        String string = jAXBContext.getClass().getName();
        if (string.startsWith("com.sun.xml.internal.bind.")) {
            string = "org.apache.sis.xml.OGCNamespacePrefixMapper";
            this.implementation = 0;
        } else if (string.startsWith("com.sun.xml.bind.")) {
            string = "org.apache.sis.xml.OGCNamespacePrefixMapper_Endorsed";
            this.implementation = 1;
        } else {
            string = null;
            this.implementation = (byte)2;
        }
        this.template = new PooledTemplate(map, this.implementation == 0);
        String string2 = this.template.remove("org.apache.sis.xml.defaultNamespace", "");
        if (string == null) {
            this.mapper = null;
        } else {
            try {
                this.mapper = Class.forName(string).getConstructor(String.class).newInstance(string2);
            }
            catch (Throwable throwable) {
                throw new JAXBException(throwable);
            }
        }
        this.marshallers = new LinkedBlockingDeque<Marshaller>();
        this.unmarshallers = new LinkedBlockingDeque<Unmarshaller>();
        this.isRemovalScheduled = new AtomicBoolean();
    }

    private <T> void recycle(Deque<T> deque, T t) {
        try {
            ((Pooled)t).reset(this.template);
        }
        catch (JAXBException jAXBException) {
            Logging.unexpectedException(Logging.getLogger("org.apache.sis.xml"), MarshallerPool.class, "recycle", jAXBException);
            return;
        }
        deque.push(t);
        this.scheduleRemoval();
    }

    private void scheduleRemoval() {
        if (this.isRemovalScheduled.compareAndSet(false, true)) {
            DelayedExecutor.schedule(new DelayedRunnable(System.nanoTime() + 30000000000L){

                @Override
                public void run() {
                    MarshallerPool.this.removeExpired();
                }
            });
        }
    }

    final void removeExpired() {
        this.isRemovalScheduled.set(false);
        long l = System.nanoTime();
        if (!MarshallerPool.removeExpired(this.marshallers, l) | !MarshallerPool.removeExpired(this.unmarshallers, l)) {
            this.scheduleRemoval();
        }
    }

    private static <T> boolean removeExpired(Deque<T> deque, long l) {
        T t;
        while ((t = deque.peekLast()) != null) {
            if (l - ((Pooled)t).resetTime < 15000000000L) {
                return false;
            }
            t = deque.pollLast();
            if (l - ((Pooled)t).resetTime >= 15000000000L) continue;
            deque.addLast(t);
            return false;
        }
        return true;
    }

    public Marshaller acquireMarshaller() throws JAXBException {
        Marshaller marshaller = this.marshallers.poll();
        if (marshaller == null) {
            marshaller = new PooledMarshaller(this.createMarshaller(), this.template);
        }
        return marshaller;
    }

    public Unmarshaller acquireUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = this.unmarshallers.poll();
        if (unmarshaller == null) {
            unmarshaller = new PooledUnmarshaller(this.createUnmarshaller(), this.template);
        }
        return unmarshaller;
    }

    public void recycle(Marshaller marshaller) {
        this.recycle(this.marshallers, marshaller);
    }

    public void recycle(Unmarshaller unmarshaller) {
        this.recycle(this.unmarshallers, unmarshaller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = this.context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        switch (this.implementation) {
            case 0: {
                marshaller.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", this.mapper);
                marshaller.setProperty("com.sun.xml.internal.bind.indentString", (Object)INDENTATION);
                break;
            }
            case 1: {
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", this.mapper);
                marshaller.setProperty("com.sun.xml.bind.indentString", (Object)INDENTATION);
            }
        }
        ServiceLoader<AdapterReplacement> serviceLoader = this.replacements;
        synchronized (serviceLoader) {
            for (AdapterReplacement adapterReplacement : this.replacements) {
                adapterReplacement.register(marshaller);
            }
        }
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = this.context.createUnmarshaller();
        ServiceLoader<AdapterReplacement> serviceLoader = this.replacements;
        synchronized (serviceLoader) {
            for (AdapterReplacement adapterReplacement : this.replacements) {
                adapterReplacement.register(unmarshaller);
            }
        }
        return unmarshaller;
    }
}

