/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.AbstractMapEntry;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.iso.RecordDefinition;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.MemberName;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

public class DefaultRecord
implements Record,
Serializable {
    private static final long serialVersionUID = -5293250754663538325L;
    final RecordDefinition definition;
    private final Object values;

    public DefaultRecord(RecordType recordType) {
        ArgumentChecks.ensureNonNull("type", recordType);
        this.definition = recordType instanceof RecordDefinition ? (RecordDefinition)((Object)recordType) : new RecordDefinition.Adapter(recordType);
        this.values = Array.newInstance(this.definition.baseValueClass(), this.definition.size());
    }

    @Override
    public RecordType getRecordType() {
        return this.definition.getRecordType();
    }

    @Override
    public Map<MemberName, Object> getAttributes() {
        return new AbstractMap<MemberName, Object>(){

            @Override
            public int size() {
                return DefaultRecord.this.definition.size();
            }

            @Override
            public Object get(Object object) {
                return object instanceof MemberName ? DefaultRecord.this.locate((MemberName)object) : null;
            }

            @Override
            public Object put(MemberName memberName, Object object) {
                Object object2 = DefaultRecord.this.locate(memberName);
                DefaultRecord.this.set(memberName, object);
                return object2;
            }

            @Override
            public Set<Map.Entry<MemberName, Object>> entrySet() {
                return new Entries();
            }
        };
    }

    @Override
    public Object locate(MemberName memberName) {
        Integer n = this.definition.indexOf(memberName);
        return n != null ? Array.get(this.values, n) : null;
    }

    @Override
    public void set(MemberName memberName, Object object) {
        Class<?> clazz;
        Integer n = this.definition.indexOf(memberName);
        if (n == null) {
            throw new IllegalArgumentException(Errors.format((short)71, this.getRecordType().getTypeName(), memberName));
        }
        if (object != null && (clazz = this.definition.getValueClass(n)) != null && !clazz.isInstance(object)) {
            throw new ClassCastException(Errors.format((short)40, memberName, object.getClass()));
        }
        Array.set(this.values, n, object);
    }

    public void setAll(Object ... objectArray) {
        ArgumentChecks.ensureNonNull("values", objectArray);
        int n = Array.getLength(this.values);
        if (objectArray.length != n) {
            throw new IllegalArgumentException(Errors.format((short)107, n, objectArray.length));
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Class<?> clazz;
            Object object = objectArray[i];
            if (object != null && (clazz = this.definition.getValueClass(i)) != null && !clazz.isInstance(object)) {
                throw new ClassCastException(Errors.format((short)40, this.definition.getName(i), object.getClass()));
            }
            Array.set(this.values, i, object);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            DefaultRecord defaultRecord = (DefaultRecord)object;
            return this.definition.getRecordType().equals(defaultRecord.definition.getRecordType()) && Objects.deepEquals(this.values, defaultRecord.values);
        }
        return false;
    }

    public int hashCode() {
        return Utilities.deepHashCode(this.values) ^ this.definition.getRecordType().hashCode();
    }

    public String toString() {
        return this.definition.toString("Record", this.values);
    }

    private final class Entry
    extends AbstractMapEntry<MemberName, Object> {
        private final int index;

        Entry(int n) {
            this.index = n;
        }

        @Override
        public MemberName getKey() {
            return DefaultRecord.this.definition.getName(this.index);
        }

        @Override
        public Object getValue() {
            return DefaultRecord.this.locate(this.getKey());
        }

        @Override
        public Object setValue(Object object) {
            MemberName memberName = this.getKey();
            Object object2 = DefaultRecord.this.locate(memberName);
            DefaultRecord.this.set(memberName, object);
            return object2;
        }
    }

    private final class Iter
    implements Iterator<Map.Entry<MemberName, Object>> {
        private int index;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.index < DefaultRecord.this.definition.size();
        }

        @Override
        public Map.Entry<MemberName, Object> next() {
            if (this.hasNext()) {
                return new Entry(this.index++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class Entries
    extends AbstractSet<Map.Entry<MemberName, Object>> {
        private Entries() {
        }

        @Override
        public int size() {
            return DefaultRecord.this.definition.size();
        }

        @Override
        public Iterator<Map.Entry<MemberName, Object>> iterator() {
            return new Iter();
        }
    }
}

