/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.GeneralMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.matrix.Solver;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.Matrix;

public abstract class MatrixSIS
implements Matrix,
LenientComparable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3075280376118406219L;

    protected MatrixSIS() {
    }

    static void ensureLengthMatch(int n, double[] dArray) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("elements", dArray);
        if (dArray.length != n) {
            throw new IllegalArgumentException(Errors.format((short)107, n, dArray.length));
        }
    }

    static void ensureSizeMatch(int n, Matrix matrix) {
        int n2 = matrix.getNumRow();
        int n3 = matrix.getNumCol();
        if (n2 != n || n3 != n) {
            Integer n4 = n;
            throw new MismatchedMatrixSizeException(Errors.format((short)60, n4, n4, n2, n3));
        }
    }

    static void ensureNumRowMatch(int n, int n2, int n3) {
        if (n2 != n) {
            throw new MismatchedMatrixSizeException(Errors.format((short)60, n, "\u24a9", n2, n3));
        }
    }

    static IndexOutOfBoundsException indexOutOfBounds(int n, int n2) {
        return new IndexOutOfBoundsException(Errors.format((short)50, n, n2));
    }

    public static MatrixSIS castOrCopy(Matrix matrix) {
        if (matrix == null || matrix instanceof MatrixSIS) {
            return (MatrixSIS)matrix;
        }
        return Matrices.copy(matrix);
    }

    void get(int n, int n2, DoubleDouble doubleDouble) {
        doubleDouble.value = this.getElement(n, n2);
        doubleDouble.error = DoubleDouble.errorForWellKnownValue(doubleDouble.value);
    }

    void set(int n, int n2, DoubleDouble doubleDouble) {
        this.setElement(n, n2, doubleDouble.value);
    }

    public Number getNumber(int n, int n2) {
        return this.getElement(n, n2);
    }

    @Override
    public abstract double getElement(int var1, int var2);

    public double[] getElements() {
        int n = this.getNumRow();
        int n2 = this.getNumCol();
        double[] dArray = new double[n * n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[n3++] = this.getElement(i, j);
            }
        }
        return dArray;
    }

    void getElements(double[] dArray) {
        double[] dArray2 = this.getElements();
        System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
    }

    public abstract void setElements(double[] var1);

    public boolean isAffine() {
        return MatrixSIS.isAffine(this);
    }

    static boolean isAffine(Matrix matrix) {
        int n = matrix.getNumRow();
        int n2 = matrix.getNumCol();
        if (n2 != n--) {
            return false;
        }
        double d = 1.0;
        while (--n2 >= 0) {
            if (matrix.getElement(n, n2) != d) {
                return false;
            }
            d = 0.0;
        }
        return true;
    }

    @Override
    public abstract boolean isIdentity();

    public abstract void transpose();

    public void normalizeColumns() {
        int n = this.getNumRow();
        int n2 = this.getNumCol();
        DoubleDouble doubleDouble = new DoubleDouble();
        DoubleDouble doubleDouble2 = new DoubleDouble();
        DoubleDouble doubleDouble3 = new DoubleDouble();
        for (int i = 0; i < n2; ++i) {
            int n3;
            doubleDouble.clear();
            for (n3 = 0; n3 < n; ++n3) {
                this.get(n3, i, doubleDouble2);
                doubleDouble2.square();
                doubleDouble.add(doubleDouble2);
            }
            doubleDouble.sqrt();
            for (n3 = 0; n3 < n; ++n3) {
                this.get(n3, i, doubleDouble3);
                doubleDouble2.setFrom(doubleDouble);
                doubleDouble2.inverseDivide(doubleDouble3);
                this.set(n3, i, doubleDouble2);
            }
        }
    }

    public void convertBefore(int n, Number number, Number number2) {
        int n2 = this.getNumCol() - 1;
        ArgumentChecks.ensureValidIndex(n2, n);
        DoubleDouble doubleDouble = new DoubleDouble();
        DoubleDouble doubleDouble2 = new DoubleDouble();
        int n3 = this.getNumRow();
        while (--n3 >= 0) {
            if (number2 != null) {
                this.get(n3, n, doubleDouble);
                this.get(n3, n2, doubleDouble2);
                doubleDouble.multiply(number2);
                doubleDouble2.add(doubleDouble);
                this.set(n3, n2, doubleDouble2);
            }
            if (number == null) continue;
            this.get(n3, n, doubleDouble);
            doubleDouble.multiply(number);
            this.set(n3, n, doubleDouble);
        }
    }

    public void convertAfter(int n, Number number, Number number2) {
        int n2 = this.getNumRow() - 1;
        int n3 = this.getNumCol() - 1;
        ArgumentChecks.ensureValidIndex(n2, n);
        DoubleDouble doubleDouble = new DoubleDouble();
        if (number != null) {
            for (int i = n3; i >= 0; --i) {
                this.get(n, i, doubleDouble);
                doubleDouble.multiply(number);
                this.set(n, i, doubleDouble);
            }
        }
        if (number2 != null) {
            this.get(n, n3, doubleDouble);
            doubleDouble.add(number2);
            this.set(n, n3, doubleDouble);
        }
    }

    public MatrixSIS multiply(Matrix matrix) throws MismatchedMatrixSizeException {
        int n = matrix.getNumCol();
        MatrixSIS.ensureNumRowMatch(this.getNumCol(), matrix.getNumRow(), n);
        GeneralMatrix generalMatrix = GeneralMatrix.createExtendedPrecision(this.getNumRow(), n, false);
        generalMatrix.setToProduct(this, matrix);
        return generalMatrix;
    }

    public MatrixSIS solve(Matrix matrix) throws MismatchedMatrixSizeException, NoninvertibleMatrixException {
        return Solver.solve(this, matrix);
    }

    public MatrixSIS inverse() throws NoninvertibleMatrixException {
        return Solver.inverse(this, true);
    }

    public int hashCode() {
        return Arrays.hashCode(this.getElements()) ^ 0x63446C4B;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            int n = this.getNumRow();
            int n2 = this.getNumCol();
            MatrixSIS matrixSIS = (MatrixSIS)object;
            if (matrixSIS.getNumRow() == n && matrixSIS.getNumCol() == n2) {
                int n3 = n;
                while (--n3 >= 0) {
                    int n4 = n2;
                    while (--n4 >= 0) {
                        if (Numerics.equals(matrixSIS.getElement(n3, n4), this.getElement(n3, n4))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean equals(Matrix matrix, double d) {
        return Matrices.equals(this, matrix, d, false);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        return object instanceof Matrix && Matrices.equals(this, (Matrix)object, comparisonMode);
    }

    @Override
    public MatrixSIS clone() {
        try {
            return (MatrixSIS)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        return Matrices.toString(this);
    }
}

