/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.io.Serializable;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.operation.Formula;
import org.opengis.util.InternationalString;

public class DefaultFormula
extends FormattableObject
implements Formula,
Serializable {
    private static final long serialVersionUID = 1929966748615362698L;
    private final InternationalString formula;
    private final Citation citation;

    DefaultFormula(InternationalString internationalString, Citation citation) {
        this.formula = internationalString;
        this.citation = citation;
    }

    public DefaultFormula(CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("formula", charSequence);
        this.formula = Types.toInternationalString(charSequence);
        this.citation = null;
    }

    public DefaultFormula(Citation citation) {
        ArgumentChecks.ensureNonNull("citation", citation);
        this.citation = citation;
        this.formula = null;
    }

    protected DefaultFormula(Formula formula) {
        ArgumentChecks.ensureNonNull("formula", formula);
        this.citation = formula.getCitation();
        this.formula = formula.getFormula();
    }

    public static DefaultFormula castOrCopy(Formula formula) {
        return formula == null || formula instanceof DefaultFormula ? (DefaultFormula)formula : new DefaultFormula(formula);
    }

    @Override
    public InternationalString getFormula() {
        return this.formula;
    }

    @Override
    public Citation getCitation() {
        return this.citation;
    }

    public int hashCode() {
        int n = 1334364298;
        if (this.formula != null) {
            n += this.formula.hashCode();
        }
        if (this.citation != null) {
            n += this.citation.hashCode() * 31;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            DefaultFormula defaultFormula = (DefaultFormula)object;
            return Objects.equals(this.formula, defaultFormula.formula) && Objects.equals(this.citation, defaultFormula.citation);
        }
        return false;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        InternationalString internationalString = null;
        Citation citation = this.getCitation();
        if (citation != null) {
            internationalString = citation.getTitle();
        }
        if (internationalString == null) {
            internationalString = this.getFormula();
        }
        if (internationalString != null) {
            formatter.append(internationalString.toString(formatter.getLocale()), ElementKind.REMARKS);
        }
        formatter.setInvalidWKT(Formula.class, null);
        return "Formula";
    }
}

