/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AxisFilter;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public enum AxesConvention implements AxisFilter
{
    NORMALIZED{

        @Override
        public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
            return true;
        }

        @Override
        public Unit<?> getUnitReplacement(Unit<?> unit) {
            if (Units.isLinear(unit)) {
                unit = SI.METRE;
            } else if (Units.isAngular(unit)) {
                unit = NonSI.DEGREE_ANGLE;
            } else if (Units.isTemporal(unit)) {
                unit = NonSI.DAY;
            }
            return unit;
        }

        @Override
        public AxisDirection getDirectionReplacement(AxisDirection axisDirection) {
            return AxisDirections.isIntercardinal(axisDirection) ? axisDirection : AxisDirections.absolute(axisDirection);
        }
    }
    ,
    CONVENTIONALLY_ORIENTED{

        @Override
        public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
            return true;
        }

        @Override
        public Unit<?> getUnitReplacement(Unit<?> unit) {
            return unit;
        }

        @Override
        public AxisDirection getDirectionReplacement(AxisDirection axisDirection) {
            return AxisDirections.isIntercardinal(axisDirection) ? axisDirection : AxisDirections.absolute(axisDirection);
        }
    }
    ,
    RIGHT_HANDED{

        @Override
        public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
            return true;
        }

        @Override
        public Unit<?> getUnitReplacement(Unit<?> unit) {
            return unit;
        }

        @Override
        public AxisDirection getDirectionReplacement(AxisDirection axisDirection) {
            return axisDirection;
        }
    }
    ,
    POSITIVE_RANGE{

        @Override
        public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
            return true;
        }

        @Override
        public Unit<?> getUnitReplacement(Unit<?> unit) {
            return unit;
        }

        @Override
        public AxisDirection getDirectionReplacement(AxisDirection axisDirection) {
            return axisDirection;
        }
    };

}

