/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Comparator;
import java.util.Map;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.DefaultCompoundCRS;
import org.apache.sis.referencing.crs.DefaultDerivedCRS;
import org.apache.sis.referencing.crs.DefaultEngineeringCRS;
import org.apache.sis.referencing.crs.DefaultGeocentricCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultImageCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.GeodeticDatum;

final class SubTypes
implements Comparator<Object> {
    private static final Class<?>[] TYPE_ORDER = new Class[]{ProjectedCRS.class, GeodeticCRS.class, VerticalCRS.class, TemporalCRS.class};
    static final Comparator<Object> BY_TYPE = new SubTypes();

    private SubTypes() {
    }

    private static int indexOf(Object object) {
        int n;
        for (n = 0; n < TYPE_ORDER.length && !TYPE_ORDER[n].isInstance(object); ++n) {
        }
        return n;
    }

    @Override
    public int compare(Object object, Object object2) {
        return SubTypes.indexOf(object) - SubTypes.indexOf(object2);
    }

    static AbstractCRS castOrCopy(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof DerivedCRS) {
            return DefaultDerivedCRS.castOrCopy((DerivedCRS)coordinateReferenceSystem);
        }
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            return DefaultProjectedCRS.castOrCopy((ProjectedCRS)coordinateReferenceSystem);
        }
        if (coordinateReferenceSystem instanceof GeodeticCRS) {
            if (coordinateReferenceSystem instanceof GeographicCRS) {
                return DefaultGeographicCRS.castOrCopy((GeographicCRS)coordinateReferenceSystem);
            }
            if (coordinateReferenceSystem instanceof GeocentricCRS) {
                return DefaultGeocentricCRS.castOrCopy((GeocentricCRS)coordinateReferenceSystem);
            }
            Map<String, ?> map = IdentifiedObjects.getProperties(coordinateReferenceSystem, new String[0]);
            GeodeticDatum geodeticDatum = ((GeodeticCRS)coordinateReferenceSystem).getDatum();
            CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
            if (coordinateSystem instanceof EllipsoidalCS) {
                return new DefaultGeographicCRS(map, geodeticDatum, (EllipsoidalCS)coordinateSystem);
            }
            if (coordinateSystem instanceof SphericalCS) {
                return new DefaultGeocentricCRS(map, geodeticDatum, (SphericalCS)coordinateSystem);
            }
            if (coordinateSystem instanceof CartesianCS) {
                return new DefaultGeocentricCRS(map, geodeticDatum, (CartesianCS)coordinateSystem);
            }
        }
        if (coordinateReferenceSystem instanceof VerticalCRS) {
            return DefaultVerticalCRS.castOrCopy((VerticalCRS)coordinateReferenceSystem);
        }
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            return DefaultTemporalCRS.castOrCopy((TemporalCRS)coordinateReferenceSystem);
        }
        if (coordinateReferenceSystem instanceof EngineeringCRS) {
            return DefaultEngineeringCRS.castOrCopy((EngineeringCRS)coordinateReferenceSystem);
        }
        if (coordinateReferenceSystem instanceof ImageCRS) {
            return DefaultImageCRS.castOrCopy((ImageCRS)coordinateReferenceSystem);
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            return DefaultCompoundCRS.castOrCopy((CompoundCRS)coordinateReferenceSystem);
        }
        if (coordinateReferenceSystem == null || coordinateReferenceSystem instanceof AbstractCRS) {
            return (AbstractCRS)coordinateReferenceSystem;
        }
        return new AbstractCRS(coordinateReferenceSystem);
    }
}

