/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.measure.unit.NonSI;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.DefinitionURI;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultCompoundCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public final class CRS
extends Static {
    private CRS() {
    }

    public static CoordinateReferenceSystem forCode(String string) throws NoSuchAuthorityCodeException, FactoryException {
        String string2;
        String string3;
        Object object;
        ArgumentChecks.ensureNonNull("code", string);
        DefinitionURI definitionURI = DefinitionURI.parse(string);
        if (definitionURI != null) {
            object = definitionURI.type;
            if (object != null && !((String)object).equalsIgnoreCase("crs")) {
                throw new NoSuchIdentifierException(Errors.format((short)118, object), (String)object);
            }
            string3 = definitionURI.authority;
            string2 = definitionURI.code;
        } else {
            int n = string.indexOf(58);
            string3 = CharSequences.trimWhitespaces(string.substring(0, Math.max(0, n)));
            string2 = CharSequences.trimWhitespaces(string.substring(n + 1));
        }
        if (string3 == null || string3.isEmpty()) {
            throw new NoSuchIdentifierException(Errors.format((short)135, string), string);
        }
        object = DefaultFactories.forClass(CRSAuthorityFactory.class);
        if (object != null) {
            try {
                return object.createCoordinateReferenceSystem(string2);
            }
            catch (FactoryException factoryException) {
                CoordinateReferenceSystem coordinateReferenceSystem = CommonCRS.forCode(string3, string2, factoryException);
                Logging.unexpectedException(Logging.getLogger("org.apache.sis.referencing.factory"), CRS.class, "forCode", factoryException);
                return coordinateReferenceSystem;
            }
        }
        return CommonCRS.forCode(string3, string2, null);
    }

    public static CoordinateReferenceSystem fromWKT(String string) throws FactoryException {
        ArgumentChecks.ensureNonNull("text", string);
        return DefaultFactories.forBuildin(CRSFactory.class).createFromWKT(string);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem coordinateReferenceSystem) {
        return coordinateReferenceSystem != null ? Extents.getGeographicBoundingBox(coordinateReferenceSystem.getDomainOfValidity()) : null;
    }

    public static boolean isHorizontalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof GeographicCRS || coordinateReferenceSystem instanceof ProjectedCRS || coordinateReferenceSystem instanceof EngineeringCRS) {
            return coordinateReferenceSystem.getCoordinateSystem().getDimension() == 2;
        }
        return false;
    }

    public static SingleCRS getHorizontalComponent(CoordinateReferenceSystem coordinateReferenceSystem) {
        IdentifiedObject identifiedObject;
        int n;
        if (CRS.isHorizontalCRS(coordinateReferenceSystem)) {
            return (SingleCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof GeographicCRS && (n = AxisDirections.indexOfColinear((CoordinateSystem)(identifiedObject = ((GeographicCRS)coordinateReferenceSystem).getCoordinateSystem()), AxisDirection.UP)) >= 0) {
            CoordinateSystemAxis coordinateSystemAxis = identifiedObject.getAxis(n > 0 ? 0 : 1);
            CoordinateSystemAxis coordinateSystemAxis2 = identifiedObject.getAxis(n > 1 ? 1 : 2);
            identifiedObject = CommonCRS.DEFAULT.geographic().getCoordinateSystem();
            if (!Utilities.equalsIgnoreMetadata(identifiedObject.getAxis(0), coordinateSystemAxis) || !Utilities.equalsIgnoreMetadata(identifiedObject.getAxis(1), coordinateSystemAxis2)) {
                identifiedObject = new DefaultEllipsoidalCS((Map<String, ?>)Collections.singletonMap("name", "Ellipsoidal 2D"), coordinateSystemAxis, coordinateSystemAxis2);
            }
            return new DefaultGeographicCRS(IdentifiedObjects.getProperties(coordinateReferenceSystem, new String[0]), ((GeographicCRS)coordinateReferenceSystem).getDatum(), (EllipsoidalCS)identifiedObject);
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            identifiedObject = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : identifiedObject.getComponents()) {
                SingleCRS singleCRS = CRS.getHorizontalComponent(coordinateReferenceSystem2);
                if (singleCRS == null) continue;
                return singleCRS;
            }
        }
        return null;
    }

    public static VerticalCRS getVerticalComponent(CoordinateReferenceSystem coordinateReferenceSystem, boolean bl) {
        Object object;
        boolean bl2;
        IdentifiedObject identifiedObject;
        if (coordinateReferenceSystem instanceof VerticalCRS) {
            return (VerticalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            identifiedObject = (CompoundCRS)coordinateReferenceSystem;
            bl2 = false;
            do {
                for (CoordinateReferenceSystem coordinateReferenceSystem2 : identifiedObject.getComponents()) {
                    object = CRS.getVerticalComponent(coordinateReferenceSystem2, bl2);
                    if (object == null) continue;
                    return object;
                }
            } while ((bl2 = !bl2) == bl);
        }
        if (bl && coordinateReferenceSystem instanceof GeographicCRS && (bl2 = AxisDirections.indexOfColinear((CoordinateSystem)(identifiedObject = coordinateReferenceSystem.getCoordinateSystem()), AxisDirection.UP)) >= false) {
            CoordinateReferenceSystem coordinateReferenceSystem2;
            CoordinateSystemAxis coordinateSystemAxis = identifiedObject.getAxis(bl2 ? 1 : 0);
            coordinateReferenceSystem2 = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            if (!coordinateReferenceSystem2.getCoordinateSystem().getAxis(0).equals(coordinateSystemAxis)) {
                object = IdentifiedObjects.getProperties(coordinateReferenceSystem2, new String[0]);
                coordinateReferenceSystem2 = new DefaultVerticalCRS((Map<String, ?>)object, coordinateReferenceSystem2.getDatum(), new DefaultVerticalCS((Map<String, ?>)object, coordinateSystemAxis));
            }
            return coordinateReferenceSystem2;
        }
        return null;
    }

    public static TemporalCRS getTemporalComponent(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            return (TemporalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                TemporalCRS temporalCRS = CRS.getTemporalComponent(coordinateReferenceSystem2);
                if (temporalCRS == null) continue;
                return temporalCRS;
            }
        }
        return null;
    }

    public static List<SingleCRS> getSingleComponents(CoordinateReferenceSystem coordinateReferenceSystem) {
        List<SingleCRS> list;
        if (coordinateReferenceSystem == null) {
            list = Collections.emptyList();
        } else if (coordinateReferenceSystem instanceof CompoundCRS) {
            if (coordinateReferenceSystem instanceof DefaultCompoundCRS) {
                list = ((DefaultCompoundCRS)coordinateReferenceSystem).getSingleComponents();
            } else {
                List<CoordinateReferenceSystem> list2 = ((CompoundCRS)coordinateReferenceSystem).getComponents();
                list = new ArrayList<SingleCRS>(list2.size());
                ReferencingUtilities.getSingleComponents(list2, list);
            }
        } else {
            list = Collections.singletonList((SingleCRS)coordinateReferenceSystem);
        }
        return list;
    }

    public static CoordinateReferenceSystem getComponentAt(CoordinateReferenceSystem coordinateReferenceSystem, int n, int n2) {
        int n3 = ReferencingUtilities.getDimension(coordinateReferenceSystem);
        ArgumentChecks.ensureValidIndexRange(n3, n, n2);
        block0: while (n != 0 || n2 != n3) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                List<CoordinateReferenceSystem> list = ((CompoundCRS)coordinateReferenceSystem).getComponents();
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    coordinateReferenceSystem = list.get(i);
                    n3 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
                    if (n < n3) continue block0;
                    n -= n3;
                    n2 -= n3;
                }
            }
            return null;
        }
        return coordinateReferenceSystem;
    }

    public static double getGreenwichLongitude(GeodeticCRS geodeticCRS) {
        ArgumentChecks.ensureNonNull("crs", geodeticCRS);
        return ReferencingUtilities.getGreenwichLongitude(geodeticCRS.getDatum().getPrimeMeridian(), NonSI.DEGREE_ANGLE);
    }
}

