/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@XmlTransient
public class AbstractReferenceSystem
extends AbstractIdentifiedObject
implements ReferenceSystem {
    private static final long serialVersionUID = 3337659819553899435L;
    private final Extent domainOfValidity;
    @XmlElement(required=true)
    private final InternationalString scope;

    public AbstractReferenceSystem(Map<String, ?> map) {
        super(map);
        this.domainOfValidity = Containers.property(map, "domainOfValidity", Extent.class);
        this.scope = Types.toInternationalString(map, "scope");
    }

    protected AbstractReferenceSystem(ReferenceSystem referenceSystem) {
        super(referenceSystem);
        this.domainOfValidity = referenceSystem.getDomainOfValidity();
        this.scope = referenceSystem.getScope();
    }

    public Class<? extends ReferenceSystem> getInterface() {
        return ReferenceSystem.class;
    }

    @Override
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @Override
    public InternationalString getScope() {
        return this.scope;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                AbstractReferenceSystem abstractReferenceSystem = (AbstractReferenceSystem)object;
                return Objects.equals(this.domainOfValidity, abstractReferenceSystem.domainOfValidity) && Objects.equals(this.scope, abstractReferenceSystem.scope);
            }
            case BY_CONTRACT: {
                ReferenceSystem referenceSystem = (ReferenceSystem)object;
                return Utilities.deepEquals(this.getDomainOfValidity(), referenceSystem.getDomainOfValidity(), comparisonMode) && Utilities.deepEquals(this.getScope(), referenceSystem.getScope(), comparisonMode);
            }
        }
        return true;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.domainOfValidity, this.scope);
    }

    AbstractReferenceSystem() {
        this.domainOfValidity = null;
        this.scope = null;
    }
}

