/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.resources.Errors;

public abstract class TabularFormat<T>
extends CompoundFormat<T> {
    private static final long serialVersionUID = -4556687020021477908L;
    protected String lineSeparator;
    protected String columnSeparator = " ";
    protected char fillCharacter = (char)32;
    protected String beforeFill = "";
    protected boolean omitTrailingNulls;
    private boolean isParsePatternDefined;
    private Pattern parsePattern;

    public TabularFormat(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
        this.lineSeparator = JDK7.lineSeparator();
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String string) {
        ArgumentChecks.ensureNonEmpty("separator", string);
        this.lineSeparator = string;
    }

    public String getColumnSeparatorPattern() {
        StringBuilder stringBuilder = new StringBuilder(8);
        stringBuilder.append(this.beforeFill).append('\uffff').append(this.columnSeparator);
        StringBuilders.replace(stringBuilder, "\\", "\\\\");
        StringBuilders.replace(stringBuilder, "?", "\\?");
        StringBuilders.replace(stringBuilder, "[", "\\[");
        StringBuilders.replace(stringBuilder, "]", "\\]");
        StringBuilders.replace(stringBuilder, "/", "\\/");
        if (this.omitTrailingNulls) {
            stringBuilder.insert(0, '?');
        }
        int n = stringBuilder.indexOf("\uffff");
        stringBuilder.replace(n, n + 1, "[\uffff]").setCharAt(n + 1, this.fillCharacter);
        if (this.isParsePatternDefined) {
            stringBuilder.append('/').append(this.parsePattern.pattern());
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setColumnSeparatorPattern(String string) throws IllegalArgumentException {
        ArgumentChecks.ensureNonEmpty("pattern", string);
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        int n2 = -1;
        block12: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\uffff': {
                    string2 = null;
                    break block12;
                }
                case '\\': {
                    if (i == n2) continue block12;
                    if (bl) break;
                    bl = true;
                    continue block12;
                }
                case '?': {
                    if (i != 0) {
                        string2 = null;
                        break block12;
                    }
                    bl2 = true;
                    continue block12;
                }
                case '[': {
                    if (bl) break;
                    if (i == n2) continue block12;
                    if (n2 >= 0) {
                        string2 = null;
                        break block12;
                    }
                    n2 = i + 1;
                    continue block12;
                }
                case ']': {
                    if (bl) break;
                    switch (i - n2) {
                        case 0: {
                            continue block12;
                        }
                        case 1: {
                            string2 = stringBuilder.toString();
                            stringBuilder.setLength(0);
                            continue block12;
                        }
                        default: {
                            string2 = null;
                            break;
                        }
                    }
                    break block12;
                }
                case '/': {
                    if (bl) break;
                    string3 = string.substring(i + 1);
                    break block12;
                }
            }
            if (i == n2) continue;
            stringBuilder.append(c);
        }
        if (string2 == null) {
            throw new IllegalArgumentException(Errors.format((short)35, this.getValueType(), string));
        }
        if (string3 != null) {
            this.parsePattern = Pattern.compile(string3);
            this.isParsePatternDefined = true;
        } else {
            this.parsePattern = null;
            this.isParsePatternDefined = false;
        }
        this.omitTrailingNulls = bl2;
        this.beforeFill = string2;
        this.columnSeparator = stringBuilder.toString();
        this.fillCharacter = string.charAt(n2);
    }

    protected Matcher getColumnSeparatorMatcher(CharSequence charSequence) {
        if (this.parsePattern == null) {
            StringBuilder stringBuilder = new StringBuilder(this.beforeFill).append(this.fillCharacter);
            String string = stringBuilder.toString();
            stringBuilder.setLength(0);
            stringBuilder.append(Pattern.quote(string)).append('*');
            string = this.columnSeparator;
            if (string.length() != 0) {
                stringBuilder.append(Pattern.quote(string));
            }
            this.parsePattern = Pattern.compile(stringBuilder.toString());
        }
        return this.parsePattern.matcher(charSequence);
    }
}

