/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.HashMap;
import java.util.NoSuchElementException;
import javax.measure.unit.SI;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public abstract class MapProjection
extends AbstractProvider {
    private static final long serialVersionUID = 6280666068007678702L;
    public static final DefaultParameterDescriptor<Double> SEMI_MAJOR;
    public static final DefaultParameterDescriptor<Double> SEMI_MINOR;

    protected MapProjection(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(2, 2, parameterDescriptorGroup);
    }

    public Class<? extends Projection> getOperationType() {
        return Projection.class;
    }

    public static void validate(ParameterDescriptor<? extends Number> parameterDescriptor, double d) throws IllegalArgumentException {
        double d2;
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException(Errors.format((short)144, parameterDescriptor.getName(), d));
        }
        Comparable<? extends Number> comparable = parameterDescriptor.getMinimumValue();
        Comparable<? extends Number> comparable2 = parameterDescriptor.getMaximumValue();
        double d3 = comparable instanceof Number ? ((Number)((Object)comparable)).doubleValue() : Double.NaN;
        double d4 = d2 = comparable2 instanceof Number ? ((Number)((Object)comparable2)).doubleValue() : Double.NaN;
        if ((d < d3 || d > d2) && d3 != d2) {
            throw new IllegalArgumentException(Errors.format((short)133, parameterDescriptor.getName(), comparable, comparable2, d));
        }
    }

    @Override
    public final MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException, FactoryException {
        return this.createProjection(Parameters.castOrWrap(parameterValueGroup)).createMapProjection(mathTransformFactory);
    }

    protected abstract NormalizedProjection createProjection(Parameters var1) throws ParameterNotFoundException;

    static GenericName sameNameAs(Citation citation, GeneralParameterDescriptor generalParameterDescriptor) {
        for (GenericName genericName : generalParameterDescriptor.getAlias()) {
            if (!(genericName instanceof Identifier) || ((Identifier)((Object)genericName)).getAuthority() != citation) continue;
            return genericName;
        }
        throw new NoSuchElementException();
    }

    static ParameterBuilder addNamesAndIdentifiers(Citation citation, ParameterDescriptor<Double> parameterDescriptor, ParameterBuilder parameterBuilder) {
        ((ParameterBuilder)parameterBuilder.addName(MapProjection.sameNameAs(citation, parameterDescriptor))).addName(parameterDescriptor.getName());
        for (GenericName object : parameterDescriptor.getAlias()) {
            if (((Identifier)((Object)object)).getAuthority() == citation) continue;
            parameterBuilder.addName(object);
        }
        for (ReferenceIdentifier referenceIdentifier : parameterDescriptor.getIdentifiers()) {
            parameterBuilder.addIdentifier(referenceIdentifier);
        }
        return parameterBuilder;
    }

    static ParameterBuilder exceptEPSG(ParameterDescriptor<?> parameterDescriptor, ParameterBuilder parameterBuilder) {
        for (GenericName genericName : parameterDescriptor.getAlias()) {
            parameterBuilder.addName(genericName);
        }
        return parameterBuilder;
    }

    static ParameterDescriptor<Double> forESRI(ParameterDescriptor<Double> parameterDescriptor, ParameterBuilder parameterBuilder) {
        return MapProjection.addNamesAndIdentifiers(Citations.ESRI, parameterDescriptor, parameterBuilder).createBounded((MeasurementRange)((DefaultParameterDescriptor)parameterDescriptor).getValueDomain(), (Comparable)parameterDescriptor.getDefaultValue());
    }

    static InternationalString notFormalParameter(String string) {
        return Messages.formatInternational((short)10, (Object)string);
    }

    static {
        MeasurementRange<Double> measurementRange = MeasurementRange.createGreaterThan(0.0, SI.METRE);
        GenericName[] genericNameArray = new GenericName[]{new NamedIdentifier(Citations.ESRI, "Semi_Major"), new NamedIdentifier(Citations.NETCDF, "semi_major_axis"), new NamedIdentifier(Citations.GEOTIFF, "SemiMajor"), new NamedIdentifier(Citations.PROJ4, "a")};
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("authority", Citations.OGC);
        hashMap.put("name", "semi_major");
        hashMap.put("alias", genericNameArray);
        SEMI_MAJOR = new DefaultParameterDescriptor<Object>(hashMap, 1, 1, Double.class, measurementRange, null, null);
        hashMap.put("name", "semi_minor");
        genericNameArray[0] = new NamedIdentifier(Citations.ESRI, "Semi_Minor");
        genericNameArray[1] = new NamedIdentifier(Citations.NETCDF, "semi_minor_axis");
        genericNameArray[2] = new NamedIdentifier(Citations.GEOTIFF, "SemiMinor");
        genericNameArray[3] = new NamedIdentifier(Citations.PROJ4, "b");
        SEMI_MINOR = new DefaultParameterDescriptor<Object>(hashMap, 1, 1, Double.class, measurementRange, null, null);
    }
}

