/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.util.List;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.ArraysExt;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;

final class GridGeometryWrapper
extends GridGeometry {
    private final CoordinateSystem netcdfCS;
    private transient CoordinateAxis2D axis2D;

    GridGeometryWrapper(CoordinateSystem coordinateSystem) {
        this.netcdfCS = coordinateSystem;
    }

    @Override
    public int getSourceDimensions() {
        return this.netcdfCS.getRankDomain();
    }

    @Override
    public int getTargetDimensions() {
        return this.netcdfCS.getRankRange();
    }

    @Override
    public Axis[] getAxes() {
        List<Dimension> list = this.netcdfCS.getDomain();
        List<CoordinateAxis> list2 = this.netcdfCS.getCoordinateAxes();
        int n = list2.size();
        Axis[] axisArray = new Axis[n];
        while (--n >= 0) {
            CoordinateAxis coordinateAxis = list2.get(n);
            List<Dimension> list3 = coordinateAxis.getDimensions();
            AttributeNames.Dimension dimension = null;
            AxisType axisType = coordinateAxis.getAxisType();
            if (axisType != null) {
                switch (axisType) {
                    case Lon: {
                        dimension = AttributeNames.LONGITUDE;
                        break;
                    }
                    case Lat: {
                        dimension = AttributeNames.LATITUDE;
                        break;
                    }
                    case Pressure: 
                    case Height: {
                        dimension = AttributeNames.VERTICAL;
                        break;
                    }
                    case RunTime: 
                    case Time: {
                        dimension = AttributeNames.TIME;
                    }
                }
            }
            int n2 = 0;
            int[] nArray = new int[list3.size()];
            int[] nArray2 = new int[nArray.length];
            for (Dimension dimension2 : list3) {
                int n3 = list.lastIndexOf(dimension2);
                if (n3 < 0) continue;
                nArray[n2] = n3;
                nArray2[n2++] = dimension2.getLength();
            }
            this.axis2D = coordinateAxis instanceof CoordinateAxis2D ? (CoordinateAxis2D)coordinateAxis : null;
            axisArray[n] = new Axis(this, dimension, ArraysExt.resize(nArray, n2), ArraysExt.resize(nArray2, n2));
        }
        this.axis2D = null;
        return axisArray;
    }

    @Override
    protected double coordinateForCurrentAxis(int n, int n2) {
        return this.axis2D != null ? this.axis2D.getCoordValue(n, n2) : Double.NaN;
    }
}

